/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.Config;
import bluej.debugmgr.inspector.FieldInfo;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.IntegerExpression;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class FieldList
extends ScrollPane {
    private static final Image objectrefIcon = Config.getImageAsFXImage("image.inspector.objectref");
    private static final double ROW_HEIGHT = 30.0;
    private final ContentPane content = new ContentPane();
    private final List<FieldInfo> curData = new ArrayList<FieldInfo>();
    private final IntegerProperty selectedRow = new SimpleIntegerProperty(-1);
    private final Label placeholderLabel = new Label();

    public FieldList() {
        this.getStyleClass().add((Object)"field-list");
        this.setContent((Node)new StackPane(new Node[]{this.content, this.placeholderLabel}));
        this.content.managedProperty().bind((ObservableValue)this.content.visibleProperty());
        this.placeholderLabel.managedProperty().bind((ObservableValue)this.placeholderLabel.visibleProperty());
        this.placeholderLabel.setVisible(true);
        this.content.setVisible(false);
        StackPane.setAlignment((Node)this.placeholderLabel, (Pos)Pos.CENTER);
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setFitToWidth(true);
    }

    public void down() {
        this.select(Math.min(this.curData.size() - 1, this.selectedRow.get() + 1));
    }

    public void up() {
        this.select(Math.max(0, this.selectedRow.get() - 1));
    }

    public void setData(List<FieldInfo> listData) {
        if (listData.equals(this.curData)) {
            return;
        }
        ArrayList<Object> children = new ArrayList<Object>();
        int i = 0;
        while (i < listData.size()) {
            FieldInfo field = listData.get(i);
            Label valueLabel = new Label(field.getValue());
            if ("<object reference>".equals(valueLabel.getText())) {
                valueLabel.setGraphic((Node)new ImageView(objectrefIcon));
                valueLabel.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            }
            BorderPane wrapper = new BorderPane((Node)valueLabel);
            JavaFXUtil.addStyleClass((Styleable)wrapper, "inspector-field-value-wrapper");
            JavaFXUtil.addStyleClass((Styleable)valueLabel, "inspector-field-value-label");
            Label descriptionLabel = new Label(field.getDescription());
            JavaFXUtil.addStyleClass((Styleable)descriptionLabel, "inspector-field-description");
            descriptionLabel.setTextOverrun(OverrunStyle.LEADING_WORD_ELLIPSIS);
            children.add(descriptionLabel);
            children.add(wrapper);
            int iFinal = i++;
            descriptionLabel.setOnMouseClicked(e -> this.select(iFinal));
            wrapper.setOnMouseClicked(e -> this.select(iFinal));
        }
        this.content.getChildren().setAll(children);
        this.content.setVisible(!children.isEmpty());
        this.placeholderLabel.setVisible(children.isEmpty());
        this.curData.clear();
        this.curData.addAll(listData);
        int sel = this.selectedRow.get();
        this.select(-1);
        this.select(sel);
        this.requestLayout();
    }

    public void setPlaceHolderText(String text) {
        this.placeholderLabel.setText(text);
    }

    public IntegerExpression selectedIndexProperty() {
        return this.selectedRow;
    }

    public void select(int index) {
        if (index == this.selectedRow.get()) {
            return;
        }
        this.selectedRow.set(index);
        ObservableList<Node> children = this.content.getChildren();
        for (int i = 0; i < children.size(); i += 2) {
            boolean selected = i / 2 == index;
            JavaFXUtil.setPseudoclass("bj-selected", selected, (Node)children.get(i), (Node)children.get(i + 1));
            if (!selected || !(((Node)children.get(i)).localToScene(0.0, 0.0).getY() < this.localToScene(0.0, 0.0).getY()) && !(((Node)children.get(i)).localToScene(0.0, 30.0).getY() > this.localToScene(0.0, this.getHeight()).getY())) continue;
            JavaFXUtil.scrollTo(this, (Node)children.get(i));
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    private static class ContentPane
    extends Region {
        private static final int MIN_LEFT = 50;
        private static final int LARGEST_SENSIBLE_RIGHT = 500;

        public ContentPane() {
            this.getStyleClass().add((Object)"field-list-content");
        }

        protected void layoutChildren() {
            double leftWidth;
            double largestMinLeft;
            Insets outerPadding = this.getInsets();
            double widthMinusPadding = this.getWidth() - (outerPadding.getLeft() + outerPadding.getRight());
            ObservableList<Node> children = this.getChildren();
            double largestPrefLeft = largestMinLeft = 50.0;
            double largestRight = 0.0;
            for (int i = 0; i < children.size(); i += 2) {
                largestMinLeft = Math.max(largestMinLeft, ((Node)children.get(i)).minWidth(30.0));
                largestPrefLeft = Math.max(largestPrefLeft, ((Node)children.get(i)).prefWidth(30.0));
                largestRight = Math.max(largestRight, ((Node)children.get(i + 1)).prefWidth(30.0));
            }
            if (largestPrefLeft + largestRight <= widthMinusPadding) {
                leftWidth = largestPrefLeft + (widthMinusPadding - largestPrefLeft - largestRight) * 0.25;
            } else {
                largestRight = Math.min(Math.max(widthMinusPadding - largestPrefLeft, 500.0), largestRight);
                leftWidth = Math.max(widthMinusPadding - largestRight, largestMinLeft);
            }
            double rightWidth = widthMinusPadding - leftWidth;
            double y = outerPadding.getTop();
            for (int i = 0; i < children.size(); i += 2) {
                ((Node)children.get(i)).resizeRelocate(outerPadding.getLeft(), y, leftWidth, 30.0);
                ((Node)children.get(i + 1)).resizeRelocate(outerPadding.getLeft() + leftWidth, y, rightWidth, 30.0);
                y += 30.0;
            }
        }

        public ObservableList<Node> getChildren() {
            return super.getChildren();
        }

        protected double computePrefWidth(double height) {
            ObservableList<Node> children = this.getChildren();
            double largestLeft = 50.0;
            double largestRight = 0.0;
            for (int i = 0; i < children.size(); i += 2) {
                largestLeft = Math.max(largestLeft, ((Node)children.get(i)).prefWidth(height));
                largestRight = Math.max(largestRight, ((Node)children.get(i + 1)).prefWidth(height));
            }
            return Math.min(150.0, largestLeft) + Math.min(500.0, largestRight) + this.getPadding().getLeft() + this.getPadding().getRight();
        }
    }
}

