/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.Config;
import bluej.GuiHandler;
import bluej.Main;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.utility.Debug;
import java.io.File;
import javafx.stage.Stage;
import threadchecker.OnThread;
import threadchecker.Tag;

public class BlueJGuiHandler
implements GuiHandler {
    private static final int FIRST_X_LOCATION = 20;
    private static final int FIRST_Y_LOCATION = 20;

    @Override
    public boolean tryOpen(File path, boolean displayError) {
        return PkgMgrFrame.doOpen(path, null);
    }

    @Override
    public void handleAbout() {
        PkgMgrFrame.handleAbout();
    }

    @Override
    public void handlePreferences() {
        PkgMgrFrame.handlePreferences();
    }

    @Override
    public void handleQuit() {
        PkgMgrFrame.handleQuit();
    }

    @Override
    public Stage initialOpenComplete(boolean projectOpen) {
        if (!projectOpen) {
            PkgMgrFrame frame = PkgMgrFrame.createFrame();
            frame.getWindow().setX(20.0);
            frame.getWindow().setY(20.0);
            frame.setVisible(true);
            return frame.getWindow();
        }
        String targetName = Config.getPropString("bluej.class.open", null);
        if (targetName != null && !targetName.equals("")) {
            boolean foundTarget = false;
            for (Project proj : Project.getProjects()) {
                Target tgt = proj.getTarget(targetName);
                if (tgt == null || !(tgt instanceof ClassTarget)) continue;
                ((ClassTarget)tgt).open();
                foundTarget = true;
            }
            if (!foundTarget) {
                Debug.message("Did not find target class in opened project: \"" + targetName + "\"");
            }
        }
        return PkgMgrFrame.getMostRecent().getWindow();
    }

    @Override
    public void doExitCleanup() {
        PkgMgrFrame[] pkgFrames = PkgMgrFrame.getAllFrames();
        BlueJGuiHandler.handleOrphanPackages(pkgFrames);
        int i = pkgFrames.length - 1;
        while (i >= 0) {
            PkgMgrFrame aFrame = pkgFrames[i--];
            aFrame.doSave();
            aFrame.closePackage();
            PkgMgrFrame.closeFrame(aFrame);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private static void handleOrphanPackages(PkgMgrFrame[] openFrames) {
        if (Main.hadOrphanPackages()) {
            BlueJGuiHandler.removeOrphanPackageList();
        }
        for (int i = 0; i < openFrames.length; ++i) {
            PkgMgrFrame aFrame = openFrames[i];
            if (aFrame.isEmptyFrame()) continue;
            Config.putPropString("bluej.openPackage" + (i + 1), aFrame.getPackage().getPath().toString());
        }
    }

    private static void removeOrphanPackageList() {
        String exists = "";
        int i = 1;
        while (exists != null) {
            exists = Config.removeProperty("bluej.openPackage" + i);
            ++i;
        }
    }
}

