/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import org.fxmisc.wellbehaved.event.InputHandler;
import org.fxmisc.wellbehaved.event.InputMap;

public class Nodes {
    private static final String P_INPUTMAP = "org.fxmisc.wellbehaved.event.inputmap";
    private static final String P_HANDLERS = "org.fxmisc.wellbehaved.event.handlers";
    private static final String P_STACK = "org.fxmisc.wellbehaved.event.stack";

    public static void addInputMap(Node node, InputMap<?> im) {
        Nodes.setInputMapUnsafe(node, InputMap.sequence(im, Nodes.getInputMap(node)));
    }

    public static void addFallbackInputMap(Node node, InputMap<?> im) {
        Nodes.setInputMapUnsafe(node, InputMap.sequence(Nodes.getInputMap(node), im));
    }

    public static void removeInputMap(Node node, InputMap<?> im) {
        Nodes.setInputMapUnsafe(node, Nodes.getInputMap(node).without(im));
    }

    public static InputMap<?> getInputMap(Node node) {
        Nodes.init(node);
        return Nodes.getInputMapUnsafe(node);
    }

    public static void pushInputMap(Node node, InputMap<?> im) {
        InputMap<?> previousInputMap = Nodes.getInputMap(node);
        Nodes.getStack(node).push(previousInputMap);
        Nodes.setInputMapUnsafe(node, im);
    }

    public static boolean popInputMap(Node node) {
        Stack<InputMap<?>> stackedInputMaps = Nodes.getStack(node);
        if (!stackedInputMaps.isEmpty()) {
            Nodes.setInputMapUnsafe(node, stackedInputMaps.pop());
            return true;
        }
        return false;
    }

    private static void init(final Node node) {
        ObservableMap<Object, Object> nodeProperties = Nodes.getProperties(node);
        if (nodeProperties.get((Object)P_INPUTMAP) == null) {
            nodeProperties.put((Object)P_INPUTMAP, InputMap.empty());
            nodeProperties.put((Object)P_HANDLERS, new ArrayList());
            MapChangeListener listener = ch -> {
                if (!P_INPUTMAP.equals(ch.getKey())) {
                    return;
                }
                Nodes.getHandlers(node).forEach(entry -> node.removeEventHandler((EventType)entry.getKey(), (EventHandler)entry.getValue()));
                Nodes.getHandlers(node).clear();
                InputMap inputMap = (InputMap)ch.getValueAdded();
                inputMap.forEachEventType(new InputMap.HandlerConsumer<Event>(){

                    @Override
                    public <E extends Event> void accept(EventType<? extends E> t, InputHandler<? super E> h) {
                        node.addEventHandler(t, h);
                        Nodes.getHandlers(node).add(new AbstractMap.SimpleEntry<EventType<? extends E>, InputHandler<? super E>>(t, h));
                    }
                });
            };
            nodeProperties.addListener(listener);
        }
    }

    private static void setInputMapUnsafe(Node node, InputMap<?> im) {
        Nodes.getProperties(node).put((Object)P_INPUTMAP, im);
    }

    private static InputMap<?> getInputMapUnsafe(Node node) {
        return (InputMap)Nodes.getProperties(node).get((Object)P_INPUTMAP);
    }

    private static List<Map.Entry<EventType<?>, EventHandler<?>>> getHandlers(Node node) {
        return (List)Nodes.getProperties(node).get((Object)P_HANDLERS);
    }

    private static Stack<InputMap<?>> getStack(Node node) {
        ObservableMap<Object, Object> nodeProperties = Nodes.getProperties(node);
        if (nodeProperties.get((Object)P_STACK) == null) {
            Stack stackedInputMaps = new Stack();
            nodeProperties.put((Object)P_STACK, stackedInputMaps);
            return stackedInputMaps;
        }
        return (Stack)nodeProperties.get((Object)P_STACK);
    }

    private static ObservableMap<Object, Object> getProperties(Node node) {
        return node.getProperties();
    }
}

