/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.vmcomm;

import bluej.utility.Debug;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.core.ShadowProjectProperties;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.gui.WorldRenderer;
import greenfoot.gui.input.KeyboardManager;
import greenfoot.gui.input.mouse.MousePollingManager;
import greenfoot.vmcomm.Command;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import threadchecker.OnThread;
import threadchecker.Tag;

public class VMCommsSimulation {
    private final WorldRenderer worldRenderer;
    private final BlockingQueue<BufferedImage> worldImagesForPainting = new ArrayBlockingQueue<BufferedImage>(3);
    private final AtomicReference<BufferedImage> worldImageForSending = new AtomicReference<Object>(null);
    private @OnThread(value=Tag.Any, requireSynchronized=true) String pAskPrompt;
    private @OnThread(value=Tag.Any, requireSynchronized=true) int pAskId;
    private @OnThread(value=Tag.Any, requireSynchronized=true) String askAnswer;
    private @OnThread(value=Tag.Any, requireSynchronized=true) boolean delayLoopEntered;
    private final ShadowProjectProperties projectProperties;
    private final IntBuffer sharedMemory;
    private int seq = 1;
    private final FileChannel shmFileChannel;
    private FileLock putLock;
    private long lastPaintNanos = System.nanoTime();
    private int lastAckCommand = -1;
    private int lastPaintSeq = -1;
    private int lastPaintSize;
    private int stoppedWithErrorCount = 0;
    private long startOfCurExecution = 0L;
    private int worldCounter = 0;
    private World world;
    private final int fileSize;
    private final AtomicBoolean userVMReadyForInvocations = new AtomicBoolean(false);

    @OnThread(value=Tag.Any)
    public VMCommsSimulation(ShadowProjectProperties projectProperties, String shmFilePath, int fileSize, int seqStart) {
        this.projectProperties = projectProperties;
        this.seq = seqStart;
        this.worldRenderer = new WorldRenderer();
        try {
            this.shmFileChannel = new RandomAccessFile(shmFilePath, "rw").getChannel();
            this.fileSize = fileSize;
            MappedByteBuffer mbb = this.shmFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
            this.sharedMemory = mbb.asIntBuffer();
            this.putLock = this.shmFileChannel.lock(16384L, fileSize - 16384, false);
            new Thread("VMCommsSimulation"){

                @Override
                @OnThread(value=Tag.Worker, ignoreParent=true)
                public void run() {
                    while (true) {
                        VMCommsSimulation.this.doInterVMComms();
                    }
                }
            }.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @OnThread(value=Tag.Any)
    public synchronized void setWorld(World world) {
        if (this.world != world) {
            ++this.worldCounter;
            this.world = world;
        }
    }

    public void markVMReady() {
        this.userVMReadyForInvocations.set(true);
    }

    @OnThread(value=Tag.Simulation)
    public void paintRemote(PaintWhen paintWhen) {
        long now = System.nanoTime();
        if (paintWhen == PaintWhen.IF_DUE && now - this.lastPaintNanos <= 8333333L) {
            return;
        }
        if (this.world != null) {
            this.lastPaintNanos = now;
            int imageWidth = WorldVisitor.getWidthInPixels(this.world);
            int imageHeight = WorldVisitor.getHeightInPixels(this.world);
            BufferedImage worldImage = (BufferedImage)this.worldImagesForPainting.poll();
            if (worldImage == null || worldImage.getHeight() != imageHeight || worldImage.getWidth() != imageWidth) {
                worldImage = new BufferedImage(imageWidth, imageHeight, 2);
            }
            this.worldRenderer.renderWorld(this.world, worldImage);
            BufferedImage oldImage = this.worldImageForSending.getAndSet(worldImage);
            if (oldImage != null) {
                this.worldImagesForPainting.offer(oldImage);
            }
        }
    }

    @OnThread(value=Tag.Simulation)
    public synchronized String doAsk(int askId, String askPrompt) {
        this.pAskPrompt = askPrompt;
        this.pAskId = askId;
        this.askAnswer = null;
        try {
            do {
                this.wait();
            } while (this.askAnswer == null);
        }
        catch (InterruptedException ie) {
            return "";
        }
        return this.askAnswer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Worker)
    private void doInterVMComms() {
        String[] answer = new String[]{null};
        FileLock fileLock = null;
        FileLock syncLock = null;
        try {
            int curWorldCounter;
            World curWorld;
            boolean doUpdateImage;
            fileLock = this.shmFileChannel.lock(4L, 16380L, false);
            VMCommsSimulation vMCommsSimulation = this;
            synchronized (vMCommsSimulation) {
                doUpdateImage = this.world != null;
                curWorld = this.world;
                curWorldCounter = this.worldCounter;
            }
            this.sharedMemory.position(1);
            int recvSeq = this.sharedMemory.get();
            if (recvSeq < 0 && Simulation.getInstance() != null) {
                int lastConsumedImg = this.sharedMemory.get();
                doUpdateImage &= lastConsumedImg >= this.lastPaintSeq;
                int latest = this.readCommands(answer);
                if (latest != -1) {
                    this.lastAckCommand = latest;
                }
            }
            BufferedImage img = doUpdateImage ? (BufferedImage)this.worldImageForSending.getAndSet(null) : null;
            int[] raw = img == null ? null : ((DataBufferInt)img.getData().getDataBuffer()).getData();
            int imageWidth = 0;
            int imageHeight = 0;
            if (img != null) {
                imageWidth = img.getWidth();
                imageHeight = img.getHeight();
            }
            this.sharedMemory.position(4096);
            this.sharedMemory.put(this.seq++);
            if (img == null) {
                this.sharedMemory.put(this.lastPaintSeq);
                this.sharedMemory.get();
                this.sharedMemory.get();
                this.sharedMemory.position(this.sharedMemory.position() + this.lastPaintSize);
            } else {
                this.lastPaintSeq = this.seq - 1;
                this.sharedMemory.put(this.lastPaintSeq);
                this.sharedMemory.put(imageWidth);
                this.sharedMemory.put(imageHeight);
                for (int i = 0; i < raw.length; ++i) {
                    this.sharedMemory.put(raw[i]);
                }
                this.lastPaintSize = raw.length;
                this.worldImagesForPainting.offer(img);
            }
            this.sharedMemory.put(this.lastAckCommand);
            this.sharedMemory.put(this.stoppedWithErrorCount);
            this.sharedMemory.put((int)(this.startOfCurExecution >> 32));
            this.sharedMemory.put((int)(this.startOfCurExecution & 0xFFFFFFFFL));
            if (Simulation.getInstance() != null) {
                this.sharedMemory.put(Simulation.getInstance().getSpeed());
            } else {
                this.sharedMemory.put(0);
            }
            this.sharedMemory.put(curWorld == null ? 0 : curWorldCounter);
            this.sharedMemory.put(curWorld == null ? 0 : WorldVisitor.getCellSize(curWorld));
            VMCommsSimulation vMCommsSimulation2 = this;
            synchronized (vMCommsSimulation2) {
                if (this.pAskPrompt == null || answer[0] != null) {
                    this.sharedMemory.put(-1);
                } else {
                    int[] codepoints = this.pAskPrompt.codePoints().toArray();
                    this.sharedMemory.put(this.pAskId);
                    this.sharedMemory.put(codepoints.length);
                    this.sharedMemory.put(codepoints);
                }
                this.sharedMemory.put(this.delayLoopEntered ? 1 : 0);
                this.sharedMemory.put(this.userVMReadyForInvocations.get() ? 1 : 0);
            }
            this.putLock.release();
            syncLock = this.shmFileChannel.lock(0L, 4L, false);
            fileLock.release();
            this.putLock = this.shmFileChannel.lock(16384L, this.fileSize - 16384, false);
            syncLock.release();
        }
        catch (IOException ex) {
            try {
                this.putLock.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Debug.reportError(ex);
        }
        catch (BufferOverflowException ex) {
            try {
                this.putLock.release();
                if (fileLock != null) {
                    fileLock.release();
                }
                if (syncLock != null) {
                    syncLock.release();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Debug.message("World size is too large.  If your world contains more than around 2.5 million pixels you will need to do the following.\nClose your project, then edit project.greenfoot in a text editor to add the following line:\nshm.size=40000000\n(The default is 20000000, keep increasing if needed.)  Save the file and re-open the project in Greenfoot.");
        }
        if (answer[0] != null) {
            this.gotAskAnswer(answer[0]);
        }
    }

    private synchronized void gotAskAnswer(String answer) {
        this.askAnswer = answer;
        this.notifyAll();
    }

    private int readCommands(String[] answer) {
        int lastSeqID = -1;
        int commandCount = this.sharedMemory.get();
        block27: for (int i = 0; i < commandCount; ++i) {
            lastSeqID = this.sharedMemory.get();
            int commandLength = this.sharedMemory.get();
            int[] data = new int[commandLength];
            this.sharedMemory.get(data);
            if (Command.isKeyEvent(data[0])) {
                KeyboardManager keyboardManager = WorldHandler.getInstance().getKeyboardManager();
                KeyCode keyCode = KeyCode.values()[data[1]];
                String keyText = new String(data, 2, data.length - 2);
                switch (data[0]) {
                    case 1: {
                        keyboardManager.keyPressed(keyCode, keyText);
                        break;
                    }
                    case 2: {
                        keyboardManager.keyReleased(keyCode, keyText);
                        break;
                    }
                    case 3: {
                        keyboardManager.keyTyped(keyCode, keyText);
                    }
                }
                continue;
            }
            if (Command.isMouseEvent(data[0])) {
                int x = data[1];
                int y = data[2];
                int button = data[3];
                int clickCount = data[4];
                MousePollingManager mouseManager = WorldHandler.getInstance().getMouseManager();
                switch (data[0]) {
                    case 11: {
                        mouseManager.mouseClicked(x, y, MouseButton.values()[button], clickCount);
                        break;
                    }
                    case 12: {
                        mouseManager.mousePressed(x, y, MouseButton.values()[button]);
                        break;
                    }
                    case 14: {
                        mouseManager.mouseReleased(x, y, MouseButton.values()[button]);
                        break;
                    }
                    case 13: {
                        mouseManager.mouseDragged(x, y, MouseButton.values()[button]);
                        break;
                    }
                    case 15: {
                        mouseManager.mouseMoved(x, y);
                        break;
                    }
                    case 16: {
                        mouseManager.mouseExited();
                    }
                }
                continue;
            }
            switch (data[0]) {
                case 21: {
                    Simulation.getInstance().setPaused(false);
                    continue block27;
                }
                case 24: {
                    Simulation.getInstance().setPaused(true);
                    continue block27;
                }
                case 25: {
                    Simulation.getInstance().runOnce();
                    continue block27;
                }
                case 26: {
                    String className = new String(data, 1, data.length - 1);
                    WorldHandler.getInstance().instantiateNewWorld(className);
                    continue block27;
                }
                case 29: {
                    WorldHandler.getInstance().discardWorld();
                    continue block27;
                }
                case 22: {
                    WorldHandler.getInstance().continueDragging(data[1], data[2], data[3]);
                    continue block27;
                }
                case 23: {
                    WorldHandler.getInstance().finishDrag(data[1]);
                    continue block27;
                }
                case 27: {
                    answer[0] = new String(data, 1, data.length - 1);
                    continue block27;
                }
                case 28: {
                    int keyLength = data[1];
                    String key = new String(data, 2, keyLength);
                    int valueLength = data[2 + keyLength];
                    String value = valueLength < 0 ? null : new String(data, 3 + keyLength, valueLength);
                    this.projectProperties.propertyChangedOnServerVM(key, value);
                    continue block27;
                }
                case 30: {
                    Simulation.getInstance().setSpeed(data[1]);
                    continue block27;
                }
                case 40: {
                    WorldHandler.getInstance().worldFocusChanged(true);
                    continue block27;
                }
                case 41: {
                    WorldHandler.getInstance().worldFocusChanged(false);
                }
            }
        }
        return lastSeqID;
    }

    public int getAskId() {
        return this.lastAckCommand;
    }

    @OnThread(value=Tag.Simulation)
    public void notifyStoppedWithError() {
        ++this.stoppedWithErrorCount;
        this.paintRemote(PaintWhen.FORCE);
    }

    @OnThread(value=Tag.Simulation)
    public synchronized void notifyDelayLoopEntered() {
        this.delayLoopEntered = true;
    }

    @OnThread(value=Tag.Simulation)
    public synchronized void notifyDelayLoopCompleted() {
        this.delayLoopEntered = false;
    }

    @OnThread(value=Tag.Simulation)
    public void userCodeStarting() {
        this.startOfCurExecution = System.currentTimeMillis();
    }

    @OnThread(value=Tag.Simulation)
    public void userCodeStopped(boolean suggestRepaint) {
        this.startOfCurExecution = 0L;
        if (suggestRepaint) {
            this.paintRemote(PaintWhen.FORCE);
        }
    }

    public static enum PaintWhen {
        FORCE,
        IF_DUE;

    }
}

