/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.vmcomm;

import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.SourceLocation;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ValueCollection;
import bluej.debugmgr.objectbench.ObjectBenchEvent;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.debugmgr.objectbench.ObjectBenchListener;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import greenfoot.core.PickActorHelper;
import greenfoot.core.ProjectManager;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.guifx.GreenfootStage;
import greenfoot.platforms.ide.WorldHandlerDelegateIDE;
import greenfoot.record.GreenfootRecorder;
import greenfoot.util.DebugUtil;
import greenfoot.vmcomm.VMCommsMain;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.geometry.Point2D;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GreenfootDebugHandler
implements DebuggerListener,
ObjectBenchInterface,
ValueCollection {
    private static final String SIMULATION_CLASS = Simulation.class.getName();
    private static final String[] INVOKE_METHODS = new String[]{"actWorld", "actActor", "newInstance", Simulation.RUN_QUEUED_TASKS, "worldStarted", "worldStopped"};
    private static final String SIMULATION_INVOKE_KEY = SIMULATION_CLASS + "INTERNAL";
    private static final String PAUSED_METHOD = "simulationWait";
    private static final String SIMULATION_THREAD_PAUSED_KEY = "SIMULATION_THREAD_PAUSED";
    private static final String SIMULATION_THREAD_RESUMED_KEY = "SIMULATION_THREAD_RESUMED";
    private static final String SIMULATION_THREAD_RUN_KEY = "SIMULATION_THREAD_RUN";
    private static final String WORLD_HANDLER_CLASS = WorldHandler.class.getName();
    private static final String WORLD_CHANGED_KEY = "WORLD_CHANGED";
    private static final String WORLD_INITIALISING_KEY = "WORLD_INITIALISING";
    private static final String WORLD_INSTANTIATION_ERROR_KEY = "WORLD_INSTANTIATION_ERROR";
    private static final String NAME_ACTOR_CLASS = WorldHandlerDelegateIDE.class.getName();
    private static final String NAME_ACTOR_KEY = "NAME_ACTOR";
    private static final String PICK_HELPER_CLASS = PickActorHelper.class.getName();
    private static final String PICK_HELPER_KEY = "PICK_HELPER_PICKED";
    private PickListener pickListener;
    private Project project;
    private DebuggerThread simulationThread;
    private DebuggerClass simulationClass;
    private GreenfootRecorder greenfootRecorder;
    private SimulationStateListener simulationListener;
    private Map<String, GreenfootObject> objectBench = new HashMap<String, GreenfootObject>();
    private List<ObjectBenchListener> benchListeners = new ArrayList<ObjectBenchListener>();
    private VMCommsMain vmComms;
    private @OnThread(value=Tag.VMEventHandler) boolean hasLaunched = false;

    @OnThread(value=Tag.FXPlatform)
    private GreenfootDebugHandler(Project project) throws IOException {
        this.project = project;
        this.greenfootRecorder = new GreenfootRecorder();
        this.vmComms = new VMCommsMain(project);
    }

    @OnThread(value=Tag.FXPlatform)
    public static void addDebuggerListener(Project project) throws IOException {
        project.getExecControls().setRestrictedClasses(DebugUtil.restrictedClassesAsNames());
        GreenfootDebugHandler handler = new GreenfootDebugHandler(project);
        if (project.getDebugger().addDebuggerListener(handler) == 2) {
            project.getDebugger().runOnEventHandler(() -> handler.launch(project.getDebugger()));
        }
        GreenfootStage.makeStage(project, handler).show();
    }

    public void setPickListener(PickListener pickListener) {
        this.pickListener = pickListener;
    }

    @OnThread(value=Tag.FXPlatform)
    private void addRunResetBreakpoints(Debugger debugger) {
        try {
            this.simulationClass = debugger.getClass(SIMULATION_CLASS, true).get();
            this.setBreakpoint(debugger, SIMULATION_CLASS, "run", SIMULATION_THREAD_RUN_KEY);
            this.setBreakpoint(debugger, SIMULATION_CLASS, PAUSED_METHOD, SIMULATION_THREAD_PAUSED_KEY);
            this.setBreakpoint(debugger, SIMULATION_CLASS, "resumeRunning", SIMULATION_THREAD_RESUMED_KEY);
            this.setBreakpoint(debugger, WORLD_HANDLER_CLASS, "setInitialisingWorld", WORLD_INITIALISING_KEY);
            this.setBreakpoint(debugger, WORLD_HANDLER_CLASS, "worldChanged", WORLD_CHANGED_KEY);
            this.setBreakpoint(debugger, WORLD_HANDLER_CLASS, "worldInstantiationError", WORLD_INSTANTIATION_ERROR_KEY);
            this.setBreakpoint(debugger, NAME_ACTOR_CLASS, "nameActors", NAME_ACTOR_KEY);
            this.setBreakpoint(debugger, PICK_HELPER_CLASS, "picked", PICK_HELPER_KEY);
        }
        catch (ClassNotFoundException cnfe) {
            Debug.reportError("Simulation class could not be located. Possible installation problem.", cnfe);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void setBreakpoint(Debugger debugger, String className, String methodName, String breakpointKey) {
        HashMap<String, String> breakpointProperties = new HashMap<String, String>();
        breakpointProperties.put(breakpointKey, "TRUE");
        breakpointProperties.put("VMReference.PERSIST_BREAKPOINT", "TRUE");
        debugger.toggleBreakpoint(className, methodName, true, breakpointProperties);
    }

    @OnThread(value=Tag.Any)
    private boolean isSimulationThread(DebuggerThread dt) {
        return dt != null && this.simulationThread != null && this.simulationThread.sameThread(dt);
    }

    public VMCommsMain getVmComms() {
        return this.vmComms;
    }

    @OnThread(value=Tag.FXPlatform)
    public File getShmFile() {
        return this.vmComms.getSharedFile();
    }

    @OnThread(value=Tag.FXPlatform)
    public int getShmFileSize() {
        return this.vmComms.getSharedFileSize();
    }

    public int getLastSeq() {
        return this.vmComms.getLastSeq();
    }

    public GreenfootRecorder getRecorder() {
        return this.greenfootRecorder;
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public boolean examineDebuggerEvent(DebuggerEvent e) {
        boolean atBreakpoint;
        Debugger debugger = (Debugger)e.getSource();
        List<SourceLocation> stack = e.getThread().getStack();
        boolean bl = atBreakpoint = e.getID() == 5 && e.getThread() != null && e.getBreakpointProperties() != null;
        if (atBreakpoint && e.getBreakpointProperties().get(SIMULATION_THREAD_RUN_KEY) != null) {
            this.simulationThread = e.getThread();
            Platform.runLater(() -> this.project.getExecControls().selectThread(this.simulationThread));
            e.getThread().cont();
            return true;
        }
        if (atBreakpoint && e.getBreakpointProperties().get(SIMULATION_THREAD_RESUMED_KEY) != null) {
            if (this.simulationListener != null) {
                this.simulationListener.simulationStartedRunning();
            }
            e.getThread().cont();
            return true;
        }
        if (atBreakpoint && e.getBreakpointProperties().get(NAME_ACTOR_KEY) != null) {
            DebuggerObject actorArray = e.getThread().getStackObjectUntyped(0, 0);
            this.greenfootRecorder.nameActors(this.fetchArray(actorArray));
            e.getThread().cont();
            return true;
        }
        if (atBreakpoint && e.getBreakpointProperties().get(WORLD_INITIALISING_KEY) != null) {
            this.greenfootRecorder.clearCode(true);
            e.getThread().cont();
            return true;
        }
        if (atBreakpoint && e.getBreakpointProperties().get(WORLD_INSTANTIATION_ERROR_KEY) != null) {
            this.simulationListener.worldInstantiationError();
            e.getThread().cont();
            return true;
        }
        if (atBreakpoint && e.getBreakpointProperties().get(WORLD_CHANGED_KEY) != null) {
            List<DebuggerField> fields = e.getThread().getCurrentObject(0).getFields();
            DebuggerField worldField = fields.stream().filter(f -> f.getName().equals("world")).findFirst().orElse(null);
            if (worldField != null) {
                DebuggerObject worldValue = worldField.getValueObject();
                this.greenfootRecorder.setWorld(worldValue);
            }
            e.getThread().cont();
            return true;
        }
        if (atBreakpoint && e.getBreakpointProperties().get(PICK_HELPER_KEY) != null) {
            List<DebuggerField> fields = e.getThread().getCurrentObject(0).getFields();
            DebuggerField actorPicksField = fields.stream().filter(f -> f.getName().equals("actorPicks")).findFirst().orElse(null);
            DebuggerField worldPickField = fields.stream().filter(f -> f.getName().equals("worldPick")).findFirst().orElse(null);
            DebuggerField pickIdField = fields.stream().filter(f -> f.getName().equals("pickId")).findFirst().orElse(null);
            if (actorPicksField != null && worldPickField != null && pickIdField != null) {
                DebuggerObject actorPicksValue = actorPicksField.getValueObject();
                DebuggerObject worldPickValue = worldPickField.getValueObject();
                int pickIdValue = Integer.parseInt(pickIdField.getValueString());
                if (actorPicksValue != null && actorPicksValue.isArray() && worldPickValue != null) {
                    List<DebuggerObject> picksElements = this.fetchArray(actorPicksValue);
                    Platform.runLater(() -> {
                        if (this.pickListener != null) {
                            this.pickListener.picked(pickIdValue, picksElements, worldPickValue);
                        }
                    });
                }
            }
            e.getThread().cont();
            return true;
        }
        if (e.isHalt() && this.isSimulationThread(e.getThread())) {
            if (atBreakpoint && e.getBreakpointProperties().get(SIMULATION_THREAD_PAUSED_KEY) != null) {
                this.removeSpecialBreakpoints(debugger);
                if (this.simulationListener != null) {
                    this.simulationListener.simulationPaused();
                }
                e.getThread().cont();
                return true;
            }
            if (GreenfootDebugHandler.insideUserCode(stack)) {
                debugger.removeBreakpointsForClass(SIMULATION_CLASS);
                if (atBreakpoint && e.getBreakpointProperties().get(SIMULATION_INVOKE_KEY) != null) {
                    e.getThread().stepInto();
                    return true;
                }
                if (GreenfootDebugHandler.inInvokeMethods(stack, 0)) {
                    this.runToInternalBreakpoint(debugger, e.getThread());
                    return true;
                }
            } else {
                if (GreenfootDebugHandler.inPauseMethod(stack)) {
                    e.getThread().cont();
                } else {
                    this.runToInternalBreakpoint(debugger, e.getThread());
                }
                return true;
            }
        }
        return false;
    }

    @OnThread(value=Tag.Any)
    private List<DebuggerObject> fetchArray(DebuggerObject arrayValue) {
        ArrayList<DebuggerObject> elements = new ArrayList<DebuggerObject>(arrayValue.getElementCount());
        for (int i = 0; i < arrayValue.getElementCount(); ++i) {
            elements.add(arrayValue.getElementObject(i));
        }
        return elements;
    }

    @Override
    @OnThread(value=Tag.VMEventHandler)
    public void processDebuggerEvent(DebuggerEvent e, boolean skipUpdate) {
        if (e.getNewState() == 1) {
            this.hasLaunched = false;
            this.vmComms.vmTerminated();
            if (this.simulationListener != null) {
                this.simulationListener.simulationVMTerminated();
            }
        }
        if (e.getNewState() == 2 && !this.hasLaunched) {
            this.launch((Debugger)e.getSource());
        }
        if (!skipUpdate) {
            if (e.isHalt() && this.isSimulationThread(e.getThread()) && this.simulationListener != null) {
                this.simulationListener.simulationDebugHalted();
            } else if (e.getID() == 6 && this.isSimulationThread(e.getThread()) && this.simulationListener != null) {
                this.simulationListener.simulationDebugResumed();
            }
        }
    }

    @OnThread(value=Tag.VMEventHandler)
    private void launch(Debugger debugger) {
        if (!ProjectManager.checkLaunchFailed()) {
            this.hasLaunched = true;
            Platform.runLater(() -> {
                this.objectBench.clear();
                this.addRunResetBreakpoints(debugger);
                ProjectManager.instance().openGreenfoot(this.project, this);
            });
        }
    }

    @OnThread(value=Tag.VMEventHandler)
    private void runToInternalBreakpoint(Debugger debugger, DebuggerThread thread) {
        this.setSpecialBreakpoints(debugger);
        thread.cont();
    }

    private static boolean insideUserCode(List<SourceLocation> stack) {
        for (int i = 0; i < stack.size(); ++i) {
            if (!GreenfootDebugHandler.inInvokeMethods(stack, i)) continue;
            return true;
        }
        return false;
    }

    private static boolean inInvokeMethods(List<SourceLocation> stack, int frame) {
        if (frame < stack.size()) {
            String className = stack.get(frame).getClassName();
            if (className.equals(SIMULATION_CLASS)) {
                String methodName = stack.get(frame).getMethodName();
                for (String actMethod : INVOKE_METHODS) {
                    if (!actMethod.equals(methodName)) continue;
                    return true;
                }
            } else if (JavaNames.getBase(className).startsWith("__SHELL")) {
                return true;
            }
        }
        return false;
    }

    private static boolean inPauseMethod(List<SourceLocation> stack) {
        for (SourceLocation loc : stack) {
            if (!loc.getClassName().equals(SIMULATION_CLASS) || !loc.getMethodName().equals(PAUSED_METHOD)) continue;
            return true;
        }
        return false;
    }

    private void setSpecialBreakpoints(Debugger debugger) {
        for (String method : INVOKE_METHODS) {
            boolean nowSet = debugger.toggleBreakpoint(this.simulationClass, method, true, Collections.singletonMap(SIMULATION_INVOKE_KEY, "yes"));
            if (nowSet) continue;
            Debug.reportError("Problem setting special Greenfoot breakpoint");
        }
    }

    private void removeSpecialBreakpoints(Debugger debugger) {
        for (String method : INVOKE_METHODS) {
            debugger.toggleBreakpoint(this.simulationClass, method, false, Collections.singletonMap(SIMULATION_INVOKE_KEY, "yes"));
        }
    }

    public void setSimulationListener(SimulationStateListener simulationListener) {
        this.simulationListener = simulationListener;
    }

    public void haltSimulationThread() {
        this.project.getDebugger().runOnEventHandler(() -> {
            if (this.simulationThread != null) {
                this.simulationThread.halt();
            }
        });
    }

    @Override
    public String addObject(DebuggerObject object, GenTypeClass type, String name) {
        while (this.objectBench.get(name) != null) {
            name = (String)name + "_";
        }
        this.objectBench.put((String)name, new GreenfootObject(object, type, (String)name));
        return name;
    }

    @OnThread(value=Tag.FXPlatform)
    public NamedValue ensureObjectOnBench(DebuggerObject object, GenTypeClass type) {
        GreenfootObject selectedObject = null;
        for (GreenfootObject benchObj : this.objectBench.values()) {
            if (!benchObj.getDebuggerObject().equals(object)) continue;
            selectedObject = benchObj;
            break;
        }
        if (selectedObject == null) {
            String name = this.project.getDebugger().guessNewName(object);
            this.project.getDebugger().addObject(this.project.getPackage("").getId(), name, object);
            GreenfootObject newObj = new GreenfootObject(object, type, name);
            this.objectBench.put(name, newObj);
            selectedObject = newObj;
        }
        return selectedObject;
    }

    @OnThread(value=Tag.FXPlatform)
    public void addSelectedObjects(List<DebuggerObject> objects, Point2D screenPosition) {
        NamedValue[] values = this.nameObjects(objects);
        for (ObjectBenchListener l : this.benchListeners) {
            l.objectEvent(new ObjectBenchEvent(this, 1, values, screenPosition));
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public NamedValue[] nameObjects(List<DebuggerObject> objects) {
        NamedValue[] values = new NamedValue[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            values[i] = this.ensureObjectOnBench(objects.get(i), objects.get(i).getGenType());
        }
        return values;
    }

    @Override
    public void addObjectBenchListener(ObjectBenchListener l) {
        this.benchListeners.add(l);
    }

    @Override
    public void removeObjectBenchListener(ObjectBenchListener l) {
        this.benchListeners.remove(l);
    }

    @Override
    public boolean hasObject(String name) {
        return this.objectBench.get(name) != null;
    }

    @Override
    public NamedValue getNamedValue(String name) {
        return this.objectBench.get(name);
    }

    @Override
    public Iterator<? extends NamedValue> getValueIterator() {
        return this.objectBench.values().iterator();
    }

    public void simulationThreadResumeOnResetClick() {
        this.project.getDebugger().runOnEventHandler(() -> {
            if (this.simulationThread != null && this.simulationThread.isSuspended()) {
                this.simulationThread.cont();
            }
        });
        this.objectBench.clear();
    }

    public static interface SimulationStateListener {
        @OnThread(value=Tag.Any)
        public void simulationStartedRunning();

        @OnThread(value=Tag.Any)
        public void simulationPaused();

        @OnThread(value=Tag.Any)
        public void simulationDebugHalted();

        @OnThread(value=Tag.Any)
        public void simulationDebugResumed();

        @OnThread(value=Tag.Any)
        public void worldInstantiationError();

        @OnThread(value=Tag.Any)
        public void simulationVMTerminated();
    }

    public static interface PickListener {
        @OnThread(value=Tag.Any)
        public void picked(int var1, List<DebuggerObject> var2, DebuggerObject var3);
    }

    private static class GreenfootObject
    implements NamedValue {
        private GenTypeClass type;
        private String name;
        private DebuggerObject debuggerObject;

        public GreenfootObject(DebuggerObject object, GenTypeClass type, String name) {
            this.type = type;
            this.name = name;
            this.debuggerObject = object;
        }

        @Override
        public JavaType getGenType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public DebuggerObject getDebuggerObject() {
            return this.debuggerObject;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }
    }
}

