/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import javax.sound.sampled.AudioFormat;

public class SoundUtils {
    public static float convertMinMax(int val, float min, float max) {
        float range = max - min;
        float newVal = (float)val / (100.0f / range);
        return newVal + min;
    }

    public static int logToLin(int level) {
        return (int)(Math.log(level) / Math.log(100.0) * 100.0);
    }

    public static long getTimeToPlayBytes(long bytes, AudioFormat format) {
        return SoundUtils.getTimeToPlayFrames(bytes / (long)format.getFrameSize(), format);
    }

    public static long getTimeToPlayFrames(long frames, AudioFormat format) {
        if (format.getFrameRate() != -1.0f) {
            return (long)((float)(1000L * frames) / format.getFrameRate());
        }
        return -1L;
    }

    public static int getBufferSizeToHold(AudioFormat format, double seconds) {
        int bufferSize = format.getFrameRate() != -1.0f ? (int)Math.ceil((double)((float)format.getFrameSize() * format.getFrameRate()) * seconds) : (format.getSampleRate() != -1.0f ? (int)Math.ceil((double)((float)(format.getSampleSizeInBits() / 8 * format.getChannels()) * format.getSampleRate()) * seconds) : -1);
        return bufferSize;
    }
}

