/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import bluej.Config;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundExceptionHandler {
    private static volatile boolean lineUnavailableHandled;
    private static volatile boolean illegalArgumentHandled;
    private static volatile boolean securityHandled;
    private static boolean mp3LibHandled;

    public static void handleUnsupportedAudioFileException(UnsupportedAudioFileException e, String filename) {
        throw new IllegalArgumentException("Format of sound file not supported: " + filename, e);
    }

    public static void handleFileNotFoundException(FileNotFoundException e, String filename) {
        throw new IllegalArgumentException("Could not find sound file: " + filename, e);
    }

    public static void handleIOException(IOException e, String filename) {
        throw new IllegalArgumentException("Could not open sound file: " + filename, e);
    }

    public static void handleLineUnavailableException(Exception e) {
        if (!lineUnavailableHandled) {
            lineUnavailableHandled = true;
            String errMsg = Config.getString("sound-line-unavailable");
            System.err.println(errMsg);
        }
    }

    public static void handleIllegalArgumentException(IllegalArgumentException e, String filename) {
        if (!illegalArgumentHandled) {
            illegalArgumentHandled = true;
            System.err.println("Could not play sound file: " + filename);
            System.err.println("If you have a sound card installed, check your system settings.");
            e.printStackTrace();
        }
    }

    public static void handleSecurityException(SecurityException e, String filename) {
        if (!securityHandled) {
            securityHandled = true;
            System.err.println("Could not play sound file due to security restrictions: " + filename);
            System.err.println("If you have a sound card installed, check your system settings.");
            e.printStackTrace();
        }
    }

    public static void handleInvalidMidiDataException(InvalidMidiDataException e, String filename) {
        throw new IllegalArgumentException("Invalid data in MIDI file: " + filename, e);
    }

    public static void handleMp3LibNotAvailable() {
        if (!mp3LibHandled) {
            mp3LibHandled = true;
            System.err.println("MP3 library not available. You will not be able to play any mp3 audio files. This is most likely happening because you are using a non-standard Greenfoot installation. To get the standard version, go to https://www.greenfoot.org");
        }
    }
}

