/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.platforms.ide;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import bluej.Config;
import bluej.runtime.ExecServer;
import bluej.utility.Debug;
import greenfoot.GreenfootImage;
import greenfoot.UserInfo;
import greenfoot.UserInfoVisitor;
import greenfoot.core.GreenfootMain;
import greenfoot.platforms.GreenfootUtilDelegate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Simulation)
public class GreenfootUtilDelegateIDE
implements GreenfootUtilDelegate {
    private static @OnThread(value=Tag.Any) GreenfootUtilDelegateIDE instance = new GreenfootUtilDelegateIDE();

    @OnThread(value=Tag.Any)
    public static GreenfootUtilDelegateIDE getInstance() {
        return instance;
    }

    private GreenfootUtilDelegateIDE() {
    }

    @Override
    @OnThread(value=Tag.Any)
    public URL getResource(String path) {
        return ExecServer.getCurrentClassLoader().getResource(path);
    }

    @Override
    @OnThread(value=Tag.Any)
    public Iterable<String> getSoundFiles() {
        ArrayList<String> files = new ArrayList<String>();
        try {
            URL url = this.getResource("sounds");
            if (url != null && "file".equals(url.getProtocol())) {
                for (String file : new File(url.toURI()).list()) {
                    files.add(file);
                }
            }
        }
        catch (URISyntaxException e) {
            Debug.reportError("Bad URI in getResources", e);
        }
        return files;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getGreenfootLogoPath() {
        File libDir = Config.getGreenfootLibDir();
        return libDir.getAbsolutePath() + "/imagelib/other/greenfoot.png";
    }

    @Override
    public boolean isStorageSupported() {
        return this.getUserName() != null && !this.getUserName().isEmpty();
    }

    @Override
    public String getUserName() {
        return GreenfootMain.getPropString("greenfoot.player.name", "Player1");
    }

    @Override
    public UserInfo getCurrentUserInfo() {
        if (this.getUserName() == null || this.getUserName().isEmpty()) {
            return null;
        }
        ArrayList<UserInfo> all = this.getAllDataSorted(true);
        if (all == null) {
            return null;
        }
        for (int i = 0; i < all.size(); ++i) {
            if (!this.getUserName().equals(all.get(i).getUserName())) continue;
            return all.get(i);
        }
        return UserInfoVisitor.allocate(this.getUserName(), -1, this.getUserName());
    }

    private UserInfo makeStorage(String[] line, int rank, boolean useSingleton) {
        UserInfo r = null;
        try {
            int i;
            int column = 0;
            r = UserInfoVisitor.allocate(line[column++], rank, useSingleton ? this.getUserName() : null);
            r.setScore(Integer.parseInt(line[column++]));
            for (i = 0; i < 10; ++i) {
                r.setInt(i, Integer.parseInt(line[column++]));
            }
            for (i = 0; i < 5; ++i) {
                r.setString(i, line[column++]);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return r;
    }

    private String[] makeLine(String userName, UserInfo data) {
        String[] line = new String[17];
        int column = 0;
        line[column++] = userName;
        line[column++] = Integer.toString(data.getScore());
        try {
            int i;
            for (i = 0; i < 10; ++i) {
                line[column++] = Integer.toString(data.getInt(i));
            }
            for (i = 0; i < 5; ++i) {
                line[column++] = data.getString(i);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return line;
    }

    @Override
    public boolean storeCurrentUserInfo(UserInfo data) {
        List<Object> all;
        if (this.getUserName() == null || this.getUserName().isEmpty()) {
            return false;
        }
        try {
            CSVReader csv = new CSVReader(new InputStreamReader((InputStream)new FileInputStream("storage.csv"), "UTF-8"));
            all = csv.readAll();
            csv.close();
        }
        catch (FileNotFoundException e) {
            all = new ArrayList();
        }
        catch (IOException e) {
            Debug.message("Error reading user data: " + e.getMessage());
            return false;
        }
        Iterator lineIt = all.iterator();
        while (lineIt.hasNext()) {
            String[] line = (String[])lineIt.next();
            if (line.length <= 1 || !this.getUserName().equals(line[0])) continue;
            lineIt.remove();
            break;
        }
        if (data != null) {
            all.add(this.makeLine(this.getUserName(), data));
        }
        try {
            CSVWriter csvOut = new CSVWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("storage.csv"), "UTF-8"));
            csvOut.writeAll(all);
            csvOut.close();
            return true;
        }
        catch (IOException e) {
            Debug.message("Error storing user data: " + e.getMessage());
            return false;
        }
    }

    private ArrayList<UserInfo> getAllDataSorted(boolean useSingleton) {
        try {
            ArrayList<UserInfo> ret = new ArrayList<UserInfo>();
            CSVReader csv = new CSVReader(new InputStreamReader((InputStream)new FileInputStream("storage.csv"), "UTF-8"));
            List<String[]> all = csv.readAll();
            Collections.sort(all, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    return -(Integer.parseInt(o1[1]) - Integer.parseInt(o2[1]));
                }
            });
            int rank = 1;
            for (String[] line : all) {
                ret.add(this.makeStorage(line, rank, useSingleton));
                ++rank;
            }
            csv.close();
            return ret;
        }
        catch (FileNotFoundException e) {
            return new ArrayList<UserInfo>();
        }
        catch (IOException e) {
            Debug.message("Error reading user data: " + e.getMessage());
            return null;
        }
    }

    @Override
    public List<UserInfo> getTopUserInfo(int limit) {
        ArrayList<UserInfo> ret = this.getAllDataSorted(false);
        if (ret == null) {
            return null;
        }
        if (ret.size() <= limit || limit <= 0) {
            return ret;
        }
        return ret.subList(0, limit);
    }

    @Override
    public GreenfootImage getUserImage(String userName) {
        return null;
    }

    @Override
    public List<UserInfo> getNearbyUserInfo(int maxAmount) {
        if (this.getUserName() == null || this.getUserName().isEmpty()) {
            return null;
        }
        ArrayList<UserInfo> all = this.getAllDataSorted(false);
        if (all == null) {
            return null;
        }
        int index = -1;
        for (int i = 0; i < all.size(); ++i) {
            if (this.getUserName() == null || !this.getUserName().equals(all.get(i).getUserName())) continue;
            index = i;
            break;
        }
        if (index == -1 || maxAmount == 0) {
            return new ArrayList<UserInfo>();
        }
        int availableBefore = index;
        int availableAfter = all.size() - 1 - index;
        int desiredBefore = maxAmount / 2;
        int desiredAfter = Math.max(0, maxAmount - 1) / 2;
        if (availableAfter + availableBefore + 1 <= maxAmount) {
            return all;
        }
        if (availableBefore <= desiredBefore) {
            return all.subList(index - availableBefore, index - availableBefore + maxAmount + 1);
        }
        if (availableAfter <= desiredAfter) {
            return all.subList(index + availableAfter - maxAmount, index + availableAfter + 1);
        }
        return all.subList(index - desiredBefore, index + desiredAfter + 1);
    }
}

