/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.mouse;

import greenfoot.Actor;
import greenfoot.MouseInfo;
import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.WorldVisitor;
import greenfoot.core.Simulation;
import greenfoot.gui.input.mouse.MousePollingManager;
import greenfoot.gui.input.mouse.WorldLocator;
import greenfoot.util.GreenfootUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javafx.scene.input.MouseButton;
import javax.swing.JPanel;
import junit.framework.TestCase;

public class MousePollTest
extends TestCase {
    private MousePollingManager mouseMan;
    private JPanel panel = new JPanel();
    private World world;
    private TestObject actorAtClick;
    private TestObject actorOutsideClick;

    @Override
    protected void setUp() {
        GreenfootUtil.initialise(new TestUtilDelegate());
        Simulation.initialize();
        this.world = WorldCreator.createWorld(200, 200, 1);
        this.actorAtClick = new TestObject(10, 10);
        this.world.addObject(this.actorAtClick, 5, 5);
        this.actorOutsideClick = new TestObject(10, 10);
        this.world.addObject(this.actorOutsideClick, 50, 50);
        this.mouseMan = new MousePollingManager(new WorldLocator(){

            @Override
            public Actor getTopMostActorAt(int worldPixelPositionX, int worldPixelPositionY) {
                Collection<Actor> actors = WorldVisitor.getObjectsAtPixel(MousePollTest.this.world, worldPixelPositionX, worldPixelPositionY);
                if (actors.isEmpty()) {
                    return null;
                }
                return actors.iterator().next();
            }

            @Override
            public int getTranslatedX(int x) {
                return WorldVisitor.toCellFloor(MousePollTest.this.world, x);
            }

            @Override
            public int getTranslatedY(int y) {
                return WorldVisitor.toCellFloor(MousePollTest.this.world, y);
            }
        });
    }

    private void dispatch(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        MouseButton button = MouseButton.values()[e.getButton()];
        int clickCount = e.getClickCount();
        switch (e.getID()) {
            case 500: {
                this.mouseMan.mouseClicked(x, y, button, clickCount);
                break;
            }
            case 501: {
                this.mouseMan.mousePressed(x, y, button);
                break;
            }
            case 506: {
                this.mouseMan.mouseDragged(x, y, button);
                break;
            }
            case 502: {
                this.mouseMan.mouseReleased(x, y, button);
                break;
            }
            case 503: {
                this.mouseMan.mouseMoved(x, y);
                break;
            }
            case 505: {
                this.mouseMan.mouseExited();
            }
        }
    }

    private void assertBlank() {
        for (Object obj : new Object[]{this.actorAtClick, this.actorOutsideClick, null}) {
            MousePollTest.assertFalse(this.mouseMan.isMouseClicked(obj));
            MousePollTest.assertFalse(this.mouseMan.isMouseDragEnded(obj));
            MousePollTest.assertFalse(this.mouseMan.isMouseDragged(obj));
            MousePollTest.assertFalse(this.mouseMan.isMouseMoved(obj));
            MousePollTest.assertFalse(this.mouseMan.isMousePressed(obj));
        }
        MouseInfo info = this.mouseMan.getMouseInfo();
        if (info != null) {
            MousePollTest.assertEquals(0, info.getClickCount());
            MousePollTest.assertEquals(0, info.getButton());
            MousePollTest.assertNull(info.getActor());
        }
    }

    public void testSingleLeftClickOnActor() {
        this.mouseMan.newActStarted();
        this.assertBlank();
        MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.assertBlank();
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(null));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(null));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.actorOutsideClick));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(this.actorAtClick));
        MouseInfo mouseInfo = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals(1, mouseInfo.getButton());
        MousePollTest.assertEquals(1, mouseInfo.getClickCount());
        this.mouseMan.newActStarted();
        this.assertBlank();
        mouseInfo = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals(0, mouseInfo.getClickCount());
    }

    public void testLongLeftClickOnActor() {
        this.mouseMan.newActStarted();
        this.assertBlank();
        MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.assertBlank();
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMousePressed(this.actorOutsideClick));
        MousePollTest.assertFalse(this.mouseMan.isMousePressed(this.world));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(null));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(null));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        MouseInfo mouseInfo = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals(1, mouseInfo.getButton());
        MousePollTest.assertEquals(0, mouseInfo.getClickCount());
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMousePressed(null));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(null));
    }

    public void testSimpleMouseDraggedOnActor() {
        this.mouseMan.newActStarted();
        MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 7, 8, 1, false, 1);
        this.dispatch(event);
        this.assertBlank();
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(this.actorAtClick));
        MouseInfo info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals(7, info.getX());
        MousePollTest.assertEquals(8, info.getY());
        this.mouseMan.newActStarted();
        this.assertBlank();
    }

    public void testLongMouseDraggedOnActor() {
        this.mouseMan.newActStarted();
        MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.assertBlank();
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertNotNull(this.mouseMan.getMouseInfo());
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 7, 7, 1, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.getMouseInfo().getX() == 7 && this.mouseMan.getMouseInfo().getY() == 7);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 8, 8, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 9, 9, 1, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.getMouseInfo().getX() == 9 && this.mouseMan.getMouseInfo().getY() == 9);
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertNotNull(this.mouseMan.getMouseInfo());
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 14, 14, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.getMouseInfo().getX() == 14 && this.mouseMan.getMouseInfo().getY() == 14);
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.actorAtClick));
    }

    public void testLongMouseMovedOnActor() {
        this.mouseMan.newActStarted();
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMouseMoved(null));
        MousePollTest.assertFalse(this.mouseMan.isMouseMoved(this.actorOutsideClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseMoved(this.world));
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse(this.mouseMan.isMouseMoved(this.actorAtClick));
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.actorAtClick));
    }

    public void testMultipleButtons() {
        Exception exception = null;
        try {
            MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 2);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 7, 7, 1, false, 1);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
            this.dispatch(event);
            this.mouseMan.newActStarted();
            this.mouseMan.isMouseClicked(null);
            this.mouseMan.isMousePressed(null);
            this.mouseMan.isMouseMoved(null);
            this.mouseMan.isMouseDragged(null);
            this.mouseMan.isMouseDragEnded(null);
            MouseInfo info = this.mouseMan.getMouseInfo();
            info.getActor();
            info.getX();
            info.getButton();
        }
        catch (Exception e) {
            exception = e;
        }
        MousePollTest.assertNull(exception);
    }

    public void testButton2() {
        MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 2);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 0, false, 2);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertNotNull(this.mouseMan.getMouseInfo());
        this.mouseMan.newActStarted();
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 5, 5, 0, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertNotNull(this.mouseMan.getMouseInfo());
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 8, 8, 0, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertNotNull(this.mouseMan.getMouseInfo());
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 7, 7, 1, false, 2);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(this.actorAtClick));
    }

    public void testBigCellSize() {
        final World world = WorldCreator.createWorld(20, 20, 10);
        this.mouseMan = new MousePollingManager(new WorldLocator(){

            @Override
            public Actor getTopMostActorAt(int worldPixelPositionX, int worldPixelPositionY) {
                Collection<Actor> actors = WorldVisitor.getObjectsAtPixel(world, worldPixelPositionX, worldPixelPositionY);
                if (actors.isEmpty()) {
                    return null;
                }
                return actors.iterator().next();
            }

            @Override
            public int getTranslatedX(int x) {
                return WorldVisitor.toCellFloor(world, x);
            }

            @Override
            public int getTranslatedY(int y) {
                return WorldVisitor.toCellFloor(world, y);
            }
        });
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseMoved(null));
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 55, 75, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseMoved(null));
        MouseInfo info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals(5, info.getX());
        MousePollTest.assertEquals(7, info.getY());
    }

    public void testDragEndPriorities() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 1, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 2, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 3, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 4, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 2, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 3, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 7, 8, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 8, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 9, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 1, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 2, 4, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 3, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 4, 5, 1, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MouseInfo info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals(7, info.getX());
        MousePollTest.assertEquals(8, info.getY());
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 5, 5, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 5, 5, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 3, 3, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(this.actorAtClick));
        info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals(3, info.getX());
        MousePollTest.assertEquals(3, info.getY());
        MousePollTest.assertFalse(this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(this.actorAtClick));
    }

    public void testClickPriorities() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 8, 8, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 5, 5, 1, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(this.actorAtClick));
        MouseInfo info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals(8, info.getX());
        MousePollTest.assertEquals(8, info.getY());
        MousePollTest.assertFalse(this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragEnded(this.actorAtClick));
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 1, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 2, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 3, 7, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 4, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 6, 4, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals(6, info.getX());
        MousePollTest.assertEquals(4, info.getY());
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragEnded(this.actorAtClick));
    }

    public void testPressPriorities() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 8, 8, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 5, 5, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        MouseInfo info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals(8, info.getX());
        MousePollTest.assertEquals(8, info.getY());
        MousePollTest.assertFalse(this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragEnded(this.actorAtClick));
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 1, 6, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 2, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 3, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 4, 3, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals(4, info.getX());
        MousePollTest.assertEquals(3, info.getY());
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragEnded(this.actorAtClick));
    }

    public void testDontKeepDataTillFirstClick() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        this.mouseMan.newActStarted();
        this.assertBlank();
        this.mouseMan.newActStarted();
        this.assertBlank();
    }

    public void testMoveClickWithinActor() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 26, 26, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 26, 26, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.actorAtClick));
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse(this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMousePressed(this.actorAtClick));
    }

    public void testNullPressDragClickOnActorBounds() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 26, 26, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 26, 26, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(null));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(null));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(null));
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse(this.mouseMan.isMouseMoved(null));
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(null));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(null));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(null));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.world));
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(this.world));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.world));
        MousePollTest.assertFalse(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMousePressed(this.actorAtClick));
    }

    public void testMultipleDragsInFrame() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 26, 26, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 26, 26, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse(this.mouseMan.isMouseMoved(null));
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(null));
        MousePollTest.assertTrue(this.mouseMan.isMouseClicked(null));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(null));
        MousePollTest.assertTrue(this.mouseMan.isMousePressed(this.world));
        MousePollTest.assertTrue(this.mouseMan.isMouseDragEnded(this.world));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.world));
        MousePollTest.assertFalse(this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse(this.mouseMan.isMousePressed(this.actorAtClick));
    }
}

