/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.importer.scratch;

import bluej.extensions2.SourceType;
import bluej.utility.Debug;
import greenfoot.importer.scratch.ImageMedia;
import greenfoot.importer.scratch.Morph;
import greenfoot.importer.scratch.ScratchImport;
import greenfoot.importer.scratch.ScratchObject;
import greenfoot.importer.scratch.ScratchObjectArray;
import greenfoot.importer.scratch.ScratchPoint;
import greenfoot.importer.scratch.ScratchPrimitive;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public abstract class ScriptableScratchMorph
extends Morph {
    private String[] costumes;
    private String mungedName;
    private File javaFile;

    public ScriptableScratchMorph(int id, int version, List<ScratchObject> scratchObjects) {
        super(id, version, scratchObjects);
    }

    @Override
    public int fields() {
        return super.fields() + 6;
    }

    private String getObjName() {
        return (String)((ScratchObject)this.scratchObjects.get(super.fields() + 0)).getValue();
    }

    public String getObjNameJava() {
        if (this.mungedName == null) {
            Debug.message("Munging: " + this.getObjName());
            this.mungedName = ScratchImport.mungeUnique(this.getObjName());
            Debug.message("Munged to: " + this.mungedName);
        }
        return this.mungedName;
    }

    public ScratchObjectArray getBlocks() {
        return (ScratchObjectArray)this.scratchObjects.get(super.fields() + 2);
    }

    public ScratchObjectArray getMedia() {
        return (ScratchObjectArray)this.scratchObjects.get(super.fields() + 4);
    }

    public ImageMedia getCostume() {
        return (ImageMedia)this.scratchObjects.get(super.fields() + 5);
    }

    public ImageMedia[] getCostumes() {
        ArrayList<ImageMedia> imgs = new ArrayList<ImageMedia>();
        ScratchObjectArray objArray = (ScratchObjectArray)this.scratchObjects.get(super.fields() + 4);
        for (ScratchObject o : objArray.getValue()) {
            if (!(o instanceof ImageMedia)) continue;
            imgs.add((ImageMedia)o);
        }
        return imgs.toArray(new ImageMedia[0]);
    }

    public int getCostumeCount() {
        return ((ScratchObjectArray)this.scratchObjects.get(super.fields() + 4)).getValue().length;
    }

    protected abstract String greenfootSuperClass();

    protected abstract void constructorContents(StringBuilder var1);

    @Override
    public File saveInto(File destDir, Properties props, String prefix) throws IOException {
        if (this.javaFile != null) {
            return this.javaFile;
        }
        ImageMedia imageMedia = this.getCostume();
        String className = this.getObjNameJava();
        StringBuilder acc = new StringBuilder();
        acc.append("import greenfoot.*;\npublic class " + className);
        String superClass = this.greenfootSuperClass();
        if (superClass != null) {
            acc.append(" extends ").append(superClass);
        }
        this.costumes = new String[this.getCostumeCount()];
        acc.append("\n{\n");
        acc.append("private static final String[] COSTUMES = new String[] {");
        int i = 0;
        int curCostume = 0;
        for (ImageMedia img : this.getCostumes()) {
            if (i != 0) {
                acc.append(", ");
            }
            this.costumes[i] = img.saveInto(destDir, props, className + "_").getName();
            acc.append("\"").append(this.costumes[i]).append("\"");
            if (img == imageMedia) {
                curCostume = i;
            }
            ++i;
        }
        acc.append("};\n");
        acc.append("private static final int[] X_OFFSETS = new int[] {");
        i = 0;
        for (ImageMedia img : this.getCostumes()) {
            if (i != 0) {
                acc.append(", ");
            }
            acc.append(this.getScaleAmount().x.multiply(new BigDecimal(img.getWidth() / 2).subtract(img.getRotationCentre().x)).intValue());
            ++i;
        }
        acc.append("};\n");
        acc.append("private static final int[] Y_OFFSETS = new int[] {");
        i = 0;
        for (ImageMedia img : this.getCostumes()) {
            if (i != 0) {
                acc.append(", ");
            }
            acc.append(this.getScaleAmount().y.multiply(new BigDecimal(img.getHeight() / 2).subtract(img.getRotationCentre().y)).intValue());
            ++i;
        }
        acc.append("};\n");
        acc.append("private int curCostume = ").append(curCostume).append(";\n");
        acc.append("public " + className + "()\n{\n");
        this.constructorContents(acc);
        acc.append("}\n");
        this.addHelpers(acc);
        this.codeForScripts(this.getBlocks(), acc, new LoopVarIterator());
        acc.append("}\n");
        this.javaFile = new File(destDir, className + "." + SourceType.Java.toString().toLowerCase());
        FileWriter javaFileWriter = new FileWriter(this.javaFile);
        javaFileWriter.write(acc.toString());
        javaFileWriter.close();
        for (ScratchObject media : this.getMedia()) {
            media.saveInto(destDir, props, className + "_");
        }
        File imageFile = ((ScratchObject)imageMedia).saveInto(destDir, props, className + "_");
        props.setProperty("class." + className + ".image", imageFile.getName());
        return this.javaFile;
    }

    protected void addHelpers(StringBuilder acc) {
    }

    private void codeForBlock(ScratchObject block, StringBuilder decl, StringBuilder method, LoopVarIterator loopVars) {
        ScratchObject[] blockContents = (ScratchObject[])block.getValue();
        if ("doRepeat".equals(blockContents[0].getValue())) {
            String var = loopVars.next();
            method.append("for (int " + var + " = 0; " + var + " < ").append(blockContents[1].getValue()).append(";" + var + "++)\n{\n");
            this.codeForBlock(blockContents[2], decl, method, new LoopVarIterator(loopVars));
            method.append("}\n");
        } else if ("doPlaySoundAndWait".equals(blockContents[0].getValue())) {
            String soundName = ScratchImport.mungeUnique("snd" + (String)blockContents[1].getValue());
            decl.append("GreenfootSound ").append(soundName).append(";\n");
            method.append("if (" + soundName + " == null || !" + soundName + ".isPlaying()) {\n").append(soundName).append(" = new GreenfootSound(\"").append(this.getObjNameJava()).append("_").append(blockContents[1].getValue()).append(".wav\");\n").append(soundName).append(".play();\n}\n");
        } else if ("playSound:".equals(blockContents[0].getValue())) {
            method.append("new GreenfootSound(\"").append(this.getObjNameJava()).append("_").append(blockContents[1].getValue()).append(".wav\").play();\n");
        } else if ("setGraphicEffect:to:".equals(blockContents[0].getValue())) {
            if ("ghost".equals(blockContents[1].getValue())) {
                method.append("getImage().setTransparency(").append(new BigDecimal(255).subtract(((BigDecimal)blockContents[2].getValue()).multiply(BigDecimal.valueOf(2.55))).intValue()).append(");\n");
            }
        } else if ("hide".equals(blockContents[0].getValue())) {
            method.append("getImage().setTransparency(0);\n");
        } else if ("show".equals(blockContents[0].getValue())) {
            method.append("getImage().setTransparency(255);\n");
        } else if ("lookLike:".equals(blockContents[0].getValue())) {
            if (blockContents[1].getValue() instanceof String) {
                String costumeRoot = this.getObjNameJava() + "_" + (String)blockContents[1].getValue();
                int costumeFile = this.findCostume(costumeRoot + ".png");
                if (costumeFile >= 0) {
                    costumeRoot = costumeRoot + ".png";
                } else {
                    costumeFile = this.findCostume(costumeRoot + ".jpg");
                    if (costumeFile >= 0) {
                        costumeRoot = costumeRoot + ".jpg";
                    }
                }
                if (costumeFile >= 0) {
                    method.append("curCostume = ").append(costumeFile).append(";\n");
                    method.append("setImage(\"").append(costumeRoot).append("\");\n");
                    method.append("getImage().scale(").append(this.getBounds().x2.subtract(this.getBounds().x).intValue()).append(", ").append(this.getBounds().y2.subtract(this.getBounds().y).intValue()).append(");\n");
                    method.append("getWorld().repaint();\n");
                } else {
                    Debug.message("Could not locate costume: " + costumeFile);
                }
            }
        } else if ("forward:".equals(blockContents[0].getValue())) {
            method.append("move(").append(blockContents[1].getValue()).append(");\n");
        } else if ("bounceOffEdge".equals(blockContents[0].getValue())) {
            method.append("if (atWorldEdge()) turn(180);\n");
        } else if ("randomFrom:to:".equals(blockContents[0].getValue())) {
            int from = (Integer)blockContents[1].getValue();
            int to = (Integer)blockContents[2].getValue();
            if (from == 0) {
                method.append("Greenfoot.randomNumber(").append(to).append(")");
            } else {
                method.append("(Greenfoot.randomNumber(").append(to - from).append(") + ").append(from).append(")");
            }
        } else if ("say:duration:elapsed:from:".equals(blockContents[0].getValue())) {
            if (blockContents.length >= 3) {
                method.append("{\nBubble bubble = new Bubble(\"").append((String)blockContents[1].getValue()).append("\");\n");
                method.append("getWorld().addObject(bubble, getX(), getY());");
                method.append("getWorld().repaint();\n");
                this.codeForBlock(new ScratchObjectArray(new ScratchObject[]{new ScratchPrimitive("wait:elapsed:from:"), blockContents[2]}), decl, method, loopVars);
                method.append("getWorld().removeObject(bubble);\n}\n");
            }
        } else if ("gotoX:y:".equals(blockContents[0].getValue())) {
            method.append("setLocation((getWorld().getWidth() / 2) + ").append(((BigDecimal)blockContents[1].getValue()).intValue()).append(" + X_OFFSETS[curCostume]").append(", (getWorld().getHeight() / 2) - ").append(((BigDecimal)blockContents[2].getValue()).intValue()).append(" + Y_OFFSETS[curCostume]").append(");\n");
        } else if ("turnRight:".equals(blockContents[0].getValue())) {
            String degrees = blockContents[1].getValue().toString();
            method.append("turn(-").append(degrees).append(");\n");
        } else if ("nextCostume".equals(blockContents[0].getValue())) {
            method.append("curCostume = (curCostume + 1) % COSTUMES.length;\n");
            method.append("setImage(COSTUMES[curCostume]);\n");
            method.append("getImage().scale(").append(this.getBounds().x2.subtract(this.getBounds().x).intValue()).append(", ").append(this.getBounds().y2.subtract(this.getBounds().y).intValue()).append(");\n");
            method.append("getWorld().repaint();\n");
        } else if ("wait:elapsed:from:".equals(blockContents[0].getValue())) {
            if (blockContents[1].getValue() instanceof BigDecimal) {
                BigDecimal seconds = (BigDecimal)blockContents[1].getValue();
                method.append("try {\n");
                method.append("Thread.sleep(").append(seconds.scaleByPowerOfTen(3).intValue()).append(");\n");
                method.append("} catch (InterruptedException e) { }");
            }
        } else if (blockContents[0] instanceof ScratchObjectArray) {
            for (ScratchObject blockContent : blockContents) {
                this.codeForBlock(blockContent, decl, method, loopVars);
            }
        } else {
            StringBuilder tmp = new StringBuilder();
            for (ScratchObject o : blockContents) {
                tmp.append(o).append(",");
            }
            Debug.message("Unknown Scratch block/code: " + tmp.toString());
        }
    }

    private int findCostume(String searchFor) {
        for (int i = 0; i < this.costumes.length; ++i) {
            if (!searchFor.equals(this.costumes[i])) continue;
            return i;
        }
        return -1;
    }

    private void codeForScripts(ScratchObjectArray scripts, StringBuilder acc, LoopVarIterator loopVars) {
        StringBuilder decl = new StringBuilder();
        StringBuilder method = new StringBuilder();
        StringBuilder firstTimeCode = new StringBuilder();
        for (ScratchObject scriptChunk : scripts.getValue()) {
            ScratchObject[] info = (ScratchObject[])scriptChunk.getValue();
            ScratchObject[] blocks = (ScratchObject[])info[1].getValue();
            ScratchObject[] firstBlockContents = (ScratchObject[])blocks[0].getValue();
            if ("MouseClickEventHatMorph".equals(firstBlockContents[0].getValue())) {
                if (!"Scratch-MouseClickEvent".equals(firstBlockContents[1].getValue())) continue;
                method.append("if (Greenfoot.mouseClicked(this)) {");
                for (ScratchObject block : Arrays.copyOfRange(blocks, 1, blocks.length)) {
                    this.codeForBlock(block, decl, method, loopVars);
                }
                method.append("}");
                continue;
            }
            if ("EventHatMorph".equals(firstBlockContents[0].getValue())) {
                ScratchObject[] blockContents;
                int i;
                if (!"Scratch-StartClicked".equals(firstBlockContents[1].getValue())) continue;
                ScratchObject[] subsequentBlocks = Arrays.copyOfRange(blocks, 1, blocks.length);
                if (subsequentBlocks.length == 1 && ScriptableScratchMorph.isLoop(subsequentBlocks[0])) {
                    this.codeForBlock(subsequentBlocks[0], decl, method, loopVars);
                    continue;
                }
                for (i = 0; i < subsequentBlocks.length && !ScriptableScratchMorph.isLoop((blockContents = (ScratchObject[])subsequentBlocks[i].getValue())[0]); ++i) {
                    this.codeForBlock(subsequentBlocks[i], decl, firstTimeCode, loopVars);
                }
                if (i >= subsequentBlocks.length) continue;
                ScratchObject[] blockContents2 = (ScratchObject[])subsequentBlocks[i].getValue();
                if ("doForever".equals(blockContents2[0].getValue())) {
                    this.codeForBlock(blockContents2[1], decl, method, loopVars);
                    continue;
                }
                if (!"doRepeat".equals(blockContents2[0].getValue())) continue;
                decl.append("private int loopCount = 0;\n");
                method.append("if (loopCount < ").append(blockContents2[1].getValue()).append(") {\n");
                method.append("loopCount += 1;\n");
                this.codeForBlock(blockContents2[2], decl, method, loopVars);
                method.append("}\n");
                continue;
            }
            if ("KeyEventHatMorph".equals(firstBlockContents[0].getValue())) {
                ScratchObject[] subsequentBlocks;
                String scratchKeyName = (String)firstBlockContents[1].getValue();
                String greenfootKeyName = null;
                if (scratchKeyName.endsWith(" arrow")) {
                    greenfootKeyName = scratchKeyName.substring(0, scratchKeyName.length() - " arrow".length());
                }
                if (greenfootKeyName == null) continue;
                method.append("if (Greenfoot.isKeyDown(\"" + greenfootKeyName + "\")) {\n");
                for (ScratchObject block : subsequentBlocks = Arrays.copyOfRange(blocks, 1, blocks.length)) {
                    this.codeForBlock(block, decl, method, loopVars);
                }
                method.append("}\n");
                continue;
            }
            Debug.message("Ignoring block headed: " + firstBlockContents[0].getValue());
        }
        acc.append((CharSequence)decl);
        if (firstTimeCode.length() > 0) {
            acc.append("private boolean firstTime = true;\n");
        }
        acc.append("public void act()\n{\n");
        if (firstTimeCode.length() > 0) {
            acc.append("if (firstTime) {\n");
            acc.append("firstTime = false;\n");
            acc.append((CharSequence)firstTimeCode);
            acc.append("}\n");
        }
        acc.append((CharSequence)method);
        acc.append("}\n");
    }

    private static boolean isLoop(ScratchObject scratchObject) {
        return "doForever".equals(scratchObject.getValue()) || "doRepeat".equals(scratchObject.getValue());
    }

    public ScratchPoint getScaleAmount() {
        return new ScratchPoint(new BigDecimal(1), new BigDecimal(1));
    }

    private static class LoopVarIterator {
        int i = 0;

        public LoopVarIterator() {
        }

        public LoopVarIterator(LoopVarIterator it) {
            this.i = it.i;
        }

        public String next() {
            switch (this.i++) {
                case 0: {
                    return "i";
                }
                case 1: {
                    return "j";
                }
                case 2: {
                    return "k";
                }
            }
            return "i" + (this.i - 2);
        }
    }
}

