/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.soundrecorder;

import bluej.Config;
import bluej.utility.DialogManager;
import bluej.utility.javafx.JavaFXUtil;
import greenfoot.sound.SoundRecorder;
import java.io.File;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
class SaveState {
    private final Window parent;
    private final SoundRecorder recorder;
    private final TextField filenameField = new TextField();
    private final Button saveButton = new Button(Config.getString("soundRecorder.save"));
    private String lastSaveName = null;
    private final SimpleBooleanProperty saved = new SimpleBooleanProperty(true);
    private final SimpleBooleanProperty changedSinceSave = new SimpleBooleanProperty(false);
    private File projectSoundDir;

    SaveState(Window parent, SoundRecorder recorder) {
        this.parent = parent;
        this.recorder = recorder;
        JavaFXUtil.addChangeListenerPlatform(this.changedSinceSave, changed -> this.updateSavedStatus());
        JavaFXUtil.addChangeListenerPlatform(this.filenameField.textProperty(), text -> this.updateSavedStatus());
    }

    HBox buildSaveBox() {
        this.saveButton.setDisable(true);
        this.saveButton.setOnAction(event -> {
            if (this.projectSoundDir != null) {
                File destination = new File(this.projectSoundDir, this.filenameField.getText() + ".wav");
                if (destination.exists()) {
                    boolean overwrite;
                    boolean bl = overwrite = DialogManager.askQuestionFX(this.parent, "file-exists-overwrite", new String[]{destination.getName()}) == 0;
                    if (overwrite) {
                        this.saveWAV(destination);
                    }
                } else {
                    this.saveWAV(destination);
                }
            }
        });
        this.updateSavedStatus();
        HBox fileBox = new HBox(3.0);
        fileBox.setAlignment(Pos.CENTER);
        fileBox.getChildren().addAll((Object[])new Node[]{new Label(Config.getString("soundRecorder.filename") + ": "), this.filenameField, new Label(".wav")});
        HBox saveBox = new HBox(20.0);
        saveBox.setAlignment(Pos.CENTER);
        saveBox.getChildren().addAll((Object[])new Node[]{fileBox, this.saveButton});
        return saveBox;
    }

    void changed(boolean value) {
        this.changedSinceSave.set(value);
        this.updateSavedStatus();
    }

    SimpleBooleanProperty savedProperty() {
        return this.saved;
    }

    private void updateSavedStatus() {
        boolean emptyRecorded = this.recorder.getRawSound() == null;
        boolean differentFromSaved = !((String)this.filenameField.textProperty().get()).equals(this.lastSaveName) || this.changedSinceSave.get();
        this.saved.set(emptyRecorded || !differentFromSaved);
        boolean emptyTextField = this.filenameField.textProperty().isEmpty().get();
        this.saveButton.disableProperty().set(emptyTextField || this.saved.get());
    }

    private void saveWAV(File destination) {
        this.recorder.writeWAV(destination);
        this.savedAs(this.filenameField.getText());
    }

    private void savedAs(String name) {
        this.lastSaveName = name;
        this.changed(false);
    }

    public void setProjectSoundDir(File projectSoundDir) {
        this.projectSoundDir = projectSoundDir;
    }
}

