/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.images;

import bluej.Config;
import bluej.utility.DialogManager;
import bluej.utility.javafx.FXCustomizedDialog;
import greenfoot.util.ExternalAppLauncher;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class NewImageDialog
extends FXCustomizedDialog<File> {
    private static final int MAX_IMAGE_HEIGHT = 2000;
    private static final int MAX_IMAGE_WIDTH = 2000;
    private static final int DEFAULT_HEIGHT = 100;
    private static final int DEFAULT_WIDTH = 100;
    private TextField name;
    private Spinner width;
    private Spinner height;
    private File projImagesDir;
    private int imageWidth;
    private int imageHeight;

    NewImageDialog(Window parent, File projImagesDir) {
        super(parent, Config.getString("imagelib.new.image.title"), null);
        this.projImagesDir = projImagesDir;
        this.imageWidth = Config.getPropInteger("greenfoot.image.create.width", 100);
        this.imageHeight = Config.getPropInteger("greenfoot.image.create.height", 100);
        this.buildUI();
    }

    private void buildUI() {
        GridPane detailsPanel = new GridPane();
        detailsPanel.setVgap(10.0);
        detailsPanel.setHgap(1.0);
        detailsPanel.setAlignment(Pos.BASELINE_CENTER);
        this.name = new TextField();
        this.name.setPrefWidth(220.0);
        this.name.setPromptText(Config.getString("imagelib.new.image.name.prompt"));
        detailsPanel.addRow(0, new Node[]{new Label(Config.getString("imagelib.new.image.name")), this.name, new Label(".png")});
        GridPane.setHgrow((Node)this.name, (Priority)Priority.ALWAYS);
        this.width = new Spinner(1, 2000, this.imageWidth);
        this.width.setEditable(true);
        detailsPanel.addRow(1, new Node[]{new Label(Config.getString("imagelib.new.image.width")), this.width});
        this.height = new Spinner(1, 2000, this.imageHeight);
        this.height.setEditable(true);
        detailsPanel.addRow(2, new Node[]{new Label(Config.getString("imagelib.new.image.height")), this.height});
        this.setContentPane((Node)detailsPanel);
        Window window = this.getDialogPane().getScene().getWindow();
        Stage stage = (Stage)window;
        stage.setMinWidth(345.0);
        stage.setMinHeight(240.0);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        okButton.disableProperty().bind((ObservableValue)this.name.textProperty().isEmpty());
        this.setResultConverter(bt -> bt == ButtonType.OK ? this.createImageFile() : null);
    }

    private File createImageFile() {
        File file = new File(this.projImagesDir, this.name.getText() + ".png");
        if (file.exists()) {
            boolean overwrite = DialogManager.askQuestionFX(this.asWindow(), "file-exists-overwrite", new String[]{file.getName()}) == 0;
            return overwrite && this.writeImageAndEdit(file) ? file : null;
        }
        return this.writeImageAndEdit(file) ? file : null;
    }

    private boolean writeImageAndEdit(File file) {
        BufferedImage im = new BufferedImage((Integer)this.width.getValue(), (Integer)this.height.getValue(), 2);
        try {
            if (ImageIO.write((RenderedImage)im, "png", file)) {
                SwingUtilities.invokeLater(() -> ExternalAppLauncher.editImage(file));
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DialogManager.showErrorFX(this.asWindow(), "imagelib-writing-image-failed");
        return false;
    }
}

