/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.images;

import bluej.Config;
import bluej.extensions2.SourceType;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.utility.javafx.FXCustomizedDialog;
import bluej.utility.javafx.JavaFXUtil;
import greenfoot.guifx.ClassNameVerifier;
import greenfoot.guifx.images.ImageLibPane;
import java.io.File;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class NewImageClassFrame
extends FXCustomizedDialog<NewImageClassInfo> {
    private final Project project;
    private final TextField classNameField = new TextField();
    private final Label errorMsgLabel = JavaFXUtil.withStyleClass(new Label(), "dialog-error-label");
    private ImageLibPane imageLibPane;
    private Node okButton;
    private ComboBox<SourceType> languageSelectionBox;

    public NewImageClassFrame(Window owner, Project project) {
        super(owner, Config.getString("imagelib.newClass"), "image-lib");
        this.project = project;
        this.buildUI();
    }

    private void buildUI() {
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        this.imageLibPane = new ImageLibPane(this.asWindow(), this.project);
        this.setContentPane((Node)new VBox(10.0, new Node[]{this.buildClassDetailsPanel(this.project.getUnnamedPackage()), this.imageLibPane}));
        VBox.setVgrow((Node)this.imageLibPane, (Priority)Priority.ALWAYS);
        this.classNameField.requestFocus();
        this.setResultConverter(bt -> bt == ButtonType.OK ? new NewImageClassInfo(this.classNameField.getText(), (SourceType)((Object)((Object)this.languageSelectionBox.getValue())), (File)this.imageLibPane.selectedImageProperty().get()) : null);
    }

    private Pane buildClassDetailsPanel(Package pkg) {
        this.classNameField.setPrefWidth(220.0);
        this.classNameField.setPromptText(Config.getString("pkgmgr.newClass.prompt"));
        this.languageSelectionBox = new ComboBox(FXCollections.observableArrayList((Object[])new SourceType[]{SourceType.Stride, SourceType.Java}));
        this.languageSelectionBox.getSelectionModel().select((Object)pkg.getDefaultSourceType());
        this.okButton = this.getDialogPane().lookupButton(ButtonType.OK);
        StringProperty classNameProperty = this.classNameField.textProperty();
        ReadOnlyObjectProperty sourceTypeProperty = this.languageSelectionBox.getSelectionModel().selectedItemProperty();
        ClassNameVerifier classNameVerifier = new ClassNameVerifier(pkg, classNameProperty, (ReadOnlyObjectProperty<SourceType>)sourceTypeProperty);
        this.updateControls(classNameVerifier);
        JavaFXUtil.addChangeListenerPlatform(classNameProperty, text -> this.updateControls(classNameVerifier));
        JavaFXUtil.addChangeListenerPlatform(sourceTypeProperty, type -> this.updateControls(classNameVerifier));
        JavaFXUtil.addChangeListenerPlatform(this.imageLibPane.selectedImageProperty(), image -> this.updateControls(classNameVerifier));
        HBox fileDetailsRow = new HBox(5.0, new Node[]{new Label(Config.getString("imagelib.className")), this.classNameField, this.languageSelectionBox});
        fileDetailsRow.setAlignment(Pos.BASELINE_LEFT);
        return new VBox(new Node[]{fileDetailsRow, this.errorMsgLabel, new Separator(Orientation.HORIZONTAL)});
    }

    private void updateControls(ClassNameVerifier classNameVerifier) {
        boolean valid = classNameVerifier.checkValidity();
        this.errorMsgLabel.setVisible(!valid);
        this.errorMsgLabel.setText(classNameVerifier.getMessage());
        this.okButton.setDisable(!valid);
    }

    public static class NewImageClassInfo {
        public final String className;
        public final SourceType sourceType;
        public final File imageFile;

        private NewImageClassInfo(String className, SourceType sourceType, File imageFile) {
            this.className = className;
            this.sourceType = sourceType;
            this.imageFile = imageFile;
        }
    }
}

