/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.images;

import bluej.Config;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import greenfoot.guifx.PastedImageNameDialog;
import greenfoot.guifx.classes.LocalGClassNode;
import greenfoot.guifx.images.ImageCategorySelector;
import greenfoot.guifx.images.ImageLibList;
import greenfoot.guifx.images.ImageListEntry;
import greenfoot.guifx.images.NewImageDialog;
import greenfoot.util.ExternalAppLauncher;
import greenfoot.util.GreenfootUtil;
import java.io.File;
import java.io.IOException;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
class ImageLibPane
extends VBox {
    private final Project project;
    private final Window container;
    private FXRunnable cancelRefresh;
    private ImageLibList projImageList;
    private ImageLibList greenfootImageList;
    private File projImagesDir;
    private ObjectProperty<File> selectedImageFile = new SimpleObjectProperty(null);
    private MenuItem editItem;
    private MenuItem duplicateItem;
    private MenuItem deleteItem;
    private static final String COPY_SUFFIX = Config.getString("imagelib.duplicate.image.name.suffix");
    private static final String DROPDOWN_ICON_FILE = "menu-button.png";

    ImageLibPane(Window container, Project project, LocalGClassNode classNode) {
        this(container, project, ImageLibPane.getSpecifiedImage(project, classNode));
    }

    ImageLibPane(Window container, Project project) {
        this(container, project, (File)null);
    }

    private ImageLibPane(Window container, Project project, File specifiedImage) {
        super(10.0);
        this.container = container;
        this.project = project;
        this.getChildren().addAll((Object[])new Node[]{this.buildImageLists(specifiedImage), this.createCogMenu()});
        this.setItemButtons(this.projImageList.getSelectionModel().getSelectedItem() != null && ((ImageListEntry)this.projImageList.getSelectionModel().getSelectedItem()).getImageFile() != null);
        container.setOnShown(e -> {
            this.cancelRefresh = JavaFXUtil.runRegular(Duration.millis((double)1000.0), () -> this.projImageList.refresh());
        });
        container.setOnHidden(e -> {
            if (this.cancelRefresh != null) {
                this.cancelRefresh.run();
                this.cancelRefresh = null;
            }
        });
    }

    private Pane buildImageLists(File specifiedImage) {
        GridPane listsGridPane = new GridPane();
        listsGridPane.setVgap(5.0);
        ColumnConstraints constraints = new ColumnConstraints();
        constraints.setHgrow(Priority.SOMETIMES);
        listsGridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{constraints, constraints, constraints});
        this.projImagesDir = new File(this.project.getProjectDir(), "images");
        this.projImageList = new ImageLibList(this.projImagesDir, true);
        this.projImageList.select(specifiedImage);
        ScrollPane imageScrollPane = new ScrollPane((Node)this.projImageList);
        imageScrollPane.setFitToWidth(true);
        imageScrollPane.setFitToHeight(true);
        GridPane.setVgrow((Node)imageScrollPane, (Priority)Priority.ALWAYS);
        GridPane.setMargin((Node)imageScrollPane, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        listsGridPane.addColumn(0, new Node[]{new Label(Config.getString("imagelib.projectImages")), imageScrollPane});
        this.greenfootImageList = new ImageLibList(false);
        JavaFXUtil.addChangeListenerPlatform(this.projImageList.getSelectionModel().selectedItemProperty(), imageListEntry -> this.valueChanged((ImageListEntry)imageListEntry, true));
        JavaFXUtil.addChangeListenerPlatform(this.greenfootImageList.getSelectionModel().selectedItemProperty(), imageListEntry -> this.valueChanged((ImageListEntry)imageListEntry, false));
        ImageCategorySelector imageCategorySelector = new ImageCategorySelector(new File(Config.getGreenfootLibDir(), "imagelib"));
        imageCategorySelector.setImageLibList(this.greenfootImageList);
        ScrollPane categoryScrollPane = new ScrollPane((Node)imageCategorySelector);
        categoryScrollPane.setFitToWidth(true);
        categoryScrollPane.setFitToHeight(true);
        listsGridPane.addColumn(1, new Node[]{new Label(Config.getString("imagelib.categories")), categoryScrollPane});
        ScrollPane greenfootImagesScrollPane = new ScrollPane((Node)this.greenfootImageList);
        greenfootImagesScrollPane.setFitToWidth(true);
        greenfootImagesScrollPane.setFitToHeight(true);
        listsGridPane.addColumn(2, new Node[]{new Label(Config.getString("imagelib.images")), greenfootImagesScrollPane});
        VBox.setVgrow((Node)listsGridPane, (Priority)Priority.ALWAYS);
        return listsGridPane;
    }

    private MenuButton createCogMenu() {
        this.editItem = this.createSelectedEntryMenuItem("imagelib.edit", "imagelib.edit.tooltip", this::editImage);
        this.duplicateItem = this.createSelectedEntryMenuItem("imagelib.duplicate", "imagelib.duplicate.tooltip", this::duplicateSelected);
        this.deleteItem = this.createSelectedEntryMenuItem("imagelib.delete", "imagelib.delete.tooltip", this::confirmDelete);
        return new MenuButton(null, (Node)new ImageView(new Image(ImageLibPane.class.getClassLoader().getResourceAsStream(DROPDOWN_ICON_FILE))), new MenuItem[]{this.editItem, this.duplicateItem, this.deleteItem, new SeparatorMenuItem(), this.createGeneralMenuItem("imagelib.create.button", "imagelib.create.tooltip", (EventHandler<ActionEvent>)((EventHandler)event -> this.createNewImage())), this.createGeneralMenuItem("imagelib.paste.image", "imagelib.paste.tooltip", (EventHandler<ActionEvent>)((EventHandler)event -> this.pasteImage())), this.createGeneralMenuItem("imagelib.import.button", "imagelib.import.tooltip", (EventHandler<ActionEvent>)((EventHandler)event -> this.importImage()))});
    }

    private MenuItem createSelectedEntryMenuItem(String label, String tooltip, FXConsumer<ImageListEntry> consumer) {
        MenuItem item = new MenuItem(Config.getString(label));
        Tooltip.install((Node)item.getGraphic(), (Tooltip)new Tooltip(Config.getString(tooltip)));
        item.setDisable(true);
        item.setOnAction(event -> {
            ImageListEntry entry = (ImageListEntry)this.projImageList.getSelectionModel().getSelectedItem();
            if (entry != null && entry.getImageFile() != null) {
                consumer.accept(entry);
            }
        });
        return item;
    }

    private MenuItem createGeneralMenuItem(String label, String tooltip, EventHandler<ActionEvent> eventHandler) {
        MenuItem item = new MenuItem(Config.getString(label));
        Tooltip.install((Node)item.getGraphic(), (Tooltip)new Tooltip(Config.getString(tooltip)));
        item.setOnAction(eventHandler);
        return item;
    }

    private void createNewImage() {
        new NewImageDialog(this.container, this.projImagesDir).showAndWait().ifPresent(file -> {
            this.projImageList.refresh();
            this.projImageList.select((File)file);
            this.selectImage((File)file);
        });
    }

    private void valueChanged(ImageListEntry entry, boolean isProjImageList) {
        if (entry != null && entry.getImageFile() != null) {
            if (isProjImageList) {
                this.greenfootImageList.getSelectionModel().clearSelection();
            } else {
                this.projImageList.getSelectionModel().clearSelection();
            }
            this.selectImage(entry.getImageFile());
            this.setItemButtons(isProjImageList);
        } else {
            this.selectImage(null);
            this.setItemButtons(false);
        }
    }

    private void setItemButtons(boolean state) {
        this.editItem.setDisable(!state);
        this.duplicateItem.setDisable(!state);
        this.deleteItem.setDisable(!state);
    }

    private void selectImage(File imageFile) {
        this.selectedImageFile.set((Object)imageFile);
    }

    private static File getSpecifiedImage(Project project, LocalGClassNode gclass) {
        String imageName = gclass.getImageFilename();
        if (imageName != null && !imageName.equals("")) {
            File imageDir = new File(project.getProjectDir(), "images");
            return new File(imageDir, imageName).getAbsoluteFile();
        }
        return null;
    }

    private void importImage() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(Config.getString("imagelib.browse.button"));
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Images", new String[]{"*.png", "*.jpg", "*.jpeg", "*.gif"}), new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
        File selectedFile = chooser.showOpenDialog(this.container);
        if (selectedFile != null) {
            File newFile = new File(this.projImagesDir, selectedFile.getName());
            GreenfootUtil.copyFile(selectedFile, newFile);
            if (this.projImageList != null) {
                this.projImageList.select(newFile);
            }
        }
    }

    public ObjectProperty<File> selectedImageProperty() {
        return this.selectedImageFile;
    }

    private void duplicateSelected(ImageListEntry entry) {
        String ext;
        Object baseName;
        File srcFile = entry.getImageFile();
        File dstFile = null;
        File dir = srcFile.getParentFile();
        String fileName = srcFile.getName();
        int index = fileName.lastIndexOf(46);
        if (index != -1) {
            baseName = fileName.substring(0, index);
            ext = fileName.substring(index + 1);
        } else {
            baseName = fileName;
            ext = "";
        }
        baseName = (String)baseName + "_" + COPY_SUFFIX;
        try {
            dstFile = GreenfootUtil.createNumberedFile(dir, (String)baseName, ext);
            FileUtility.copyFile(srcFile, dstFile);
        }
        catch (IOException e) {
            Debug.reportError(e);
        }
        if (dstFile != null) {
            this.projImageList.select(dstFile);
        }
    }

    private void confirmDelete(ImageListEntry entry) {
        boolean delete;
        boolean bl = delete = DialogManager.askQuestionFX(this.container, "imagelib-delete-confirm", new String[]{entry.getImageFile().getName()}) == 0;
        if (delete) {
            entry.getImageFile().delete();
            this.projImageList.refresh();
        }
    }

    private void editImage(ImageListEntry entry) {
        File file = entry.getImageFile();
        SwingUtilities.invokeLater(() -> ExternalAppLauncher.editImage(file));
    }

    private void pasteImage() {
        if (Clipboard.getSystemClipboard().hasImage()) {
            Image image = Clipboard.getSystemClipboard().getImage();
            new PastedImageNameDialog(this.container, image, this.projImagesDir).showAndWait().ifPresent(file -> {
                this.projImageList.refresh();
                this.projImageList.select((File)file);
                this.selectImage((File)file);
            });
        } else {
            DialogManager.showErrorFX(this.container, "no-clipboard-image-data");
        }
    }
}

