/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.images;

import bluej.utility.javafx.JavaFXUtil;
import greenfoot.guifx.images.ImageLibList;
import java.io.File;
import java.util.Arrays;
import javafx.collections.FXCollections;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ImageCategorySelector
extends ListView<File> {
    private ImageLibList imageLibList;

    public ImageCategorySelector(File categoriesRoot) {
        this.setOrientation(Orientation.VERTICAL);
        this.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.setCellFactory(param -> new ImageCell());
        Object[] categoriesFolders = categoriesRoot.listFiles(File::isDirectory);
        if (categoriesFolders == null) {
            return;
        }
        Arrays.sort(categoriesFolders);
        this.setItems(FXCollections.observableArrayList((Object[])categoriesFolders));
        JavaFXUtil.addChangeListenerPlatform(this.getSelectionModel().selectedItemProperty(), selected -> {
            if (this.imageLibList != null && selected != null) {
                this.imageLibList.setDirectory((File)selected);
            }
        });
    }

    public void setImageLibList(ImageLibList imageLibList) {
        this.imageLibList = imageLibList;
    }

    @OnThread(value=Tag.FXPlatform)
    private static class ImageCell
    extends ListCell<File> {
        private static final String iconFile = "openRight.png";
        private static final Image openRightIcon = new Image(ImageCategorySelector.class.getClassLoader().getResource("openRight.png").toString());

        private ImageCell() {
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void updateItem(File file, boolean empty) {
            super.updateItem((Object)file, empty);
            if (empty || file == null) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.setText(file.getName());
                this.setGraphic((Node)new ImageView(openRightIcon));
            }
        }
    }
}

