/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.export;

import bluej.Config;
import bluej.utility.javafx.FXCustomizedDialog;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ProxyAuthDialog
extends FXCustomizedDialog<ProxyAuthInfo> {
    private final TextField usernameField = new TextField();
    private final PasswordField passwordField = new PasswordField();

    public ProxyAuthDialog(Window parent) {
        super(parent, Config.getString("export.publish.proxyAuth"), null);
        this.setModal(true);
        this.buildUI();
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)this.usernameField.textProperty().isEmpty().or((ObservableBooleanValue)this.passwordField.textProperty().isEmpty()));
        this.setResultConverter(bt -> bt == ButtonType.OK ? new ProxyAuthInfo(this.usernameField.getText(), this.passwordField.getText()) : null);
    }

    private void buildUI() {
        GridPane authPanel = new GridPane();
        this.usernameField.setPrefColumnCount(20);
        this.passwordField.setPrefColumnCount(20);
        authPanel.addRow(0, new Node[]{new Label(Config.getString("export.publish.username")), this.usernameField});
        authPanel.addRow(1, new Node[]{new Label(Config.getString("export.publish.password")), this.passwordField});
        this.setContentPane((Node)new VBox(new Node[]{new Label(Config.getString("export.publish.needProxyAuth")), authPanel}));
    }

    public class ProxyAuthInfo {
        private String username;
        private String password;

        private ProxyAuthInfo(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

