/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.export;

import bluej.Config;
import bluej.utility.DialogManager;
import greenfoot.export.mygame.ExportInfo;
import greenfoot.export.mygame.ScenarioInfo;
import greenfoot.guifx.export.ExportTab;
import java.io.File;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public abstract class ExportLocalTab
extends ExportTab {
    private final String type;
    private final String extension;
    private final Window parent;
    protected TextField targetDirField;

    public ExportLocalTab(Window parent, ScenarioInfo scenarioInfo, String scenarioName, File defaultExportDir, String type, String extension) {
        super(scenarioInfo, "export-" + type + ".png");
        this.parent = parent;
        this.type = type;
        this.extension = extension;
        this.buildContentPane(new File(defaultExportDir, scenarioName + extension));
        this.applySharedStyle();
        this.getContent().getStyleClass().add((Object)"export-local-tab");
    }

    public String getExportFileName() {
        return this.targetDirField.getText();
    }

    protected void buildContentPane(File targetFile) {
        Label exportLocationLabel = new Label(Config.getString("export." + this.type + ".location"));
        this.targetDirField = new TextField(targetFile.toString());
        this.targetDirField.setPrefColumnCount(30);
        this.targetDirField.setEditable(false);
        this.validProperty.bind((ObservableValue)this.targetDirField.textProperty().isNotEmpty());
        Button browse = new Button(Config.getString("export." + this.type + ".browse"));
        browse.setOnAction(event -> this.targetDirField.setText(this.askForFileName(targetFile)));
        HBox exportLocationPane = new HBox(new Node[]{exportLocationLabel, this.targetDirField, browse});
        exportLocationPane.setAlignment(Pos.BASELINE_LEFT);
        exportLocationPane.getStyleClass().add((Object)"location-pane");
        Label helpLabel = new Label(Config.getString("export." + this.type + ".help"));
        helpLabel.setWrapText(true);
        VBox vBox = new VBox(new Node[]{helpLabel, exportLocationPane});
        vBox.setPrefWidth(400.0);
        this.setContent((Node)vBox);
    }

    private String askForFileName(File targetFile) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Config.getString("export." + this.type + ".choose"));
        fileChooser.setInitialDirectory(targetFile.getParentFile());
        File file = fileChooser.showSaveDialog(this.parent);
        if (file == null) {
            return "";
        }
        Object newName = file.getPath();
        if (!((String)newName).endsWith(this.extension)) {
            if (((String)newName).toLowerCase().endsWith(this.extension)) {
                newName = ((String)newName).substring(0, ((String)newName).length() - this.extension.length());
            }
            newName = (String)newName + this.extension;
        }
        if (file.exists()) {
            boolean overwrite;
            boolean bl = overwrite = DialogManager.askQuestionFX(this.parent, "file-exists-overwrite", new String[]{newName}) == 0;
            if (!overwrite) {
                return this.askForFileName(targetFile);
            }
        }
        return newName;
    }

    @Override
    protected void updateInfoFromFields() {
    }

    @Override
    protected ExportInfo getExportInfo() {
        ExportInfo info = new ExportInfo(this.scenarioInfo);
        info.setExportFileName(this.getExportFileName());
        return info;
    }
}

