/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.classes;

import greenfoot.guifx.GreenfootStage;
import greenfoot.guifx.classes.ClassDisplay;
import greenfoot.guifx.classes.ClassDisplaySelectionManager;
import greenfoot.guifx.classes.InheritArrow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.scene.control.ContextMenu;
import javafx.scene.image.Image;

public abstract class GClassNode {
    private final List<GClassNode> subClasses = new ArrayList<GClassNode>();
    protected Image image;
    protected final ClassDisplaySelectionManager selectionManager;
    protected ContextMenu curContextMenu = null;
    protected ClassDisplay display;
    private InheritArrow arrowFromSub;

    protected GClassNode(Image image, List<GClassNode> subClasses, ClassDisplaySelectionManager selectionManager) {
        this.selectionManager = selectionManager;
        this.image = image;
        this.subClasses.addAll(subClasses);
        Collections.sort(this.subClasses, Comparator.comparing(ci -> ci.getDisplayName()));
    }

    public abstract String getQualifiedName();

    public void add(GClassNode classInfo) {
        this.subClasses.add(classInfo);
        Collections.sort(this.subClasses, Comparator.comparing(ci -> ci.getDisplayName()));
    }

    public List<GClassNode> getSubClasses() {
        return Collections.unmodifiableList(this.subClasses);
    }

    public abstract String getDisplayName();

    public ClassDisplay getDisplay(GreenfootStage greenfootStage) {
        if (this.display == null) {
            this.display = new ClassDisplay(this.getDisplayName(), this.getQualifiedName(), this.image, this.selectionManager);
            this.setupClassDisplay(greenfootStage, this.display);
        }
        return this.display;
    }

    protected abstract void setupClassDisplay(GreenfootStage var1, ClassDisplay var2);

    public InheritArrow getArrowFromSub() {
        if (this.arrowFromSub == null) {
            this.arrowFromSub = new InheritArrow();
        }
        return this.arrowFromSub;
    }

    public void tidyup() {
        if (this.display != null) {
            this.selectionManager.removeClassDisplay(this.display);
        }
        for (GClassNode subClass : this.subClasses) {
            subClass.tidyup();
        }
    }

    public String getImageFilename() {
        return null;
    }

    protected void setImage(Image newImage) {
        this.image = newImage;
        if (this.display != null) {
            this.display.setImage(newImage);
        }
    }
}

