/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.classes;

import bluej.Config;
import bluej.debugger.gentype.Reflective;
import bluej.extensions2.ClassNotFoundException;
import bluej.extensions2.ProjectNotOpenException;
import bluej.parser.symtab.ClassInfo;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.views.ConstructorView;
import bluej.views.View;
import bluej.views.ViewFilter;
import greenfoot.guifx.GreenfootStage;
import greenfoot.guifx.classes.BuiltInGClassNode;
import greenfoot.guifx.classes.ClassDisplay;
import greenfoot.guifx.classes.ClassDisplaySelectionManager;
import greenfoot.guifx.classes.ClassGroup;
import greenfoot.guifx.classes.GClassNode;
import greenfoot.guifx.classes.LocalGClassNode;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class GClassDiagram
extends BorderPane {
    private final ContextMenu contextMenu;
    private final ClassDisplaySelectionManager selectionManager = new ClassDisplaySelectionManager();
    private final ClassGroup worldClasses;
    private final ClassGroup actorClasses;
    private final ClassGroup otherClasses;
    private final GreenfootStage greenfootStage;
    private Project project;

    public boolean hasUserWorld() {
        return this.worldClasses.streamAllClasses().filter(c -> !c.getQualifiedName().equals("greenfoot.World")).findFirst().isPresent();
    }

    public String getInstantiatableWorld() {
        return this.worldClasses.streamAllClasses().map(c -> {
            Target t = this.project.getTarget(c.getQualifiedName());
            if (t instanceof ClassTarget) {
                Class<?> cl = this.project.loadClass(((ClassTarget)t).getQualifiedName());
                if (cl == null) {
                    return null;
                }
                View view = View.getView(cl);
                if (!Modifier.isAbstract(cl.getModifiers())) {
                    ViewFilter filter = new ViewFilter(ViewFilter.StaticOrInstance.INSTANCE, "");
                    ConstructorView constructorView = Arrays.stream(view.getConstructors()).filter(filter).filter(cv -> !cv.hasParameters()).findFirst().orElse(null);
                    if (constructorView != null) {
                        return cl.getName();
                    }
                }
            }
            return null;
        }).filter(w -> w != null).findFirst().orElse(null);
    }

    public GClassDiagram(GreenfootStage greenfootStage) {
        this.greenfootStage = greenfootStage;
        this.getStyleClass().add((Object)"gclass-diagram");
        this.worldClasses = new ClassGroup(greenfootStage);
        this.actorClasses = new ClassGroup(greenfootStage);
        this.otherClasses = new ClassGroup(greenfootStage);
        this.setTop((Node)this.worldClasses);
        this.setCenter((Node)this.actorClasses);
        this.setBottom((Node)this.otherClasses);
        BorderPane.setAlignment((Node)this.actorClasses, (Pos)Pos.TOP_LEFT);
        BorderPane.setAlignment((Node)this.otherClasses, (Pos)Pos.BOTTOM_LEFT);
        BorderPane.setMargin((Node)this.actorClasses, (Insets)new Insets(20.0, 0.0, 20.0, 0.0));
        BorderPane.setMargin((Node)this.otherClasses, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
        this.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.setMaxHeight(Double.MAX_VALUE);
        this.contextMenu = new ContextMenu();
        this.contextMenu.getItems().add((Object)JavaFXUtil.makeMenuItem(Config.getString("new.other.class"), () -> greenfootStage.newNonImageClass(this.project.getUnnamedPackage(), null), null));
        this.contextMenu.getItems().add((Object)JavaFXUtil.makeMenuItem(Config.getString("import.action"), () -> greenfootStage.doImportClass(), null));
        this.setOnContextMenuRequested(e -> {
            this.hideContextMenu();
            this.contextMenu.show((Node)this, e.getScreenX(), e.getScreenY());
            e.consume();
        });
    }

    protected void hideContextMenu() {
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
    }

    public void setProject(Project project) {
        this.project = project;
        if (project != null) {
            this.recalculateGroups();
            this.setDisable(false);
        } else {
            this.worldClasses.setClasses(Collections.emptyList());
            this.actorClasses.setClasses(Collections.emptyList());
            this.otherClasses.setClasses(Collections.emptyList());
            this.setDisable(true);
        }
    }

    public void recalculateGroups() {
        ArrayList<ClassTarget> originalClassTargets = this.project.getUnnamedPackage().getClassTargets();
        HashMap<ClassTarget, Boolean> classTargets = new HashMap<ClassTarget, Boolean>();
        for (ClassTarget originalClassTarget : originalClassTargets) {
            classTargets.put(originalClassTarget, false);
        }
        List<GClassNode> worldSubclasses = this.findAllSubclasses("greenfoot.World", classTargets, GClassType.WORLD);
        BuiltInGClassNode worldClassesInfo = new BuiltInGClassNode(GClassType.WORLD, worldSubclasses, this);
        this.worldClasses.setClasses(Collections.singletonList(worldClassesInfo));
        List<GClassNode> actorSubclasses = this.findAllSubclasses("greenfoot.Actor", classTargets, GClassType.ACTOR);
        BuiltInGClassNode actorClassesInfo = new BuiltInGClassNode(GClassType.ACTOR, actorSubclasses, this);
        this.actorClasses.setClasses(Collections.singletonList(actorClassesInfo));
        this.otherClasses.setClasses(this.findAllSubclasses(null, classTargets, GClassType.OTHER));
    }

    private List<GClassNode> findAllSubclasses(String parentClassName, Map<ClassTarget, Boolean> classTargets, GClassType type) {
        ArrayList<GClassNode> curLevel = new ArrayList<GClassNode>();
        for (Map.Entry<ClassTarget, Boolean> classTargetAndVal : classTargets.entrySet()) {
            String finalSuperClassName;
            boolean includeAtThisLevel;
            if (classTargetAndVal.getValue().booleanValue()) continue;
            ClassTarget classTarget = classTargetAndVal.getKey();
            ClassInfo classInfo = classTarget.analyseSource();
            String superClassName = null;
            if (classInfo != null) {
                superClassName = classInfo.getSuperclass();
            } else {
                try {
                    Class<?> superClass;
                    Class<?> javaClass = classTarget.getBClass().getJavaClass();
                    if (javaClass != null && (superClass = javaClass.getSuperclass()) != null) {
                        superClassName = superClass.getName();
                    }
                }
                catch (ClassNotFoundException | ProjectNotOpenException e) {
                    e.printStackTrace();
                }
            }
            if (!(includeAtThisLevel = parentClassName == null ? (finalSuperClassName = superClassName) == null || !classTargets.keySet().stream().anyMatch(ct -> Objects.equals(ct.getQualifiedName(), finalSuperClassName)) : Objects.equals(superClassName, parentClassName))) continue;
            classTargetAndVal.setValue(true);
            List<GClassNode> subClasses = this.findAllSubclasses(classTarget.getQualifiedName(), classTargets, type);
            curLevel.add(this.makeClassInfo(classTarget, subClasses, type));
        }
        return curLevel;
    }

    public LocalGClassNode addClass(ClassTarget classTarget) {
        String superClass = null;
        ClassInfo info = classTarget.analyseSource();
        if (info != null) {
            superClass = info.getSuperclass();
        }
        if (superClass != null) {
            block5: for (GClassType type : GClassType.values()) {
                ClassGroup classGroup;
                switch (type) {
                    case ACTOR: {
                        classGroup = this.actorClasses;
                        break;
                    }
                    case WORLD: {
                        classGroup = this.worldClasses;
                        break;
                    }
                    case OTHER: {
                        classGroup = this.otherClasses;
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                LocalGClassNode classInfo = this.findAndAdd(classGroup.getLiveTopLevelClasses(), classTarget, superClass, type);
                if (classInfo == null) continue;
                classGroup.updateAfterAdd();
                return classInfo;
            }
        }
        LocalGClassNode classInfo = this.makeClassInfo(classTarget, Collections.emptyList(), GClassType.OTHER);
        this.otherClasses.getLiveTopLevelClasses().add(classInfo);
        this.otherClasses.updateAfterAdd();
        return classInfo;
    }

    private LocalGClassNode findAndAdd(List<GClassNode> classInfos, ClassTarget classTarget, String classTargetSuperClass, GClassType type) {
        for (GClassNode classInfo : classInfos) {
            LocalGClassNode newClassInfo;
            if (classInfo.getQualifiedName().equals(classTargetSuperClass)) {
                newClassInfo = this.makeClassInfo(classTarget, Collections.emptyList(), type);
                classInfo.add(newClassInfo);
                return newClassInfo;
            }
            newClassInfo = this.findAndAdd(classInfo.getSubClasses(), classTarget, classTargetSuperClass, type);
            if (newClassInfo == null) continue;
            return newClassInfo;
        }
        return null;
    }

    protected LocalGClassNode makeClassInfo(ClassTarget classTarget, List<GClassNode> subClasses, GClassType type) {
        return new LocalGClassNode(this, classTarget, subClasses, type);
    }

    public static MenuItem contextInbuilt(String text, FXPlatformRunnable action) {
        MenuItem menuItem = JavaFXUtil.makeMenuItem(text, action, null);
        JavaFXUtil.addStyleClass((Styleable)menuItem, "class-action-inbuilt");
        return menuItem;
    }

    public static AbstractOperation<LocalGClassNode> contextInbuiltOp(String identifier, final String text, final AbstractOperation.MenuItemOrder menuItemOrder, final FXPlatformConsumer<LocalGClassNode> action) {
        return new AbstractOperation<LocalGClassNode>(identifier, AbstractOperation.Combine.ONE, null){

            @Override
            public void activate(List<LocalGClassNode> localGClassNodes) {
                localGClassNodes.forEach(action::accept);
            }

            @Override
            public List<String> getStyleClasses() {
                return List.of("class-action-inbuilt");
            }

            @Override
            public List<AbstractOperation.ItemLabel> getLabels() {
                return List.of(new AbstractOperation.ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(text), menuItemOrder));
            }
        };
    }

    public ClassTarget getSelectedClassTarget() {
        Target target;
        ClassDisplay selected = this.selectionManager.getSelected();
        if (selected != null && (target = this.project.getUnnamedPackage().getTarget(selected.getQualifiedName())) instanceof ClassTarget) {
            return (ClassTarget)target;
        }
        return null;
    }

    public ClassDisplaySelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public GreenfootStage getGreenfootStage() {
        return this.greenfootStage;
    }

    public void save(Properties p) {
        this.worldClasses.saveImageSelections(p);
        this.actorClasses.saveImageSelections(p);
        this.otherClasses.saveImageSelections(p);
    }

    public String getImageForActorClass(Reflective r) {
        ArrayList<Reflective> inheritanceChain = new ArrayList<Reflective>();
        inheritanceChain.add(r);
        Reflective[] superClass = new Reflective[1];
        while (r != null && !r.getName().equals("greenfoot.Actor")) {
            superClass[0] = null;
            r.getSuperTypesR().stream().filter(s -> !s.isInterface()).findFirst().ifPresent(e -> {
                superClass[0] = e;
                inheritanceChain.add((Reflective)e);
            });
            r = superClass[0];
        }
        if (r == null) {
            return null;
        }
        int i = inheritanceChain.size() - 1;
        ClassGroup group = this.actorClasses;
        GClassNode classNode = group.getLiveTopLevelClasses().get(0);
        --i;
        String fileName = null;
        block1: while (i >= 0) {
            List<GClassNode> subs = classNode.getSubClasses();
            for (GClassNode candidate : subs) {
                if (!candidate.getQualifiedName().equals(((Reflective)inheritanceChain.get(i)).getName())) continue;
                --i;
                classNode = candidate;
                String candidateImage = candidate.getImageFilename();
                if (candidateImage == null) continue block1;
                fileName = candidateImage;
                continue block1;
            }
        }
        return fileName;
    }

    public static enum GClassType {
        ACTOR,
        WORLD,
        OTHER;

    }
}

