/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.classes;

import bluej.utility.javafx.JavaFXUtil;
import greenfoot.guifx.classes.ClassDisplaySelectionManager;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ClassDisplay
extends StackPane {
    private final String fullyQualifiedName;
    private final BorderPane stripePane;
    private final Label contentLabel;

    public ClassDisplay(String displayName, String fullyQualifiedName, Image image, ClassDisplaySelectionManager selectionManager) {
        this.fullyQualifiedName = fullyQualifiedName;
        this.getStyleClass().add((Object)"class-display");
        this.setSnapToPixel(true);
        this.contentLabel = new Label(displayName);
        BorderPane content = new BorderPane((Node)this.contentLabel);
        this.setImage(image);
        JavaFXUtil.addStyleClass((Styleable)content, "class-display-content");
        this.stripePane = new BorderPane();
        this.getChildren().addAll((Object[])new Node[]{this.stripePane, content});
        selectionManager.addClassDisplay(this);
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 1) {
                selectionManager.select(this);
                e.consume();
            }
        });
    }

    public void setSelected(boolean selected) {
        JavaFXUtil.setPseudoclass("gf-selected", selected, new Node[]{this});
    }

    public String getQualifiedName() {
        return this.fullyQualifiedName;
    }

    public void setImage(Image image) {
        if (image == null) {
            this.contentLabel.setGraphic(null);
        } else {
            ImageView imageView = new ImageView(image);
            imageView.setFitHeight(Math.min(image.getHeight(), 16.0));
            imageView.setFitWidth(Math.min(image.getWidth(), 16.0));
            imageView.setPreserveRatio(true);
            this.contentLabel.setGraphic((Node)imageView);
        }
    }

    public void setStripePattern(Paint stripeFill) {
        this.stripePane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(stripeFill, null, null)}));
    }
}

