/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.classes;

import bluej.Config;
import bluej.utility.javafx.FXPlatformRunnable;
import greenfoot.guifx.GreenfootStage;
import greenfoot.guifx.classes.ClassDisplay;
import greenfoot.guifx.classes.GClassDiagram;
import greenfoot.guifx.classes.GClassNode;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.MouseButton;

public class BuiltInGClassNode
extends GClassNode {
    private final GClassDiagram.GClassType type;
    private final GClassDiagram classDiagram;

    public BuiltInGClassNode(GClassDiagram.GClassType type, List<GClassNode> subClasses, GClassDiagram classDiagram) {
        super(null, subClasses, classDiagram.getSelectionManager());
        this.type = type;
        this.classDiagram = classDiagram;
    }

    @Override
    public String getQualifiedName() {
        return "greenfoot." + BuiltInGClassNode.shortName(this.type);
    }

    @Override
    public String getDisplayName() {
        return BuiltInGClassNode.shortName(this.type);
    }

    private static String shortName(GClassDiagram.GClassType type) {
        switch (type) {
            case ACTOR: {
                return "Actor";
            }
            case WORLD: {
                return "World";
            }
        }
        throw new RuntimeException();
    }

    @Override
    protected void setupClassDisplay(GreenfootStage greenfootStage, ClassDisplay display) {
        FXPlatformRunnable showDocs = () -> greenfootStage.openGreenfootDocTab(display.getQualifiedName());
        display.setOnContextMenuRequested(e -> {
            e.consume();
            if (this.curContextMenu != null) {
                this.curContextMenu.hide();
                this.curContextMenu = null;
                this.classDiagram.hideContextMenu();
            }
            this.curContextMenu = new ContextMenu();
            this.curContextMenu.getItems().add((Object)GClassDiagram.contextInbuilt(Config.getString("show.apidoc"), showDocs));
            this.curContextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.curContextMenu.getItems().add((Object)GClassDiagram.contextInbuilt(Config.getString("new.sub.class"), () -> greenfootStage.newSubClassOf(display.getQualifiedName(), this.type)));
            this.selectionManager.select(display);
            this.curContextMenu.show((Node)display, e.getScreenX(), e.getScreenY());
        });
        display.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 2) {
                showDocs.run();
            }
        });
    }
}

