/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx;

import bluej.Boot;
import bluej.Config;
import bluej.Main;
import bluej.collect.DataCollector;
import bluej.collect.GreenfootInterfaceEvent;
import bluej.compiler.CompileInputFile;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.compiler.FXCompileObserver;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerResult;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.debugmgr.objectbench.ResultWatcherBase;
import bluej.editor.Editor;
import bluej.extensions2.SourceType;
import bluej.pkgmgr.AboutDialogTemplate;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageUI;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.ProjectUtils;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.ReadmeTarget;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.ObjectInspectInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaReflective;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformFunction;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.UnfocusableScrollPane;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import greenfoot.Actor;
import greenfoot.core.ProjectManager;
import greenfoot.export.ScenarioSaver;
import greenfoot.export.mygame.ScenarioInfo;
import greenfoot.guifx.ControlPanel;
import greenfoot.guifx.ExecutionTwirler;
import greenfoot.guifx.GreenfootStageContentPane;
import greenfoot.guifx.NewClassDialog;
import greenfoot.guifx.SetPlayerDialog;
import greenfoot.guifx.WorldDisplay;
import greenfoot.guifx.classes.GClassDiagram;
import greenfoot.guifx.classes.ImportClassDialog;
import greenfoot.guifx.classes.LocalGClassNode;
import greenfoot.guifx.export.ExportDialog;
import greenfoot.guifx.export.ExportException;
import greenfoot.guifx.images.NewImageClassFrame;
import greenfoot.guifx.images.SelectImageFrame;
import greenfoot.guifx.soundrecorder.SoundRecorderControls;
import greenfoot.record.GreenfootRecorder;
import greenfoot.util.GreenfootUtil;
import greenfoot.vmcomm.GreenfootDebugHandler;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Queue;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class GreenfootStage
extends Stage
implements FXCompileObserver,
GreenfootDebugHandler.SimulationStateListener,
PackageUI,
ControlPanel.ControlPanelListener,
ScenarioSaver {
    private static final String STAGE_TITLE = "Greenfoot";
    private static int numberOfOpenProjects = 0;
    private static List<GreenfootStage> stages = new ArrayList<GreenfootStage>();
    private boolean isQuittingRequest = false;
    private Project project;
    private BooleanProperty hasNoProject = new SimpleBooleanProperty(true);
    private final Pane glassPane;
    private final ObjectProperty<NewActor> newActorProperty = new SimpleObjectProperty(null);
    private final WorldDisplay worldDisplay;
    private final UnfocusableScrollPane worldViewScroll;
    private final GClassDiagram classDiagram;
    private ContextMenu contextMenu;
    private Point2D lastMousePosInScene = new Point2D(0.0, 0.0);
    private final Label backgroundMessage;
    private final BooleanProperty worldVisible = new SimpleBooleanProperty(false);
    private boolean worldInstantiationError = false;
    private int lastUserSetSpeed;
    private boolean settingSpeedFromSimulation = false;
    private final ExecutionTwirler executionTwirler;
    private long lastExecStartTime;
    private final ControlPanel controlPanel;
    private DebuggerObject draggedActor;
    private AnimationTimer vmCommsHandler;
    private boolean constructingWorld = false;
    private final ObjectProperty<State> stateProperty = new SimpleObjectProperty((Object)State.NO_PROJECT);
    private boolean atBreakpoint = false;
    private boolean simulationRunning = false;
    private boolean waitingForDiscard = false;
    private final Queue<FXPlatformRunnable> executeAfterTermination = new LinkedList<FXPlatformRunnable>();
    private final Queue<FXPlatformRunnable> executeAfterReady = new LinkedList<FXPlatformRunnable>();
    private int nextPickId = 1;
    private int curPickRequest;
    private Point2D curPickPoint;
    private PickType curPickType;
    private int curDragRequest;
    private GreenfootRecorder saveTheWorldRecorder;
    private final SoundRecorderControls soundRecorder;
    private GreenfootDebugHandler debugHandler;
    private final Menu recentProjectsMenu = new Menu(Config.getString("menu.openRecent"));
    private final SimpleBooleanProperty showingDebugger = new SimpleBooleanProperty(false);
    private ClassTarget currentWorld;
    private final WritableImage[] worldImg = new WritableImage[2];
    private int nextWorldImgToWrite = 0;
    private ScenarioInfo scenarioInfo;
    private ChangeListener<String> playerNameListener = new ChangeListener<String>(){

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            GreenfootStage.this.sendPropertyToDebugVM("greenfoot.player.name", newValue);
        }
    };

    private GreenfootStage(Project project, GreenfootDebugHandler greenfootDebugHandler) {
        this.setTitle(STAGE_TITLE);
        stages.add(this);
        this.soundRecorder = new SoundRecorderControls(project);
        this.executionTwirler = new ExecutionTwirler(project, greenfootDebugHandler);
        this.controlPanel = new ControlPanel(this, (Node)this.executionTwirler);
        this.backgroundMessage = new Label();
        this.backgroundMessage.getStyleClass().add((Object)"background-message");
        Label hungMessage = new Label();
        hungMessage.setText(Config.getString("centrePanel.message.hung"));
        hungMessage.getStyleClass().add((Object)"hung-message");
        hungMessage.setVisible(false);
        hungMessage.managedProperty().bind((ObservableValue)hungMessage.visibleProperty());
        this.worldDisplay = new WorldDisplay();
        this.worldDisplay.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.PRIMARY && this.stateProperty.get() == State.RUNNING) {
                this.worldDisplay.requestFocus();
            }
        });
        JavaFXUtil.addFocusListener((Node)this.worldDisplay, focused -> this.debugHandler.getVmComms().worldFocusChanged((boolean)focused));
        this.executionTwirler.setWhileTwirling(twirling -> hungMessage.setVisible(twirling != false && (this.worldDisplay.isGreyedOut() && !this.worldDisplay.isAsking() || this.stateProperty.get() == State.RUNNING_REQUESTED_PAUSE)));
        this.classDiagram = new GClassDiagram(this);
        UnfocusableScrollPane classDiagramScroll = new UnfocusableScrollPane((Node)this.classDiagram);
        JavaFXUtil.expandScrollPaneContent(classDiagramScroll);
        classDiagramScroll.getStyleClass().add((Object)"gclass-diagram-scroll");
        classDiagramScroll.setMinViewportWidth(150.0);
        classDiagramScroll.setMinViewportHeight(200.0);
        this.worldViewScroll = new UnfocusableScrollPane((Node)this.worldDisplay);
        this.worldViewScroll.getStyleClass().add((Object)"world-display-scroll");
        JavaFXUtil.expandScrollPaneContent(this.worldViewScroll);
        this.worldViewScroll.visibleProperty().bind((ObservableValue)this.worldVisible);
        StackPane worldPane = new StackPane(new Node[]{this.backgroundMessage, this.worldViewScroll, hungMessage});
        ImageView shareIcon = new ImageView(new Image(this.getClass().getClassLoader().getResourceAsStream("export-publish.png")));
        shareIcon.setPreserveRatio(true);
        shareIcon.setFitHeight(24.0);
        Button shareButton = new Button(Config.getString("export.project"), (Node)shareIcon);
        shareButton.setFocusTraversable(false);
        shareButton.disableProperty().bind((ObservableValue)this.hasNoProject);
        shareButton.setOnAction(e -> this.doShare());
        GreenfootStageContentPane contentPane = new GreenfootStageContentPane((Pane)worldPane, shareButton, classDiagramScroll, this.controlPanel);
        BorderPane root = new BorderPane((Node)contentPane, (Node)this.makeMenu(), null, null, null);
        this.glassPane = new Pane();
        this.glassPane.setMouseTransparent(true);
        StackPane stackPane = new StackPane(new Node[]{root, this.glassPane});
        this.setupMouseForPlacingNewActor(stackPane);
        Scene scene = new Scene((Parent)stackPane);
        Config.addGreenfootStylesheets(scene);
        Config.addPMFStylesheets(scene);
        this.setScene(scene);
        this.setMinWidth(700.0);
        this.setMinHeight(400.0);
        this.setOnCloseRequest(e -> {
            this.isQuittingRequest = true;
            this.doClose(false);
        });
        JavaFXUtil.addChangeListenerPlatform(this.stateProperty, this::updateGUIState);
        this.setupKeyAndMouseHandlers();
        if (project != null) {
            this.showProject(project, greenfootDebugHandler);
        }
        this.updateBackgroundMessage();
        JavaFXUtil.addChangeListenerPlatform(this.focusedProperty(), focused -> {
            if (focused.booleanValue() && this.project != null) {
                DataCollector.recordGreenfootEvent(this.project, GreenfootInterfaceEvent.WINDOW_ACTIVATED);
                if (this.project.getUnnamedPackage().getClassTargets().stream().anyMatch(ct -> !ct.isCompiled())) {
                    this.project.scheduleCompilation(true, CompileReason.USER, CompileType.INDIRECT_USER_COMPILE, this.project.getUnnamedPackage());
                } else if (this.worldDisplay.isGreyedOut() && !this.worldDisplay.isAsking()) {
                    this.doReset();
                }
            }
        });
    }

    private void showProject(Project project, GreenfootDebugHandler greenfootDebugHandler) {
        this.setTitle("Greenfoot: " + project.getProjectName());
        this.project = project;
        this.saveTheWorldRecorder = greenfootDebugHandler.getRecorder();
        project.getPackage("").setUI(this);
        this.debugHandler = greenfootDebugHandler;
        this.hasNoProject.set(false);
        ++numberOfOpenProjects;
        project.getUnnamedPackage().addCompileObserver(this);
        greenfootDebugHandler.setPickListener(this::pickResults);
        greenfootDebugHandler.setSimulationListener(this);
        this.showingDebugger.bindBidirectional((Property)project.debuggerShowing());
        this.classDiagram.setProject(project);
        this.soundRecorder.setProject(project);
        this.executionTwirler.setProject(project, greenfootDebugHandler);
        this.vmCommsHandler = new AnimationTimer(){

            public void handle(long now) {
                if (GreenfootStage.this.debugHandler.getVmComms().checkIO(GreenfootStage.this)) {
                    GreenfootStage.this.executeAfterReady.forEach(JavaFXUtil::runAfterCurrent);
                    GreenfootStage.this.executeAfterReady.clear();
                }
            }
        };
        this.vmCommsHandler.start();
        this.loadAndMirrorProperties();
        Properties lastSavedProperties = project.getUnnamedPackage().getLastSavedProperties();
        String lastInstantiatedWorldName = lastSavedProperties.getProperty("world.lastInstantiated");
        ClassTarget classTarget = this.currentWorld = lastInstantiatedWorldName != null ? (ClassTarget)project.getTarget(lastInstantiatedWorldName) : null;
        if (this.currentWorld != null && this.currentWorld.isCompiled() && GreenfootStage.hasNoArgConstructor(this.currentWorld.getTypeReflective())) {
            this.constructingWorld = true;
            project.getTerminal().activate(true);
            this.debugHandler.getVmComms().instantiateWorld(lastInstantiatedWorldName);
            this.saveTheWorldRecorder.recordingValid();
            this.updateBackgroundMessage();
        }
        JavaFXUtil.addChangeListenerPlatform(this.worldVisible, b -> this.updateBackgroundMessage());
        PrefMgr.getPlayerName().addListener(this.playerNameListener);
        this.scenarioInfo = new ScenarioInfo(lastSavedProperties);
        String xPosition = lastSavedProperties.getProperty("xPosition");
        String yPosition = lastSavedProperties.getProperty("yPosition");
        if (xPosition != null && yPosition != null) {
            Point2D location = Config.ensureOnScreen(Double.valueOf(xPosition).intValue(), Double.valueOf(yPosition).intValue());
            this.setX(location.getX());
            this.setY(location.getY());
        }
        String width = lastSavedProperties.getProperty("width");
        String height = lastSavedProperties.getProperty("height");
        if (width != null) {
            this.setWidth(Double.valueOf(width));
        }
        if (height != null) {
            this.setHeight(Double.valueOf(height));
        }
        this.stateProperty.set((Object)State.NO_WORLD);
    }

    private void updateBackgroundMessage() {
        Object message;
        if (this.stateProperty.get() == State.NO_WORLD && !this.classDiagram.hasUserWorld()) {
            message = Config.getString("centrePanel.message.createWorldClass");
        } else if (this.worldVisible.get()) {
            message = "";
        } else if (this.stateProperty.get() == State.NO_WORLD) {
            if (this.worldInstantiationError) {
                message = Config.getString("centrePanel.message.error1") + " " + Config.getString("centrePanel.message.error2");
            } else if (this.constructingWorld) {
                message = Config.getString("centrePanel.message.initialising");
            } else {
                String possibleWorld = this.classDiagram.getInstantiatableWorld();
                if (possibleWorld != null) {
                    Properties props = new Properties();
                    props.put("exampleWorld", possibleWorld);
                    message = Config.getString("centrePanel.message.createWorldObject", null, props, false);
                } else {
                    message = this.classDiagram.hasUserWorld() ? Config.getString("centrePanel.message.missingWorldConstructor1") + " " + Config.getString("centrePanel.message.missingWorldConstructor2") : Config.getString("centrePanel.message.createWorldClass");
                }
            }
        } else {
            message = this.stateProperty.get() == State.NO_PROJECT ? (this.isQuittingRequest ? Config.getString("centrePanel.message.quitGreenfoot") : Config.getString("centrePanel.message.openScenario")) : (this.currentWorld != null && !this.currentWorld.isCompiled() ? Config.getString("centrePanel.message.compile1") + " " + Config.getString("centrePanel.message.compile2") : "");
        }
        this.backgroundMessage.setText((String)message);
    }

    public static GreenfootStage makeStage(Project project, GreenfootDebugHandler greenfootDebugHandler) {
        if (stages.size() == 1 && GreenfootStage.stages.get((int)0).project == null) {
            stages.get(0).showProject(project, greenfootDebugHandler);
            return stages.get(0);
        }
        return new GreenfootStage(project, greenfootDebugHandler);
    }

    @Override
    public void userReset() {
        DataCollector.recordGreenfootEvent(this.project, GreenfootInterfaceEvent.WORLD_RESET);
        this.doReset();
    }

    @OnThread(value=Tag.FXPlatform)
    public void doReset() {
        this.debugHandler.getVmComms().pauseSimulation();
        if (this.currentWorld != null && this.currentWorld.isCompiled() && GreenfootStage.hasNoArgConstructor(this.currentWorld.getTypeReflective())) {
            ClassTarget curWorld = this.currentWorld;
            this.suggestTerminateIfAskingThenRun(() -> {
                this.doWorldDiscard();
                this.constructingWorld = true;
                this.project.getTerminal().activate(true);
                this.debugHandler.getVmComms().instantiateWorld(curWorld.getQualifiedName());
                this.currentWorld = curWorld;
            });
        } else if (this.constructingWorld && this.worldDisplay.isAsking()) {
            this.suggestTerminateIfAskingThenRun(() -> this.doWorldDiscard());
        } else {
            this.doWorldDiscard();
        }
    }

    private void doWorldDiscard() {
        this.discardWorld();
        this.debugHandler.simulationThreadResumeOnResetClick();
        this.saveTheWorldRecorder.recordingValid();
        this.highlightObject(null);
    }

    private void discardWorld() {
        if (this.stateProperty.get() != State.NO_WORLD && this.stateProperty.get() != State.NO_PROJECT) {
            this.debugHandler.getVmComms().discardWorld();
            this.stateProperty.set((Object)State.NO_WORLD);
            this.waitingForDiscard = true;
        }
    }

    private void loadAndMirrorProperties() {
        Properties props = this.project.getUnnamedPackage().getLastSavedProperties();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            this.sendPropertyToDebugVM(key, value);
        }
        this.sendPropertyToDebugVM("greenfoot.player.name", (String)PrefMgr.getPlayerName().get());
        this.lastUserSetSpeed = 50;
        try {
            String speedString = this.project.getUnnamedPackage().getLastSavedProperties().getProperty("simulation.speed");
            if (speedString != null) {
                this.lastUserSetSpeed = Integer.valueOf(speedString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.controlPanel.setSpeed(this.lastUserSetSpeed);
        this.debugHandler.getVmComms().setSimulationSpeed(this.lastUserSetSpeed);
    }

    private void doOpenScenario() {
        File choice = FileUtility.getOpenProjectFX((Window)this);
        if (choice != null) {
            this.doOpenScenario(choice);
        }
    }

    public void doOpenGfarScenario() {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Greenfoot Scenarios (*.gfar)", new String[]{"*.gfar"})});
        chooser.setInitialDirectory(PrefMgr.getProjectDirectory());
        File chosen = chooser.showOpenDialog((Window)this.getStage());
        if (chosen != null) {
            GreenfootStage.openArchive(chosen, (Window)this.getStage());
        }
    }

    public static boolean openArchive(File archive, Window window) {
        File oPath = Utility.maybeExtractArchive(archive, () -> window);
        if (oPath != null && Project.isProject(oPath.getPath())) {
            ProjectManager.instance().launchProject(Project.openProject(oPath.toString()));
            return true;
        }
        return false;
    }

    private void doOpenScenario(File projPath) {
        Project p = Project.openProject(projPath.getAbsolutePath());
        if (p != null) {
            GreenfootStage stage = GreenfootStage.findStageForProject(p);
            if (stage != null) {
                stage.toFront();
            } else {
                ProjectManager.instance().launchProject(p);
            }
        } else {
            DialogManager.showErrorFX((Window)this, "could-not-open-project");
        }
    }

    private void updateRecentProjects() {
        this.recentProjectsMenu.getItems().clear();
        List<String> projects = PrefMgr.getRecentProjects();
        for (String projectToOpen : projects) {
            MenuItem item = new MenuItem(projectToOpen);
            this.recentProjectsMenu.getItems().add((Object)item);
            item.setOnAction(e -> this.doOpenScenario(new File(projectToOpen)));
        }
        if (projects.isEmpty()) {
            MenuItem noRecentProjects = new MenuItem(Config.getString("menu.noRecentProjects"));
            noRecentProjects.setDisable(true);
            this.recentProjectsMenu.getItems().add((Object)noRecentProjects);
        }
    }

    private void doClose(boolean keepLast) {
        PrefMgr.getPlayerName().removeListener(this.playerNameListener);
        if (numberOfOpenProjects <= 1 && !keepLast) {
            this.close();
            Main.doQuit();
            return;
        }
        if (this.project != null) {
            this.doSave();
            Project.cleanUp(this.project);
            this.project.getPackage("").closeAllEditors();
            --numberOfOpenProjects;
        }
        if (numberOfOpenProjects == 0) {
            this.removeScenarioDetails();
        } else {
            stages.remove(this);
            this.close();
        }
    }

    private void removeScenarioDetails() {
        if (this.project != null) {
            this.showingDebugger.unbindBidirectional((Property)this.project.debuggerShowing());
            this.project = null;
        }
        if (this.vmCommsHandler != null) {
            this.vmCommsHandler.stop();
            this.vmCommsHandler = null;
        }
        this.hasNoProject.set(true);
        this.worldDisplay.setImage(null);
        this.worldVisible.set(false);
        this.classDiagram.setProject(null);
        this.stateProperty.set((Object)State.NO_PROJECT);
        this.setTitle(STAGE_TITLE);
        this.currentWorld = null;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void doSave() {
        try {
            Properties p = this.project.getProjectPropertiesCopy();
            p.setProperty("simulation.speed", Integer.toString(this.lastUserSetSpeed));
            if (this.debugHandler.getShmFileSize() != 20000000) {
                p.setProperty("shm.size", Integer.toString(this.debugHandler.getShmFileSize()));
            }
            p.put("width", Integer.toString((int)this.getWidth()));
            p.put("height", Integer.toString((int)this.getHeight()));
            p.put("xPosition", Integer.toString((int)Math.max(this.getX(), 0.0)));
            p.put("yPosition", Integer.toString((int)Math.max(this.getY(), 0.0)));
            p.put("version", Boot.GREENFOOT_API_VERSION);
            if (this.currentWorld != null) {
                p.put("world.lastInstantiated", this.currentWorld.getQualifiedName());
            }
            this.project.saveEditorLocations(p);
            this.classDiagram.save(p);
            this.scenarioInfo.store(p);
            this.project.getUnnamedPackage().save(p);
            this.project.getImportScanner().saveCachedImports();
            this.project.saveAllEditors();
        }
        catch (IOException ioe) {
            DialogManager.showMessageFX((Window)this, "error-saving-project", new String[0]);
        }
    }

    public void doSaveAs() {
        File choice = FileUtility.getSaveProjectFX(this.project, (Window)this, Config.getString("project.saveAs.title"));
        if (choice == null) {
            return;
        }
        if (!ProjectUtils.saveProjectCopy(this.project, choice, this)) {
            return;
        }
        this.doClose(true);
        Project p = Project.openProject(choice.getAbsolutePath());
        if (p == null) {
            Debug.reportError("Project save-as succeeded, but new project could not be opened");
            return;
        }
        ProjectManager.instance().launchProject(p);
    }

    private void doShare() {
        if (this.stateProperty.get() == State.NO_WORLD) {
            DialogManager.showErrorFX((Window)this, "export-compile-not-compiled");
        } else {
            try {
                new ExportDialog((Window)this, this.project, this, this.scenarioInfo, this.currentWorld, this.worldDisplay.getSnapshot()).showAndWait();
            }
            catch (ExportException e) {
                DialogManager.showErrorTextFX((Window)this, e.getMessage());
            }
        }
    }

    @Override
    public void act() {
        if (this.stateProperty.get() == State.PAUSED) {
            DataCollector.recordGreenfootEvent(this.project, GreenfootInterfaceEvent.WORLD_ACT);
            this.debugHandler.getVmComms().act();
            this.stateProperty.set((Object)State.PAUSED_REQUESTED_ACT_OR_RUN);
            this.saveTheWorldRecorder.invalidateRecording();
        }
    }

    @Override
    public void doRunPause() {
        if (this.stateProperty.get() == State.PAUSED) {
            DataCollector.recordGreenfootEvent(this.project, GreenfootInterfaceEvent.WORLD_RUN);
            this.debugHandler.getVmComms().runSimulation();
            this.stateProperty.set((Object)State.PAUSED_REQUESTED_ACT_OR_RUN);
            this.saveTheWorldRecorder.invalidateRecording();
            this.worldDisplay.requestFocus();
        } else if (this.stateProperty.get() == State.RUNNING) {
            DataCollector.recordGreenfootEvent(this.project, GreenfootInterfaceEvent.WORLD_PAUSE);
            this.debugHandler.getVmComms().pauseSimulation();
            this.stateProperty.set((Object)State.RUNNING_REQUESTED_PAUSE);
        }
    }

    public void showApiDoc(String page) {
        try {
            String customUrl = Utility.getGreenfootApiDocURL(page);
            if (customUrl != null) {
                GreenfootStage.openWebBrowser(customUrl);
            }
        }
        catch (IOException ioe) {
            DialogManager.showErrorWithTextFX((Window)this, "cannot-read-apidoc", ioe.getLocalizedMessage());
        }
    }

    private static void openWebBrowser(String url) {
        EventQueue.invokeLater(() -> {
            boolean success = Utility.openWebBrowser(url);
            if (!success) {
                Platform.runLater(() -> DialogManager.showErrorFX(null, "cannot-open-browser"));
            }
        });
    }

    private void showCopyright() {
        String text = Config.getString("menu.help.copyright.line1") + "\n" + Config.getString("menu.help.copyright.line2") + "\n" + Config.getString("menu.help.copyright.line3") + "\n" + Config.getString("menu.help.copyright.line4");
        Alert alert = new Alert(Alert.AlertType.INFORMATION, text, new ButtonType[]{ButtonType.OK});
        alert.setTitle(Config.getString("menu.help.copyright.title"));
        alert.initOwner((Window)this);
        alert.initModality(Modality.WINDOW_MODAL);
        alert.setHeaderText(Config.getString("menu.help.copyright.line0"));
        alert.showAndWait();
    }

    private MenuBar makeMenu() {
        this.recentProjectsMenu.setOnShowing(e -> this.updateRecentProjects());
        this.updateRecentProjects();
        Menu scenarioMenu = new Menu(Config.getString("menu.scenario"), null, new MenuItem[]{JavaFXUtil.makeMenuItem("stride.new.project", (KeyCombination)new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), () -> this.doNewProject(SourceType.Stride), null), JavaFXUtil.makeMenuItem("java.new.project", (KeyCombination)new KeyCodeCombination(KeyCode.J, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), () -> this.doNewProject(SourceType.Java), null), JavaFXUtil.makeMenuItem("open.project", (KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this::doOpenScenario, null), this.recentProjectsMenu, JavaFXUtil.makeMenuItem("open.gfar.project", null, this::doOpenGfarScenario, null), JavaFXUtil.makeMenuItem("project.close", (KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), () -> this.doClose(true), (ObservableValue<Boolean>)this.hasNoProject), JavaFXUtil.makeMenuItem("project.save", (KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this::doSave, (ObservableValue<Boolean>)this.hasNoProject), JavaFXUtil.makeMenuItem("project.saveAs", null, this::doSaveAs, (ObservableValue<Boolean>)this.hasNoProject), new SeparatorMenuItem(), JavaFXUtil.makeMenuItem("show.readme", null, this::openReadme, (ObservableValue<Boolean>)this.hasNoProject), JavaFXUtil.makeMenuItem("export.project", (KeyCombination)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this::doShare, (ObservableValue<Boolean>)this.hasNoProject)});
        if (!Config.isMacOS()) {
            scenarioMenu.getItems().add((Object)new SeparatorMenuItem());
            scenarioMenu.getItems().add((Object)JavaFXUtil.makeMenuItem("greenfoot.quit", (KeyCombination)new KeyCodeCombination(KeyCode.Q, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), () -> {
                this.isQuittingRequest = true;
                Main.wantToQuit();
            }, null));
        }
        Menu toolsMenu = new Menu(Config.getString("menu.tools"), null);
        toolsMenu.getItems().addAll((Object[])new MenuItem[]{JavaFXUtil.makeMenuItem(Config.getString("save.world"), () -> {
            FXPlatformFunction<String, Editor> fetchEditorByName = className -> {
                Target t = this.project.getTarget((String)className);
                if (t instanceof ClassTarget) {
                    return ((ClassTarget)t).getEditor();
                }
                return null;
            };
            if (!this.saveTheWorldRecorder.writeCode(fetchEditorByName)) {
                DialogManager.showErrorFX((Window)this, "cannot-save-world");
            }
        }, null), JavaFXUtil.makeMenuItem(Config.getString("menu.tools.recompileAll"), () -> this.project.getUnnamedPackage().rebuild(), null), JavaFXUtil.makeMenuItem("menu.tools.generateDoc", (KeyCombination)new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this::generateDocumentation, (ObservableValue<Boolean>)this.hasNoProject), JavaFXUtil.makeCheckMenuItem(Config.getString("menu.soundRecorder"), (Property<Boolean>)this.soundRecorder.getShowingProperty(), (KeyCombination)new KeyCodeCombination(KeyCode.U, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this::toggleSoundRecorder), JavaFXUtil.makeCheckMenuItem(Config.getString("menu.debugger"), (Property<Boolean>)this.showingDebugger, (KeyCombination)new KeyCodeCombination(KeyCode.B, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), JavaFXUtil.makeMenuItem("set.player", (KeyCombination)Config.GREENFOOT_SET_PLAYER_NAME_SHORTCUT, this::setPlayer, (ObservableValue<Boolean>)this.hasNoProject)});
        if (!Config.isMacOS()) {
            toolsMenu.getItems().add((Object)JavaFXUtil.makeMenuItem("greenfoot.preferences", (KeyCombination)new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), () -> GreenfootStage.showPreferences(), null));
        }
        Menu helpMenu = new Menu(Config.getString("menu.help"), null);
        if (!Config.isMacOS()) {
            helpMenu.getItems().add((Object)JavaFXUtil.makeMenuItem("menu.help.about", null, () -> GreenfootStage.aboutGreenfoot((Window)this), null));
        }
        helpMenu.getItems().addAll((Object[])new MenuItem[]{JavaFXUtil.makeMenuItem("greenfoot.copyright", null, this::showCopyright, null), new SeparatorMenuItem(), JavaFXUtil.makeMenuItem("menu.help.classDoc", null, () -> this.showApiDoc("index.html"), null), JavaFXUtil.makeMenuItem("menu.help.javadoc", null, () -> GreenfootStage.openWebBrowser(Config.getPropString("url.javaStdLib")), null), new SeparatorMenuItem(), JavaFXUtil.makeMenuItem("menu.help.tutorial", null, () -> GreenfootStage.openWebBrowser(Config.getPropString("greenfoot.url.tutorial")), null), JavaFXUtil.makeMenuItem("menu.help.website", null, () -> GreenfootStage.openWebBrowser(Config.getPropString("greenfoot.url.greenfoot")), null), JavaFXUtil.makeMenuItem("menu.help.discuss", null, () -> GreenfootStage.openWebBrowser(Config.getPropString("greenfoot.url.discuss")), null), JavaFXUtil.makeMenuItem("menu.help.moreScenarios", null, () -> GreenfootStage.openWebBrowser(Config.getPropString("greenfoot.url.scenarios")), null)});
        MenuBar menuBar = new MenuBar(new Menu[]{scenarioMenu, new Menu(Config.getString("menu.edit"), null, new MenuItem[]{JavaFXUtil.makeMenuItem("new.other.class", (KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), () -> this.newNonImageClass(this.project.getUnnamedPackage(), null), (ObservableValue<Boolean>)this.hasNoProject), JavaFXUtil.makeMenuItem("import.action", (KeyCombination)new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), () -> this.doImportClass(), (ObservableValue<Boolean>)this.hasNoProject)}), new Menu(Config.getString("menu.controls"), null, this.controlPanel.makeMenuItems().toArray(new MenuItem[0])), toolsMenu, helpMenu});
        menuBar.setUseSystemMenuBar(true);
        return menuBar;
    }

    private void toggleSoundRecorder(Boolean showing) {
        if (showing.booleanValue()) {
            this.soundRecorder.show();
        } else {
            this.soundRecorder.close();
        }
    }

    private void generateDocumentation() {
        String message = this.project.generateDocumentation();
        if (message.length() != 0) {
            DialogManager.showTextFX((Window)this, message);
        }
    }

    private void setPlayer() {
        SetPlayerDialog dlg = new SetPlayerDialog((Window)this, (String)PrefMgr.getPlayerName().get());
        dlg.showAndWait().ifPresent(name -> PrefMgr.getPlayerName().set(name));
    }

    public void sendPropertyToDebugVM(String key, String value) {
        this.debugHandler.getVmComms().sendProperty(key, value);
    }

    public static void showPreferences() {
        PrefMgrDialog.showDialog(null);
    }

    private void updateGUIState(State newState) {
        this.controlPanel.updateState(newState, this.atBreakpoint);
        this.updateBackgroundMessage();
    }

    @OnThread(value=Tag.Any)
    private void addActorQuick(Point2D dest, Point2D cell, DebuggerObject actor) {
        this.saveTheWorldRecorder.addActorToWorld(actor, (int)cell.getX(), (int)cell.getY());
        DebuggerObject xObject = this.project.getDebugger().getMirror("" + (int)dest.getX());
        DebuggerObject yObject = this.project.getDebugger().getMirror("" + (int)dest.getY());
        this.project.getDebugger().instantiateClass("greenfoot.core.AddToWorldHelper", new String[]{"java.lang.Object", "java.lang.String", "java.lang.String"}, new DebuggerObject[]{actor, xObject, yObject});
    }

    private void setupMouseForPlacingNewActor(StackPane stackPane) {
        stackPane.setOnMouseMoved(e -> {
            this.lastMousePosInScene = new Point2D(e.getSceneX(), e.getSceneY());
            if (this.newActorProperty.get() != null) {
                ((NewActor)this.newActorProperty.get()).previewNode.setTranslateX(e.getX() - ((NewActor)this.newActorProperty.get()).previewNode.getWidth() / 2.0);
                ((NewActor)this.newActorProperty.get()).previewNode.setTranslateY(e.getY() - ((NewActor)this.newActorProperty.get()).previewNode.getHeight() / 2.0);
                ((NewActor)this.newActorProperty.get()).cannotDrop.set(!this.worldDisplay.worldContains(this.worldDisplay.sceneToWorld(this.lastMousePosInScene)));
            }
        });
        stackPane.setOnMouseClicked(e -> {
            this.lastMousePosInScene = new Point2D(e.getSceneX(), e.getSceneY());
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 1 && this.newActorProperty.get() != null) {
                final Point2D dest = this.worldDisplay.sceneToWorld(this.lastMousePosInScene);
                if (this.worldDisplay.worldContains(dest)) {
                    final DebuggerObject actor = ((NewActor)this.newActorProperty.get()).actorObject;
                    final Point2D cell = this.pixelToCellCoordinates(dest);
                    if (actor != null) {
                        this.saveTheWorldRecorder.createActor(actor, ((NewActor)this.newActorProperty.get()).invokerRecord.getArgumentValues(), ((NewActor)this.newActorProperty.get()).paramTypes);
                        this.newActorProperty.set(null);
                        new Thread("Add actor on click"){

                            @Override
                            public void run() {
                                GreenfootStage.this.addActorQuick(dest, cell, actor);
                            }
                        }.start();
                    } else {
                        new Thread("Add actor on shift click"){

                            @Override
                            public void run() {
                                DebuggerResult result = GreenfootStage.this.project.getDebugger().instantiateClass(((NewActor)GreenfootStage.this.newActorProperty.get()).typeName);
                                DebuggerObject actor = result.getResultObject();
                                if (actor != null) {
                                    GreenfootStage.this.saveTheWorldRecorder.createActor(actor, new String[0], new JavaType[0]);
                                    GreenfootStage.this.addActorQuick(dest, cell, actor);
                                }
                            }
                        }.start();
                    }
                } else {
                    this.newActorProperty.set(null);
                }
            }
        });
        this.newActorProperty.addListener((ChangeListener)new ChangeListener<NewActor>(){

            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public void changed(ObservableValue<? extends NewActor> prop, NewActor oldVal, NewActor newVal) {
                if (oldVal != null) {
                    GreenfootStage.this.glassPane.getChildren().remove((Object)oldVal.previewNode);
                }
                if (newVal != null) {
                    GreenfootStage.this.glassPane.getChildren().add((Object)newVal.previewNode);
                    GreenfootStage.this.glassPane.requestLayout();
                    GreenfootStage.this.glassPane.layout();
                    newVal.previewNode.setTranslateX(GreenfootStage.this.lastMousePosInScene.getX() - newVal.previewNode.getWidth() / 2.0);
                    newVal.previewNode.setTranslateY(GreenfootStage.this.lastMousePosInScene.getY() - newVal.previewNode.getHeight() / 2.0);
                    newVal.cannotDrop.set(!GreenfootStage.this.worldDisplay.worldContains(GreenfootStage.this.worldDisplay.sceneToWorld(GreenfootStage.this.lastMousePosInScene)));
                }
            }
        });
    }

    public void setLatestMousePosOnScreen(double screenX, double screenY) {
        Point2D rootPoint = this.getScene().getRoot().screenToLocal(screenX, screenY);
        this.lastMousePosInScene = this.getScene().getRoot().localToScene(rootPoint);
    }

    private static boolean hasNoArgConstructor(Reflective type) {
        return type.getDeclaredConstructors().stream().anyMatch(c -> c.getParamTypes().isEmpty() && !Modifier.isPrivate(c.getModifiers()));
    }

    private Point2D pixelToCellCoordinates(Point2D worldPixels) {
        int cellSize = this.debugHandler.getVmComms().getWorldCellSize();
        if (cellSize == 0) {
            return worldPixels;
        }
        int xpos = (int)worldPixels.getX() / cellSize;
        int ypos = (int)worldPixels.getY() / cellSize;
        return new Point2D((double)xpos, (double)ypos);
    }

    private void setupKeyAndMouseHandlers() {
        this.getScene().addEventFilter(KeyEvent.ANY, e -> {
            if (Config.isMacOS() && e.getEventType() == KeyEvent.KEY_PRESSED && e.getCode() == KeyCode.M && e.isMetaDown()) {
                this.setIconified(true);
                return;
            }
            if (this.project == null) {
                return;
            }
            if (this.worldDisplay.isAsking()) {
                return;
            }
            if (e.getEventType() == KeyEvent.KEY_PRESSED) {
                Reflective type;
                if (e.getCode() == KeyCode.ESCAPE && this.newActorProperty.get() != null) {
                    this.newActorProperty.set(null);
                    return;
                }
                boolean paused = this.stateProperty.get() == State.PAUSED;
                ClassTarget selectedClassTarget = this.classDiagram.getSelectedClassTarget();
                if (e.getCode() == KeyCode.SHIFT && this.newActorProperty.get() == null && selectedClassTarget != null && paused && (type = selectedClassTarget.getTypeReflective()) != null && this.getActorReflective().isAssignableFrom(type) && GreenfootStage.hasNoArgConstructor(type)) {
                    this.newActorProperty.set((Object)new NewActor(this.getImageViewForClass(type), selectedClassTarget.getBaseName()));
                }
            } else if (e.getEventType() == KeyEvent.KEY_RELEASED && e.getCode() == KeyCode.SHIFT && this.newActorProperty.get() != null && ((NewActor)this.newActorProperty.get()).actorObject == null) {
                this.newActorProperty.set(null);
            }
        });
        this.worldDisplay.addEventFilter(KeyEvent.ANY, e -> {
            int eventType;
            if (this.project == null) {
                return;
            }
            if (this.worldDisplay.isAsking()) {
                return;
            }
            if (e.getEventType().equals(KeyEvent.KEY_PRESSED)) {
                eventType = 1;
            } else if (e.getEventType().equals(KeyEvent.KEY_RELEASED)) {
                eventType = 2;
            } else if (e.getEventType().equals(KeyEvent.KEY_TYPED)) {
                eventType = 3;
            } else {
                return;
            }
            this.debugHandler.getVmComms().sendKeyEvent(eventType, e.getCode(), e.getText());
            if (!e.isControlDown() || e.isAltDown() && Config.isWinOS()) {
                e.consume();
            }
        });
        this.worldDisplay.setOnContextMenuRequested(e -> {
            boolean paused;
            if (this.project == null) {
                return;
            }
            boolean bl = paused = this.stateProperty.get() == State.PAUSED;
            if (paused) {
                Point2D worldPos = this.worldDisplay.sceneToWorld(new Point2D(e.getSceneX(), e.getSceneY()));
                this.pickRequest(worldPos, PickType.CONTEXT_MENU);
            }
        });
        this.worldDisplay.getImageView().addEventFilter(MouseEvent.ANY, e -> {
            int eventType;
            if (this.project == null) {
                return;
            }
            boolean paused = this.stateProperty.get() == State.PAUSED;
            Point2D worldPos = this.worldDisplay.sceneToWorld(new Point2D(e.getSceneX(), e.getSceneY()));
            if (e.getEventType() == MouseEvent.MOUSE_CLICKED) {
                if (!(e.getButton() != MouseButton.PRIMARY || Config.isMacOS() && e.isControlDown())) {
                    this.hideContextMenu();
                    if (paused) {
                        this.pickRequest(worldPos, PickType.LEFT_CLICK);
                    }
                }
                eventType = 11;
            } else if (e.getEventType() == MouseEvent.MOUSE_PRESSED) {
                eventType = 12;
                if (paused && e.isPrimaryButtonDown() && !e.isControlDown()) {
                    this.pickRequest(worldPos, PickType.DRAG);
                }
            } else if (e.getEventType() == MouseEvent.MOUSE_RELEASED) {
                eventType = 14;
                if (this.curDragRequest != -1) {
                    this.debugHandler.getVmComms().endDrag(this.curDragRequest);
                    this.curDragRequest = -1;
                    Point2D cellPos = this.pixelToCellCoordinates(worldPos);
                    this.saveTheWorldRecorder.moveActor(this.draggedActor, (int)cellPos.getX(), (int)cellPos.getY());
                }
            } else if (e.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                if (e.getButton() == MouseButton.PRIMARY && paused && this.curDragRequest != -1) {
                    this.debugHandler.getVmComms().continueDrag(this.curDragRequest, (int)worldPos.getX(), (int)worldPos.getY());
                }
                eventType = 13;
            } else if (e.getEventType() == MouseEvent.MOUSE_MOVED) {
                eventType = 15;
            } else if (e.getEventType() == MouseEvent.MOUSE_EXITED) {
                eventType = 16;
            } else {
                return;
            }
            MouseButton button = e.getButton();
            if (Config.isMacOS() && button == MouseButton.PRIMARY && e.isControlDown()) {
                button = MouseButton.SECONDARY;
            }
            if (this.newActorProperty.get() == null) {
                this.debugHandler.getVmComms().sendMouseEvent(eventType, (int)worldPos.getX(), (int)worldPos.getY(), button.ordinal(), e.getClickCount());
            }
        });
    }

    public void receivedWorldImage(int width, int height, IntBuffer buffer) {
        if (this.project == null) {
            return;
        }
        if (this.worldImg[this.nextWorldImgToWrite] == null || this.worldImg[this.nextWorldImgToWrite].getWidth() != (double)width || this.worldImg[this.nextWorldImgToWrite].getHeight() != (double)height) {
            this.worldImg[this.nextWorldImgToWrite] = new WritableImage(width == 0 ? 1 : width, height == 0 ? 1 : height);
            if (this.worldViewScroll.getWidth() < this.worldImg[this.nextWorldImgToWrite].getWidth() || this.worldViewScroll.getHeight() < this.worldImg[this.nextWorldImgToWrite].getHeight()) {
                JavaFXUtil.runAfterCurrent(() -> this.sizeToScene());
            }
        }
        try {
            this.worldImg[this.nextWorldImgToWrite].getPixelWriter().setPixels(0, 0, width, height, (PixelFormat)PixelFormat.getIntArgbInstance(), (Buffer)buffer, width);
            this.worldDisplay.setImage((Image)this.worldImg[this.nextWorldImgToWrite]);
            this.nextWorldImgToWrite = (this.nextWorldImgToWrite + 1) % this.worldImg.length;
            this.worldInstantiationError = false;
            this.worldVisible.set(true);
        }
        catch (IndexOutOfBoundsException ex) {
            Debug.reportError("Error receiving world (world image probably too large)");
            this.worldInstantiationError = true;
            this.worldVisible.set(false);
        }
        if (this.stateProperty.get() == State.NO_WORLD && !this.waitingForDiscard) {
            this.stateProperty.set((Object)(this.simulationRunning ? State.RUNNING : State.PAUSED));
        }
    }

    public void worldChanged(boolean worldPresent) {
        this.waitingForDiscard = false;
        this.constructingWorld = false;
        this.project.getTerminal().activate(false);
        if (!worldPresent) {
            this.worldDisplay.greyOutWorld();
            this.stateProperty.set((Object)State.NO_WORLD);
        }
    }

    public void receivedAsk(int askId, int[] promptCodepoints) {
        this.worldDisplay.ensureAsking(new String(promptCodepoints, 0, promptCodepoints.length), s -> this.debugHandler.getVmComms().sendAnswer(askId, (String)s));
        this.worldVisible.set(true);
    }

    public void cancelAsk() {
        this.worldDisplay.cancelAsk();
    }

    private void pickRequest(Point2D worldPosition, PickType pickType) {
        this.curPickType = pickType;
        Debugger debugger = this.project.getDebugger();
        DebuggerObject xObject = debugger.getMirror("" + (int)worldPosition.getX());
        DebuggerObject yObject = debugger.getMirror("" + (int)worldPosition.getY());
        int thisPickId = this.nextPickId++;
        DebuggerObject pickIdObject = debugger.getMirror("" + thisPickId);
        String requestTypeString = pickType == PickType.DRAG ? "drag" : "";
        DebuggerObject requestTypeObject = debugger.getMirror(requestTypeString);
        this.curPickRequest = thisPickId;
        this.curPickPoint = worldPosition;
        Utility.runBackground(() -> debugger.instantiateClass("greenfoot.core.PickActorHelper", new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"}, new DebuggerObject[]{xObject, yObject, pickIdObject, requestTypeObject}));
    }

    @OnThread(value=Tag.Any)
    public void pickResults(int pickId, List<DebuggerObject> actors, DebuggerObject world) {
        Platform.runLater(() -> {
            if (this.curPickRequest != pickId) {
                return;
            }
            if (this.curPickType == PickType.CONTEXT_MENU) {
                if (!actors.isEmpty()) {
                    NamedValue[] namesForActors = this.debugHandler.nameObjects(actors);
                    ArrayList<Menu> actorMenus = new ArrayList<Menu>();
                    for (int i = 0; i < actors.size(); ++i) {
                        DebuggerObject actor = (DebuggerObject)actors.get(i);
                        Target target = this.project.getTarget(actor.getClassName());
                        if (!(target instanceof ClassTarget)) continue;
                        Menu menu = new Menu(namesForActors[i].getName() + ":" + actor.getClassName());
                        ObjectWrapper.createMethodMenuItems((ObservableList<MenuItem>)menu.getItems(), this.project.loadClass(actor.getClassName()), new RecordInvoke(actor), "", true);
                        menu.getItems().add((Object)this.makeInspectMenuItem(actor, namesForActors[i].getName()));
                        for (MenuItem menuItem : menu.getItems()) {
                            menuItem.addEventHandler(ActionEvent.ACTION, e -> this.hideContextMenu());
                        }
                        MenuItem removeItem = new MenuItem(Config.getString("world.handlerDelegate.remove"));
                        JavaFXUtil.addStyleClass((Styleable)removeItem, "class-action-inbuilt");
                        removeItem.setOnAction(e -> {
                            this.project.getDebugger().instantiateClass("greenfoot.core.RemoveFromWorldHelper", new String[]{"java.lang.Object"}, new DebuggerObject[]{actor});
                            this.saveTheWorldRecorder.removeActor(actor);
                        });
                        menu.getItems().add((Object)removeItem);
                        actorMenus.add(menu);
                    }
                    this.hideContextMenu();
                    this.contextMenu = new ContextMenu();
                    this.contextMenu.setOnHidden(e -> {
                        this.contextMenu = null;
                    });
                    if (actorMenus.size() == 1) {
                        this.contextMenu.getItems().addAll((Collection)((Menu)actorMenus.get(0)).getItems());
                    } else {
                        this.contextMenu.getItems().addAll(actorMenus);
                    }
                    Point2D screenLocation = this.worldDisplay.worldToScreen(this.curPickPoint);
                    this.contextMenu.show((Node)this.worldDisplay, screenLocation.getX(), screenLocation.getY());
                } else {
                    Target target = this.project.getTarget(world.getClassName());
                    if (target instanceof ClassTarget) {
                        this.hideContextMenu();
                        this.contextMenu = new ContextMenu();
                        this.contextMenu.setOnHidden(e -> {
                            this.contextMenu = null;
                        });
                        ObjectWrapper.createMethodMenuItems((ObservableList<MenuItem>)this.contextMenu.getItems(), this.project.loadClass(world.getClassName()), new RecordInvoke(world), "", true);
                        this.contextMenu.getItems().add((Object)this.makeInspectMenuItem(world, this.debugHandler.nameObjects(List.of(world))[0].getName()));
                        MenuItem saveTheWorld = new MenuItem(Config.getString("save.world"));
                        JavaFXUtil.addStyleClass((Styleable)saveTheWorld, "class-action-inbuilt");
                        saveTheWorld.setOnAction(e -> {
                            if (!this.saveTheWorldRecorder.writeCode(className -> ((ClassTarget)target).getEditor())) {
                                DialogManager.showErrorFX((Window)this, "cannot-save-world");
                            }
                        });
                        this.contextMenu.getItems().add((Object)saveTheWorld);
                        Point2D screenLocation = this.worldDisplay.worldToScreen(this.curPickPoint);
                        this.contextMenu.show((Node)this.worldDisplay, screenLocation.getX(), screenLocation.getY());
                    }
                }
            } else if (this.curPickType == PickType.DRAG && !actors.isEmpty()) {
                this.curDragRequest = pickId;
                this.draggedActor = (DebuggerObject)actors.get(0);
            } else if (this.curPickType == PickType.LEFT_CLICK && !actors.isEmpty()) {
                this.debugHandler.addSelectedObjects(actors, this.worldDisplay.worldToScreen(this.curPickPoint));
            }
        });
    }

    private void hideContextMenu() {
        if (this.contextMenu != null) {
            this.contextMenu.hide();
        }
    }

    private MenuItem makeInspectMenuItem(DebuggerObject debuggerObject, String name) {
        MenuItem inspectItem = new MenuItem(Config.getString("debugger.objectwrapper.inspect"));
        JavaFXUtil.addStyleClass((Styleable)inspectItem, "class-action-inbuilt");
        inspectItem.setOnAction(e -> {
            ObjectInspectInvokerRecord ir = new ObjectInspectInvokerRecord(debuggerObject.getClassName());
            this.project.getInspectorInstance(debuggerObject, name, this.project.getUnnamedPackage(), ir, (Window)this, null);
        });
        return inspectItem;
    }

    private ImageView getImageViewForClass(Reflective typeReflective) {
        File file = this.getImageFilename(typeReflective);
        if (file == null) {
            file = new File(GreenfootStage.getGreenfootLogoPath());
        }
        ImageView imageView = null;
        try {
            imageView = new ImageView(file.toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            Debug.reportError(e);
        }
        return imageView;
    }

    private static String getGreenfootLogoPath() {
        File libDir = Config.getGreenfootLibDir();
        return libDir.getAbsolutePath() + "/imagelib/other/greenfoot.png";
    }

    private File getImageFilename(Reflective type) {
        String imageFileName = this.classDiagram.getImageForActorClass(type);
        if (imageFileName == null) {
            return null;
        }
        File imageDir = new File(this.project.getProjectDir(), "images");
        return new File(imageDir, imageFileName);
    }

    @Override
    public void startCompile(CompileInputFile[] sources, CompileReason reason, CompileType type, int compilationSequence) {
        this.discardWorld();
        this.worldDisplay.greyOutWorld();
        this.updateBackgroundMessage();
    }

    @Override
    public boolean compilerMessage(Diagnostic diagnostic, CompileType type) {
        return false;
    }

    @Override
    public void endCompile(CompileInputFile[] sources, boolean succesful, CompileType type, int compilationSequence) {
        if (this.project == null) {
            return;
        }
        System.gc();
        if (this.isFocused()) {
            this.doReset();
        }
        this.updateBackgroundMessage();
        this.classDiagram.recalculateGroups();
    }

    @Override
    @OnThread(value=Tag.Any)
    public void simulationStartedRunning() {
        Platform.runLater(() -> {
            this.simulationRunning = true;
            if (this.stateProperty.get() != State.NO_WORLD) {
                this.stateProperty.set((Object)State.RUNNING);
            }
            this.project.getTerminal().activate(true);
        });
    }

    @Override
    @OnThread(value=Tag.Any)
    public void simulationPaused() {
        Platform.runLater(() -> {
            this.simulationRunning = false;
            if (this.project != null && this.stateProperty.get() != State.NO_WORLD) {
                this.stateProperty.set((Object)State.PAUSED);
            }
            this.project.getTerminal().activate(false);
        });
    }

    @Override
    @OnThread(value=Tag.Any)
    public void simulationDebugHalted() {
        Platform.runLater(() -> {
            this.atBreakpoint = true;
            this.updateGUIState((State)((Object)((Object)this.stateProperty.get())));
        });
    }

    @Override
    @OnThread(value=Tag.Any)
    public void simulationDebugResumed() {
        Platform.runLater(() -> {
            this.atBreakpoint = false;
            this.updateGUIState((State)((Object)((Object)this.stateProperty.get())));
        });
    }

    @Override
    @OnThread(value=Tag.Any)
    public void worldInstantiationError() {
        Platform.runLater(() -> {
            this.worldInstantiationError = true;
            this.constructingWorld = false;
            this.project.getTerminal().activate(false);
            this.worldVisible.set(false);
        });
    }

    @Override
    @OnThread(value=Tag.Any)
    public void simulationVMTerminated() {
        Platform.runLater(() -> {
            this.worldDisplay.setImage(null);
            this.worldDisplay.cancelAsk();
            this.worldInstantiationError = false;
            this.settingSpeedFromSimulation = false;
            this.constructingWorld = false;
            this.setLastUserExecutionStartTime(0L, false);
            this.atBreakpoint = false;
            this.nextPickId = 1;
            this.curPickRequest = 0;
            this.curDragRequest = -1;
            this.currentWorld = null;
            this.worldVisible.set(false);
            this.stateProperty.set((Object)State.NO_WORLD);
            this.loadAndMirrorProperties();
            if (this.executeAfterTermination != null) {
                this.executeAfterReady.addAll(this.executeAfterTermination);
                this.executeAfterTermination.clear();
            }
        });
    }

    public void setImageFor(LocalGClassNode classNode) {
        SelectImageFrame selectImageFrame = new SelectImageFrame((Window)this, this.project, classNode);
        selectImageFrame.showAndWait().ifPresent(selectedFile -> this.setImageToClassNode(classNode, (File)selectedFile));
    }

    private void setImageToClassNode(LocalGClassNode classNode, File originalImageFile) {
        File localImageFile;
        File imagesDir = new File(this.project.getProjectDir(), "images");
        if (originalImageFile.getParentFile().equals(imagesDir)) {
            localImageFile = originalImageFile;
        } else {
            localImageFile = new File(imagesDir, originalImageFile.getName());
            GreenfootUtil.copyFile(originalImageFile, localImageFile);
        }
        String imageFileName = localImageFile.getName();
        classNode.setImageFilename(imageFileName);
        String qualifiedName = classNode.getQualifiedName();
        this.saveAndMirrorClassImageFilename(qualifiedName, imageFileName);
    }

    public void saveAndMirrorClassImageFilename(String qualifiedName, String imageFileName) {
        this.doSave();
        this.sendPropertyToDebugVM("class." + qualifiedName + ".image", imageFileName);
    }

    public void duplicateClass(LocalGClassNode originalNode, ClassTarget originalClassTarget) {
        String originalClassName = originalClassTarget.getDisplayName();
        SourceType sourceType = originalClassTarget.getSourceType();
        NewClassDialog dialog = new NewClassDialog((Window)this, sourceType);
        dialog.setSuggestedClassName("CopyOf" + originalClassName);
        dialog.disableLanguageBox(true);
        dialog.showAndWait().ifPresent(newClassInfo -> {
            String newClassName = newClassInfo.className;
            String extension = sourceType.getExtension();
            Package pkg = originalClassTarget.getPackage();
            File dir = pkg.getProject().getProjectDir();
            File originalFile = new File(dir, originalClassName + "." + extension);
            File newFile = new File(dir, newClassName + "." + extension);
            try {
                ProjectUtils.duplicate(originalClassName, newClassName, originalFile, newFile, sourceType);
                ClassTarget newClass = pkg.addClass(newClassName);
                LocalGClassNode newNode = this.classDiagram.addClass(newClass);
                String originalImage = originalNode.getImageFilename();
                if (originalImage != null) {
                    File imagesDir = new File(this.project.getProjectDir(), "images");
                    File srcImage = new File(imagesDir, originalImage);
                    this.setImageToClassNode(newNode, srcImage);
                }
                pkg.compile(newClass, CompileReason.LOADED, CompileType.INDIRECT_USER_COMPILE);
            }
            catch (IOException ioe) {
                Debug.reportError(ioe);
            }
        });
    }

    public void doImportClass() {
        File srcFile = new ImportClassDialog(this).showAndWait().orElse(null);
        if (srcFile != null) {
            boolean librariesImportedFlag = false;
            String className = GreenfootUtil.removeExtension(srcFile.getName());
            Package pkg = this.project.getUnnamedPackage();
            for (ClassTarget preexist : pkg.getClassTargets()) {
                if (!preexist.getQualifiedName().equals(className)) continue;
                DialogManager.showMessageFX((Window)this, "import-class-exists", className);
                return;
            }
            File srcImage = ImportClassDialog.findImage(srcFile);
            File destImage = null;
            if (srcImage != null && (destImage = new File(new File(this.project.getProjectDir(), "images"), srcImage.getName())).exists()) {
                DialogManager.showMessageFX((Window)this, "import-image-exists", srcImage.getName());
                destImage = null;
            }
            File destFile = new File(this.project.getProjectDir(), srcFile.getName());
            GreenfootUtil.copyFile(srcFile, destFile);
            File libFolder = new File(srcFile.getParentFile(), className + "/lib");
            if (libFolder.exists() && libFolder.listFiles().length > 0) {
                for (File srcLibFile : libFolder.listFiles()) {
                    File destLibFile = new File(this.project.getProjectDir(), "+libs/" + srcLibFile.getName());
                    GreenfootUtil.copyFile(srcLibFile, destLibFile);
                }
                librariesImportedFlag = true;
            }
            pkg.reload();
            ClassTarget gclass = (ClassTarget)pkg.getTarget(className);
            if (gclass == null) {
                return;
            }
            LocalGClassNode gclassNode = this.classDiagram.addClass(gclass);
            if (srcImage != null && destImage != null && !destImage.exists()) {
                GreenfootUtil.copyFile(srcImage, destImage);
                this.setImageToClassNode(gclassNode, destImage);
            }
            pkg.compile(gclass, CompileReason.LOADED, CompileType.INDIRECT_USER_COMPILE);
            if (librariesImportedFlag) {
                this.project.restartVM();
            }
        }
    }

    public void newNonImageClass(Package pkg, String superClassName) {
        NewClassDialog dlg = new NewClassDialog((Window)this, this.project.getUnnamedPackage().getDefaultSourceType());
        dlg.showAndWait().ifPresent(result -> this.createNewClass(pkg, superClassName, result.className, result.sourceType, GreenfootStage.getNormalTemplateFileName(result.sourceType)));
    }

    private LocalGClassNode createNewClass(Package pkg, String superClassName, String className, SourceType language, String templateFileName) {
        try {
            File dir = this.project.getProjectDir();
            String extension = language.getExtension();
            File newFile = new File(dir, className + "." + extension);
            ProjectUtils.createSkeleton(className, superClassName, newFile, templateFileName, this.project.getProjectCharset().toString());
            ClassTarget newClass = pkg.addClass(className);
            pkg.compile(newClass, CompileReason.LOADED, CompileType.INDIRECT_USER_COMPILE);
            return this.classDiagram.addClass(newClass);
        }
        catch (IOException ioe) {
            Debug.reportError(ioe);
            return null;
        }
    }

    private static String getNormalTemplateFileName(SourceType language) {
        return "std" + language + ".tmpl";
    }

    public static String getActorTemplateFileName(SourceType language) {
        return "actor" + language + ".tmpl";
    }

    public static String getWorldTemplateFileName(boolean makeDirectSubclassOfWorld, SourceType language) {
        if (!makeDirectSubclassOfWorld) {
            return "subworld" + language + ".tmpl";
        }
        return "world" + language + ".tmpl";
    }

    public void newSubClassOf(String parentName, GClassDiagram.GClassType classType) {
        if (classType == GClassDiagram.GClassType.WORLD || classType == GClassDiagram.GClassType.ACTOR) {
            NewImageClassFrame frame = new NewImageClassFrame((Window)this, this.project);
            frame.showAndWait().ifPresent(classInfo -> {
                SourceType sourceType = classInfo.sourceType;
                String extendsName = parentName;
                if (extendsName.startsWith("greenfoot.")) {
                    extendsName = extendsName.substring("greenfoot.".length());
                }
                LocalGClassNode newClass = this.createNewClass(this.project.getUnnamedPackage(), extendsName, classInfo.className, sourceType, this.getTemplateFileName(classType, parentName, sourceType));
                File imageFile = classInfo.imageFile;
                if (imageFile != null) {
                    this.setImageToClassNode(newClass, imageFile);
                }
            });
        } else {
            ClassTarget classTarget = this.classDiagram.getSelectedClassTarget();
            Package pkg = classTarget.getPackage();
            this.newNonImageClass(pkg, parentName);
        }
    }

    private String getTemplateFileName(GClassDiagram.GClassType classType, String parentName, SourceType sourceType) {
        if (classType == GClassDiagram.GClassType.WORLD) {
            return GreenfootStage.getWorldTemplateFileName("greenfoot.World".equals(parentName), sourceType);
        }
        if (classType == GClassDiagram.GClassType.ACTOR) {
            return GreenfootStage.getActorTemplateFileName(sourceType);
        }
        throw new IllegalArgumentException("This method should be called only on World or Actor classes.");
    }

    private Reflective getActorReflective() {
        return new JavaReflective(this.project.loadClass("greenfoot.Actor"));
    }

    private Reflective getWorldReflective() {
        return new JavaReflective(this.project.loadClass("greenfoot.World"));
    }

    public void openGreenfootDocTab(String qualifiedClassName) {
        this.project.getDefaultFXTabbedEditor().openGreenfootDocTab(qualifiedClassName);
    }

    public void classModified() {
        this.discardWorld();
    }

    public static void aboutGreenfoot(Window parentWindow) {
        URL resource = Boot.class.getResource("gen-greenfoot-splash.png");
        Image image = new Image(resource.toString());
        String[] translatorNames = new String[]{"Arabic", "Hakim Hadjaissa", "Brazilian", "Herodoto Bento-DeMello", "Chinese", "Wobot Yuan and He Qing", "Czech", "Zden\u011bk Chalupsk\u00fd", "Dutch", "Erik van Veen and Renske Smetsers-Weeda", "French", "Guillaume Baudoin, Pierre Lefebvre and Denis Bureau", "German", "Matthias Taulien, Martin Schleyer, Stefan Mueller and Michael K\u00f6lling", "Greek", "Elevtherios Chrysochoidis and Dragon Turtle", "Indian", "Kiran Kumar D", "Italian", "Stefano Federici", "Korean", "John Kim", "Malayalam", "K.R.Arun", "Polish", "Przemys\u0142aw Adam \u015amiejek", "Portuguese", "Paulo Abadie and Fabio Hedayioglu", "Russian", "Sergey Zemlyannikov", "Spanish", "Jos\u00e9 Lerma, Esteban Manriquez, Kenneth Daly, Iris Gutierrez and Luis Mijangos", "Swedish", "Daniel Norrman"};
        String[] previousTeamMembers = new String[]{"Amjad Altadmri", "Michael Berry", "Hamza Hamza", "Fabio Hedayioglu", "Poul Henriksen", "Davin McCall", "Philip Stevens", "Ian Utting", "Marion Zalk"};
        new AboutDialogTemplate(parentWindow, Boot.GREENFOOT_VERSION, "https://greenfoot.org/", image, translatorNames, previousTeamMembers).showAndWait();
    }

    public static void closeAll() {
        String exists;
        ArrayList<GreenfootStage> stages_copy = new ArrayList<GreenfootStage>(stages);
        int i = 0;
        for (GreenfootStage stage : stages_copy) {
            if (stage.project == null) continue;
            Config.putPropString("bluej.openPackage" + ++i, stage.project.getProjectDir().getPath());
        }
        while ((exists = Config.removeProperty("bluej.openPackage" + ++i)) != null) {
        }
        for (GreenfootStage stage : stages_copy) {
            stage.doClose(true);
        }
    }

    public static GreenfootStage findStageForProject(Project project) {
        for (GreenfootStage stage : stages) {
            if (stage.project != project) continue;
            return stage;
        }
        return null;
    }

    public void bringTerminalToFront() {
        this.project.getTerminal().showHide(true);
        this.project.getTerminal().getWindow().toFront();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Stage getStage() {
        return this;
    }

    private void gotConstructionResult(final DebuggerObject result, InvokerRecord ir, JavaType[] paramTypes) {
        Reflective typeReflective = result.getGenType().getReflective();
        if (typeReflective != null) {
            Class<?> cl = this.project.loadClass(typeReflective.getName());
            typeReflective = cl != null ? new JavaReflective(cl) : null;
        }
        if (typeReflective != null && this.getActorReflective().isAssignableFrom(typeReflective)) {
            ImageView imageView = this.getImageViewForClass(typeReflective);
            if (imageView != null) {
                this.newActorProperty.set((Object)new NewActor(imageView, result, ir, paramTypes));
            }
        } else if (typeReflective != null && this.getWorldReflective().isAssignableFrom(typeReflective)) {
            String className = result.getGenType().getErasedType().toString();
            Target t = this.project.getTarget(className);
            if (t instanceof ClassTarget) {
                this.currentWorld = (ClassTarget)t;
            }
            new Thread("Setting constructed world"){

                @Override
                public void run() {
                    GreenfootStage.this.project.getDebugger().instantiateClass("greenfoot.core.SetWorldHelper", new String[]{"java.lang.Object"}, new DebuggerObject[]{result});
                    Platform.runLater(() -> GreenfootStage.this.saveTheWorldRecorder.recordingValid());
                }
            }.start();
        } else {
            this.project.getInspectorInstance(result, "<object>", this.project.getUnnamedPackage(), null, (Window)this, null);
        }
    }

    private void suggestTerminateIfAskingThenRun(FXPlatformRunnable runAfterward) {
        if (this.worldDisplay.isAsking()) {
            if (0 == DialogManager.askQuestionFX((Window)this, "terminate-for-reset")) {
                this.executeAfterTermination.add(runAfterward);
                this.project.restartVM();
            }
        } else {
            this.executeAfterReady.add(runAfterward);
        }
    }

    @Override
    public void callStaticMethodOrConstructor(CallableView cv) {
        this.suggestTerminateIfAskingThenRun(() -> this.callStaticMethodOrConstructorNowReady(cv));
    }

    private void callStaticMethodOrConstructorNowReady(final CallableView cv) {
        ResultWatcherBase watcher = null;
        Package pkg = this.project.getPackage("");
        if (cv instanceof ConstructorView) {
            Class<?> viewClass = cv.getDeclaringView().getViewClass();
            try {
                if (viewClass.getClassLoader().loadClass("greenfoot.World").isAssignableFrom(viewClass)) {
                    this.constructingWorld = true;
                    this.updateBackgroundMessage();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            watcher = new ResultWatcherBase(pkg, this, cv){

                @Override
                public void beginCompile() {
                    super.beginCompile();
                }

                @Override
                protected void nonNullResult(DebuggerObject result, String name, InvokerRecord ir) {
                    if (name == null || name.length() == 0) {
                        name = "result";
                    }
                    GreenfootStage.this.project.getTerminal().activate(false);
                    GreenfootStage.this.debugHandler.addObject(result, result.getGenType(), name);
                    GreenfootStage.this.project.getDebugger().addObject(GreenfootStage.this.project.getPackage("").getId(), name, result);
                    GreenfootStage.this.gotConstructionResult(result, ir, cv.getParamTypes(false));
                }

                @Override
                protected void addInteraction(InvokerRecord ir) {
                }

                @Override
                public void putException(ExceptionDescription exception, InvokerRecord ir) {
                    GreenfootStage.this.constructingWorld = false;
                    GreenfootStage.this.project.getTerminal().activate(false);
                    GreenfootStage.this.updateBackgroundMessage();
                    super.putException(exception, ir);
                }

                @Override
                public void putError(String msg, InvokerRecord ir) {
                    GreenfootStage.this.constructingWorld = false;
                    GreenfootStage.this.project.getTerminal().activate(false);
                    GreenfootStage.this.updateBackgroundMessage();
                    super.putError(msg, ir);
                }
            };
        } else if (cv instanceof MethodView) {
            watcher = new ResultWatcherBase(pkg, this, cv){

                @Override
                protected void addInteraction(InvokerRecord ir) {
                    GreenfootStage.this.project.getTerminal().activate(false);
                    GreenfootStage.this.saveTheWorldRecorder.callStaticMethod(cv.getClassName(), ((MethodView)cv).getMethod(), ir.getArgumentValues(), cv.getParamTypes(false));
                }
            };
        }
        if (ProjectUtils.checkDebuggerState(this.project, this)) {
            this.project.getTerminal().activate(true);
            new Invoker(this, pkg, cv, watcher, pkg.getCallHistory(), this.debugHandler, this.debugHandler, this.project.getDebugger(), null).invokeInteractive();
        }
    }

    public void doNewProject(SourceType sourceType) {
        String title = Config.getString("greenfoot.utilDelegate.newScenario") + " - " + sourceType;
        File newnameFile = FileUtility.getSaveProjectFX(this.project, (Window)this.getStage(), title);
        if (newnameFile == null) {
            return;
        }
        if (!this.newProject(newnameFile.getAbsolutePath(), sourceType)) {
            DialogManager.showErrorWithTextFX(null, "cannot-create-directory", newnameFile.getPath());
        }
    }

    public boolean newProject(String dirName, SourceType sourceType) {
        if (Project.createNewProject(dirName)) {
            Project proj = Project.openProject(dirName);
            if (proj != null) {
                Package unNamedPkg = proj.getUnnamedPackage();
                Properties props = new Properties(unNamedPkg.getLastSavedProperties());
                props.put("version", Boot.GREENFOOT_API_VERSION);
                unNamedPkg.save(props);
                ProjectManager.instance().launchProject(proj);
                GreenfootStage stage = GreenfootStage.findStageForProject(proj);
                LocalGClassNode worldClass = stage.createNewClass(unNamedPkg, "World", "MyWorld", sourceType, GreenfootStage.getWorldTemplateFileName(true, sourceType));
                stage.currentWorld = worldClass.getClassTarget();
                stage.toFront();
                return true;
            }
            DialogManager.showErrorFX((Window)this, "could-not-open-project");
            return false;
        }
        DialogManager.showErrorFX((Window)this, "cannot-create-project");
        return false;
    }

    public void setLastUserExecutionStartTime(long lastExecStartTime, boolean delayLoop) {
        this.lastExecStartTime = lastExecStartTime;
        if (lastExecStartTime == 0L) {
            this.executionTwirler.stopTwirling();
        } else {
            long duration = System.currentTimeMillis() - lastExecStartTime;
            if (duration < 4000L) {
                this.executionTwirler.stopTwirling();
                JavaFXUtil.runAfter(Duration.millis((double)(4000L - duration)), () -> {
                    if (this.lastExecStartTime == lastExecStartTime && !delayLoop) {
                        this.executionTwirler.startTwirling();
                    }
                });
            } else if (!delayLoop) {
                this.executionTwirler.startTwirling();
            }
        }
    }

    public void notifySimulationSpeed(int simSpeed) {
        this.settingSpeedFromSimulation = true;
        this.controlPanel.setSpeed(simSpeed);
        this.settingSpeedFromSimulation = false;
    }

    public void openReadme() {
        ReadmeTarget target = this.project.getUnnamedPackage().getReadmeTarget();
        if (target.getEditor() == null) {
            DialogManager.showErrorFX((Window)this, "error-open-readme");
        } else {
            target.getEditor().setEditorVisible(true, false);
        }
    }

    @Override
    public void setSpeedFromSlider(int newSpeed) {
        if (!this.settingSpeedFromSimulation) {
            this.lastUserSetSpeed = newSpeed;
            this.debugHandler.getVmComms().setSimulationSpeed(newSpeed);
        }
    }

    public void fireWorldRemovedCheck(ClassTarget classTarget) {
        if (classTarget.equals(this.currentWorld)) {
            this.currentWorld = null;
            this.worldVisible.set(false);
            this.doReset();
        } else {
            this.updateBackgroundMessage();
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void highlightObject(DebuggerObject currentObject) {
        GenTypeClass actorType = new GenTypeClass(new JavaReflective(Actor.class));
        if (currentObject != null && currentObject.getGenType() != null && ((JavaType)actorType).isAssignableFrom(currentObject.getGenType())) {
            Utility.runBackground(() -> {
                OptionalInt x = this.getIntegerField(currentObject, "greenfoot.Actor", "x");
                OptionalInt y = this.getIntegerField(currentObject, "greenfoot.Actor", "y");
                OptionalInt rotation = this.getIntegerField(currentObject, "greenfoot.Actor", "rotation");
                OptionalInt width = this.getIntegerField(currentObject, "greenfoot.Actor", "imageWidth");
                OptionalInt height = this.getIntegerField(currentObject, "greenfoot.Actor", "imageHeight");
                DebuggerObject world = GreenfootStage.getObjectField(currentObject, "greenfoot.Actor", "world");
                OptionalInt cellSize = this.getIntegerField(world, "greenfoot.World", "cellSize");
                if (x.isPresent() && y.isPresent() && width.isPresent() && height.isPresent() && rotation.isPresent() && cellSize.isPresent()) {
                    Platform.runLater(() -> this.worldDisplay.setActorHighlight(x.getAsInt() * cellSize.getAsInt() + cellSize.getAsInt() / 2, y.getAsInt() * cellSize.getAsInt() + cellSize.getAsInt() / 2, width.getAsInt(), height.getAsInt(), rotation.getAsInt()));
                }
            });
        } else {
            this.worldDisplay.clearActorHighlight();
        }
    }

    @OnThread(value=Tag.Any)
    private static DebuggerObject getObjectField(DebuggerObject currentObject, String className, String fieldName) {
        if (currentObject == null || currentObject.isNullObject()) {
            return null;
        }
        return currentObject.getFields().stream().filter(f -> f.getDeclaringClassName().equals(className) && f.getName().equals(fieldName)).map(f -> f.getValueObject()).findFirst().orElse(null);
    }

    @OnThread(value=Tag.Any)
    private OptionalInt getIntegerField(DebuggerObject currentObject, String className, String fieldName) {
        if (currentObject == null || currentObject.isNullObject()) {
            return OptionalInt.empty();
        }
        return currentObject.getFields().stream().filter(f -> f.getDeclaringClassName().equals(className) && f.getName().equals(fieldName)).mapToInt(f -> Integer.parseInt(f.getValueString())).findFirst();
    }

    public static Stage getOpenStage() {
        return stages.isEmpty() ? null : (Stage)stages.get(0);
    }

    private class RecordInvoke
    implements InvokeListener {
        private final DebuggerObject target;

        public RecordInvoke(DebuggerObject target) {
            this.target = target;
        }

        @Override
        public void executeMethod(final MethodView mv) {
            String objInstanceName = GreenfootStage.this.debugHandler.ensureObjectOnBench(this.target, this.target.getGenType()).getName();
            ResultWatcherBase watcher = new ResultWatcherBase(this.target, objInstanceName, GreenfootStage.this.project.getUnnamedPackage(), GreenfootStage.this, mv){

                @Override
                protected void addInteraction(InvokerRecord ir) {
                    GreenfootStage.this.saveTheWorldRecorder.callActorOrWorldMethod(RecordInvoke.this.target, mv.getMethod(), ir.getArgumentValues(), mv.getParamTypes(false));
                }
            };
            if (ProjectUtils.checkDebuggerState(GreenfootStage.this.project, GreenfootStage.this)) {
                Package unpkg = GreenfootStage.this.project.getPackage("");
                Invoker invoker = new Invoker(GreenfootStage.this, unpkg, mv, watcher, unpkg.getCallHistory(), GreenfootStage.this.debugHandler, GreenfootStage.this.debugHandler, GreenfootStage.this.project.getDebugger(), objInstanceName);
                invoker.invokeInteractive();
            }
        }

        @Override
        public void callConstructor(ConstructorView cv) {
        }
    }

    private static class NewActor {
        private final Region previewNode;
        private final BooleanProperty cannotDrop = new SimpleBooleanProperty(true);
        private final DebuggerObject actorObject;
        private final String typeName;
        private final InvokerRecord invokerRecord;
        private final JavaType[] paramTypes;

        private Region makePreviewNode(ImageView imageView, String invocation) {
            ImageView cannotDropIcon = new ImageView(this.getClass().getClassLoader().getResource("noParking.png").toExternalForm());
            cannotDropIcon.visibleProperty().bind((ObservableValue)this.cannotDrop);
            Text newLabel = new Text(invocation);
            newLabel.getStyleClass().add((Object)"actor-preview-text");
            StackPane.setAlignment((Node)newLabel, (Pos)Pos.TOP_CENTER);
            StackPane.setAlignment((Node)cannotDropIcon, (Pos)Pos.CENTER);
            StackPane stackPane = new StackPane(new Node[]{imageView, newLabel, cannotDropIcon});
            stackPane.setEffect((Effect)new DropShadow(10.0, 3.0, 3.0, Color.BLACK));
            stackPane.setCache(true);
            stackPane.setCacheShape(true);
            stackPane.setCacheHint(CacheHint.QUALITY);
            return stackPane;
        }

        public NewActor(ImageView imageView, DebuggerObject actorObject, InvokerRecord ir, JavaType[] paramTypes) {
            this.previewNode = this.makePreviewNode(imageView, "");
            this.actorObject = actorObject;
            this.invokerRecord = ir;
            this.paramTypes = paramTypes;
            this.typeName = null;
        }

        public NewActor(ImageView imageView, String typeName) {
            this.previewNode = this.makePreviewNode(imageView, "new " + typeName + "()");
            this.actorObject = null;
            this.invokerRecord = null;
            this.paramTypes = null;
            this.typeName = typeName;
        }
    }

    private static enum PickType {
        LEFT_CLICK,
        CONTEXT_MENU,
        DRAG;

    }

    public static enum State {
        RUNNING,
        RUNNING_REQUESTED_PAUSE,
        PAUSED,
        PAUSED_REQUESTED_ACT_OR_RUN,
        NO_WORLD,
        NO_PROJECT;

    }
}

