/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx;

import bluej.GuiHandler;
import bluej.Main;
import bluej.pkgmgr.Project;
import greenfoot.core.ProjectManager;
import greenfoot.guifx.GreenfootStage;
import java.io.File;
import javafx.stage.Stage;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class GreenfootGuiHandler
implements GuiHandler {
    @Override
    public boolean tryOpen(File path, boolean displayError) {
        Project project = Project.openProject(path.toString());
        if (project != null) {
            ProjectManager.instance().launchProject(project);
            return true;
        }
        return GreenfootStage.openArchive(path, null);
    }

    @Override
    public void handleAbout() {
        GreenfootStage.aboutGreenfoot(null);
    }

    @Override
    public void handlePreferences() {
        GreenfootStage.showPreferences();
    }

    @Override
    public void handleQuit() {
        Main.wantToQuit();
    }

    @Override
    public Stage initialOpenComplete(boolean projectOpen) {
        if (!projectOpen) {
            GreenfootStage stage = GreenfootStage.makeStage(null, null);
            stage.show();
            return stage;
        }
        return GreenfootStage.getOpenStage();
    }

    @Override
    public void doExitCleanup() {
        GreenfootStage.closeAll();
    }
}

