/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx;

import bluej.Config;
import bluej.pkgmgr.Project;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.JavaFXUtil;
import greenfoot.vmcomm.GreenfootDebugHandler;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.RotateTransition;
import javafx.animation.Timeline;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ExecutionTwirler
extends MenuButton {
    private final Animation animation;
    private Project project;
    private GreenfootDebugHandler greenfootDebugHandler;
    private FXPlatformConsumer<Boolean> twirlListener;

    public ExecutionTwirler(Project project, GreenfootDebugHandler greenfootDebugHandler) {
        this.project = project;
        this.greenfootDebugHandler = greenfootDebugHandler;
        ImageView imageView = new ImageView(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("swirl.png")));
        imageView.setFitHeight(15.0);
        imageView.setPreserveRatio(true);
        this.setGraphic((Node)imageView);
        RotateTransition rotateTransition = new RotateTransition(Duration.millis((double)3000.0), (Node)imageView);
        rotateTransition.setInterpolator(Interpolator.LINEAR);
        rotateTransition.setByAngle(360.0);
        rotateTransition.setCycleCount(-1);
        Timeline callTwirlListener = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), e -> {
            if (this.twirlListener != null) {
                this.twirlListener.accept(this.isVisible());
            }
        }, new KeyValue[0])});
        callTwirlListener.setCycleCount(-1);
        this.animation = new ParallelTransition(new Animation[]{rotateTransition, callTwirlListener});
        this.setVisible(false);
        this.setPopupSide(Side.BOTTOM);
        this.getItems().setAll((Object[])new MenuItem[]{JavaFXUtil.makeMenuItem(Config.getString("executionDisplay.restart"), () -> this.project.restartVM(), null), JavaFXUtil.makeMenuItem(Config.getString("executionDisplay.openDebugger"), () -> {
            this.project.getExecControls().show();
            this.greenfootDebugHandler.haltSimulationThread();
        }, null)});
    }

    public void setProject(Project project, GreenfootDebugHandler greenfootDebugHandler) {
        this.project = project;
        this.greenfootDebugHandler = greenfootDebugHandler;
    }

    public void startTwirling() {
        this.setVisible(true);
        this.animation.play();
    }

    public void stopTwirling() {
        this.setVisible(false);
        this.animation.stop();
        if (this.twirlListener != null) {
            this.twirlListener.accept(this.isVisible());
        }
    }

    public void setWhileTwirling(FXPlatformConsumer<Boolean> twirlListener) {
        this.twirlListener = twirlListener;
    }
}

