/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx;

import bluej.Config;
import bluej.utility.javafx.JavaFXUtil;
import greenfoot.guifx.GreenfootStage;
import java.util.Arrays;
import java.util.List;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.TilePane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ControlPanel
extends GridPane {
    private static final String PAUSE_BUTTON_TEXT = Config.getString("controls.pause.button");
    private static final String RUN_BUTTON_TEXT = Config.getString("controls.run.button");
    private static final String RUN_BUTTON_TOOLTIP_TEXT = Config.getString("controls.run.shortDescription");
    private static final String PAUSE_BUTTON_TOOLTIP_TEXT = Config.getString("controls.pause.shortDescription");
    private final Node run_icon = ControlPanel.makeRunIcon();
    private final Node pause_icon = ControlPanel.makePauseIcon();
    private final Node act_icon = ControlPanel.makeActIcon();
    private final Node reset_icon = ControlPanel.makeResetIcon();
    private final Button actButton;
    private final Button runPauseButton;
    private final Label speedLabel;
    private final Slider speedSlider;
    private final ControlPanelListener listener;
    private final BooleanProperty actDisabled = new SimpleBooleanProperty(true);
    private final BooleanProperty resetDisabled = new SimpleBooleanProperty(true);
    private final BooleanProperty runDisabled = new SimpleBooleanProperty(true);
    private final BooleanProperty pauseDisabled = new SimpleBooleanProperty(true);
    private final BooleanBinding runPauseDisabled = this.runDisabled.and((ObservableBooleanValue)this.pauseDisabled);

    public ControlPanel(ControlPanelListener listener, Node executionTwirler) {
        this.listener = listener;
        this.actButton = ControlPanel.unfocusableButton(Config.getString("run.once"));
        this.actButton.setTooltip(new Tooltip(Config.getString("controls.runonce.shortDescription")));
        this.actButton.setGraphic(this.act_icon);
        this.runPauseButton = ControlPanel.unfocusableButton(RUN_BUTTON_TEXT);
        this.runPauseButton.setGraphic(this.run_icon);
        this.runPauseButton.setTooltip(new Tooltip(RUN_BUTTON_TOOLTIP_TEXT));
        Button resetButton = ControlPanel.unfocusableButton(Config.getString("reset.world"));
        resetButton.setTooltip(new Tooltip(Config.getString("controls.reset.shortDescription")));
        resetButton.setGraphic(this.reset_icon);
        this.actButton.disableProperty().bind((ObservableValue)this.actDisabled);
        this.runPauseButton.disableProperty().bind((ObservableValue)this.runPauseDisabled);
        resetButton.disableProperty().bind((ObservableValue)this.resetDisabled);
        for (Button button : Arrays.asList(this.actButton, this.runPauseButton, resetButton)) {
            button.setMaxWidth(Double.MAX_VALUE);
        }
        int min = 0;
        int max = 100;
        this.speedSlider = new Slider(){

            @OnThread(value=Tag.FX)
            public void requestFocus() {
            }
        };
        this.speedSlider.setValue((double)(min + (max - min) / 2));
        this.speedSlider.setShowTickLabels(false);
        this.speedSlider.setShowTickMarks(true);
        this.speedSlider.setMin((double)min);
        this.speedSlider.setMax((double)max);
        this.speedSlider.setMajorTickUnit((double)(max / 2));
        this.speedSlider.setMinorTickCount(1);
        this.speedSlider.setBlockIncrement(20.0);
        this.speedSlider.setTooltip(new Tooltip(Config.getString("controls.speedSlider.tooltip")));
        this.speedSlider.setFocusTraversable(false);
        this.speedSlider.setMaxWidth(150.0);
        this.speedSlider.setDisable(true);
        this.actButton.setOnAction(e -> this.listener.act());
        this.runPauseButton.setOnAction(e -> this.listener.doRunPause());
        resetButton.setOnAction(e -> this.listener.userReset());
        JavaFXUtil.addChangeListenerPlatform(this.speedSlider.valueProperty(), newSpeed -> this.listener.setSpeedFromSlider(newSpeed.intValue()));
        TilePane controlPanel = new TilePane(new Node[]{this.actButton, this.runPauseButton, resetButton});
        controlPanel.setPrefColumns(3);
        controlPanel.getStyleClass().add((Object)"buttons-panel");
        controlPanel.setAlignment(Pos.CENTER);
        this.speedLabel = new Label(Config.getString("controls.speed.label"));
        this.speedLabel.setMinWidth(0.0);
        this.speedLabel.setDisable(true);
        this.add((Node)controlPanel, 0, 0);
        GridPane speedAndTwirler = new GridPane();
        speedAndTwirler.add((Node)this.speedLabel, 0, 0);
        speedAndTwirler.add((Node)this.speedSlider, 1, 0, 2, 1);
        if (executionTwirler != null) {
            speedAndTwirler.add(executionTwirler, 3, 0);
        }
        speedAndTwirler.getStyleClass().add((Object)"speed-panel");
        GridPane.setHalignment((Node)this.speedLabel, (HPos)HPos.RIGHT);
        GridPane.setValignment((Node)this.speedSlider, (VPos)VPos.BOTTOM);
        GridPane.setMargin((Node)this.speedSlider, (Insets)new Insets(8.0, 0.0, 0.0, 0.0));
        this.speedLabel.setAlignment(Pos.BASELINE_RIGHT);
        GridPane.setHgrow((Node)this.speedLabel, (Priority)Priority.ALWAYS);
        GridPane.setMargin((Node)speedAndTwirler, (Insets)new Insets(8.0, 8.0, 0.0, 0.0));
        this.add((Node)speedAndTwirler, 1, 0);
        GridPane.setHalignment((Node)speedAndTwirler, (HPos)HPos.CENTER);
        ColumnConstraints leftHalf = new ColumnConstraints();
        ColumnConstraints rightHalf = new ColumnConstraints();
        leftHalf.setPercentWidth(60.0);
        rightHalf.setPercentWidth(40.0);
        this.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{leftHalf, rightHalf});
        this.getStyleClass().add((Object)"control-panel");
    }

    private static Button unfocusableButton(String text) {
        return new Button(text){

            @OnThread(value=Tag.FX)
            public void requestFocus() {
            }
        };
    }

    public void updateState(GreenfootStage.State newState, boolean atBreakpoint) {
        boolean showingPause;
        this.actDisabled.setValue(Boolean.valueOf(newState != GreenfootStage.State.PAUSED || atBreakpoint));
        this.runDisabled.setValue(Boolean.valueOf(newState != GreenfootStage.State.PAUSED || atBreakpoint));
        this.pauseDisabled.setValue(Boolean.valueOf(newState != GreenfootStage.State.RUNNING || atBreakpoint));
        this.resetDisabled.setValue(Boolean.valueOf(newState == GreenfootStage.State.NO_PROJECT));
        this.speedSlider.setDisable(newState == GreenfootStage.State.NO_PROJECT);
        this.speedLabel.setDisable(newState == GreenfootStage.State.NO_PROJECT);
        boolean bl = showingPause = newState == GreenfootStage.State.RUNNING || newState == GreenfootStage.State.RUNNING_REQUESTED_PAUSE;
        if (showingPause) {
            if (!this.runPauseButton.getText().equals(PAUSE_BUTTON_TEXT)) {
                this.runPauseButton.setGraphic(this.pause_icon);
                this.runPauseButton.setText(PAUSE_BUTTON_TEXT);
                this.runPauseButton.setTooltip(new Tooltip(PAUSE_BUTTON_TOOLTIP_TEXT));
            }
        } else if (!this.runPauseButton.getText().equals(RUN_BUTTON_TEXT)) {
            this.runPauseButton.setGraphic(this.run_icon);
            this.runPauseButton.setText(RUN_BUTTON_TEXT);
            this.runPauseButton.setTooltip(new Tooltip(RUN_BUTTON_TOOLTIP_TEXT));
        }
    }

    public void setSpeed(int simSpeed) {
        this.speedSlider.setValue((double)simSpeed);
    }

    public void lockControls() {
        this.actButton.setVisible(false);
        this.speedSlider.setVisible(false);
        this.speedLabel.setVisible(false);
    }

    public List<MenuItem> makeMenuItems() {
        MenuItem[] menuItemArray = new MenuItem[4];
        menuItemArray[0] = JavaFXUtil.makeMenuItem("run.once", this.getIcon("step.png"), (KeyCombination)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.listener::act, (ObservableValue<Boolean>)this.actDisabled);
        menuItemArray[1] = JavaFXUtil.makeMenuItem("controls.run.button", this.getIcon("run.png"), (KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.listener::doRunPause, (ObservableValue<Boolean>)this.runDisabled);
        menuItemArray[2] = JavaFXUtil.makeMenuItem("controls.pause.button", this.getIcon("pause.png"), (KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}), this.listener::doRunPause, (ObservableValue<Boolean>)this.pauseDisabled);
        menuItemArray[3] = JavaFXUtil.makeMenuItem("reset.world", this.getIcon("reset.png"), (KeyCombination)new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.listener::userReset, (ObservableValue<Boolean>)this.resetDisabled);
        return Arrays.asList(menuItemArray);
    }

    private ImageView getIcon(String fileName) {
        return new ImageView(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName)));
    }

    @OnThread(value=Tag.FXPlatform)
    private static Node makeActIcon() {
        return (Node)JavaFXUtil.withStyleClass(new Polyline(new double[]{0.0, 0.0, 12.0, 5.0, 0.0, 10.0}), "act-icon");
    }

    @OnThread(value=Tag.FXPlatform)
    private static Node makeRunIcon() {
        return (Node)JavaFXUtil.withStyleClass(new Polygon(new double[]{0.0, 0.0, 12.0, 5.0, 0.0, 10.0}), "run-icon");
    }

    @OnThread(value=Tag.FXPlatform)
    private static Node makePauseIcon() {
        return (Node)JavaFXUtil.withStyleClass(new Path(new PathElement[]{new MoveTo(2.0, 0.0), new LineTo(2.0, 10.0), new MoveTo(8.0, 0.0), new LineTo(8.0, 10.0)}), "pause-icon");
    }

    @OnThread(value=Tag.FXPlatform)
    private static Node makeResetIcon() {
        Canvas canvas = new Canvas(15.0, 15.0);
        GraphicsContext g = canvas.getGraphicsContext2D();
        g.setStroke((Paint)Color.SADDLEBROWN);
        g.setLineWidth(2.0);
        g.setFill(null);
        int centreX = 7;
        int centreY = 7;
        g.arc((double)centreX, (double)centreY, 5.0, 5.0, 135.0, 260.0);
        g.stroke();
        double arcEndX = (double)centreX - 5.0 / Math.sqrt(2.0);
        double arcEndY = (double)centreY - 5.0 / Math.sqrt(2.0);
        int triangleHeading = 25;
        int arrowRadius = 4;
        g.setFill(g.getStroke());
        g.setStroke(null);
        g.fillPolygon(new double[]{(arcEndX += 1.0) + (double)arrowRadius * Math.cos(Math.toRadians(triangleHeading)), arcEndX + (double)arrowRadius * Math.cos(Math.toRadians(triangleHeading + 120)), arcEndX + (double)arrowRadius * Math.cos(Math.toRadians(triangleHeading + 240))}, new double[]{arcEndY - (double)arrowRadius * Math.sin(Math.toRadians(triangleHeading)), arcEndY - (double)arrowRadius * Math.sin(Math.toRadians(triangleHeading + 120)), arcEndY - (double)arrowRadius * Math.sin(Math.toRadians(triangleHeading + 240))}, 3);
        return canvas;
    }

    public static interface ControlPanelListener {
        public void act();

        public void doRunPause();

        public void userReset();

        public void setSpeedFromSlider(int var1);
    }
}

