/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.input;

import java.awt.Toolkit;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javafx.scene.input.KeyCode;
import threadchecker.OnThread;
import threadchecker.Tag;

public class KeyboardManager {
    private String lastKeyTyped;
    private final Set<String> keyLatched = new HashSet<String>();
    private final Set<String> keyDown = new HashSet<String>();
    private boolean hasNumLock = true;

    @OnThread(value=Tag.Simulation)
    public synchronized void clearLatchedKeys() {
        Iterator<String> i = this.keyLatched.iterator();
        while (i.hasNext()) {
            String keyCode = i.next();
            if (this.keyDown.contains(keyCode)) continue;
            i.remove();
        }
    }

    @OnThread(value=Tag.Simulation)
    public synchronized String getKey() {
        String r = this.lastKeyTyped;
        this.lastKeyTyped = null;
        return r;
    }

    @OnThread(value=Tag.Simulation)
    public synchronized boolean isKeyDown(String key) {
        boolean pressed = this.keyDown.contains(key = key.toLowerCase()) || this.keyLatched.contains(key);
        this.keyLatched.remove(key);
        return pressed;
    }

    public synchronized void keyPressed(KeyCode keyCode, String keyText) {
        String keyName = this.getKeyName(keyCode, keyText);
        this.keyLatched.add(keyName);
        this.keyDown.add(keyName);
    }

    public synchronized void keyReleased(KeyCode keyCode, String keyText) {
        String keyName = this.getKeyName(keyCode, keyText);
        this.keyDown.remove(keyName);
        this.lastKeyTyped = keyName;
    }

    private String getKeyName(KeyCode keycode, String keyText) {
        if (keycode.ordinal() >= KeyCode.NUMPAD0.ordinal() && keycode.ordinal() <= KeyCode.NUMPAD9.ordinal()) {
            return "" + (char)(48 + (keycode.ordinal() - KeyCode.NUMPAD0.ordinal()));
        }
        boolean numlock = true;
        if (this.hasNumLock) {
            try {
                numlock = Toolkit.getDefaultToolkit().getLockingKeyState(144);
            }
            catch (UnsupportedOperationException usoe) {
                this.hasNumLock = false;
            }
        }
        if (numlock) {
            if (keycode == KeyCode.KP_UP) {
                keycode = KeyCode.DIGIT8;
            } else if (keycode == KeyCode.KP_DOWN) {
                keycode = KeyCode.DIGIT2;
            } else if (keycode == KeyCode.KP_LEFT) {
                keycode = KeyCode.DIGIT4;
            } else if (keycode == KeyCode.KP_RIGHT) {
                keycode = KeyCode.DIGIT6;
            }
        } else if (keycode == KeyCode.KP_UP) {
            keycode = KeyCode.UP;
        } else if (keycode == KeyCode.KP_DOWN) {
            keycode = KeyCode.DOWN;
        } else if (keycode == KeyCode.KP_LEFT) {
            keycode = KeyCode.LEFT;
        } else if (keycode == KeyCode.KP_RIGHT) {
            keycode = KeyCode.RIGHT;
        }
        switch (keycode) {
            case ESCAPE: {
                return "escape";
            }
            case BACK_SPACE: {
                return "backspace";
            }
            case QUOTE: {
                return "'";
            }
            case CONTROL: {
                return "control";
            }
        }
        if (!keyText.isEmpty()) {
            switch (keyText) {
                case "\r": 
                case "\n": {
                    return "enter";
                }
                case "\t": {
                    return "tab";
                }
                case "\b": {
                    return "backspace";
                }
                case " ": {
                    return "space";
                }
                case "\u001b": {
                    return "escape";
                }
            }
            return keyText.toLowerCase();
        }
        return keycode.getName().toLowerCase();
    }

    public synchronized void keyTyped(KeyCode keyCode, String keyText) {
        String keyName = this.getKeyName(keyCode, keyText);
        if (!keyName.isEmpty() && !keyName.equals("undefined")) {
            this.lastKeyTyped = keyName;
        }
    }

    public void focusGained() {
    }

    public void focusLost() {
        this.releaseAllKeys();
    }

    private synchronized void releaseAllKeys() {
        this.keyDown.clear();
        this.keyLatched.clear();
    }
}

