/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export.mygame;

import bluej.utility.FXWorker;
import greenfoot.export.mygame.MyGameClient;
import greenfoot.export.mygame.ScenarioInfo;
import java.io.IOException;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class ExistingScenarioChecker {
    private FXWorker worker;
    private boolean checking = false;
    private boolean abort = false;
    private boolean finished = false;
    private volatile String hostName;
    private volatile String userName;
    private volatile String scenarioName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScenarioExistenceCheck(String hostName, String userName, String scenarioName) {
        ExistingScenarioChecker existingScenarioChecker = this;
        synchronized (existingScenarioChecker) {
            boolean sameScenario;
            boolean bl = sameScenario = hostName.equals(this.hostName) && userName.equals(this.userName) && scenarioName.equals(this.scenarioName);
            if (sameScenario) {
                return;
            }
            if (this.checking) {
                this.abort();
            }
            this.hostName = hostName;
            this.userName = userName;
            this.scenarioName = scenarioName;
            this.checking = true;
            this.abort = false;
            this.finished = false;
            this.worker = new ScenarioWorker();
            this.worker.start();
        }
    }

    public synchronized boolean abort() {
        if (this.finished) {
            return false;
        }
        if (!this.checking) {
            throw new IllegalStateException("Check not started yet. Nothing to abort.");
        }
        this.abort = true;
        this.worker.interrupt();
        return true;
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract void scenarioExistenceChecked(ScenarioInfo var1);

    @OnThread(value=Tag.FXPlatform)
    public abstract void scenarioExistenceCheckFailed(Exception var1);

    @OnThread(value=Tag.Worker)
    private Object checkExistence(String hostName, String userName, String scenarioName) {
        MyGameClient client = new MyGameClient(null);
        ScenarioInfo info = new ScenarioInfo();
        try {
            if (client.checkExistingScenario(hostName, userName, scenarioName, info)) {
                return info;
            }
            return null;
        }
        catch (IOException e) {
            return e;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private synchronized void workerFinished(Object value) {
        this.finished = true;
        this.checking = false;
        if (!this.abort) {
            if (value instanceof Exception) {
                this.scenarioExistenceCheckFailed((Exception)value);
            } else {
                this.scenarioExistenceChecked((ScenarioInfo)value);
            }
        }
    }

    class ScenarioWorker
    extends FXWorker {
        ScenarioWorker() {
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            return ExistingScenarioChecker.this.checkExistence(ExistingScenarioChecker.this.hostName, ExistingScenarioChecker.this.userName, ExistingScenarioChecker.this.scenarioName);
        }

        @Override
        public void finished() {
            ExistingScenarioChecker.this.workerFinished(this.getValue());
        }

        @Override
        public void abort() {
            ExistingScenarioChecker.this.abort();
        }
    }
}

