/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.runtime.ExecServer;
import bluej.utility.Debug;
import greenfoot.core.InternalGreenfootError;
import greenfoot.core.ShadowProjectProperties;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.event.SimulationListener;
import greenfoot.platforms.ide.ActorDelegateIDE;
import greenfoot.platforms.ide.WorldHandlerDelegateIDE;
import greenfoot.sound.SoundFactory;
import greenfoot.util.Version;
import greenfoot.vmcomm.VMCommsSimulation;
import java.awt.EventQueue;
import java.lang.reflect.Field;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GreenfootMain {
    private static Version version = null;
    private static GreenfootMain instance;
    private static ShadowProjectProperties projectProperties;

    @OnThread(value=Tag.Any)
    public static void initialize(String projDir, String shmFilePath, int shmFileSize, int seqStart) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        if (instance == null) {
            instance = new GreenfootMain(projDir, shmFilePath, shmFileSize, seqStart);
        }
    }

    public static GreenfootMain getInstance() {
        return instance;
    }

    private GreenfootMain(String projDir, final String shmFilePath, final int shmFileSize, final int seqStart) {
        instance = this;
        try {
            projectProperties = new ShadowProjectProperties();
            ActorDelegateIDE.setupAsActorDelegate(projectProperties);
            EventQueue.invokeLater(new Runnable(){

                @Override
                @OnThread(value=Tag.Swing, ignoreParent=true)
                public void run() {
                    new JFXPanel();
                    Platform.setImplicitExit((boolean)false);
                    final VMCommsSimulation vmComms = new VMCommsSimulation(projectProperties, shmFilePath, shmFileSize, seqStart);
                    WorldHandlerDelegateIDE worldHandlerDelegate = new WorldHandlerDelegateIDE(vmComms);
                    WorldHandler.initialise(worldHandlerDelegate);
                    WorldHandler worldHandler = WorldHandler.getInstance();
                    Simulation.initialize();
                    Simulation sim = Simulation.getInstance();
                    sim.addSimulationListener(new SimulationListener(){

                        @Override
                        @OnThread(value=Tag.Simulation)
                        public void simulationChangedSync(SimulationListener.SyncEvent e) {
                            if (e == SimulationListener.SyncEvent.NEW_ACT_ROUND || e == SimulationListener.SyncEvent.QUEUED_TASK_BEGIN) {
                                vmComms.userCodeStarting();
                            } else if (e == SimulationListener.SyncEvent.END_ACT_ROUND || e == SimulationListener.SyncEvent.QUEUED_TASK_END) {
                                vmComms.userCodeStopped(e == SimulationListener.SyncEvent.QUEUED_TASK_END);
                            } else if (e == SimulationListener.SyncEvent.DELAY_LOOP_ENTERED) {
                                vmComms.notifyDelayLoopEntered();
                            } else if (e == SimulationListener.SyncEvent.DELAY_LOOP_COMPLETED) {
                                vmComms.notifyDelayLoopCompleted();
                            }
                        }

                        @Override
                        @OnThread(value=Tag.Any)
                        public void simulationChangedAsync(SimulationListener.AsyncEvent e) {
                        }
                    });
                    sim.addSimulationListener(SoundFactory.getInstance().getSoundCollection());
                    Simulation.getInstance().setPaused(true);
                    sim.attachWorldHandler(worldHandler);
                    ExecServer.setCustomRunOnThread(r -> Simulation.getInstance().runLater(r::run));
                    vmComms.markVMReady();
                }
            });
        }
        catch (Exception exc) {
            Debug.reportError("could not create greenfoot main", exc);
        }
    }

    @OnThread(value=Tag.Any)
    public static Version getAPIVersion() {
        if (version == null) {
            try {
                Class<?> bootCls = Class.forName("bluej.Boot");
                Field field = bootCls.getField("GREENFOOT_API_VERSION");
                String versionStr = (String)field.get(null);
                version = new Version(versionStr);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                Debug.reportError("Could not get Greenfoot API version", e);
                throw new InternalGreenfootError(e);
            }
        }
        return version;
    }

    @OnThread(value=Tag.Any)
    public static String getPropString(String key, String defaultValue) {
        return projectProperties.getString(key, defaultValue);
    }

    public static class VersionCheckInfo {
        public final VersionInfo versionInfo;
        public final boolean removeAWTImports;

        public VersionCheckInfo(VersionInfo versionInfo, boolean removeAWTImports) {
            this.removeAWTImports = removeAWTImports;
            this.versionInfo = versionInfo;
        }
    }

    public static enum VersionInfo {
        VERSION_OK,
        VERSION_UPDATED,
        VERSION_BAD;

    }
}

