/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.BlueJPropStringSource;
import bluej.Config;
import bluej.utility.Debug;
import greenfoot.core.GreenfootMain;
import greenfoot.platforms.ide.GreenfootUtilDelegateIDE;
import greenfoot.util.GreenfootUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class GreenfootLauncherDebugVM {
    private static GreenfootLauncherDebugVM instance;
    private Object transportField;

    public GreenfootLauncherDebugVM(final String prjDir, final String libDirPath, final String userPrefDirPath, final String propsFilePath, final String shmFilePath, final String shmFileSize, final String seqStart) {
        instance = this;
        new Thread("Launching Greenfoot VM"){

            @Override
            public void run() {
                final Properties properties = new Properties();
                try {
                    properties.load(new FileInputStream(new File(propsFilePath)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Config.initializeVMside(new File(libDirPath), new File(userPrefDirPath), new BlueJPropStringSource(){

                    @Override
                    public String getBlueJPropertyString(String property, String def) {
                        return properties.getProperty(property, def);
                    }

                    @Override
                    public String getLabel(String key) {
                        return properties.getProperty(key, key);
                    }
                });
                Debug.setDebugStream(new PrintWriter(System.err));
                GreenfootUtil.initialise(GreenfootUtilDelegateIDE.getInstance());
                GreenfootMain.initialize(prjDir, shmFilePath, Integer.parseInt(shmFileSize), Integer.parseInt(seqStart));
            }
        }.start();
    }

    public static GreenfootLauncherDebugVM getInstance() {
        return instance;
    }

    public void setTransportField(Object transportField) {
        this.transportField = transportField;
    }
}

