/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.core.Simulation;
import greenfoot.util.GreenfootUtil;
import java.util.List;
import junit.framework.TestCase;

public class SubClassTests
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        GreenfootUtil.initialise(new TestUtilDelegate());
        Simulation.initialize();
    }

    public void testHierarchy() {
        World world = WorldCreator.createWorld(10, 10, 10);
        SuperClass superObj = new SuperClass(20, 20);
        world.addObject(superObj, 2, 2);
        SubClass subObj = new SubClass(10, 10);
        world.addObject(subObj, 2, 2);
        IndependentClass indepObj = new IndependentClass(10, 10);
        world.addObject(indepObj, 2, 2);
        List res = indepObj.getIntersectingObjectsP(SuperClass.class);
        SubClassTests.assertEquals(2, res.size());
        res = indepObj.getIntersectingObjectsP(SubClass.class);
        SubClassTests.assertEquals(1, res.size());
        res = indepObj.getIntersectingObjectsP(SuperClass.class);
        SubClassTests.assertEquals(2, res.size());
    }

    public void testHierarchy2() {
        World world = WorldCreator.createWorld(10, 10, 10);
        SuperClass superObj = new SuperClass(20, 20);
        world.addObject(superObj, 2, 2);
        SubClass subObj = new SubClass(10, 10);
        world.addObject(subObj, 2, 2);
        IndependentClass indepObj = new IndependentClass(10, 10);
        world.addObject(indepObj, 2, 2);
        List res = superObj.getIntersectingObjectsP(IndependentClass.class);
        SubClassTests.assertEquals(1, res.size());
        res = indepObj.getIntersectingObjectsP(SuperClass.class);
        SubClassTests.assertEquals(2, res.size());
    }

    public void testSubSubClassing() {
        World world = WorldCreator.createWorld(10, 10, 10);
        SuperClass superObj = new SuperClass(20, 20);
        world.addObject(superObj, 2, 2);
        SubSubClass subSubObj = new SubSubClass(10, 10);
        world.addObject(subSubObj, 2, 2);
        IndependentClass indepObj = new IndependentClass(10, 10);
        world.addObject(indepObj, 2, 2);
        List res = superObj.getIntersectingObjectsP(IndependentClass.class);
        SubClassTests.assertEquals(1, res.size());
        res = indepObj.getIntersectingObjectsP(SubClass.class);
        SubClassTests.assertEquals(1, res.size());
        res = indepObj.getIntersectingObjectsP(SuperClass.class);
        SubClassTests.assertEquals(2, res.size());
    }

    class IndependentClass
    extends TestObject {
        public IndependentClass(int w, int h) {
            super(w, h);
        }
    }

    class SubSubClass
    extends SubClass {
        public SubSubClass(int w, int h) {
            super(w, h);
        }
    }

    class SubClass
    extends SuperClass {
        public SubClass(int w, int h) {
            super(w, h);
        }
    }

    class SuperClass
    extends TestObject {
        public SuperClass(int w, int h) {
            super(w, h);
        }
    }
}

