/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.util.GreenfootUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;

public class NeighbourTest
extends TestCase {
    private World world;

    @Override
    protected void setUp() throws Exception {
        GreenfootUtil.initialise(new TestUtilDelegate());
        Simulation.initialize();
    }

    public void testNoWrapDiagonal() {
        int d = 2;
        this.world = WorldCreator.createWorld(10, 10, 10);
        WorldHandler.initialise();
        WorldHandler.getInstance().setWorld(this.world, false);
        int xStart = 9;
        int yStart = 9;
        TestObject me = new TestObject();
        this.world.addObject(me, xStart, yStart);
        Collection neighbours = this.createNeigboursWithDiagonal(xStart, yStart, d);
        List c = me.getNeighboursP(d, true, TestObject.class);
        NeighbourTest.assertEquals(8, c.size());
        NeighbourTest.assertTrue(c.containsAll(neighbours));
        this.world = WorldCreator.createWorld(10, 10, 10);
        xStart = 0;
        yStart = 0;
        this.world.addObject(me, xStart, yStart);
        neighbours = this.createNeigboursWithDiagonal(xStart, yStart, d);
        c = me.getNeighboursP(d, true, TestObject.class);
        NeighbourTest.assertEquals(8, c.size());
        NeighbourTest.assertTrue(c.containsAll(neighbours));
    }

    private Collection createNeigboursWithDiagonal(int xStart, int yStart, int d) {
        for (int x = 0; x < this.world.getWidth(); ++x) {
            for (int y = 0; y < this.world.getHeight(); ++y) {
                TestObject actor = new TestObject();
                this.world.addObject(actor, x, y);
            }
        }
        ArrayList<TestObject> neighbours = new ArrayList<TestObject>();
        for (int x = xStart - d; x <= xStart + d; ++x) {
            for (int y = yStart - d; y <= yStart + d; ++y) {
                if (x < 0 || y < 0 || x >= this.world.getWidth() || y >= this.world.getHeight()) continue;
                List<TestObject> remove = this.world.getObjectsAt(x, y, TestObject.class);
                for (TestObject element : remove) {
                    if (x == xStart && y == yStart) continue;
                    neighbours.add(element);
                }
            }
        }
        return neighbours;
    }
}

