/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.util.GreenfootUtil;
import java.util.List;
import junit.framework.TestCase;

public class IntersectionTest
extends TestCase {
    private World world;

    @Override
    protected void setUp() throws Exception {
        GreenfootUtil.initialise(new TestUtilDelegate());
        Simulation.initialize();
    }

    public void testIntersectingSingleCell() {
        this.world = WorldCreator.createWorld(10, 10, 10);
        TestObject o1 = new TestObject(10, 10);
        this.world.addObject(o1, 2, 2);
        TestObject o2 = new TestObject(10, 10);
        this.world.addObject(o2, 2, 2);
        IntersectionTest.assertTrue(o1.intersectsP(o2));
        IntersectionTest.assertTrue(o2.intersectsP(o1));
        List c = o1.getIntersectingObjectsP(TestObject.class);
        IntersectionTest.assertTrue(c.contains(o2));
        IntersectionTest.assertEquals(1, c.size());
        o2.setLocation(3, 2);
        IntersectionTest.assertFalse(o1.intersectsP(o2));
        IntersectionTest.assertFalse(o2.intersectsP(o1));
    }

    public void testIntersectingPixelLevelOdd() {
        this.world = WorldCreator.createWorld(70, 70, 1);
        WorldHandler.initialise();
        WorldHandler.getInstance().setWorld(this.world, false);
        TestObject o1 = new TestObject(7, 7);
        this.world.addObject(o1, 0, 0);
        TestObject o2 = new TestObject(7, 7);
        this.world.addObject(o2, 6, 6);
        IntersectionTest.assertTrue(o1.intersectsP(o2));
        IntersectionTest.assertTrue(o2.intersectsP(o1));
        List c = o1.getIntersectingObjectsP(TestObject.class);
        IntersectionTest.assertTrue(c.contains(o2));
        IntersectionTest.assertEquals(1, c.size());
        o2.setLocation(7, 7);
        IntersectionTest.assertFalse(o1.intersectsP(o2));
        IntersectionTest.assertFalse(o2.intersectsP(o1));
    }

    public void testIntersectingPixelLevelEven() {
        this.world = WorldCreator.createWorld(80, 80, 1);
        TestObject o1 = new TestObject(8, 8);
        this.world.addObject(o1, 0, 0);
        TestObject o2 = new TestObject(8, 8);
        this.world.addObject(o2, 7, 7);
        IntersectionTest.assertTrue(o1.intersectsP(o2));
        IntersectionTest.assertTrue(o2.intersectsP(o1));
        List c = o1.getIntersectingObjectsP(TestObject.class);
        IntersectionTest.assertTrue(c.contains(o2));
        IntersectionTest.assertEquals(1, c.size());
        o2.setLocation(8, 8);
        IntersectionTest.assertFalse(o1.intersectsP(o2));
        IntersectionTest.assertFalse(o2.intersectsP(o1));
        o2.setLocation(9, 9);
        IntersectionTest.assertFalse(o1.intersectsP(o2));
        IntersectionTest.assertFalse(o2.intersectsP(o1));
    }

    public void testRotationIntersection45() {
        this.world = WorldCreator.createWorld(200, 200, 1);
        TestObject o1 = new TestObject(50, 50);
        this.world.addObject(o1, 0, 0);
        TestObject o2 = new TestObject(50, 50);
        this.world.addObject(o2, 55, 0);
        IntersectionTest.assertNull(o2.getOneIntersectingObjectP(TestObject.class));
        o2.setRotation(45);
        IntersectionTest.assertEquals(o1, o2.getOneIntersectingObjectP(TestObject.class));
        o2.setLocation(55, 55);
        IntersectionTest.assertNull(o2.getOneIntersectingObjectP(TestObject.class));
        o1.setRotation(45);
        IntersectionTest.assertNull(o2.getOneIntersectingObjectP(TestObject.class));
    }

    public void testRotationIntersection90() {
        this.world = WorldCreator.createWorld(200, 200, 1);
        TestObject o1 = new TestObject(100, 10);
        this.world.addObject(o1, 0, 0);
        TestObject o2 = new TestObject(10, 10);
        this.world.addObject(o2, 0, 40);
        IntersectionTest.assertNull(o2.getOneIntersectingObjectP(TestObject.class));
        o1.setRotation(90);
        IntersectionTest.assertEquals(o1, o2.getOneIntersectingObjectP(TestObject.class));
    }

    public void testRotationIntersectionBoth() {
        this.world = WorldCreator.createWorld(100, 100, 1);
        TestObject actor1 = new TestObject(3, 3);
        TestObject actor2 = new TestObject(3, 3);
        int xoffs = 2;
        int yoffs = 0;
        for (int rot = 0; rot < 360; rot += 90) {
            actor1.setRotation(rot);
            actor2.setRotation(rot);
            this.world.addObject(actor1, 50, 50);
            this.world.addObject(actor2, 50 + xoffs, 50 + yoffs);
            IntersectionTest.assertTrue(actor2.isTouchingP(TestObject.class));
            int pyoffs = yoffs;
            yoffs = xoffs;
            xoffs = -pyoffs;
            this.world.removeObject(actor1);
            this.world.removeObject(actor2);
        }
    }

    public void testIntersectionSmallObject() {
        this.world = WorldCreator.createWorld(200, 200, 1);
        TestObject o1 = new TestObject(100, 100);
        this.world.addObject(o1, 55, 55);
        TestObject o2 = new TestObject(1, 1);
        o2.setRotation(45);
        this.world.addObject(o2, 56, 56);
        IntersectionTest.assertNotNull(o2.getOneIntersectingObjectP(TestObject.class));
        o1.setRotation(45);
        o2.setLocation(100, 100);
        IntersectionTest.assertNull(o2.getOneIntersectingObjectP(TestObject.class));
    }
}

