/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.GreenfootImage;
import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.core.Simulation;
import greenfoot.util.GreenfootUtil;
import java.util.List;
import junit.framework.TestCase;

public class GetAtTest
extends TestCase {
    private World world;

    @Override
    protected void setUp() throws Exception {
        GreenfootUtil.initialise(new TestUtilDelegate());
        Simulation.initialize();
    }

    public void testPixelOdd() {
        this.world = WorldCreator.createWorld(100, 100, 1);
        TestObject actor1 = new TestObject(21, 21);
        this.world.addObject(actor1, 50, 50);
        List<TestObject> result = this.world.getObjectsAt(50, 50, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor1));
        result = this.world.getObjectsAt(60, 60, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor1));
        result = this.world.getObjectsAt(40, 40, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor1));
        result = this.world.getObjectsAt(39, 39, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor1));
        result = this.world.getObjectsAt(61, 61, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor1));
    }

    public void testPixelEven() {
        this.world = WorldCreator.createWorld(100, 100, 1);
        TestObject actor1 = new TestObject(20, 20);
        this.world.addObject(actor1, 50, 50);
        List<TestObject> result = this.world.getObjectsAt(50, 50, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor1));
        result = this.world.getObjectsAt(59, 59, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor1));
        result = this.world.getObjectsAt(40, 40, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor1));
        result = this.world.getObjectsAt(39, 39, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor1));
        result = this.world.getObjectsAt(60, 60, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor1));
    }

    public void testRotation() {
        this.world = WorldCreator.createWorld(100, 100, 1);
        TestObject actor1 = new TestObject(40, 20);
        this.world.addObject(actor1, 50, 50);
        List<TestObject> result = this.world.getObjectsAt(30, 40, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor1));
        result = this.world.getObjectsAt(69, 59, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor1));
        actor1.setRotation(90);
        result = this.world.getObjectsAt(42, 32, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor1));
        result = this.world.getObjectsAt(57, 67, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor1));
    }

    public void testRotation2() {
        this.world = WorldCreator.createWorld(10, 10, 50);
        TestObject actor1 = new TestObject(50, 50);
        this.world.addObject(actor1, 0, 0);
        TestObject actor2 = new TestObject(50, 50);
        this.world.addObject(actor2, 5, 0);
        actor2.setRotation(45);
        List<TestObject> result = this.world.getObjectsAt(5, 0, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor2));
        result = this.world.getObjectsAt(6, 0, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor2));
        result = this.world.getObjectsAt(5, 1, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor2));
        result = this.world.getObjectsAt(4, 0, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor2));
    }

    public void testRotation3() {
        this.world = WorldCreator.createWorld(10, 10, 50);
        TestObject actor1 = new TestObject(50, 50);
        this.world.addObject(actor1, 0, 0);
        TestObject actor2 = new TestObject(50, 50);
        actor2.setRotation(45);
        this.world.addObject(actor2, 5, 0);
        List<TestObject> result = this.world.getObjectsAt(5, 0, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor2));
        result = this.world.getObjectsAt(6, 0, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor2));
        result = this.world.getObjectsAt(5, 1, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor2));
        result = this.world.getObjectsAt(4, 0, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor2));
    }

    public void testBigCells() {
        this.world = WorldCreator.createWorld(10, 10, 50);
        TestObject actor1 = new TestObject(50, 50);
        this.world.addObject(actor1, 1, 1);
        List<TestObject> result = this.world.getObjectsAt(1, 1, TestObject.class);
        GetAtTest.assertTrue(result.contains(actor1));
        result = this.world.getObjectsAt(0, 0, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor1));
        result = this.world.getObjectsAt(0, 1, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor1));
        result = this.world.getObjectsAt(1, 0, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor1));
        result = this.world.getObjectsAt(2, 2, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor1));
        result = this.world.getObjectsAt(1, 2, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor1));
        result = this.world.getObjectsAt(2, 1, TestObject.class);
        GetAtTest.assertFalse(result.contains(actor1));
    }

    public void testMovement() {
        this.world = WorldCreator.createWorld(10, 10, 50);
        TestObject actor1 = new TestObject(8, 8);
        TestObject actor2 = new TestObject(8, 8);
        TestObject actor3 = new TestObject(8, 8);
        TestObject actor4 = new TestObject(8, 8);
        this.world.addObject(actor1, 0, 0);
        this.world.addObject(actor2, 9, 0);
        this.world.addObject(actor3, 0, 9);
        this.world.addObject(actor4, 9, 9);
        GetAtTest.assertSame(actor1.getOneObjectAtP(9, 0, TestObject.class), actor2);
        GetAtTest.assertSame(actor1.getOneObjectAtP(0, 9, TestObject.class), actor3);
        GetAtTest.assertSame(actor1.getOneObjectAtP(9, 9, TestObject.class), actor4);
        GetAtTest.assertSame(actor2.getOneObjectAtP(-9, 0, TestObject.class), actor1);
        actor1.setLocation(1, 1);
        actor4.setLocation(8, 8);
        GetAtTest.assertSame(actor1.getOneObjectAtP(8, -1, TestObject.class), actor2);
        GetAtTest.assertSame(actor1.getOneObjectAtP(-1, 8, TestObject.class), actor3);
        GetAtTest.assertSame(actor1.getOneObjectAtP(7, 7, TestObject.class), actor4);
        GetAtTest.assertSame(actor2.getOneObjectAtP(-8, 1, TestObject.class), actor1);
        this.world.removeObjects(this.world.getObjects(null));
        this.world.addObject(actor1, 0, 0);
        this.world.addObject(actor2, 9, 0);
        this.world.addObject(actor3, 0, 9);
        this.world.addObject(actor4, 9, 9);
        GetAtTest.assertSame(actor1.getOneObjectAtP(9, 0, TestObject.class), actor2);
        GetAtTest.assertSame(actor1.getOneObjectAtP(0, 9, TestObject.class), actor3);
        GetAtTest.assertSame(actor1.getOneObjectAtP(9, 9, TestObject.class), actor4);
        GetAtTest.assertSame(actor2.getOneObjectAtP(-9, 0, TestObject.class), actor1);
    }

    public void testResize() {
        this.world = WorldCreator.createWorld(10, 10, 60);
        TestObject wombat = new TestObject(58, 45);
        this.world.addObject(wombat, 4, 7);
        class BadLeaf
        extends TestObject {
            public BadLeaf() {
                super(512, 433);
            }

            @Override
            protected void addedToWorld(World world) {
                GreenfootImage myImage = this.getImage();
                myImage.scale(60, 60);
                this.setImage(new GreenfootImage(60, 60));
                this.getOneObjectAtOffset(0, 0, TestObject.class);
            }
        }
        this.world.addObject(new BadLeaf(), 3, 5);
        this.world.addObject(new BadLeaf(), 2, 9);
        GetAtTest.assertNull(wombat.getOneObjectAtP(1, 0, TestObject.class));
    }
}

