/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.Actor;
import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.core.Simulation;
import greenfoot.util.GreenfootUtil;
import java.util.List;
import junit.framework.TestCase;

public class CommonTest
extends TestCase {
    private World world;
    private TestObject obj1;

    @Override
    protected void setUp() {
        GreenfootUtil.initialise(new TestUtilDelegate());
        Simulation.initialize();
        this.world = WorldCreator.createWorld(10, 10, 10);
        this.obj1 = new TestObject(10, 10);
        this.world.addObject(this.obj1, 0, 0);
    }

    public void testNullClass() {
        boolean gotException = false;
        try {
            this.world.getObjectsAt(0, 0, null);
            this.obj1.getIntersectingObjectsP(null);
            this.obj1.getNeighboursP(1, true, null);
            this.obj1.getNeighboursP(1, false, null);
            this.obj1.getObjectsAtP(5, 5, null);
            this.obj1.getObjectsInRangeP(1, null);
            this.obj1.getOneIntersectingObjectP(null);
            this.obj1.getOneObjectAtP(0, 0, null);
        }
        catch (NullPointerException npe) {
            gotException = true;
            npe.printStackTrace();
        }
        CommonTest.assertFalse(gotException);
    }

    public void testSelfInclusion() {
        this.world.getObjectsAt(0, 0, TestObject.class);
        List l = this.obj1.getIntersectingObjectsP(TestObject.class);
        CommonTest.assertFalse(l.contains(this.obj1));
        l = this.obj1.getNeighboursP(1, true, TestObject.class);
        CommonTest.assertFalse(l.contains(this.obj1));
        l = this.obj1.getNeighboursP(1, false, TestObject.class);
        CommonTest.assertFalse(l.contains(this.obj1));
        l = this.obj1.getObjectsAtP(5, 5, TestObject.class);
        CommonTest.assertFalse(l.contains(this.obj1));
        l = this.obj1.getObjectsInRangeP(1, TestObject.class);
        CommonTest.assertFalse(l.contains(this.obj1));
        Actor o = this.obj1.getOneIntersectingObjectP(TestObject.class);
        CommonTest.assertNotSame(this.obj1, o);
        o = this.obj1.getOneObjectAtP(0, 0, TestObject.class);
        CommonTest.assertNotSame(this.obj1, o);
    }
}

