/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.MouseInfo;
import greenfoot.World;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.sound.MicLevelGrabber;
import greenfoot.sound.Sound;
import greenfoot.sound.SoundFactory;
import java.util.Random;

public class Greenfoot {
    private static Random randomGenerator = new Random();

    public static void setWorld(World world) {
        if (world == null) {
            throw new NullPointerException("The given world cannot be null.");
        }
        WorldHandler.getInstance().setWorld(world, true);
    }

    public static String getKey() {
        return WorldHandler.getInstance().getKeyboardManager().getKey();
    }

    public static boolean isKeyDown(String keyName) {
        return WorldHandler.getInstance().getKeyboardManager().isKeyDown(keyName);
    }

    public static void delay(int time) {
        Simulation.getInstance().sleep(time);
    }

    public static void setSpeed(int speed) {
        Simulation.getInstance().setSpeed(speed);
    }

    public static void stop() {
        Simulation.getInstance().setPaused(true);
    }

    public static void start() {
        Simulation.getInstance().setPaused(false);
    }

    public static int getRandomNumber(int limit) {
        return randomGenerator.nextInt(limit);
    }

    public static void playSound(String soundFile) {
        Sound sound = SoundFactory.getInstance().createSound(soundFile, false);
        if (sound != null) {
            sound.play();
        }
    }

    public static boolean mousePressed(Object obj) {
        return WorldHandler.getInstance().getMouseManager().isMousePressed(obj);
    }

    public static boolean mouseClicked(Object obj) {
        return WorldHandler.getInstance().getMouseManager().isMouseClicked(obj);
    }

    public static boolean mouseDragged(Object obj) {
        return WorldHandler.getInstance().getMouseManager().isMouseDragged(obj);
    }

    public static boolean mouseDragEnded(Object obj) {
        return WorldHandler.getInstance().getMouseManager().isMouseDragEnded(obj);
    }

    public static boolean mouseMoved(Object obj) {
        return WorldHandler.getInstance().getMouseManager().isMouseMoved(obj);
    }

    public static MouseInfo getMouseInfo() {
        return WorldHandler.getInstance().getMouseManager().getMouseInfo();
    }

    public static int getMicLevel() {
        return MicLevelGrabber.getInstance().getLevel();
    }

    public static String ask(String prompt) {
        return WorldHandler.getInstance().ask(prompt);
    }
}

