/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.GreenfootImage;
import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.collision.ibsp.Rect;
import greenfoot.core.Simulation;
import greenfoot.util.GreenfootUtil;
import junit.framework.TestCase;

public class ActorTest
extends TestCase {
    private World world;

    @Override
    protected void setUp() throws Exception {
        GreenfootUtil.initialise(new TestUtilDelegate());
        Simulation.initialize();
    }

    public void testNoImage() {
        this.world = WorldCreator.createWorld(10, 10, 10);
        TestObject o = new TestObject(11, 31);
        o.setImage((GreenfootImage)null);
        this.world.addObject(o, 0, 0);
        ActorTest.assertNull(o.getImage());
    }

    public void testRotatedSizeSmall() {
        this.world = WorldCreator.createWorld(100, 100, 1);
        TestObject o = new TestObject(20, 20);
        this.world.addObject(o, 0, 0);
        o.setRotation(45);
        Rect r = o.getBoundingRect();
        ActorTest.assertTrue(r.getWidth() >= 28 && r.getWidth() <= 29);
        ActorTest.assertTrue(r.getHeight() >= 28 && r.getWidth() <= 29);
    }

    public void testOutOfBounds() {
        this.world = WorldCreator.createWorld(10, 10, 10);
        TestObject o = new TestObject(11, 31);
        int x = 2;
        int y = 3;
        this.world.addObject(o, x, y);
        IndexOutOfBoundsException exception = null;
        try {
            o.setLocation(11, 11);
        }
        catch (IndexOutOfBoundsException e) {
            exception = e;
        }
        ActorTest.assertNull(exception);
        ActorTest.assertEquals(9, o.getX());
        ActorTest.assertEquals(9, o.getY());
    }

    public void testRotationCenter() {
        this.world = WorldCreator.createWorld(700, 480, 1);
        TestObject o = new TestObject(1, 1);
        o.setRotation(-173);
        this.world.addObject(o, 0, 0);
        o.setLocation(0, 0);
        Rect rect = o.getBoundingRect();
        ActorTest.assertEquals(-1, rect.getX());
        ActorTest.assertEquals(-1, rect.getY());
        ActorTest.assertEquals(2, rect.getTop());
        ActorTest.assertEquals(2, rect.getRight());
    }
}

