/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.slots.EditableSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.MultiListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContextMenu;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class FrameSelection {
    private final @OnThread(value=Tag.FXPlatform) ObservableList<Frame> selection = FXCollections.observableList(new ArrayList());
    private final Canvas selectionHighlight = new Canvas();
    private final InteractionManager editor;
    private boolean deletePreview;
    private boolean pullUpPreview;

    @OnThread(value=Tag.FX)
    public FrameSelection(InteractionManager editor) {
        this.editor = editor;
        this.selectionHighlight.setMouseTransparent(true);
        this.deletePreview = false;
        this.pullUpPreview = false;
        Function<Frame, MultiListener.RemoveAndUpdate> removeAndUpdate = f -> {
            FXRunnable removeA = JavaFXUtil.addChangeListener((ObservableValue)f.getNode().localToSceneTransformProperty(), x -> JavaFXUtil.runNowOrLater(() -> this.redraw()));
            FXRunnable removeB = JavaFXUtil.addChangeListener((ObservableValue)f.getNode().boundsInLocalProperty(), x -> JavaFXUtil.runNowOrLater(() -> this.redraw()));
            return () -> ((FXRunnable)JavaFXUtil.sequence((FXRunnable[])new FXRunnable[]{removeA, removeB})).run();
        };
        MultiListener positionListener = new MultiListener(removeAndUpdate);
        this.addChangeListener(() -> {
            this.redraw();
            positionListener.listenOnlyTo(this.selection.stream());
        });
    }

    @OnThread(value=Tag.FXPlatform)
    private void redraw() {
        this.editor.getCodeOverlayPane().removeOverlay((Node)this.selectionHighlight);
        if (!this.selection.isEmpty()) {
            this.editor.getCodeOverlayPane().addOverlay((Node)this.selectionHighlight, ((Frame)this.selection.get(0)).getNode(), null, null);
            Node topNode = ((Frame)this.selection.get(0)).getNode();
            Node bottomNode = ((Frame)this.selection.get(this.selection.size() - 1)).getNode();
            this.selectionHighlight.setWidth(topNode.getBoundsInParent().getWidth());
            this.selectionHighlight.setHeight(bottomNode.getBoundsInParent().getMinY() + bottomNode.getLayoutBounds().getHeight() - topNode.getBoundsInParent().getMinY());
            GraphicsContext gc = this.selectionHighlight.getGraphicsContext2D();
            gc.clearRect(0.0, 0.0, this.selectionHighlight.getWidth(), this.selectionHighlight.getHeight());
            if (this.deletePreview || this.pullUpPreview) {
                gc.setFill((Paint)new Color(1.0, 0.4, 0.4, 0.7));
                if (this.pullUpPreview) {
                    gc.setFillRule(FillRule.EVEN_ODD);
                    for (Frame f : this.selection) {
                        gc.beginPath();
                        this.roundedRectPath(gc, 0.5, 0.5, this.selectionHighlight.getWidth() - 1.0, this.selectionHighlight.getHeight() - 1.0, 7.0);
                        for (FrameCanvas c : Utility.iterableStream((Stream)f.getCanvases())) {
                            Bounds sceneBounds = c.getContentSceneBounds();
                            Bounds b = this.selectionHighlight.sceneToLocal(sceneBounds);
                            this.roundedRectPath(gc, b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight(), 5.0);
                        }
                        gc.fill();
                        gc.closePath();
                    }
                } else {
                    gc.fillRoundRect(0.5, 0.5, this.selectionHighlight.getWidth() - 1.0, this.selectionHighlight.getHeight() - 1.0, 7.0, 7.0);
                }
            }
            gc.setStroke((Paint)Color.BLACK);
            gc.setLineWidth(2.0);
            gc.strokeRoundRect(0.5, 0.5, this.selectionHighlight.getWidth() - 1.0, this.selectionHighlight.getHeight() - 1.0, 7.0, 7.0);
        }
    }

    private void roundedRectPath(GraphicsContext gc, double minX, double minY, double width, double height, double arc) {
        gc.moveTo(minX + arc, minY);
        gc.lineTo(minX + width - arc, minY);
        gc.arcTo(minX + width, minY, minX + width, minY + arc, arc);
        gc.lineTo(minX + width, minY + height - arc);
        gc.arcTo(minX + width, minY + height, minX + width - arc, minY + height, arc);
        gc.lineTo(minX + arc, minY + height);
        gc.arcTo(minX, minY + height, minX, minY + height - arc, arc);
        gc.lineTo(minX, minY + arc);
        gc.arcTo(minX, minY, minX + arc, minY, arc);
    }

    @OnThread(value=Tag.FXPlatform)
    public void clear() {
        this.selection.clear();
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean contains(Frame f) {
        return this.selection.contains((Object)f);
    }

    @OnThread(value=Tag.FXPlatform)
    public List<Frame> getSelected() {
        return Collections.unmodifiableList(this.selection);
    }

    @OnThread(value=Tag.FXPlatform)
    public void toggleSelectDown(Frame f) {
        if (f == null) {
            return;
        }
        if (this.selection.size() > 0 && this.selection.get(0) == f) {
            this.selection.remove(0);
        } else {
            this.selection.add((Object)f);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void toggleSelectUp(Frame f) {
        if (f == null) {
            return;
        }
        if (this.selection.size() > 0 && this.selection.get(this.selection.size() - 1) == f) {
            this.selection.remove(this.selection.size() - 1);
        } else {
            this.selection.add(0, (Object)f);
        }
    }

    public Map<EditableSlot.TopLevelMenu, AbstractOperation.MenuItems> getEditMenuItems(boolean contextMenu) {
        return Collections.singletonMap(EditableSlot.TopLevelMenu.EDIT, AbstractOperation.getMenuItems(this.selection, (boolean)contextMenu));
    }

    public ContextMenu getContextMenu() {
        AbstractOperation.MenuItems ops = AbstractOperation.getMenuItems(this.selection, (boolean)true);
        if (ops.isEmpty()) {
            return null;
        }
        return AbstractOperation.MenuItems.makeContextMenu(Collections.singletonMap(EditableSlot.TopLevelMenu.EDIT, ops));
    }

    @OnThread(value=Tag.FXPlatform)
    public void setDeletePreview(boolean deletePreview) {
        this.deletePreview = deletePreview;
        this.pullUpPreview = false;
        this.redraw();
    }

    @OnThread(value=Tag.FXPlatform)
    public void setPullUpPreview(boolean pullUpPreview) {
        this.deletePreview = false;
        this.pullUpPreview = pullUpPreview;
        this.redraw();
    }

    @OnThread(value=Tag.FXPlatform)
    public void set(List<Frame> frames) {
        this.selection.clear();
        this.selection.setAll(frames);
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean isEmpty() {
        return this.selection.isEmpty();
    }

    @OnThread(value=Tag.FX)
    public void addChangeListener(FXPlatformRunnable listener) {
        JavaFXUtil.runNowOrLater(() -> this.selection.addListener(c -> listener.run()));
    }

    @OnThread(value=Tag.FXPlatform)
    public FrameCursor getCursorAfter() {
        if (this.selection.size() == 0) {
            return null;
        }
        return ((Frame)this.selection.get(this.selection.size() - 1)).getCursorAfter();
    }

    @OnThread(value=Tag.FXPlatform)
    public FrameCursor getCursorBefore() {
        if (this.selection.size() == 0) {
            return null;
        }
        return ((Frame)this.selection.get(0)).getCursorBefore();
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean executeKey(FrameCursor cursor, char key) {
        if (this.selection.size() == 1) {
            for (ExtensionDescription extension : ((Frame)this.selection.get(0)).getAvailableExtensions(null, null)) {
                if (extension.getShortcutKey() != key || !extension.validFor(ExtensionDescription.ExtensionSource.AFTER) && !extension.validFor(ExtensionDescription.ExtensionSource.BEFORE) && !extension.validFor(ExtensionDescription.ExtensionSource.SELECTION)) continue;
                extension.activate();
                return true;
            }
        }
        if (key == '\\') {
            boolean allDisabled = this.getCanHaveEnabledState(false).allMatch(f -> !f.isFrameEnabled());
            this.editor.beginRecordingState((RecallableFocus)cursor);
            this.getCanHaveEnabledState(allDisabled).forEach(t -> t.setFrameEnabled(allDisabled));
            this.editor.endRecordingState((RecallableFocus)cursor);
            return true;
        }
        if (this.getNonIgnored().allMatch(f -> f.getAvailableExtensions(null, null).stream().filter(m -> m.validFor(ExtensionDescription.ExtensionSource.SELECTION) && m.getShortcutKey() == key).count() == 1L)) {
            this.getNonIgnored().flatMap(f -> f.getAvailableExtensions(null, null).stream()).filter(m -> m.validFor(ExtensionDescription.ExtensionSource.SELECTION) && m.getShortcutKey() == key).findAny().ifPresent(e -> e.activate(this.getNonIgnored().collect(Collectors.toList())));
            return true;
        }
        return false;
    }

    private Stream<Frame> getCanHaveEnabledState(boolean state) {
        return this.selection.stream().filter(f -> f.canHaveEnabledState(state));
    }

    private Stream<Frame> getNonIgnored() {
        return this.selection.stream().filter(f -> f.isEffectiveFrame());
    }
}

