/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.Config;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;

public class ErrorOverviewBar
extends VBox {
    private final Label status;
    private final ErrorsBar bar;
    private final InteractionManager editor;
    private final Pane codeContainer;
    private final IntegerProperty showingCount = new SimpleIntegerProperty(0);

    public ErrorOverviewBar(InteractionManager editor, Pane codeContainer, FXRunnable nextError) {
        this.editor = editor;
        this.codeContainer = codeContainer;
        this.bar = new ErrorsBar();
        this.status = new Label();
        JavaFXUtil.addStyleClass((Styleable)this.status, (String[])new String[]{"error-overview-bar-status"});
        this.status.setOnMouseClicked(e -> {
            nextError.run();
            e.consume();
        });
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"error-overview-bar-pane"});
        this.getChildren().addAll((Object[])new Node[]{this.status, this.bar});
        VBox.setVgrow((Node)this.bar, (Priority)Priority.ALWAYS);
    }

    public void update(List<ErrorInfo> errors, ErrorState state) {
        this.bar.clear();
        errors.forEach(this.bar::add);
        this.updateShowingCount();
        this.setState(state);
    }

    private void setState(ErrorState state) {
        switch (state) {
            case ERRORS: {
                this.status.setText("\u2717");
                this.status.setTooltip(new Tooltip(this.showingCount.get() + " " + Config.getString((String)(this.showingCount.get() == 1 ? "frame.error.overview.bar.error.single" : "frame.error.overview.bar.error.plural"))));
                break;
            }
            case NO_ERRORS: {
                this.status.setText("\u2713");
                this.status.setTooltip(new Tooltip(Config.getString((String)"frame.error.overview.bar.error.none")));
                break;
            }
            case EDITING: {
                this.status.setText("\u270e");
                this.status.setTooltip(new Tooltip(Config.getString((String)"frame.error.overview.bar.error.editing")));
            }
        }
        JavaFXUtil.selectPseudoClass((Node)this.status, (int)state.ordinal(), (String[])new String[]{"bj-success", "bj-failure", "bj-editing"});
    }

    private void updateShowingCount() {
        this.showingCount.set(this.bar.calculateShowing());
        if (this.showingCount.get() > 0) {
            this.setState(ErrorState.ERRORS);
        }
    }

    public ReadOnlyIntegerProperty showingCount() {
        return this.showingCount;
    }

    private class Error
    extends Rectangle
    implements ChangeListener<Boolean> {
        private final ObservableBooleanValue focused;
        private final ObservableBooleanValue visible;

        public Error(String message, ObservableBooleanValue focused, ObservableBooleanValue visible, FXPlatformRunnable onClick) {
            JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"error-overview-error"});
            this.setOnMouseClicked(e -> {
                onClick.run();
                e.consume();
            });
            this.focused = focused;
            this.visible = visible;
            this.focused.addListener((ChangeListener)this);
            this.visible.addListener((ChangeListener)this);
            Tooltip.install((Node)this, (Tooltip)new Tooltip(message));
        }

        public void cleanup() {
            this.focused.removeListener((ChangeListener)this);
            this.visible.removeListener((ChangeListener)this);
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (observable == this.focused) {
                JavaFXUtil.setPseudoclass((String)"bj-showing", (boolean)newValue, (Node[])new Node[]{this});
            } else if (observable == this.visible) {
                ErrorOverviewBar.this.updateShowingCount();
            }
        }
    }

    private class ErrorsBar
    extends Pane {
        private ErrorsBar() {
        }

        public void clear() {
            this.getChildren().forEach(x -> ((Error)((Object)x)).cleanup());
            this.getChildren().clear();
        }

        public void add(ErrorInfo info) {
            double posTop = ErrorOverviewBar.this.codeContainer.sceneToLocal(info.node.localToScene(0.0, 0.0)).getY() / ErrorOverviewBar.this.codeContainer.getHeight();
            Error e = new Error(info.message, info.focused, info.visible, info.giveFocus);
            e.visibleProperty().bind((ObservableValue)info.visible);
            e.setManaged(false);
            e.setX(1.0);
            e.setHeight(8.0);
            e.setY(posTop * this.getHeight());
            e.setWidth(this.getWidth() - 2.0);
            this.getChildren().add((Object)e);
        }

        public int calculateShowing() {
            return (int)this.getChildren().stream().filter(x -> x.visibleProperty().get()).count();
        }
    }

    public static class ErrorInfo {
        private final String message;
        private final Node node;
        private final FXPlatformRunnable giveFocus;
        private final ObservableBooleanValue visible;
        private final ObservableBooleanValue focused;

        ErrorInfo(String message, Node node, ObservableBooleanValue visible, ObservableBooleanValue focused, FXPlatformRunnable giveFocus) {
            this.message = message;
            this.node = node;
            this.visible = visible;
            this.focused = focused;
            this.giveFocus = giveFocus;
        }

        public boolean isVisible() {
            return this.visible.get();
        }
    }

    public static enum ErrorState {
        NO_ERRORS,
        ERRORS,
        EDITING;

    }
}

