/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.editor.base.BackgroundItem;
import bluej.editor.base.BaseEditorPane;
import bluej.editor.base.EditorPosition;
import bluej.editor.base.LineDisplay;
import bluej.editor.base.MarginAndTextLine;
import bluej.editor.base.TextLine;
import bluej.editor.flow.Document;
import bluej.editor.flow.HoleDocument;
import bluej.editor.flow.JavaSyntaxView;
import bluej.editor.flow.ScopeColors;
import bluej.editor.flow.TrackedPosition;
import bluej.prefmgr.PrefMgr;
import bluej.utility.javafx.JavaFXUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.IndexRange;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public class FlowEditorPane
extends BaseEditorPane
implements JavaSyntaxView.Display {
    private final FlowEditorPaneListener listener;
    private final HoleDocument document;
    private final TrackedPosition anchor;
    private final TrackedPosition caret;
    private int targetColumnForVerticalMovement;
    private LineStyler lineStyler = (i, s) -> Collections.singletonList(new TextLine.StyledSegment(Collections.emptyList(), s.toString()));
    private ErrorQuery errorQuery = () -> Collections.emptyList();
    private boolean editable = true;
    private boolean justAddedOpeningCurlyBracket;

    public FlowEditorPane(String content, FlowEditorPaneListener listener) {
        super(true, listener);
        this.listener = listener;
        this.setSnapToPixel(true);
        this.document = new HoleDocument();
        this.document.replaceText(0, 0, content);
        this.caret = this.document.trackPosition(0, Document.Bias.FORWARD);
        this.anchor = this.document.trackPosition(0, Document.Bias.FORWARD);
        this.updateRender(false);
        this.document.addListener(false, (origStartIncl, replaced, replacement, linesRemoved, linesAdded) -> this.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT));
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public @OnThread(value=Tag.FXPlatform, ignoreParent=true) Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objects) {
        switch (accessibleAttribute) {
            case EDITABLE: {
                return true;
            }
            case TEXT: {
                return this.getDocument().getFullContent();
            }
            case CARET_OFFSET: {
                return this.caret.position;
            }
            case SELECTION_START: {
                return this.getSelectionStart();
            }
            case SELECTION_END: {
                return this.getSelectionEnd();
            }
            case LINE_FOR_OFFSET: {
                return this.document.getLineFromPosition((Integer)objects[0]);
            }
            case LINE_START: {
                return this.document.getLineStart((Integer)objects[0]);
            }
            case LINE_END: {
                return this.document.getLineEnd((Integer)objects[0]);
            }
            case BOUNDS_FOR_RANGE: {
                return this.lineDisplay.getBoundsForRange(this.document, (Integer)objects[0], (Integer)objects[1]);
            }
            case OFFSET_AT_POINT: {
                Point2D screenPoint = (Point2D)objects[0];
                return this.getCaretPositionForLocalPoint(this.screenToLocal(screenPoint)).map(p -> p.getPosition()).orElse(0);
            }
            case HELP: {
                String err = this.listener.getErrorAtPosition(this.caret.position);
                if (err == null) break;
                return "Error: " + err;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objects);
    }

    @Override
    protected EditorPosition makePosition(int line, int column) {
        return new TrackedPosition(this.document, this.document.getLineStart(line) + column, Document.Bias.NONE);
    }

    @Override
    protected void keyPressed(KeyEvent event) {
        if (event.getCode() == KeyCode.CONTEXT_MENU) {
            this.showContextMenuAtCaret();
            event.consume();
        }
    }

    @Override
    protected void keyTyped(KeyEvent event) {
        if (!this.editable) {
            return;
        }
        String character = event.getCharacter();
        if (character.length() == 0) {
            return;
        }
        if ((event.isControlDown() || event.isAltDown() || Config.isMacOS() && event.isMetaDown()) && (!event.isControlDown() && !Config.isMacOS() || !event.isAltDown())) {
            return;
        }
        if (character.charAt(0) > '\u001f' && character.charAt(0) != '\u007f' && !event.isMetaDown()) {
            this.replaceSelection(character);
            JavaFXUtil.runAfterCurrent(() -> this.scheduleCaretUpdate(true));
            this.justAddedOpeningCurlyBracket = character.equals("{");
        }
    }

    @Override
    protected void mousePressed(MouseEvent e) {
        this.requestFocus();
        if (e.getButton() == MouseButton.PRIMARY) {
            boolean setAnchor = !e.isShiftDown();
            this.getCaretPositionForMouseEvent(e).ifPresent(p -> {
                if (setAnchor) {
                    this.positionCaret(p.getPosition());
                } else {
                    this.moveCaret((EditorPosition)p, true);
                }
            });
            this.updateRender(true);
        }
    }

    @Override
    protected void mouseMoved(MouseEvent event) {
        this.getCaretPositionForMouseEvent(event).ifPresent(pos -> this.listener.showErrorPopupForCaretPos(pos.getPosition(), true));
    }

    @Override
    public Optional<EditorPosition> getCaretPositionForLocalPoint(Point2D localPoint) {
        return super.getCaretPositionForLocalPoint(localPoint);
    }

    public void textChanged() {
        this.updateRender(false);
        this.targetColumnForVerticalMovement = -1;
        this.callSelectionListeners();
    }

    @Override
    protected void updateRender(boolean ensureCaretVisible) {
        super.updateRender(ensureCaretVisible);
        if (this.errorQuery != null) {
            for (IndexRange indexRange : this.errorQuery.getErrorUnderlines()) {
                this.addErrorUnderline(indexRange.getStart(), indexRange.getEnd());
            }
        }
    }

    @Override
    protected int getLineLength(int lineIndex) {
        return this.document.getLineLength(lineIndex);
    }

    @Override
    protected String getLineContentAtCaret() {
        return this.document.getLines().get(this.caret.getLine()).toString();
    }

    @Override
    public boolean isLineVisible(int line) {
        return this.lineDisplay.isLineVisible(line);
    }

    int[] getLineRangeVisible() {
        return this.lineDisplay.getLineRangeVisible();
    }

    double getLineHeight() {
        return this.lineDisplay.getLineHeight();
    }

    private PathElement[] keepBottom(PathElement[] rangeShape) {
        if (rangeShape.length % 5 == 0) {
            for (int i = 0; i < rangeShape.length; i += 5) {
                if (!(rangeShape[0] instanceof MoveTo) || !(rangeShape[1] instanceof LineTo) || !(rangeShape[2] instanceof LineTo) || !(rangeShape[3] instanceof LineTo) || !(rangeShape[4] instanceof LineTo)) continue;
                rangeShape[1] = this.lineToMove(rangeShape[1]);
                rangeShape[2] = this.lineToMove(rangeShape[2]);
                rangeShape[4] = this.lineToMove(rangeShape[4]);
            }
        }
        return rangeShape;
    }

    private PathElement lineToMove(PathElement pathElement) {
        LineTo lineTo = (LineTo)pathElement;
        return new MoveTo(lineTo.getX(), lineTo.getY());
    }

    public int getTargetColumnForVerticalMove() {
        return this.targetColumnForVerticalMovement;
    }

    public void setTargetColumnForVerticalMove(int targetColumn) {
        this.targetColumnForVerticalMovement = targetColumn;
    }

    private void addErrorUnderline(int startPos, int endPos) {
        int lineIndex = this.document.getLineFromPosition(startPos);
        int startColumn = this.document.getColumnFromPosition(startPos);
        int endColumn = Math.min(this.document.getLineEnd(lineIndex), endPos - this.document.getLineStart(lineIndex));
        if (this.lineDisplay.isLineVisible(lineIndex)) {
            this.lineDisplay.getVisibleLine((int)lineIndex).textLine.showError(startColumn, endColumn);
        }
    }

    void showHighlights(TextLine.HighlightType highlightType, List<int[]> results) {
        HashMap resultsByLine = new HashMap();
        for (int[] result : results) {
            int lineIndex = this.document.getLineFromPosition(result[0]);
            int startColumn = this.document.getColumnFromPosition(result[0]);
            int endColumn = Math.min(this.document.getLineEnd(lineIndex), result[1] - this.document.getLineStart(lineIndex));
            resultsByLine.computeIfAbsent(lineIndex, n -> new ArrayList()).add(new int[]{startColumn, endColumn});
        }
        int[] visibleLines = this.lineDisplay.getLineRangeVisible();
        for (int line = visibleLines[0]; line <= visibleLines[1]; ++line) {
            this.lineDisplay.getVisibleLine((int)line).textLine.showHighlight(highlightType, resultsByLine.getOrDefault(line, List.of()));
        }
    }

    public void setErrorQuery(ErrorQuery errorQuery) {
        this.errorQuery = errorQuery;
    }

    @Override
    public void applyScopeBackgrounds(Map<Integer, List<BackgroundItem>> scopeBackgrounds) {
        HashMap<Integer, List<BackgroundItem>> withOverlays = new HashMap<Integer, List<BackgroundItem>>();
        Set<Integer> breakpointLines = this.listener.getBreakpointLines();
        int stepLine = this.listener.getStepLine();
        scopeBackgrounds.forEach((line, scopes) -> {
            if (breakpointLines.contains(line) || line == stepLine) {
                ArrayList<BackgroundItem> regions = new ArrayList<BackgroundItem>((Collection<BackgroundItem>)scopes);
                BackgroundItem region = new BackgroundItem(0.0, this.getWidth() - (double)MarginAndTextLine.textLeftEdge(true), new BackgroundFill((Paint)(line == stepLine ? this.listener.stepMarkOverlayColorProperty() : this.listener.breakpointOverlayColorProperty()).get(), null, null));
                regions.add(region);
                withOverlays.put((Integer)line, (List<BackgroundItem>)regions);
            } else {
                withOverlays.put((Integer)line, (List<BackgroundItem>)scopes);
            }
        });
        this.lineDisplay.applyScopeBackgrounds(withOverlays);
    }

    public void ensureCaretShowing() {
        this.updateRender(true);
    }

    public void setLineMarginGraphics(int lineIndex, EnumSet<MarginAndTextLine.MarginDisplay> marginDisplays) {
        if (this.lineDisplay.isLineVisible(lineIndex)) {
            this.lineDisplay.getVisibleLine(lineIndex).setMarginGraphics(marginDisplays);
        }
    }

    public void fontSizeChanged() {
        this.lineDisplay.fontSizeChanged();
        this.updateRender(false);
    }

    public void select(int start, int end) {
        this.positionAnchor(start);
        this.moveCaret(end);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void write(Writer writer) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        bufferedWriter.write(this.document.getFullContent());
        bufferedWriter.flush();
    }

    public void hideAllErrorUnderlines() {
        this.lineDisplay.hideAllErrorUnderlines();
    }

    public HoleDocument getDocument() {
        return this.document;
    }

    public void scrollTo(int lineIndex) {
        this.lineDisplay.scrollTo(lineIndex, 0.0);
        this.updateRender(false);
    }

    @Override
    public Optional<Double> getLeftEdgeX(int leftOfCharIndex) {
        return FlowEditorPane.getLeftEdgeX(leftOfCharIndex, this.document, this.lineDisplay);
    }

    static Optional<Double> getLeftEdgeX(int leftOfCharIndex, Document document, LineDisplay lineDisplay) {
        int lineIndex = document.getLineFromPosition(leftOfCharIndex);
        if (lineDisplay.isLineVisible(lineIndex)) {
            TextLine line = lineDisplay.getVisibleLine((int)lineIndex).textLine;
            if (line.isNeedsLayout()) {
                return Optional.empty();
            }
            Font curFont = line.getChildren().stream().flatMap(n -> n instanceof Text ? Stream.of(((Text)n).getFont()) : Stream.empty()).findFirst().orElse(null);
            if (curFont != null && !curFont.getFamily().equals(PrefMgr.getEditorFontFamily())) {
                return Optional.empty();
            }
            int posInLine = leftOfCharIndex - document.getLineStart(lineIndex);
            PathElement[] elements = line.caretShape(posInLine, true);
            Path path = new Path(elements);
            Bounds bounds = path.getBoundsInLocal();
            if (posInLine > 0 && bounds.getMaxX() < 2.0) {
                return Optional.empty();
            }
            return Optional.of((bounds.getMinX() + bounds.getMaxX()) / 2.0);
        }
        return Optional.empty();
    }

    public Optional<Bounds> getCaretBoundsOnScreen(int position) {
        int lineIndex = this.document.getLineFromPosition(position);
        if (this.lineDisplay.isLineVisible(lineIndex)) {
            TextLine line = this.lineDisplay.getVisibleLine((int)lineIndex).textLine;
            PathElement[] elements = line.caretShape(position - this.document.getLineStart(lineIndex), true);
            Path path = new Path(elements);
            Bounds bounds = line.localToScreen(path.getBoundsInLocal());
            return Optional.of(bounds);
        }
        return Optional.empty();
    }

    public Optional<double[]> getTopAndBottom(int lineIndex) {
        if (this.lineDisplay.isLineVisible(lineIndex)) {
            MarginAndTextLine line = this.lineDisplay.getVisibleLine(lineIndex);
            Bounds bounds = line.getLayoutBounds();
            return Optional.of(new double[]{line.getLayoutY() + bounds.getMinY(), line.getLayoutY() + bounds.getMaxY()});
        }
        return Optional.empty();
    }

    public Rectangle2D getLineBoundsOnScreen(int line, Point2D windowPos, double renderScaleX, double renderScaleY) {
        if (this.lineDisplay.isLineVisible(line)) {
            MarginAndTextLine marginAndTextLine = this.lineDisplay.getVisibleLine(line);
            Bounds bounds = marginAndTextLine.textLine.localToScene(marginAndTextLine.textLine.getBoundsInLocal());
            double sceneX = marginAndTextLine.getScene().getX();
            double sceneY = marginAndTextLine.getScene().getY();
            double windowX = windowPos.getX();
            double windowY = windowPos.getY();
            return new Rectangle2D((bounds.getMinX() + sceneX + windowX) * renderScaleX, (bounds.getMinY() + sceneY + windowY) * renderScaleY, bounds.getWidth() * renderScaleX, bounds.getHeight() * renderScaleY);
        }
        return null;
    }

    public double getFontSizeInPixels() {
        return this.lineDisplay.getFontSizeInPixels();
    }

    public void positionCaret(int position) {
        this.caret.moveTo(position);
        this.anchor.moveTo(position);
        this.targetColumnForVerticalMovement = -1;
        this.justAddedOpeningCurlyBracket = false;
        this.updateRender(true);
        this.callSelectionListeners();
    }

    public void positionCaretWithoutScrolling(int position) {
        this.caret.moveTo(position);
        this.anchor.moveTo(position);
        this.targetColumnForVerticalMovement = -1;
        this.justAddedOpeningCurlyBracket = false;
        this.updateRender(false);
        this.callSelectionListeners();
    }

    public void moveCaret(int position) {
        this.moveCaret(new TrackedPosition(this.document, position, Document.Bias.NONE), true);
    }

    @Override
    protected void moveCaret(EditorPosition position, boolean ensureCaretVisible) {
        this.caret.moveTo(position.getPosition());
        this.targetColumnForVerticalMovement = -1;
        this.justAddedOpeningCurlyBracket = false;
        this.updateRender(ensureCaretVisible);
        this.callSelectionListeners();
    }

    public void positionAnchor(int position) {
        this.anchor.moveTo(position);
        this.justAddedOpeningCurlyBracket = false;
        this.updateRender(false);
        this.callSelectionListeners();
    }

    @Override
    public EditorPosition getCaretEditorPosition() {
        return this.caret;
    }

    @Override
    public EditorPosition getAnchorEditorPosition() {
        return this.anchor;
    }

    public int getCaretPosition() {
        return this.caret.getPosition();
    }

    public int getAnchorPosition() {
        return this.anchor.getPosition();
    }

    @Override
    public void addLineDisplayListener(LineDisplay.LineDisplayListener lineDisplayListener) {
        this.lineDisplay.addLineDisplayListener(lineDisplayListener);
    }

    @Override
    public void repaint() {
        this.updateRender(false);
    }

    public void replaceSelection(String text) {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        this.document.replaceText(start, end, text);
        this.positionCaret(start + text.length());
    }

    public int getSelectionEnd() {
        return Math.max(this.caret.position, this.anchor.position);
    }

    public int getSelectionStart() {
        return Math.min(this.caret.position, this.anchor.position);
    }

    public String getSelectedText() {
        return this.document.getContent(this.getSelectionStart(), this.getSelectionEnd()).toString();
    }

    @Override
    public void setLineStyler(LineStyler lineStyler) {
        this.lineStyler = lineStyler;
    }

    public boolean hasJustAddedCurlyBracket() {
        return this.justAddedOpeningCurlyBracket;
    }

    @Override
    public double getWidthOfText(String content) {
        return this.lineDisplay.calculateLineWidth(content);
    }

    @Override
    protected int getLineCount() {
        return this.document.getLineCount();
    }

    @Override
    protected List<List<TextLine.StyledSegment>> getStyledLines() {
        return new StyledLines(this.document, this.lineStyler);
    }

    @Override
    protected String getLongestLineInWholeDocument() {
        return this.document.getLongestLine();
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    static class StyledLines
    extends AbstractList<List<TextLine.StyledSegment>> {
        private final LineStyler lineStyler;
        private final List<CharSequence> documentLines;

        public StyledLines(Document document, LineStyler lineStyler) {
            this.documentLines = document.getLines();
            this.lineStyler = lineStyler;
        }

        @Override
        public int size() {
            return this.documentLines.size();
        }

        @Override
        public List<TextLine.StyledSegment> get(int lineIndex) {
            return this.lineStyler.getLineForDisplay(lineIndex, this.documentLines.get(lineIndex));
        }
    }

    public static interface FlowEditorPaneListener
    extends ScopeColors,
    BaseEditorPane.BaseEditorPaneListener {
        public Set<Integer> getBreakpointLines();

        public int getStepLine();

        public void showErrorPopupForCaretPos(int var1, boolean var2);

        public String getErrorAtPosition(int var1);
    }

    @OnThread(value=Tag.FXPlatform)
    public static interface LineStyler {
        public List<TextLine.StyledSegment> getLineForDisplay(int var1, CharSequence var2);
    }

    public static interface ErrorQuery {
        public List<IndexRange> getErrorUnderlines();
    }
}

