/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.debugger.DebuggerThread;
import bluej.editor.Editor;
import bluej.editor.EditorWatcher;
import bluej.editor.TextEditor;
import bluej.editor.base.BackgroundItem;
import bluej.editor.base.BaseEditorPane;
import bluej.editor.base.EditorPosition;
import bluej.editor.base.LineContainer;
import bluej.editor.base.LineDisplay;
import bluej.editor.base.MarginAndTextLine;
import bluej.editor.base.TextLine;
import bluej.editor.fixes.EditorFixesManager;
import bluej.editor.fixes.FixDisplayManager;
import bluej.editor.fixes.SuggestionList;
import bluej.editor.flow.Document;
import bluej.editor.flow.DocumentUndoStack;
import bluej.editor.flow.FindNavigator;
import bluej.editor.flow.FindPanel;
import bluej.editor.flow.FlowActions;
import bluej.editor.flow.FlowEditorPane;
import bluej.editor.flow.FlowErrorManager;
import bluej.editor.flow.FlowIndent;
import bluej.editor.flow.GoToLineDialog;
import bluej.editor.flow.HoleDocument;
import bluej.editor.flow.Info;
import bluej.editor.flow.JavaSyntaxView;
import bluej.editor.flow.ParserMessageHandler;
import bluej.editor.flow.PrintDialog;
import bluej.editor.flow.ScopeColorsBorderPane;
import bluej.editor.flow.StatusLabel;
import bluej.editor.flow.TextUtilities;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FlowFXTab;
import bluej.editor.stride.FrameEditor;
import bluej.extensions2.editor.DocumentListener;
import bluej.parser.AssistContent;
import bluej.parser.AssistContentThreadSafe;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.ImportsCollection;
import bluej.parser.ParseUtils;
import bluej.parser.SourceLocation;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.lexer.JavaLexer;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.MethodNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.RBTreeNode;
import bluej.parser.nodes.ReparseableDocument;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.print.PrintProgressDialog;
import bluej.prefmgr.PrefMgr;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.slots.ExpressionCompletionCalculator;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXFunction;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.css.Styleable;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.TextFlow;
import javafx.scene.web.WebView;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventTarget;
import threadchecker.OnThread;
import threadchecker.Tag;

public class FlowEditor
extends ScopeColorsBorderPane
implements TextEditor,
FlowEditorPane.FlowEditorPaneListener,
BaseEditorPane.SelectionListener,
BlueJEventListener,
DocumentListener {
    public static final int VERSION = 400;
    public static final String CRASHFILE_SUFFIX = "#";
    static final String LabelSuffix = "Label";
    static final String ActionSuffix = "Action";
    private final FlowEditorPane flowEditorPane;
    private final HoleDocument document;
    private final JavaSyntaxView javaSyntaxView;
    private final FetchTabbedEditor fetchTabbedEditor;
    private final FlowFXTab fxTab;
    private final FlowActions actions;
    private final EditorWatcher watcher;
    private final EditorFixesManager editorFixesMgr;
    private final boolean sourceIsCode;
    private final List<Menu> fxMenus;
    private final ListView<FlowErrorManager.ErrorDetails> errorList;
    private final BorderPane errorListPane;
    private boolean compilationStarted;
    private boolean requeueForCompilation;
    private boolean compilationQueued;
    private boolean compilationQueuedExplicit;
    private CompileReason requeueReason;
    private CompileType requeueType;
    private final Info info;
    private final StatusLabel saveState;
    private FlowErrorManager errorManager = new FlowErrorManager(this);
    private FXTabbedEditor fxTabbedEditor;
    private boolean mayHaveBreakpoints;
    private final BooleanProperty compiledProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty viewingHTML = new SimpleBooleanProperty(false);
    private ErrorDisplay errorDisplay;
    private final BitSet breakpoints = new BitSet();
    private int currentStepLineIndex = -1;
    private ComboBox<String> interfaceToggle;
    private final WebView htmlPane;
    private String filename;
    private String docFilename;
    private Charset characterSet;
    private String windowTitle;
    private final Properties resources = Config.moeUserProps;
    private final ArrayList<int[]> findResults = new ArrayList();
    private static ArrayList<String> readMeActions;
    private final FindPanel finder;
    private final ObjectProperty<FindNavigator> currentSearchResult = new SimpleObjectProperty(null);
    private String lastSearchString = "";
    private final JavadocResolver javadocResolver;
    private final ArrayList<int[]> bracketMatches = new ArrayList();
    private final HashMap<String, Object> propertyMap = new HashMap();
    private int oldCaretLineNumber = -1;
    private long lastModified;
    private boolean respondingToChange = false;
    private boolean ignoreChanges = false;
    private boolean showingChangedOnDiskDialog = false;
    private FXPlatformRunnable callbackOnOpen;
    private final ContextMenu editorContextMenu;
    final UndoManager undoManager;

    public boolean containsSourceCode() {
        return this.sourceIsCode;
    }

    public void enableParser(boolean force) {
        this.javaSyntaxView.enableParser(force);
    }

    @Override
    public boolean marginClickedForLine(int lineIndex) {
        return this.toggleBreakpointForLine(lineIndex);
    }

    @Override
    public ContextMenu getContextMenuToShow(BaseEditorPane editorPane) {
        this.editorContextMenu.hide();
        return this.editorContextMenu;
    }

    private boolean toggleBreakpointForLine(int lineIndex) {
        boolean hasBreakpoint = this.watcher.breakpointToggleEvent(lineIndex + 1, !this.breakpoints.get(lineIndex));
        this.breakpoints.set(lineIndex, hasBreakpoint);
        if (hasBreakpoint) {
            this.mayHaveBreakpoints = true;
        }
        this.flowEditorPane.setLineMarginGraphics(lineIndex, this.calculateMarginDisplay(lineIndex));
        this.flowEditorPane.applyScopeBackgrounds(this.javaSyntaxView.getScopeBackgrounds());
        return hasBreakpoint;
    }

    public void toggleBreakpoint() {
        this.toggleBreakpointForLine(this.flowEditorPane.getDocument().getLineFromPosition(this.flowEditorPane.getCaretPosition()));
    }

    @Override
    public Set<Integer> getBreakpointLines() {
        return this.breakpoints.stream().mapToObj(Integer::valueOf).collect(Collectors.toSet());
    }

    @Override
    public int getStepLine() {
        return this.currentStepLineIndex;
    }

    public FlowActions getActions() {
        return this.actions;
    }

    public Project getProject() {
        if (this.fxTabbedEditor != null) {
            return this.fxTabbedEditor.getProject();
        }
        return null;
    }

    public FlowEditor(FetchTabbedEditor fetchTabbedEditor, String title, EditorWatcher editorWatcher, EntityResolver parentResolver, JavadocResolver javadocResolver, FXPlatformRunnable openCallback, @OnThread(value=Tag.FXPlatform) BooleanExpression syntaxHighlighting, boolean sourceIsCode) {
        this.fxTab = new FlowFXTab(this, title);
        this.javadocResolver = javadocResolver;
        this.windowTitle = title;
        this.callbackOnOpen = openCallback;
        this.flowEditorPane = new FlowEditorPane("", this);
        this.document = this.flowEditorPane.getDocument();
        this.document.addListener(false, this);
        this.javaSyntaxView = new JavaSyntaxView(this.document, this.flowEditorPane, this, parentResolver, syntaxHighlighting);
        this.flowEditorPane.setErrorQuery(this.errorManager);
        this.undoManager = new UndoManager(this.document);
        this.fetchTabbedEditor = fetchTabbedEditor;
        this.watcher = editorWatcher;
        this.info = new Info();
        this.saveState = new StatusLabel(StatusLabel.Status.SAVED, this, this.errorManager);
        this.actions = new FlowActions(this);
        this.htmlPane = new WebView();
        this.sourceIsCode = sourceIsCode;
        this.editorFixesMgr = new EditorFixesManager(this.watcher == null || this.watcher.getPackage() == null ? new CompletableFuture() : this.watcher.getPackage().getProject().getImports());
        this.htmlPane.visibleProperty().bind((ObservableValue)this.viewingHTML);
        this.setCenter((Node)new StackPane(new Node[]{this.flowEditorPane, this.htmlPane}));
        this.interfaceToggle = this.createInterfaceSelector();
        this.interfaceToggle.setDisable(!sourceIsCode);
        Region toolbar = this.createToolbar((DoubleExpression)this.interfaceToggle.heightProperty());
        this.setTop((Node)JavaFXUtil.withStyleClass((Styleable)new BorderPane((Node)toolbar, null, this.interfaceToggle, null, null), (String[])new String[]{"flow-top-bar"}));
        this.errorList = new ListView(this.errorManager.getObservableErrorList());
        this.errorListPane = new BorderPane(this.errorList);
        this.errorList.setCellFactory(lv -> new ListCell<FlowErrorManager.ErrorDetails>(){
            {
                this.setOnMouseClicked(e -> {
                    if (e.getClickCount() == 2 && e.getButton() == MouseButton.PRIMARY) {
                        FlowErrorManager.ErrorDetails err = (FlowErrorManager.ErrorDetails)this.getItem();
                        FlowEditor.this.errorList.getSelectionModel().select((Object)err);
                        FlowEditor.this.flowEditorPane.positionCaret(err.startPos);
                        FlowEditor.this.flowEditorPane.requestFocus();
                        e.consume();
                    }
                });
            }

            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            protected void updateItem(FlowErrorManager.ErrorDetails item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText(null);
                } else {
                    this.setText("Line " + FlowEditor.this.document.getLineFromPosition(item.startPos) + ": " + item.message);
                }
            }
        });
        this.errorList.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ENTER) {
                FlowErrorManager.ErrorDetails err = (FlowErrorManager.ErrorDetails)this.errorList.getSelectionModel().getSelectedItem();
                if (err != null) {
                    this.flowEditorPane.positionCaret(err.startPos);
                    this.flowEditorPane.requestFocus();
                }
                e.consume();
            } else if (e.getCode() == KeyCode.ESCAPE) {
                this.errorListPane.setVisible(false);
                this.errorListPane.setManaged(false);
                this.flowEditorPane.requestFocus();
                e.consume();
            }
        });
        this.errorListPane.setTop((Node)new Label("Errors"));
        this.errorListPane.setPadding(new Insets(3.0));
        this.setRight((Node)this.errorListPane);
        this.errorList.getItems().addListener(c -> {
            if (c.getList().isEmpty()) {
                this.errorListPane.setVisible(false);
                this.errorListPane.setManaged(false);
            }
        });
        this.errorListPane.setVisible(false);
        this.errorListPane.setManaged(false);
        this.flowEditorPane.addSelectionListener(this);
        this.flowEditorPane.addLineDisplayListener(new LineDisplay.LineDisplayListener(){

            @Override
            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public void renderedLines(int fromIncl, int toIncl) {
                for (int i = fromIncl; i <= toIncl; ++i) {
                    FlowEditor.this.flowEditorPane.setLineMarginGraphics(i, FlowEditor.this.calculateMarginDisplay(i));
                }
                FlowEditor.this.flowEditorPane.showHighlights(TextLine.HighlightType.FIND_RESULT, FlowEditor.this.findResults);
                FlowEditor.this.flowEditorPane.showHighlights(TextLine.HighlightType.BRACKET_MATCH, FlowEditor.this.bracketMatches);
            }
        });
        this.fxMenus = this.createMenus();
        this.actions.updateKeymap();
        BorderPane bottomArea = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)bottomArea, (String[])new String[]{"moe-bottom-bar"});
        this.finder = new FindPanel(this);
        this.finder.setVisible(false);
        BorderPane commentsPanel = new BorderPane();
        commentsPanel.setCenter((Node)this.info);
        commentsPanel.setRight((Node)this.saveState);
        BorderPane.setAlignment((Node)this.info, (Pos)Pos.TOP_LEFT);
        BorderPane.setAlignment((Node)this.saveState, (Pos)Pos.CENTER_RIGHT);
        JavaFXUtil.addStyleClass((Styleable)commentsPanel, (String[])new String[]{"moe-bottom-status-row"});
        commentsPanel.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS((boolean)false));
        bottomArea.setBottom((Node)commentsPanel);
        bottomArea.setTop((Node)this.finder);
        this.setBottom((Node)bottomArea);
        this.editorContextMenu = new ContextMenu(new MenuItem[]{this.getActions().getActionByName("cut-to-clipboard").makeContextMenuItem(Config.getString((String)"editor.cutLabel")), this.getActions().getActionByName("copy-to-clipboard").makeContextMenuItem(Config.getString((String)"editor.copyLabel")), this.getActions().getActionByName("paste-from-clipboard").makeContextMenuItem(Config.getString((String)"editor.pasteLabel"))});
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)PrefMgr.getEditorFontSize(), s -> {
            this.javaSyntaxView.fontSizeChanged();
            this.flowEditorPane.fontSizeChanged();
        });
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)PrefMgr.flagProperty((String)"bluej.editor.displayLineNumbers"), b -> this.flowEditorPane.repaint());
    }

    private String getResource(String name) {
        return Config.getPropString((String)name, null, (Properties)this.resources);
    }

    private Region createToolbar(DoubleExpression buttonHeight) {
        TilePane tilePane = new TilePane(Orientation.VERTICAL, new Node[]{this.createToolbarButton("compile", buttonHeight), this.createToolbarButton("undo", buttonHeight), this.createToolbarButton("cut", buttonHeight), this.createToolbarButton("copy", buttonHeight), this.createToolbarButton("paste", buttonHeight), this.createToolbarButton("find", buttonHeight), this.createToolbarButton("close", buttonHeight)});
        tilePane.setPrefRows(1);
        tilePane.setPrefColumns(tilePane.getChildren().size());
        tilePane.prefWidthProperty().bind((ObservableValue)tilePane.maxWidthProperty());
        tilePane.prefHeightProperty().bind((ObservableValue)tilePane.minHeightProperty());
        return (Region)JavaFXUtil.withStyleClass((Styleable)tilePane, (String[])new String[]{"flow-top-bar-buttons"});
    }

    private ButtonBase createToolbarButton(String key, DoubleExpression buttonHeight) {
        Button button;
        FlowActions.FlowAbstractAction action;
        String label = Config.getString((String)("editor." + key + LabelSuffix));
        String actionName = this.getResource(key + ActionSuffix);
        if (actionName == null) {
            actionName = key;
        }
        if ((action = this.actions.getActionByName(actionName)) != null) {
            button = action.makeButton();
            button.setText(label);
        } else {
            button = new Button("Unknown");
        }
        if (action == null) {
            button.setDisable(true);
            Debug.message((String)("Moe: action not found for button " + label));
        }
        if (FlowEditor.isNonReadmeAction(actionName) && !this.sourceIsCode) {
            action.setEnabled(false);
        }
        button.setFocusTraversable(false);
        button.setMaxWidth(Double.MAX_VALUE);
        button.prefHeightProperty().bind((ObservableValue)buttonHeight);
        button.setMaxHeight(Double.MAX_VALUE);
        button.getStyleClass().add((Object)("toolbar-" + key + "-button"));
        return button;
    }

    private static boolean isNonReadmeAction(String actionName) {
        ArrayList<String> flaggedActions = FlowEditor.getNonReadmeActions();
        return flaggedActions.contains(actionName);
    }

    private static ArrayList<String> getNonReadmeActions() {
        if (readMeActions == null) {
            readMeActions = new ArrayList();
            readMeActions.add("compile");
            readMeActions.add("autoindent");
            readMeActions.add("insert-method");
            readMeActions.add("add-javadoc");
            readMeActions.add("toggle-interface-view");
        }
        return readMeActions;
    }

    private ComboBox<String> createInterfaceSelector() {
        String interfaceString = Config.getString((String)"editor.interfaceLabel");
        String implementationString = Config.getString((String)"editor.implementationLabel");
        Object[] choiceStrings = new String[]{implementationString, interfaceString};
        ComboBox interfaceToggle = new ComboBox(FXCollections.observableArrayList((Object[])choiceStrings));
        interfaceToggle.setFocusTraversable(false);
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)interfaceToggle.valueProperty(), v -> {
            if (v.equals(interfaceString)) {
                this.switchToInterfaceView();
            } else {
                this.switchToSourceView();
            }
        });
        return interfaceToggle;
    }

    private List<Menu> createMenus() {
        return List.of(this.createMenu("class", "save - print - close"), this.createMenu("edit", "undo redo - cut-to-clipboard copy-to-clipboard paste-from-clipboard - indent-block deindent-block comment-block uncomment-block autoindent - insert-method add-javadoc"), this.createMenu("tools", "find find-next find-next-backward replace go-to-line - compile toggle-breakpoint - toggle-interface-view"), this.createMenu("option", "increase-font decrease-font reset-font - key-bindings preferences"));
    }

    private Menu createMenu(String titleKey, String itemList) {
        String[] itemKeys;
        Menu menu = new Menu(Config.getString((String)("editor." + titleKey + LabelSuffix)));
        for (String itemKey : itemKeys = itemList.split(" ")) {
            if (itemKey.equals("-")) {
                menu.getItems().add((Object)new SeparatorMenuItem());
                continue;
            }
            FlowActions.FlowAbstractAction action = this.actions.getActionByName(itemKey);
            if (action == null) {
                Debug.message((String)("Moe: cannot find action " + itemKey));
                continue;
            }
            if (Config.isMacOS() && titleKey.toLowerCase().equals("option") && itemKey.toLowerCase().equals("preferences")) continue;
            MenuItem item = action.makeMenuItem();
            menu.getItems().add((Object)item);
            String label = Config.getString((String)("editor." + itemKey + LabelSuffix));
            item.setText(label);
        }
        return menu;
    }

    public EditorWatcher getWatcher() {
        return this.watcher;
    }

    @Override
    public String getErrorAtPosition(int caretPos) {
        String errorMessage = this.errorManager.getErrorAtPosition(caretPos) != null ? this.errorManager.getErrorAtPosition((int)caretPos).message : null;
        return errorMessage;
    }

    @Override
    public void selectionChanged(int caretPos, int anchorPos) {
        this.showErrorPopupForCaretPos(caretPos, false);
        this.actions.userAction();
        if (PrefMgr.getFlag((String)"bluej.editor.matchBrackets")) {
            this.doBracketMatch();
        }
        if (this.oldCaretLineNumber != this.document.getLineFromPosition(caretPos) && this.isOpen()) {
            this.recordEdit(true);
            this.cancelFreshState();
            JavaFXUtil.runAfterCurrent(() -> {
                this.getSourcePane().ensureCaretShowing();
                this.layout();
            });
        }
        this.oldCaretLineNumber = this.document.getLineFromPosition(caretPos);
    }

    private void doBracketMatch() {
        this.bracketMatches.clear();
        for (Integer position : this.getBracketMatchPositions()) {
            this.bracketMatches.add(new int[]{position, position + 1});
        }
        this.flowEditorPane.showHighlights(TextLine.HighlightType.BRACKET_MATCH, this.bracketMatches);
    }

    private void removeBracketHighlight() {
        this.bracketMatches.clear();
        this.flowEditorPane.showHighlights(TextLine.HighlightType.BRACKET_MATCH, this.bracketMatches);
    }

    private List<Integer> getBracketMatchPositions() {
        int actualCaretPos = this.flowEditorPane.getCaretPosition();
        ArrayList<Integer> matches = new ArrayList<Integer>();
        for (int caretPos = Math.max(0, actualCaretPos - 1); caretPos <= Math.min(actualCaretPos, this.getTextLength() - 1); ++caretPos) {
            int pos = TextUtilities.findMatchingBracket(this.document, caretPos);
            if (pos == -1) continue;
            matches.add(caretPos);
            matches.add(pos);
        }
        return matches;
    }

    public boolean hasQuickFixShown() {
        return this.errorDisplay != null && this.errorDisplay.hasFixes() && this.errorDisplay.popup.isShowing();
    }

    public boolean hasQuickFixSelected() {
        return this.errorDisplay.hasQuickFixSelected();
    }

    @Override
    public void showErrorPopupForCaretPos(int caretPos, boolean mousePosition) {
        boolean isStillSameError;
        FlowErrorManager.ErrorDetails err = caretPos == -1 ? null : this.errorManager.getErrorAtPosition(caretPos);
        boolean isPopupOpenedWithFixes = this.errorDisplay != null && this.errorDisplay.hasFixes() && this.errorDisplay.popup.isShowing();
        boolean bl = isStillSameError = this.errorDisplay != null && caretPos >= this.errorDisplay.details.startPos && caretPos <= this.errorDisplay.details.endPos;
        if (err != null && !isStillSameError) {
            this.showErrorOverlay(err, caretPos);
        } else if (!mousePosition && !isStillSameError) {
            this.showErrorOverlay(err, caretPos);
        } else if (!(isPopupOpenedWithFixes || this.errorDisplay == null || mousePosition && this.errorDisplay.details.containsPosition(caretPos))) {
            this.showErrorOverlay(null, caretPos);
        }
    }

    public void changeQuickFixSelection(boolean changeDownwards) {
        if (changeDownwards) {
            this.errorDisplay.down();
        } else {
            this.errorDisplay.up();
        }
    }

    void executeQuickFix() {
        this.errorDisplay.executeQuickFix();
    }

    public void requestEditorFocus() {
        this.flowEditorPane.requestFocus();
    }

    public void notifyVisibleTab(boolean visible) {
        if (visible) {
            if (this.watcher != null) {
                this.watcher.recordSelected();
            }
            if (PrefMgr.getFlag((String)"bluej.editor.checkDiskFileChanges")) {
                this.checkForChangeOnDisk();
            }
        } else {
            this.showErrorOverlay(null, 0);
        }
    }

    private void showErrorOverlay(FlowErrorManager.ErrorDetails details, int displayPosition) {
        if (details != null) {
            if (this.errorDisplay == null || this.errorDisplay.details != details) {
                if (this.errorDisplay != null) {
                    ErrorDisplay old = this.errorDisplay;
                    old.popup.hide();
                }
                Bounds pos = null;
                boolean before = false;
                try {
                    pos = this.getSourcePane().getCaretBoundsOnScreen(displayPosition).orElse(null);
                    if (pos == null) {
                        pos = this.getSourcePane().getCaretBoundsOnScreen(displayPosition - 1).orElse(null);
                        before = true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (pos == null) {
                    return;
                }
                int xpos = (int)(before ? pos.getMaxX() : pos.getMinX());
                int ypos = (int)(pos.getMinY() + 4.0 * pos.getHeight() / 3.0);
                ErrorDisplay newDisplay = this.errorDisplay = new ErrorDisplay(this, () -> this.getWatcher(), details);
                newDisplay.createPopup();
                newDisplay.popup.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_TOP_LEFT);
                newDisplay.popup.setAnchorX((double)xpos);
                newDisplay.popup.setAnchorY((double)ypos);
                newDisplay.popup.show(this.getWindow());
                if (this.watcher != null) {
                    newDisplay.recordShow(() -> this.watcher);
                }
            }
        } else if (this.errorDisplay != null) {
            ErrorDisplay old = this.errorDisplay;
            old.popup.hide();
            this.errorDisplay = null;
        }
    }

    private void checkForChangeOnDisk() {
        if (this.filename == null) {
            return;
        }
        File file = new File(this.filename);
        long modified = file.lastModified();
        if (modified > this.lastModified + 1000L && !this.showingChangedOnDiskDialog) {
            Debug.message((String)("File " + this.filename + " changed on disk; our record is " + this.lastModified + " but file was " + modified));
            if (this.saveState.isChanged()) {
                this.showingChangedOnDiskDialog = true;
                int answer = DialogManager.askQuestionFX((Window)this.getWindow(), (String)"changed-on-disk");
                if (answer == 0) {
                    this.doReload();
                } else {
                    this.setLastModified(modified);
                }
                this.showingChangedOnDiskDialog = false;
            } else {
                this.doReload();
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void cancelFreshState() {
        if (this.saveState.isChanged()) {
            if (this.sourceIsCode) {
                this.scheduleCompilation(CompileReason.MODIFIED, CompileType.ERROR_CHECK_ONLY);
            } else {
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void setParent(FXTabbedEditor parent, boolean partOfMove) {
        if (this.watcher != null) {
            if (!partOfMove && parent != null) {
                this.watcher.recordOpen();
            } else if (!partOfMove && parent == null) {
                this.watcher.recordClose();
            }
            if (parent == null && this.saveState.isChanged()) {
                this.scheduleCompilation(CompileReason.MODIFIED, CompileType.ERROR_CHECK_ONLY);
            }
        }
        this.fxTabbedEditor = parent;
    }

    public void scheduleCompilation(CompileReason reason, CompileType ctype) {
        if (this.watcher != null) {
            if (!this.compilationQueued) {
                this.watcher.scheduleCompilation(true, reason, ctype);
                this.compilationQueued = true;
            } else if (!(!this.compilationStarted && (ctype == CompileType.ERROR_CHECK_ONLY || this.compilationQueuedExplicit) || this.requeueForCompilation && ctype != CompileType.ERROR_CHECK_ONLY)) {
                this.requeueForCompilation = true;
                this.requeueReason = reason;
                this.requeueType = ctype;
            }
        }
    }

    public List<Menu> getFXMenu() {
        return this.fxMenus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean showFile(String filename, Charset charset, boolean compiled, String docFilename) {
        this.filename = filename;
        this.docFilename = docFilename;
        this.characterSet = charset;
        boolean loaded = false;
        File file = new File(filename);
        if (filename != null) {
            this.setupJavadocMangler();
            try {
                String crashFilename = filename + CRASHFILE_SUFFIX;
                String backupFilename = crashFilename + "backup";
                File crashFile = new File(crashFilename);
                if (crashFile.exists()) {
                    File backupFile = new File(backupFilename);
                    backupFile.delete();
                    crashFile.renameTo(backupFile);
                    DialogManager.showMessageFX((Window)this.fxTabbedEditor.getStage(), (String)"editor-crashed", (String[])new String[0]);
                }
                this.ignoreChanges = true;
                this.document.replaceText(0, this.document.getLength(), Files.readString(file.toPath(), charset).replace("\r", "").replace("\t", "    "));
                this.setLastModified(file.lastModified());
                this.getSourcePane().positionCaret(0);
                this.undoManager.forgetHistory();
                if (this.sourceIsCode) {
                    this.javaSyntaxView.enableParser(false);
                }
                loaded = true;
            }
            catch (IOException ex) {
                Debug.reportError((String)"Couldn't open file", (Throwable)ex);
            }
            finally {
                this.ignoreChanges = false;
            }
        } else if (docFilename != null && new File(docFilename).exists()) {
            this.showInterface(true);
            loaded = true;
            this.interfaceToggle.setDisable(true);
        }
        if (!loaded) {
            return false;
        }
        this.setCompileStatus(compiled);
        return true;
    }

    private void setupJavadocMangler() {
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.htmlPane.getEngine().documentProperty(), doc -> {
            if (doc != null) {
                NodeList anchors = doc.getElementsByTagName("a");
                for (int i = 0; i < anchors.getLength(); ++i) {
                    org.w3c.dom.Node headerNode;
                    org.w3c.dom.Node liNode;
                    org.w3c.dom.Node ulNode;
                    org.w3c.dom.Node anchorItem = anchors.item(i);
                    org.w3c.dom.Node anchorName = anchorItem.getAttributes().getNamedItem("id");
                    if (anchorName == null || anchorName.getNodeValue() == null || !anchorName.getNodeValue().endsWith(")") || (ulNode = FlowEditor.findHTMLNode(anchorItem, org.w3c.dom.Node::getNextSibling, n -> "ul".equals(n.getLocalName()))) == null || (liNode = FlowEditor.findHTMLNode(ulNode.getFirstChild(), org.w3c.dom.Node::getNextSibling, n -> "li".equals(n.getLocalName()))) == null || (headerNode = FlowEditor.findHTMLNode(liNode.getFirstChild(), org.w3c.dom.Node::getNextSibling, n -> "h4".equals(n.getLocalName()))) == null) continue;
                    Element newLink = doc.createElement("a");
                    newLink.setAttribute("style", "padding-left: 2em;cursor:pointer;");
                    newLink.insertBefore(doc.createTextNode("[Show source in BlueJ]"), null);
                    headerNode.insertBefore(newLink, null);
                    ((EventTarget)((Object)newLink)).addEventListener("click", e -> {
                        String[] tokens = anchorName.getNodeValue().split("[(,)]");
                        ArrayList<String> paramTypes = new ArrayList<String>();
                        for (int t = 1; t < tokens.length; ++t) {
                            paramTypes.add(tokens[t]);
                        }
                        this.focusMethod(tokens[0].equals("<init>") ? this.windowTitle : tokens[0], paramTypes);
                    }, false);
                }
            }
        });
    }

    private static org.w3c.dom.Node findHTMLNode(org.w3c.dom.Node start, UnaryOperator<org.w3c.dom.Node> next, Predicate<org.w3c.dom.Node> stopWhen) {
        org.w3c.dom.Node n = start;
        while (n != null) {
            if ((n = (org.w3c.dom.Node)next.apply(n)) == null || !stopWhen.test(n)) continue;
            return n;
        }
        return null;
    }

    @Override
    public void clear() {
        this.document.replaceText(0, this.document.getLength(), "");
    }

    @Override
    public void insertText(String text, boolean caretBack) {
        int startPos = this.flowEditorPane.getSelectionStart();
        this.flowEditorPane.replaceSelection(text);
        if (caretBack) {
            this.flowEditorPane.positionCaret(startPos);
        }
    }

    @Override
    public void setSelection(SourceLocation begin, SourceLocation end) {
        this.flowEditorPane.select(this.document.getPosition(begin), this.document.getPosition(end));
    }

    @Override
    public SourceLocation getCaretLocation() {
        return this.document.makeSourceLocation(this.flowEditorPane.getCaretPosition());
    }

    @Override
    public void setCaretLocation(SourceLocation location) {
        this.flowEditorPane.positionCaret(this.document.getPosition(location));
    }

    @Override
    public SourceLocation getSelectionBegin() {
        return this.document.makeSourceLocation(this.flowEditorPane.getSelectionStart());
    }

    @Override
    public SourceLocation getSelectionEnd() {
        return this.document.makeSourceLocation(this.flowEditorPane.getSelectionEnd());
    }

    @Override
    public String getText(SourceLocation begin, SourceLocation end) {
        return this.document.getContent(this.document.getPosition(begin), this.document.getPosition(end)).toString();
    }

    @Override
    public void setText(SourceLocation begin, SourceLocation end, String newText) {
        this.document.replaceText(this.document.getPosition(begin), this.document.getPosition(end), newText);
    }

    @Override
    public SourceLocation getLineColumnFromOffset(int offset) {
        return this.document.makeSourceLocation(offset);
    }

    @Override
    public int getOffsetFromLineColumn(SourceLocation location) {
        return this.document.getPosition(location);
    }

    @Override
    public int getLineLength(int line) {
        return this.document.getLineLength(line);
    }

    @Override
    public int numberOfLines() {
        return this.document.getLineCount();
    }

    @Override
    public int getTextLength() {
        return this.document.getLength();
    }

    @Override
    public ParsedCUNode getParsedNode() {
        this.javaSyntaxView.flushReparseQueue();
        return this.javaSyntaxView.getParser();
    }

    @Override
    public ReparseableDocument getSourceDocument() {
        return this.javaSyntaxView;
    }

    @Override
    public void reloadFile() {
        this.doReload();
    }

    private void read(Reader reader) throws IOException {
        this.document.replaceText(0, this.document.getLength(), CharStreams.toString((Readable)reader).replace("\r", ""));
        this.getSourcePane().positionCaret(0);
        this.undoManager.forgetHistory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReload() {
        this.removeSearchHighlights();
        Reader reader = null;
        try {
            FileInputStream inputStream = new FileInputStream(this.filename);
            reader = new InputStreamReader((InputStream)inputStream, this.characterSet);
            this.read(reader);
            try {
                reader.close();
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            File file = new File(this.filename);
            this.setLastModified(file.lastModified());
            if (this.sourceIsCode) {
                this.enableParser(false);
            }
            this.saveState.setState(StatusLabel.Status.SAVED);
            this.setChanged();
            this.setSaved();
            this.scheduleCompilation(CompileReason.LOADED, CompileType.ERROR_CHECK_ONLY);
        }
        catch (FileNotFoundException ex) {
            this.info.message(Config.getString((String)"editor.info.fileDisappeared"));
        }
        catch (IOException ex) {
            this.info.message(Config.getString((String)"editor.info.fileReadError"));
            this.setChanged();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {}
            if (this.finder != null && this.finder.isVisible()) {
                this.findNext(false);
            }
        }
    }

    @Override
    public void setEditorVisible(boolean vis, boolean openInNewWindow) {
        FXTabbedEditor fxTabbedEditor;
        boolean becameVisible = false;
        FXTabbedEditor tabParent = this.fxTab.getParent();
        if (!vis && tabParent == null) {
            return;
        }
        if (vis && (openInNewWindow || tabParent == null)) {
            if (tabParent != null) {
                tabParent.close(this.fxTab);
            }
            fxTabbedEditor = this.fetchTabbedEditor.getFXTabbedEditor(openInNewWindow);
            becameVisible = fxTabbedEditor.addTab(this.fxTab, vis, true);
        } else {
            fxTabbedEditor = tabParent;
        }
        boolean bl = becameVisible = fxTabbedEditor.setWindowVisible(vis, this.fxTab) || becameVisible;
        if (vis) {
            fxTabbedEditor.bringToFront(this.fxTab);
            if (becameVisible) {
                if (this.callbackOnOpen != null) {
                    this.callbackOnOpen.run();
                }
                this.checkBracketStatus();
                if (this.sourceIsCode && !this.compiledProperty.get()) {
                    this.scheduleCompilation(CompileReason.LOADED, CompileType.ERROR_CHECK_ONLY);
                }
            }
            this.getSourcePane().ensureCaretShowing();
            this.requestLayout();
        } else if (tabParent != null) {
            tabParent.close(this.fxTab);
        }
    }

    private void checkBracketStatus() {
        boolean matchBrackets = PrefMgr.getFlag((String)"bluej.editor.matchBrackets");
        if (matchBrackets) {
            this.doBracketMatch();
        } else {
            this.removeBracketHighlight();
        }
    }

    @Override
    public boolean isOpen() {
        return this.fxTabbedEditor != null && this.fxTabbedEditor.isWindowVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws IOException {
        Throwable failureException = null;
        if (this.saveState.isChanged() && this.filename != null) {
            this.recordEdit(true);
            if (PrefMgr.getFlag((String)"bluej.editor.checkDiskFileChanges")) {
                this.checkForChangeOnDisk();
            }
            if (!this.saveState.isChanged()) {
                return;
            }
            Writer writer = null;
            try {
                String crashFilename = this.filename + CRASHFILE_SUFFIX;
                FileUtility.copyFile((String)this.filename, (String)crashFilename);
                BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(this.filename));
                writer = new OutputStreamWriter((OutputStream)ostream, this.characterSet);
                this.getSourcePane().write(writer);
                writer.close();
                writer = null;
                this.setLastModified(new File(this.filename).lastModified());
                File crashFile = new File(crashFilename);
                crashFile.delete();
                this.setSaved();
            }
            catch (IOException ex) {
                failureException = ex;
                this.info.message(Config.getString((String)"editor.info.errorSaving") + " - " + ex.getLocalizedMessage());
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ex) {
                    failureException = ex;
                }
            }
        }
        if (failureException != null) {
            this.info.message(Config.getString((String)"editor.info.errorSaving") + " - " + failureException.getLocalizedMessage());
            throw failureException;
        }
    }

    private void setSaved() {
        this.saveState.setState(StatusLabel.Status.SAVED);
        if (this.watcher != null) {
            this.watcher.saveEvent(this);
        }
    }

    private void recordEdit(boolean includeOneLineEdits) {
        if (this.watcher != null) {
            this.watcher.recordJavaEdit(this.document.getFullContent(), includeOneLineEdits);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void close() {
        this.cancelFreshState();
        try {
            this.save();
        }
        catch (IOException ioe) {
            DialogManager.showErrorTextFX((Window)this.getWindow(), (String)"Error saving source code");
        }
        this.doClose();
    }

    public void doClose() {
        this.setEditorVisible(false, false);
        if (this.watcher != null) {
            this.watcher.closeEvent(this);
        }
    }

    @Override
    public void refresh() {
        this.checkBracketStatus();
        this.javaSyntaxView.recalculateAndApplyAllScopes();
    }

    @Override
    public void displayMessage(String message, int lineNumber, int column) {
        this.switchToSourceView();
        int lineStart = this.document.getLineStart(lineNumber - 1);
        int lineEnd = this.document.getLineEnd(lineNumber - 1);
        this.getSourcePane().positionCaret(lineStart);
        this.getSourcePane().moveCaret(lineEnd - 1);
        this.info.messageImportant(message);
    }

    @Override
    public boolean displayDiagnostic(Diagnostic diagnostic, int errorIndex, CompileType compileType) {
        if (compileType.showEditorOnError()) {
            this.setEditorVisible(true, false);
        }
        this.switchToSourceView();
        if (diagnostic.getStartLine() >= 0L && diagnostic.getStartLine() < (long)this.document.getLineCount()) {
            int startPos = this.document.getPosition(new SourceLocation((int)diagnostic.getStartLine(), (int)diagnostic.getStartColumn()));
            int endPos = diagnostic.getStartLine() != diagnostic.getEndLine() ? this.document.getLineEnd((int)diagnostic.getStartLine()) : this.document.getPosition(new SourceLocation((int)diagnostic.getStartLine(), (int)diagnostic.getEndColumn()));
            if (endPos == startPos) {
                if (endPos < this.getTextLength() - 1 && !this.document.getContent(endPos, endPos + 1).equals("\n")) {
                    ++endPos;
                } else if (startPos > 0 && !this.document.getContent(startPos - 1, startPos).equals("\n")) {
                    --startPos;
                }
            }
            this.errorManager.addErrorHighlight(startPos, endPos, diagnostic.getMessage(), diagnostic.getIdentifier());
        }
        return true;
    }

    private void switchToSourceView() {
        if (!this.viewingHTML.get()) {
            return;
        }
        this.resetMenuToolbar(true);
        this.viewingHTML.set(false);
        this.interfaceToggle.getSelectionModel().selectFirst();
        this.watcher.showingInterface(false);
        this.clearMessage();
        this.flowEditorPane.requestFocus();
    }

    private void switchToInterfaceView() {
        if (this.viewingHTML.get()) {
            return;
        }
        this.resetMenuToolbar(false);
        try {
            boolean generateDoc;
            this.save();
            this.info.message(Config.getString((String)"editor.info.loadingDoc"));
            boolean bl = generateDoc = !this.docUpToDate();
            if (generateDoc) {
                this.info.message(Config.getString((String)"editor.info.generatingDoc"));
                BlueJEvent.addListener((BlueJEventListener)this);
                if (this.watcher != null) {
                    this.watcher.generateDoc();
                }
            } else {
                this.refreshHtmlDisplay();
            }
            this.interfaceToggle.getSelectionModel().selectLast();
            this.viewingHTML.set(true);
            this.watcher.showingInterface(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void blueJEvent(int eventId, Object arg, Project prj) {
        switch (eventId) {
            case 7: {
                BlueJEvent.removeListener((BlueJEventListener)this);
                this.refreshHtmlDisplay();
                break;
            }
            case 8: {
                BlueJEvent.removeListener((BlueJEventListener)this);
                this.info.message(Config.getString((String)"editor.info.docAborted"));
            }
        }
    }

    private boolean docUpToDate() {
        if (this.filename == null) {
            return true;
        }
        try {
            File src = new File(this.filename);
            File doc = new File(this.docFilename);
            if (!doc.exists() || src.exists() && src.lastModified() > doc.lastModified()) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void refreshHtmlDisplay() {
        try {
            File urlFile = new File(this.docFilename);
            if (!urlFile.exists()) {
                return;
            }
            URL myURL = urlFile.toURI().toURL();
            String location = this.htmlPane.getEngine().getLocation();
            if (Objects.equals(location == null ? null : new URL(location), myURL)) {
                this.htmlPane.getEngine().reload();
            } else {
                this.htmlPane.getEngine().load(myURL.toString());
            }
            this.info.message(Config.getString((String)"editor.info.docLoaded"));
        }
        catch (IOException exc) {
            this.info.message(Config.getString((String)"editor.info.docDisappeared"), this.docFilename);
            Debug.reportError((String)("loading class interface failed: " + exc));
        }
    }

    public void clearMessage() {
        this.info.clear();
    }

    private void resetMenuToolbar(boolean sourceView) {
        if (sourceView) {
            this.actions.makeAllAvailable();
        } else {
            this.actions.makeAllUnavailableExcept("close", "toggle-interface-view");
        }
    }

    @Override
    public boolean setStepMark(int lineNumber, String message, boolean isBreak, DebuggerThread thread) {
        this.switchToSourceView();
        this.removeStepMark();
        this.currentStepLineIndex = lineNumber - 1;
        this.flowEditorPane.setLineMarginGraphics(this.currentStepLineIndex, this.calculateMarginDisplay(this.currentStepLineIndex));
        this.flowEditorPane.applyScopeBackgrounds(this.javaSyntaxView.getScopeBackgrounds());
        this.flowEditorPane.positionCaret(this.getOffsetFromLineColumn(new SourceLocation(lineNumber, 1)));
        if (message != null) {
            this.info.messageImportant(message);
        }
        return false;
    }

    private EnumSet<MarginAndTextLine.MarginDisplay> calculateMarginDisplay(int lineIndex) {
        EnumSet<MarginAndTextLine.MarginDisplay> r = EnumSet.noneOf(MarginAndTextLine.MarginDisplay.class);
        if (PrefMgr.getFlag((String)"bluej.editor.displayLineNumbers")) {
            r.add(MarginAndTextLine.MarginDisplay.LINE_NUMBER);
        }
        if (this.breakpoints.get(lineIndex)) {
            r.add(MarginAndTextLine.MarginDisplay.BREAKPOINT);
        }
        if (lineIndex == this.currentStepLineIndex) {
            r.add(MarginAndTextLine.MarginDisplay.STEP_MARK);
        }
        if (this.errorManager.getErrorOnLine(lineIndex) != null) {
            r.add(MarginAndTextLine.MarginDisplay.ERROR);
        }
        if (!this.compiledProperty.get()) {
            r.add(MarginAndTextLine.MarginDisplay.UNCOMPILED);
        }
        return r;
    }

    @Override
    public void writeMessage(String msg) {
        this.info.message(msg);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void removeStepMark() {
        if (this.currentStepLineIndex != -1) {
            int oldStepLine = this.currentStepLineIndex;
            this.currentStepLineIndex = -1;
            this.flowEditorPane.setLineMarginGraphics(oldStepLine, this.calculateMarginDisplay(oldStepLine));
            this.flowEditorPane.applyScopeBackgrounds(this.javaSyntaxView.getScopeBackgrounds());
        }
    }

    @Override
    public void changeName(String title, String filename, String javaFilename, String docFilename) {
        this.filename = filename;
        this.docFilename = docFilename;
        this.windowTitle = title;
        this.setWindowTitle();
    }

    private void setWindowTitle() {
        String title = this.windowTitle;
        if (title == null) {
            title = this.filename == null ? "<no name>" : this.filename;
        }
        this.fxTab.setWindowTitle(title);
    }

    @Override
    public void setCompiled(boolean compiled) {
        this.setCompileStatus(compiled);
        if (compiled) {
            this.removeErrorHighlights();
        }
    }

    private void setCompileStatus(boolean compiled) {
        this.actions.getActionByName("toggle-breakpoint").setEnabled(compiled && this.viewingCode());
        this.compiledProperty.set(compiled);
    }

    private boolean viewingCode() {
        return this.sourceIsCode && !this.viewingHTML.get();
    }

    @Override
    public boolean compileStarted(int compilationSequence) {
        this.compilationStarted = true;
        this.removeErrorHighlights();
        return false;
    }

    @Override
    public void removeErrorHighlights() {
        this.errorManager.removeAllErrorHighlights();
    }

    @Override
    public void compileFinished(boolean successful, boolean classesKept) {
        this.compilationStarted = false;
        if (this.requeueForCompilation) {
            this.requeueForCompilation = false;
            if (classesKept) {
                this.compilationQueued = false;
            } else {
                this.compilationQueuedExplicit = this.requeueType != CompileType.ERROR_CHECK_ONLY;
                this.watcher.scheduleCompilation(true, this.requeueReason, this.requeueType);
            }
        } else {
            this.compilationQueued = false;
        }
        if (classesKept) {
            if (successful) {
                this.info.messageImportant(Config.getString((String)"editor.info.compiled"));
            } else {
                this.info.messageImportant(this.getCompileErrorLabel());
            }
        }
    }

    private String getCompileErrorLabel() {
        return Config.getString((String)"editor.info.compileError").replace("$", this.actions.getKeyStrokesForAction("compile").stream().map(KeyCodeCombination::getDisplayText).collect(Collectors.joining(" " + Config.getString((String)"or") + " ")));
    }

    @Override
    public void removeBreakpoints() {
        JavaFXUtil.runAfterCurrent(() -> this.clearAllBreakpoints());
    }

    private void clearAllBreakpoints() {
        if (this.mayHaveBreakpoints) {
            this.breakpoints.clear();
            for (int lineIndex = 0; lineIndex < this.document.getLineCount(); ++lineIndex) {
                this.flowEditorPane.setLineMarginGraphics(lineIndex, this.calculateMarginDisplay(lineIndex));
            }
            this.flowEditorPane.applyScopeBackgrounds(this.javaSyntaxView.getScopeBackgrounds());
            this.mayHaveBreakpoints = false;
        }
    }

    @Override
    public void reInitBreakpoints() {
        if (this.mayHaveBreakpoints) {
            this.mayHaveBreakpoints = false;
            for (int i = 1; i <= this.numberOfLines(); ++i) {
                if (!this.breakpoints.get(i) || this.watcher == null) continue;
                boolean wasSet = this.watcher.breakpointToggleEvent(i + 1, true);
                this.breakpoints.set(i, wasSet);
                if (!wasSet) continue;
                this.mayHaveBreakpoints = true;
            }
        }
        this.flowEditorPane.applyScopeBackgrounds(this.javaSyntaxView.getScopeBackgrounds());
    }

    public void textReplaced(int origStartIncl, String replaced, String replacement, int linesRemoved, int linesAdded) {
        if (this.respondingToChange) {
            return;
        }
        this.respondingToChange = true;
        if (!this.ignoreChanges && !this.saveState.isChanged()) {
            this.saveState.setState(StatusLabel.Status.CHANGED);
            this.setChanged();
        }
        if (!(this.ignoreChanges || linesRemoved <= 0 && linesAdded <= 0)) {
            this.saveState.setState(StatusLabel.Status.CHANGED);
            this.setChanged();
            if (this.sourceIsCode && this.watcher != null) {
                this.scheduleCompilation(CompileReason.MODIFIED, CompileType.ERROR_CHECK_ONLY);
            }
        }
        this.clearMessage();
        JavaFXUtil.runAfterCurrent(() -> {
            this.removeSearchHighlights();
            this.currentSearchResult.setValue(null);
            this.removeErrorHighlights();
            this.showErrorOverlay(null, 0);
        });
        this.actions.userAction();
        if ("}".equals(replacement) && PrefMgr.getFlag((String)"bluej.editor.autoIndent")) {
            JavaFXUtil.runAfterCurrent(() -> {
                if (origStartIncl + replacement.length() <= this.document.getLength() && replacement.equals("}")) {
                    this.actions.closingBrace(origStartIncl);
                }
            });
        }
        this.recordEdit(false);
        this.respondingToChange = false;
        this.flowEditorPane.textChanged();
    }

    private void setChanged() {
        if (this.ignoreChanges) {
            return;
        }
        this.setCompileStatus(false);
        if (this.watcher != null) {
            this.watcher.modificationEvent(this);
        }
    }

    @Override
    public boolean isModified() {
        return this.saveState.isChanged();
    }

    @Override
    public boolean isReadOnly() {
        return !this.getSourcePane().isEditable();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.saveState.setState(StatusLabel.Status.READONLY);
        }
        this.getSourcePane().setEditable(!readOnly);
    }

    @Override
    public void showInterface(boolean interfaceStatus) {
        this.interfaceToggle.getSelectionModel().select(interfaceStatus ? 1 : 0);
    }

    @Override
    public Object getProperty(String propertyKey) {
        return this.propertyMap.get(propertyKey);
    }

    @Override
    public void setProperty(String propertyKey, Object value) {
        if (propertyKey == null) {
            return;
        }
        this.propertyMap.put(propertyKey, value);
    }

    @Override
    public TextEditor assumeText() {
        return this;
    }

    @Override
    public FrameEditor assumeFrame() {
        return null;
    }

    @Override
    public void insertAppendMethod(NormalMethodElement method, FXPlatformConsumer<Boolean> after) {
        NodeTree.NodeAndPosition<ParsedNode> classNode = this.findClassNode();
        if (classNode != null) {
            NodeTree.NodeAndPosition<ParsedNode> existingMethodNode = this.findMethodNode(method.getName(), classNode);
            if (existingMethodNode != null) {
                Object text = "";
                for (CodeElement codeElement : method.getContents()) {
                    text = (String)text + codeElement.toJavaSource().toTemporaryJavaCodeString();
                }
                this.appendTextToNode(existingMethodNode, (String)text);
                after.accept((Object)false);
                return;
            }
            this.appendTextToNode(classNode, method.toJavaSource().toTemporaryJavaCodeString());
            after.accept((Object)true);
        }
        after.accept((Object)false);
    }

    @Override
    public void insertMethodCallInConstructor(String className, CallElement callElement, FXPlatformConsumer<Boolean> after) {
        NodeTree.NodeAndPosition<ParsedNode> classNode = this.findClassNode();
        if (classNode != null) {
            NodeTree.NodeAndPosition<ParsedNode> constructor = this.findMethodNode(className, classNode);
            if (constructor == null) {
                this.addDefaultConstructor(className, callElement);
            } else {
                String methodName = callElement.toJavaSource().toTemporaryJavaCodeString();
                if (!this.hasMethodCall(methodName = methodName.substring(0, methodName.indexOf(40)), constructor, true)) {
                    this.appendTextToNode(constructor, callElement.toJavaSource().toTemporaryJavaCodeString());
                    after.accept((Object)true);
                    return;
                }
            }
        }
        after.accept((Object)false);
    }

    private void addDefaultConstructor(String className, CallElement callElement) {
        NodeTree.NodeAndPosition<ParsedNode> classNode = this.findClassNode();
        if (classNode != null) {
            this.appendTextToNode(classNode, "public " + className + "()\n{\n" + callElement.toJavaSource().toTemporaryJavaCodeString() + "}\n");
        }
    }

    private void appendTextToNode(NodeTree.NodeAndPosition<ParsedNode> node, String text) {
        for (int pos = node.getEnd() - 1; pos >= 0; --pos) {
            if (!"}".equals(this.getText(this.getLineColumnFromOffset(pos), this.getLineColumnFromOffset(pos + 1)))) continue;
            int posFinal = pos;
            this.undoManager.compoundEdit(() -> {
                int originalLength = node.getSize();
                this.setText(this.getLineColumnFromOffset(posFinal), this.getLineColumnFromOffset(posFinal), text);
                int oldPos = this.getSourcePane().getCaretPosition();
                FlowIndent.calculateIndentsAndApply(this.getSourceDocument(), this.document, node.getPosition(), node.getPosition() + originalLength + text.length(), oldPos);
            });
            this.setCaretLocation(this.getLineColumnFromOffset(pos));
            return;
        }
        Debug.message((String)("Could not find end of node to append to: \"" + this.getText(this.getLineColumnFromOffset(node.getPosition()), this.getLineColumnFromOffset(node.getEnd())) + "\""));
    }

    private NodeTree.NodeAndPosition<ParsedNode> findClassNode() {
        NodeTree.NodeAndPosition root = new NodeTree.NodeAndPosition((RBTreeNode)this.getParsedNode(), 0, this.getParsedNode().getSize());
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable((NodeTree.NodeAndPosition<ParsedNode>)root)) {
            if (((ParsedNode)nap.getNode()).getNodeType() != 1) continue;
            return nap;
        }
        return null;
    }

    private NodeTree.NodeAndPosition<ParsedNode> findMethodNode(String methodName, NodeTree.NodeAndPosition<ParsedNode> start) {
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable(start)) {
            NodeTree.NodeAndPosition<ParsedNode> r;
            if (((ParsedNode)nap.getNode()).getNodeType() == 0 && (r = this.findMethodNode(methodName, nap)) != null) {
                return r;
            }
            if (((ParsedNode)nap.getNode()).getNodeType() != 2 || !((ParsedNode)nap.getNode()).getName().equals(methodName)) continue;
            return nap;
        }
        return null;
    }

    private boolean hasMethodCall(String methodName, NodeTree.NodeAndPosition<ParsedNode> methodNode, boolean root) {
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable(methodNode)) {
            if (((ParsedNode)nap.getNode()).getNodeType() == 0 && root) {
                return this.hasMethodCall(methodName, nap, false);
            }
            if (((ParsedNode)nap.getNode()).getNodeType() != 6 || !this.document.getContent(nap.getPosition(), nap.getPosition() + nap.getSize()).toString().startsWith(methodName)) continue;
            return true;
        }
        return false;
    }

    private Iterable<NodeTree.NodeAndPosition<ParsedNode>> iterable(NodeTree.NodeAndPosition<ParsedNode> parent) {
        return () -> ((ParsedNode)parent.getNode()).getChildren(parent.getPosition());
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void focusMethod(String methodName, List<String> paramTypes) {
        this.focusMethod(methodName, paramTypes, (NodeTree.NodeAndPosition<ParsedNode>)new NodeTree.NodeAndPosition((RBTreeNode)this.getParsedNode(), 0, 0), 0);
    }

    private boolean focusMethod(String methodName, List<String> paramTypes, NodeTree.NodeAndPosition<ParsedNode> tree, int offset) {
        if (((ParsedNode)tree.getNode()).getNodeType() == 2 && methodName.equals(((ParsedNode)tree.getNode()).getName()) && this.paramsMatch((ParsedNode)tree.getNode(), paramTypes)) {
            this.switchToSourceView();
            this.flowEditorPane.positionCaret(offset);
            return true;
        }
        for (NodeTree.NodeAndPosition child : () -> ((ParsedNode)tree.getNode()).getChildren(0)) {
            if (!this.focusMethod(methodName, paramTypes, (NodeTree.NodeAndPosition<ParsedNode>)child, offset + child.getPosition())) continue;
            return true;
        }
        return false;
    }

    private boolean paramsMatch(ParsedNode node, List<String> paramTypes) {
        if (paramTypes == null) {
            return true;
        }
        if (node instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)node;
            if (methodNode.getParamTypes().size() != paramTypes.size()) {
                return false;
            }
            for (int i = 0; i < paramTypes.size(); ++i) {
                JavaEntity paramType = (JavaEntity)methodNode.getParamTypes().get(i);
                if (paramType.getName().equals(paramTypes.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setExtendsClass(String className, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                if (info.getSuperclass() == null) {
                    Selection s1 = info.getExtendsInsertSelection();
                    this.setSelection(new SourceLocation(s1.getLine(), s1.getColumn()), new SourceLocation(s1.getEndLine(), s1.getEndColumn()));
                    this.insertText(" extends " + className, false);
                } else {
                    Selection s1 = info.getSuperReplaceSelection();
                    this.setSelection(new SourceLocation(s1.getLine(), s1.getColumn()), new SourceLocation(s1.getEndLine(), s1.getEndColumn()));
                    this.insertText(className, false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            DialogManager.showMessageWithTextFX((Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage());
        }
    }

    @Override
    public void removeExtendsClass(ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = info.getExtendsReplaceSelection();
                s1.combineWith(info.getSuperReplaceSelection());
                if (s1 != null) {
                    this.setSelection(new SourceLocation(s1.getLine(), s1.getColumn()), new SourceLocation(s1.getEndLine(), s1.getEndColumn()));
                    this.insertText("", false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            DialogManager.showMessageWithTextFX((Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage());
        }
    }

    @Override
    public void addImplements(String interfaceName, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = info.getImplementsInsertSelection();
                this.setSelection(new SourceLocation(s1.getLine(), s1.getColumn()), new SourceLocation(s1.getEndLine(), s1.getEndColumn()));
                if (info.hasInterfaceSelections()) {
                    List<String> exists = this.getInterfaceTexts(info.getInterfaceSelections());
                    if (!exists.contains(interfaceName)) {
                        this.insertText(", " + interfaceName, false);
                    }
                } else {
                    this.insertText(" implements " + interfaceName, false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            DialogManager.showMessageWithTextFX((Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage());
        }
    }

    private List<String> getInterfaceTexts(List<Selection> selections) {
        ArrayList<String> r = new ArrayList<String>(selections.size());
        for (Selection sel : selections) {
            String text = this.getText(new SourceLocation(sel.getLine(), sel.getColumn()), new SourceLocation(sel.getEndLine(), sel.getEndColumn()));
            int taIndex = text.indexOf(60);
            if (taIndex != -1) {
                text = text.substring(0, taIndex);
            }
            text = text.trim();
            r.add(text);
        }
        return r;
    }

    @Override
    public void addExtendsInterface(String interfaceName, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = info.getExtendsInsertSelection();
                this.setSelection(new SourceLocation(s1.getLine(), s1.getColumn()), new SourceLocation(s1.getEndLine(), s1.getEndColumn()));
                if (info.hasInterfaceSelections()) {
                    List<String> exists = this.getInterfaceTexts(info.getInterfaceSelections());
                    if (!exists.contains(interfaceName)) {
                        this.insertText(", " + interfaceName, false);
                    }
                } else {
                    this.insertText(" extends " + interfaceName, false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            DialogManager.showMessageWithTextFX((Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage());
        }
    }

    @Override
    public void removeExtendsOrImplementsInterface(String interfaceName, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = null;
                List vsels = info.getInterfaceSelections();
                List<String> vtexts = this.getInterfaceTexts(vsels);
                int where = vtexts.indexOf(interfaceName);
                if (where == 1 && vsels.size() > 2) {
                    where = 2;
                }
                if (where > 0) {
                    s1 = (Selection)vsels.get(where - 1);
                    s1.combineWith((Selection)vsels.get(where));
                }
                if (s1 != null) {
                    this.setSelection(new SourceLocation(s1.getLine(), s1.getColumn()), new SourceLocation(s1.getEndLine(), s1.getEndColumn()));
                    this.insertText("", false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            DialogManager.showMessageWithTextFX((Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage());
        }
    }

    @Override
    public EditorFixesManager getEditorFixesManager() {
        return this.editorFixesMgr;
    }

    @Override
    public void addImportFromQuickFix(String importName) {
        int importOffset = 0;
        int currentCaretPos = this.flowEditorPane.getSelectionStart();
        List<CharSequence> docLines = this.document.getLines();
        boolean isLineAfterImportBlank = docLines.get(0).toString().isBlank();
        SourceLocation errorSourceLocation = this.getLineColumnFromOffset(currentCaretPos);
        String beforeErrorLineContent = this.getText(new SourceLocation(1, 1), errorSourceLocation);
        boolean isErrorInImportStatement = this.checkCodeIsOnImportStatement(beforeErrorLineContent);
        if (isErrorInImportStatement) {
            int errorImportStatementStartIndex = beforeErrorLineContent.lastIndexOf("import ");
            String afterErrorLineContent = this.getText(errorSourceLocation, this.getLineColumnFromOffset(this.getTextLength()));
            int errorImportStatementEndIndex = afterErrorLineContent.indexOf(";");
            String fullImportStr = "import " + importName;
            this.flowEditorPane.select(currentCaretPos - (beforeErrorLineContent.length() - errorImportStatementStartIndex), currentCaretPos + errorImportStatementEndIndex);
            this.insertText(fullImportStr, false);
        } else {
            boolean hasPackage;
            boolean hasImports = docLines.stream().filter(charSequence -> charSequence.toString().startsWith("import ")).count() > 0L;
            boolean bl = hasPackage = docLines.stream().filter(charSequence -> charSequence.toString().startsWith("package ")).count() > 0L;
            if (hasImports || hasPackage) {
                boolean passedImport = false;
                boolean passedPackage = false;
                for (CharSequence charseq : docLines) {
                    boolean isLineImport = charseq.toString().startsWith("import ");
                    boolean isLinePackage = charseq.toString().startsWith("package ");
                    if (hasImports && !isLineImport && (passedImport |= isLineImport) || !hasImports && (passedPackage |= isLinePackage) && !isLinePackage) {
                        isLineAfterImportBlank = charseq.toString().isBlank();
                        break;
                    }
                    importOffset += charseq.length() + 1;
                }
            }
            String fullImportStr = "import " + importName + (isLineAfterImportBlank ? ";\n" : ";\n\n");
            this.flowEditorPane.select(importOffset, importOffset);
            this.insertText(fullImportStr, false);
            int newCaretPos = currentCaretPos >= importOffset ? currentCaretPos + fullImportStr.length() : currentCaretPos;
            this.flowEditorPane.select(newCaretPos, newCaretPos);
        }
        this.refresh();
    }

    @Override
    public void removeImports(List<String> importTargets) {
        ArrayList<ImportsCollection.LocatableImport> toRemove = new ArrayList<ImportsCollection.LocatableImport>();
        for (String importTarget : importTargets) {
            ImportsCollection.LocatableImport details = this.getParsedNode().getImports().getImportInfo(importTarget);
            if (details == null) continue;
            toRemove.add(details);
        }
        Collections.sort(toRemove, Comparator.comparingInt(t -> -t.getStart()));
        for (ImportsCollection.LocatableImport locatableImport : toRemove) {
            if (locatableImport.getStart() == -1) continue;
            this.document.replaceText(locatableImport.getStart(), locatableImport.getStart() + locatableImport.getLength(), "");
        }
    }

    private boolean checkCodeIsOnImportStatement(String code) {
        JavaLexer l = new JavaLexer((Reader)new StringReader(code));
        boolean isInImportStatement = false;
        LocatableToken t = l.nextToken();
        while (t.getType() != 1 && t.getType() != 101 && t.getType() != 102 && t.getType() != 103) {
            switch (t.getType()) {
                case 64: {
                    isInImportStatement = true;
                    break;
                }
                case 63: {
                    if (!isInImportStatement) break;
                    isInImportStatement = false;
                    break;
                }
            }
            t = l.nextToken();
        }
        return isInImportStatement;
    }

    public boolean checkTypeIsImported(AssistContentThreadSafe type, boolean checkStrictInnerTypeImport) {
        if (type.getPackage().equals("java.lang")) {
            return true;
        }
        ArrayList<String> userCodeImportsList = new ArrayList<String>();
        boolean parsingUserCodeImport = false;
        StringBuilder userCodeImportSB = new StringBuilder();
        JavaLexer l = new JavaLexer((Reader)new StringReader(this.getText(new SourceLocation(1, 1), this.getLineColumnFromOffset(this.getTextLength()))));
        LocatableToken t = l.nextToken();
        while (t.getType() != 1 && t.getType() != 101 && t.getType() != 102 && t.getType() != 103) {
            switch (t.getType()) {
                case 64: {
                    parsingUserCodeImport = true;
                    break;
                }
                case 63: {
                    if (!parsingUserCodeImport) break;
                    userCodeImportsList.add(userCodeImportSB.toString());
                    userCodeImportSB.setLength(0);
                    parsingUserCodeImport = false;
                    break;
                }
                case 61: {
                    break;
                }
                default: {
                    if (!parsingUserCodeImport) break;
                    userCodeImportSB.append(t.getText());
                }
            }
            t = l.nextToken();
        }
        return type.getDeclaringClass() == null && userCodeImportsList.contains(type.getPackage() + "." + type.getName()) || type.getDeclaringClass() != null && !checkStrictInnerTypeImport && userCodeImportsList.contains(type.getPackage() + "." + type.getDeclaringClass()) || type.getDeclaringClass() != null && userCodeImportsList.contains(type.getPackage() + "." + type.getDeclaringClass() + ".*") || type.getDeclaringClass() != null && userCodeImportsList.contains(type.getPackage() + "." + type.getDeclaringClass() + "." + type.getName()) || !checkStrictInnerTypeImport && userCodeImportsList.contains(type.getPackage() + ".*");
    }

    @Override
    public void setHeaderImage(Image image) {
        this.fxTab.setHeaderImage(image);
    }

    public void toggleInterface() {
        if (this.viewingHTML.get()) {
            this.switchToSourceView();
        } else {
            this.switchToInterfaceView();
        }
    }

    @Override
    public void setLastModified(long millisSinceEpoch) {
        this.lastModified = millisSinceEpoch;
    }

    public FlowEditorPane getSourcePane() {
        return this.flowEditorPane;
    }

    public void compileOrShowNextError() {
        if (this.watcher != null) {
            if (this.saveState.isChanged() || !this.errorManager.hasErrorHighlights()) {
                this.scheduleCompilation(CompileReason.USER, CompileType.EXPLICIT_USER_COMPILE);
            } else {
                FlowErrorManager.ErrorDetails err = this.errorManager.getNextErrorPos(this.flowEditorPane.getCaretPosition());
                if (err != null) {
                    this.flowEditorPane.positionCaret(err.startPos);
                    if (PrefMgr.getFlag((String)"bluej.accessibility.support")) {
                        this.errorListPane.setManaged(true);
                        this.errorListPane.setVisible(true);
                        this.errorList.getSelectionModel().select((Object)err);
                        this.errorList.requestFocus();
                    }
                }
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public Window getWindow() {
        if (this.fxTabbedEditor == null) {
            return null;
        }
        return this.fxTabbedEditor.getStage();
    }

    public void showPreferences(int paneIndex) {
        this.watcher.showPreferences(paneIndex);
    }

    public void goToLine() {
        int numberOfLines = this.numberOfLines();
        GoToLineDialog goToLineDialog = new GoToLineDialog((Window)this.fxTabbedEditor.getStage());
        goToLineDialog.setRangeMax(numberOfLines);
        Optional o = goToLineDialog.showAndWait();
        o.ifPresent(n -> this.setSelection(new SourceLocation(n.intValue(), 1), new SourceLocation(n.intValue(), 1)));
    }

    void updateHeaderHasErrors(boolean hasErrors) {
        this.fxTab.setErrorStatus(hasErrors);
    }

    FindNavigator doFind(final String searchFor, final boolean ignoreCase) {
        this.removeSearchHighlights();
        this.flowEditorPane.positionCaret(this.flowEditorPane.getSelectionStart());
        this.lastSearchString = searchFor;
        String content = this.document.getFullContent();
        int curPosition = 0;
        boolean finished = false;
        final ArrayList<Integer> foundStarts = new ArrayList<Integer>();
        while (!finished) {
            int foundPos = FindNavigator.findSubstring(content, searchFor, ignoreCase, false, curPosition);
            if (foundPos != -1) {
                foundStarts.add(foundPos);
                curPosition = foundPos + searchFor.length();
                continue;
            }
            finished = true;
        }
        this.currentSearchResult.set((Object)(foundStarts.isEmpty() ? null : new FindNavigator(){

            @Override
            public void highlightAll() {
                FlowEditor.this.findResults.clear();
                FlowEditor.this.findResults.addAll(Utility.mapList((Collection)foundStarts, foundPos -> new int[]{foundPos, foundPos + searchFor.length()}));
                FlowEditor.this.flowEditorPane.showHighlights(TextLine.HighlightType.FIND_RESULT, FlowEditor.this.findResults);
            }

            @Override
            public FindNavigator replaceCurrent(String replacement) {
                if (!FlowEditor.this.flowEditorPane.getSelectedText().equals(searchFor)) {
                    this.selectNext(true);
                }
                int pos = FlowEditor.this.flowEditorPane.getSelectionStart();
                FlowEditor.this.document.replaceText(pos, pos + searchFor.length(), replacement);
                FlowEditor.this.flowEditorPane.positionCaret(pos + searchFor.length());
                return FlowEditor.this.doFind(searchFor, ignoreCase);
            }

            @Override
            public void replaceAll(String replacement) {
                foundStarts.stream().sorted(Comparator.reverseOrder()).forEach(pos -> FlowEditor.this.document.replaceText((int)pos, pos + searchFor.length(), replacement));
            }

            @Override
            public void selectNext(boolean canBeAtCurrentPos) {
                if (this.validProperty().get()) {
                    int selStart = FlowEditor.this.flowEditorPane.getSelectionStart();
                    int position = foundStarts.stream().filter(pos -> pos > selStart || canBeAtCurrentPos && pos == selStart).findFirst().orElse((Integer)foundStarts.get(0));
                    this.select(position);
                }
            }

            private void select(int position) {
                FlowEditor.this.flowEditorPane.select(position, position + searchFor.length());
            }

            @Override
            public void selectPrev() {
                if (this.validProperty().get()) {
                    int selStart = FlowEditor.this.flowEditorPane.getSelectionStart();
                    int position = Utility.streamReversed((List)foundStarts).filter(pos -> pos < selStart).findFirst().orElse((Integer)foundStarts.get(foundStarts.size() - 1));
                    this.select(position);
                }
            }

            @Override
            public BooleanExpression validProperty() {
                return FlowEditor.this.currentSearchResult.isEqualTo((Object)this);
            }
        }));
        return (FindNavigator)this.currentSearchResult.get();
    }

    public void removeSearchHighlights() {
        this.findResults.clear();
        this.flowEditorPane.showHighlights(TextLine.HighlightType.FIND_RESULT, List.of());
    }

    public void initFindPanel() {
        this.finder.displayFindPanel(this.flowEditorPane.getSelectedText());
    }

    public void findNext(boolean backwards) {
        if (this.currentSearchResult.get() == null || !((FindNavigator)this.currentSearchResult.get()).validProperty().get()) {
            String search = this.flowEditorPane.getSelectedText();
            if (search.isEmpty()) {
                search = this.lastSearchString;
            }
            this.doFind(search, true);
        }
        if (this.currentSearchResult.get() != null) {
            if (backwards) {
                ((FindNavigator)this.currentSearchResult.get()).selectPrev();
            } else {
                ((FindNavigator)this.currentSearchResult.get()).selectNext(false);
            }
        }
    }

    protected void showReplacePanel() {
        if (!this.finder.isVisible()) {
            this.finder.setVisible(true);
        }
        this.finder.requestFindfieldFocus();
        this.finder.setReplaceEnabled(true);
    }

    public void setFindTextfield(String text) {
        this.finder.populateFindTextfield(text);
    }

    @Override
    public SourceLocation getTextPositionForScreenPos(int screenX, int screenY) {
        double renderScaleY;
        int windowX = this.fxTabbedEditor.getX();
        int windowY = this.fxTabbedEditor.getY();
        double sceneX = this.flowEditorPane.getScene().getX();
        double sceneY = this.flowEditorPane.getScene().getY();
        double renderScaleX = this.fxTabbedEditor.getRenderScaleX();
        Point2D scenePoint = new Point2D((double)screenX / renderScaleX - (double)windowX, (double)screenY / (renderScaleY = this.fxTabbedEditor.getRenderScaleY()) - (double)windowY).subtract(sceneX, sceneY);
        Point2D localPoint = this.flowEditorPane.sceneToLocal(scenePoint);
        Optional<EditorPosition> caretPos = this.flowEditorPane.getCaretPositionForLocalPoint(localPoint);
        if (caretPos.isPresent()) {
            return this.getLineColumnFromOffset(caretPos.get().getPosition());
        }
        return null;
    }

    protected void createContentAssist() {
        ExpressionTypeInfo suggests;
        this.javaSyntaxView.flushReparseQueue();
        ParsedCUNode parser = this.getParsedNode();
        ExpressionTypeInfo expressionTypeInfo = suggests = parser == null ? null : parser.getExpressionType(this.flowEditorPane.getCaretPosition(), (ReparseableDocument)this.javaSyntaxView);
        if (suggests != null) {
            final ArrayList<AssistContent> completionCandidates = new ArrayList<AssistContent>();
            SuggestionList.getStaticClassesCompletion(completionCandidates, Pattern.compile("(;|^)\\s*import\\s+greenfoot\\s*\\.\\s*(\\*\\s*;|Greenfoot\\s*;)").matcher(this.getText(new SourceLocation(1, 1), this.getCaretLocation())).find(), this.getProject().getPackage(""), this.javadocResolver);
            LocatableToken suggestToken = suggests.getSuggestionToken();
            AssistContent[] possibleCompletions = ParseUtils.getPossibleCompletions((ExpressionTypeInfo)suggests, (JavadocResolver)this.javadocResolver, null, (ParsedNode)parser.getContainingMethodOrClassNode(this.flowEditorPane.getCaretPosition()));
            Arrays.sort(possibleCompletions, AssistContent.getComparator());
            completionCandidates.addAll(Arrays.asList(possibleCompletions));
            List suggestionDetails = completionCandidates.stream().map(AssistContentThreadSafe::new).map(ac -> new SuggestionList.SuggestionDetailsWithHTMLDoc(ac.getName(), ExpressionCompletionCalculator.getParamsCompletionDisplay((AssistContentThreadSafe)ac), ac.getType(), SuggestionList.SuggestionShown.COMMON, ac.getDocHTML())).collect(Collectors.toList());
            final int originalPosition = suggestToken == null ? this.flowEditorPane.getCaretPosition() : suggestToken.getPosition();
            Bounds screenPos = this.flowEditorPane.getCaretBoundsOnScreen(originalPosition).orElse(null);
            if (screenPos == null && originalPosition > 0) {
                screenPos = this.flowEditorPane.getCaretBoundsOnScreen(originalPosition - 1).orElse(null);
                screenPos = new BoundingBox(screenPos.getMaxX(), screenPos.getMinY(), 0.0, screenPos.getHeight());
            }
            if (screenPos == null) {
                return;
            }
            Bounds spLoc = this.flowEditorPane.screenToLocal(screenPos);
            final StringExpression editorFontCSS = PrefMgr.getEditorFontCSS((boolean)true);
            SuggestionList suggestionList = new SuggestionList(new SuggestionList.SuggestionListParent(){

                @Override
                @OnThread(value=Tag.FX)
                public StringExpression getFontCSS() {
                    return editorFontCSS;
                }

                @Override
                public double getFontSize() {
                    return PrefMgr.getEditorFontSize().get();
                }

                @Override
                public void setupSuggestionWindow(Stage window) {
                    FlowEditor.this.flowEditorPane.setFakeCaret(true);
                }
            }, suggestionDetails, null, SuggestionList.SuggestionShown.RARE, i -> {}, new SuggestionList.SuggestionListListener(){

                @Override
                @OnThread(value=Tag.FXPlatform)
                public void suggestionListChoiceClicked(SuggestionList suggestionList, int highlighted) {
                    if (highlighted != -1) {
                        FlowEditor.this.codeComplete((AssistContent)completionCandidates.get(highlighted), originalPosition, FlowEditor.this.flowEditorPane.getCaretPosition(), suggestionList);
                    }
                }

                @Override
                public SuggestionList.SuggestionListListener.Response suggestionListKeyTyped(SuggestionList suggestionList, KeyEvent event, int highlighted) {
                    if (!event.getCharacter().equals("\b") && !event.getCharacter().equals("\u007f")) {
                        if (event.getCharacter().equals("\n")) {
                            this.suggestionListChoiceClicked(suggestionList, highlighted);
                            return SuggestionList.SuggestionListListener.Response.DISMISS;
                        }
                        FlowEditor.this.document.replaceText(FlowEditor.this.flowEditorPane.getCaretPosition(), FlowEditor.this.flowEditorPane.getCaretPosition(), event.getCharacter());
                    }
                    String prefix = FlowEditor.this.document.getContent(originalPosition, FlowEditor.this.flowEditorPane.getCaretPosition()).toString();
                    suggestionList.calculateEligible(prefix, true, false);
                    suggestionList.updateVisual(prefix);
                    return SuggestionList.SuggestionListListener.Response.CONTINUE;
                }

                @Override
                @OnThread(value=Tag.FXPlatform)
                public SuggestionList.SuggestionListListener.Response suggestionListKeyPressed(SuggestionList suggestionList, KeyEvent event, int highlighted) {
                    switch (event.getCode()) {
                        case ESCAPE: {
                            return SuggestionList.SuggestionListListener.Response.DISMISS;
                        }
                        case ENTER: 
                        case TAB: {
                            this.suggestionListChoiceClicked(suggestionList, highlighted);
                            return SuggestionList.SuggestionListListener.Response.DISMISS;
                        }
                        case BACK_SPACE: {
                            FlowEditor.this.actions.getActionByName("delete-previous").actionPerformed(false);
                            break;
                        }
                        case DELETE: {
                            FlowEditor.this.actions.getActionByName("delete-next").actionPerformed(false);
                        }
                    }
                    if (FlowEditor.this.flowEditorPane.getCaretPosition() < originalPosition) {
                        return SuggestionList.SuggestionListListener.Response.DISMISS;
                    }
                    return SuggestionList.SuggestionListListener.Response.CONTINUE;
                }

                @Override
                @OnThread(value=Tag.FXPlatform)
                public void hidden() {
                    FlowEditor.this.flowEditorPane.setFakeCaret(false);
                }
            });
            String prefix = this.document.getContent(originalPosition, this.flowEditorPane.getCaretPosition()).toString();
            suggestionList.calculateEligible(prefix, true, false);
            suggestionList.updateVisual(prefix);
            suggestionList.highlightFirstEligible();
            suggestionList.show((Node)this.flowEditorPane, spLoc);
            this.watcher.recordCodeCompletionStarted(this.document.getLineFromPosition(originalPosition) + 1, this.document.getColumnFromPosition(originalPosition) + 1, null, null, prefix, suggestionList.getRecordingId());
        }
    }

    private void codeComplete(AssistContent selected, int prefixBegin, int prefixEnd, SuggestionList suggestionList) {
        Object start = selected.getName();
        List params = selected.getParams();
        if (params != null) {
            start = (String)start + "(";
        }
        this.flowEditorPane.select(prefixBegin, prefixEnd);
        String prefix = this.flowEditorPane.getSelectedText();
        this.insertText((String)start, false);
        Object inserted = start;
        if (params != null) {
            int selLoc = this.flowEditorPane.getCaretPosition();
            if (!params.isEmpty()) {
                String joinedParams = params.stream().map(AssistContent.ParamInfo::getDummyName).collect(Collectors.joining(", "));
                this.insertText(joinedParams, false);
                inserted = (String)inserted + joinedParams;
            }
            this.insertText(")", false);
            inserted = (String)inserted + ")";
            if (params.size() > 0) {
                this.flowEditorPane.select(selLoc, selLoc + ((AssistContent.ParamInfo)params.get(0)).getDummyName().length());
            }
        }
        this.watcher.recordCodeCompletionEnded(this.document.getLineFromPosition(prefixBegin) + 1, this.document.getColumnFromPosition(prefixBegin) + 1, null, null, prefix, (String)inserted, suggestionList.getRecordingId());
        try {
            this.save();
        }
        catch (IOException e) {
            Debug.reportError((Throwable)e);
        }
    }

    @Override
    public void scrollEventOnTextLine(ScrollEvent e, BaseEditorPane editorPane) {
        editorPane.scrollEventOnTextLine(e);
    }

    @Override
    public Rectangle2D getScreenBoundsIfSelectedTab() {
        return this.fxTab.getScreenBoundsIfSelectedTab();
    }

    @Override
    public double getFontSizeInPixels() {
        return this.flowEditorPane.getFontSizeInPixels();
    }

    @Override
    public Rectangle2D getScreenBoundsOfLine(int line) {
        return this.flowEditorPane.getLineBoundsOnScreen(line - 1, new Point2D((double)this.fxTabbedEditor.getX(), (double)this.fxTabbedEditor.getY()), this.fxTabbedEditor.getRenderScaleX(), this.fxTabbedEditor.getRenderScaleY());
    }

    @Override
    public void addDocumentListener(DocumentListener documentListener) {
        this.document.addListener(false, documentListener);
    }

    @Override
    public void removeDocumentListener(DocumentListener documentListener) {
        this.document.removeListener(documentListener);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public FXRunnable printTo(PrinterJob printerJob, PrefMgr.PrintSize printSize, boolean printLineNumbers, final boolean printScopeBackgrounds, Editor.PrintProgressUpdate progressUpdate) {
        final HoleDocument doc = new HoleDocument();
        doc.replaceText(0, 0, this.document.getFullContent());
        OffScreenFlowEditorPaneListener flowEditorPaneListener = new OffScreenFlowEditorPaneListener();
        String fontSize = "7pt";
        switch (printSize) {
            case SMALL: {
                fontSize = "5pt";
                break;
            }
            case STANDARD: {
                fontSize = "7pt";
                break;
            }
            case LARGE: {
                fontSize = "9pt";
            }
        }
        String fontCSS = "-fx-font-size: " + fontSize + ";" + PrefMgr.getEditorFontFamilyCSS();
        final LineDisplay lineDisplay = new LineDisplay((DoubleExpression)new ReadOnlyDoubleWrapper(0.0), (StringExpression)new ReadOnlyStringWrapper(fontCSS), true, flowEditorPaneListener);
        final LineContainer lineContainer = new LineContainer(lineDisplay, true);
        final FlowEditorPane.LineStyler[] lineStylerWrapper = new FlowEditorPane.LineStyler[]{(i, s) -> Collections.singletonList(new TextLine.StyledSegment(Collections.emptyList(), s.toString()))};
        JavaSyntaxView javaSyntaxView = new JavaSyntaxView(doc, new JavaSyntaxView.Display(){

            @Override
            public ReadOnlyObjectProperty<Scene> sceneProperty() {
                return lineContainer.sceneProperty();
            }

            @Override
            public ReadOnlyDoubleProperty widthProperty() {
                return lineContainer.widthProperty();
            }

            @Override
            public ReadOnlyDoubleProperty heightProperty() {
                return lineContainer.heightProperty();
            }

            @Override
            public boolean isPrinting() {
                return true;
            }

            @Override
            public void requestLayout() {
                lineContainer.requestLayout();
                lineContainer.layout();
            }

            @Override
            public boolean isLineVisible(int lineIndex) {
                return lineDisplay.isLineVisible(lineIndex);
            }

            @Override
            public Optional<Double> getLeftEdgeX(int charIndex) {
                return FlowEditorPane.getLeftEdgeX(charIndex, doc, lineDisplay);
            }

            @Override
            public void addLineDisplayListener(LineDisplay.LineDisplayListener lineDisplayListener) {
                lineDisplay.addLineDisplayListener(lineDisplayListener);
            }

            @Override
            public void setLineStyler(FlowEditorPane.LineStyler lineStyler) {
                lineStylerWrapper[0] = lineStyler;
            }

            @Override
            public double getTextDisplayWidth() {
                return lineContainer.getTextDisplayWidth();
            }

            @Override
            public void applyScopeBackgrounds(Map<Integer, List<BackgroundItem>> scopeBackgrounds) {
                if (printScopeBackgrounds) {
                    lineDisplay.applyScopeBackgrounds(scopeBackgrounds);
                }
            }

            @Override
            public void repaint() {
            }

            @Override
            public double getWidthOfText(String content) {
                return lineDisplay.calculateLineWidth(content);
            }
        }, flowEditorPaneListener, this.javaSyntaxView.getEntityResolver(), PrefMgr.flagProperty((String)"bluej.editor.syntaxHilighting"));
        javaSyntaxView.enableParser(true);
        FlowEditorPane.StyledLines allLines = new FlowEditorPane.StyledLines(doc, lineStylerWrapper[0]);
        lineContainer.getChildren().setAll(lineDisplay.recalculateVisibleLines(allLines, (FXFunction<Double, Double>)((FXFunction)Math::ceil), 0.0, printerJob.getJobSettings().getPageLayout().getPrintableWidth(), lineContainer.getHeight(), true, null));
        Label pageNumberLabel = new Label("");
        String timestamp = new SimpleDateFormat("yyyy-MMM-dd HH:mm").format(new Date());
        BorderPane header = new BorderPane((Node)new Label(timestamp), null, (Node)pageNumberLabel, null, (Node)new Label(this.windowTitle));
        for (Node node : header.getChildren()) {
            node.setStyle(PrefMgr.getEditorFontFamilyCSS());
        }
        header.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, null, null)}));
        header.setPadding(new Insets(5.0));
        BorderPane rootPane = new BorderPane((Node)lineContainer, (Node)header, null, (Node)flowEditorPaneListener, null);
        flowEditorPaneListener.setManaged(false);
        flowEditorPaneListener.setVisible(false);
        rootPane.setBackground(null);
        double pixelWidth = printerJob.getJobSettings().getPageLayout().getPrintableWidth();
        double pixelHeight = printerJob.getJobSettings().getPageLayout().getPrintableHeight();
        Scene scene = new Scene((Parent)rootPane, pixelWidth, pixelHeight, (Paint)Color.GRAY);
        Config.addEditorStylesheets((Scene)scene);
        lineContainer.applyCss();
        rootPane.requestLayout();
        rootPane.layout();
        rootPane.applyCss();
        FXConsumer updatePageNumber = n -> {
            pageNumberLabel.setText("Page " + n);
            rootPane.requestLayout();
            rootPane.layout();
            rootPane.applyCss();
        };
        return () -> FlowEditor.printPages(printerJob, (Node)rootPane, (FXConsumer<Integer>)updatePageNumber, lineContainer, lineDisplay, allLines, printLineNumbers, progressUpdate);
    }

    @OnThread(value=Tag.FX)
    public static void printPages(PrinterJob printerJob, Node printNode, FXConsumer<Integer> updatePageNumber, LineContainer lineContainer, LineDisplay lineDisplay, List<List<TextLine.StyledSegment>> allLines, boolean printLineNumbers, Editor.PrintProgressUpdate progressUpdate) {
        int topLine = 0;
        boolean lastPage = false;
        int editorLines = allLines.size();
        int pageNumber = 1;
        int lastTopLine = topLine;
        while (topLine < editorLines && !lastPage) {
            if (!progressUpdate.printProgress(topLine, editorLines)) {
                return;
            }
            lineDisplay.scrollTo(topLine, 0.0);
            List<MarginAndTextLine> lines = lineDisplay.recalculateVisibleLines(allLines, (FXFunction<Double, Double>)((FXFunction)Math::ceil), 0.0, printerJob.getJobSettings().getPageLayout().getPrintableWidth(), lineContainer.getHeight(), true, null);
            for (MarginAndTextLine line : lines) {
                line.setMarginGraphics(printLineNumbers ? EnumSet.of(MarginAndTextLine.MarginDisplay.LINE_NUMBER) : EnumSet.noneOf(MarginAndTextLine.MarginDisplay.class));
            }
            lineContainer.getChildren().setAll(lines);
            lineContainer.layout();
            lineContainer.applyCss();
            updatePageNumber.accept((Object)pageNumber);
            lineContainer.requestLayout();
            lineContainer.layout();
            lineContainer.applyCss();
            ArrayList<Node> visibleCells = new ArrayList<Node>((Collection<Node>)lineContainer.getChildren());
            if (visibleCells.isEmpty()) {
                return;
            }
            Node lastCell = (Node)visibleCells.get(visibleCells.size() - 1);
            boolean bl = lastPage = lineDisplay.getLineRangeVisible()[1] >= editorLines - 1 && lastCell.getLayoutY() < lineContainer.getHeight();
            if (!lastPage) {
                double limitY = lastCell.getLayoutY();
                lineContainer.setClip((Node)new Rectangle(lineContainer.getWidth(), limitY));
                topLine += visibleCells.size() - 1;
            } else {
                lineContainer.setClip((Node)new Rectangle(lineContainer.getWidth(), lineContainer.getHeight()));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            printerJob.printPage(printNode);
            ++pageNumber;
            if (topLine <= lastTopLine) break;
            lastTopLine = topLine;
        }
    }

    public void print() {
        Optional choices = new PrintDialog(this.getWindow(), null, this.document.getLineCount() >= 200).showAndWait();
        if (!choices.isPresent()) {
            return;
        }
        final PrinterJob job = JavaFXUtil.createPrinterJob();
        if (job == null) {
            DialogManager.showErrorFX((Window)this.getWindow(), (String)"print-no-printers");
        } else if (job.showPrintDialog(this.getWindow())) {
            final PrintProgressDialog printProgressDialog = new PrintProgressDialog(this.getWindow(), false);
            final FXRunnable printAction = this.printTo(job, ((PrintDialog.PrintChoices)choices.get()).printSize, ((PrintDialog.PrintChoices)choices.get()).printLineNumbers, ((PrintDialog.PrintChoices)choices.get()).printHighlighting, printProgressDialog.getWithinFileUpdater());
            new Thread("PRINT"){

                @Override
                @OnThread(value=Tag.FX, ignoreParent=true)
                public void run() {
                    printAction.run();
                    job.endJob();
                    printProgressDialog.finished();
                }
            }.start();
            printProgressDialog.showAndWait();
        }
    }

    private static class ErrorDisplay
    extends FixDisplayManager {
        private final FlowErrorManager.ErrorDetails details;
        private final Supplier<EditorWatcher> editorWatcherSupplier;
        private PopupControl popup;
        private final FlowEditor flowEditor;

        public ErrorDisplay(FlowEditor flowEditor, Supplier<EditorWatcher> editorWatcherSupplier, FlowErrorManager.ErrorDetails details) {
            super(details.identifier, details.message);
            this.details = details;
            this.editorWatcherSupplier = editorWatcherSupplier;
            this.flowEditor = flowEditor;
        }

        public boolean hasQuickFixSelected() {
            return this.highlighted > -1;
        }

        @OnThread(value=Tag.FXPlatform)
        void executeQuickFix() {
            super.executeAndRecordSelectedFix(this.editorWatcherSupplier);
        }

        @Override
        @OnThread(value=Tag.FX, ignoreParent=true)
        protected void hide() {
            this.popup.hide();
        }

        @Override
        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        protected void postFixError() {
            this.flowEditor.compileOrShowNextError();
        }

        @OnThread(value=Tag.FXPlatform)
        public void createPopup() {
            this.popup = new PopupControl();
            final VBox errorVBox = new VBox();
            String errorMessage = ParserMessageHandler.getMessageForCode(this.details.message);
            TextFlow tf = null;
            if (this.details.getItalicMessageStartIndex() == -1 || this.details.getItalicMessageEndIndex() == -1) {
                tf = new TextFlow(new Node[]{new Label(errorMessage)});
            } else {
                int italicStartIndex = this.details.getItalicMessageStartIndex();
                int italicEndIndex = this.details.getItalicMessageEndIndex();
                Label beforeItalicText = italicStartIndex > 0 ? new Label(errorMessage.substring(0, italicStartIndex)) : new Label("");
                Label italicText = new Label(errorMessage.substring(italicStartIndex, italicEndIndex));
                JavaFXUtil.withStyleClass((Styleable)italicText, (String[])new String[]{"error-fix-display-italic"});
                Label afterItalicText = italicEndIndex < errorMessage.length() - 1 ? new Label(errorMessage.substring(italicEndIndex)) : new Label("");
                tf = new TextFlow(new Node[]{beforeItalicText, italicText, afterItalicText});
            }
            errorVBox.getChildren().add((Object)tf);
            this.prepareFixDisplay(errorVBox, this.details.corrections, this.editorWatcherSupplier);
            JavaFXUtil.addStyleClass((Styleable)tf, (String[])new String[]{"error-label"});
            this.popup.setSkin((Skin)new Skin<Skinnable>(){

                @OnThread(value=Tag.FX)
                public Skinnable getSkinnable() {
                    return popup;
                }

                @OnThread(value=Tag.FX)
                public Node getNode() {
                    return errorVBox;
                }

                @OnThread(value=Tag.FX)
                public void dispose() {
                }
            });
            errorVBox.getStyleClass().add((Object)"java-error-popup");
            tf.setStyle((String)PrefMgr.getEditorFontCSS((boolean)false).get());
            Config.addPopupStylesheets((Parent)errorVBox);
        }
    }

    class UndoManager {
        private final DocumentUndoStack undoStack;
        private final BooleanProperty cannotRedo = new SimpleBooleanProperty(true);
        private final BooleanProperty cannotUndo = new SimpleBooleanProperty(true);

        public UndoManager(Document document) {
            this.undoStack = new DocumentUndoStack(document);
            this.undoStack.setStateListener(this::updateState);
        }

        private void updateState() {
            this.cannotUndo.setValue(Boolean.valueOf(this.undoStack.canUndoCount() == 0));
            this.cannotRedo.setValue(Boolean.valueOf(this.undoStack.canRedoCount() == 0));
        }

        public BooleanExpression cannotUndo() {
            return this.cannotUndo;
        }

        public BooleanExpression cannotRedo() {
            return this.cannotRedo;
        }

        public void undo() {
            int pos = this.undoStack.undo();
            if (pos >= 0) {
                FlowEditor.this.flowEditorPane.positionCaret(pos);
            }
        }

        public void redo() {
            int pos = this.undoStack.redo();
            if (pos >= 0) {
                FlowEditor.this.flowEditorPane.positionCaret(pos);
            }
        }

        public void forgetHistory() {
            this.undoStack.clear();
        }

        public void compoundEdit(FXPlatformRunnable action) {
            this.undoStack.compoundEdit(action);
        }
    }

    public static class OffScreenFlowEditorPaneListener
    extends ScopeColorsBorderPane
    implements FlowEditorPane.FlowEditorPaneListener {
        @Override
        public boolean marginClickedForLine(int lineIndex) {
            return false;
        }

        @Override
        public Set<Integer> getBreakpointLines() {
            return ImmutableSet.of();
        }

        @Override
        public int getStepLine() {
            return -1;
        }

        @Override
        public void showErrorPopupForCaretPos(int caretPos, boolean mousePosition) {
        }

        @Override
        public String getErrorAtPosition(int caretPos) {
            return null;
        }

        @Override
        public ContextMenu getContextMenuToShow(BaseEditorPane editorPane) {
            return null;
        }

        @Override
        public void scrollEventOnTextLine(ScrollEvent e, BaseEditorPane editorPane) {
        }
    }

    public static interface FetchTabbedEditor {
        public FXTabbedEditor getFXTabbedEditor(boolean var1);
    }
}

