/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.editor.flow.ScopeHighlightingPrefDisplay;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class EditorPrefPanel
extends VBox
implements PrefPanelListener {
    private TextField editorFontField;
    private CheckBox highlightingBox;
    private CheckBox autoIndentBox;
    private CheckBox closeCurlyBox;
    private CheckBox lineNumbersBox;
    private CheckBox matchBracketsBox;
    private CheckBox checkFileChangedOnDiskBox;
    private ScopeHighlightingPrefDisplay scopeHighlightingPrefDisplay;
    private TextField textFileExtensionsField;
    private Button textFileExtensionsDefaultButton;

    public EditorPrefPanel() {
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"prefmgr-pref-panel"});
        this.scopeHighlightingPrefDisplay = new ScopeHighlightingPrefDisplay();
        ArrayList<Object> javaEditorPanel = new ArrayList<Object>();
        GridPane topPanel = new GridPane();
        JavaFXUtil.addStyleClass((Styleable)topPanel, (String[])new String[]{"prefmgr-java-editor-top"});
        this.editorFontField = new TextField();
        this.editorFontField.setPrefColumnCount(4);
        topPanel.add(PrefMgrDialog.labelledItem((String)"prefmgr.edit.editorfontsize", (Node)this.editorFontField), 0, 0);
        this.autoIndentBox = new CheckBox(Config.getString((String)"prefmgr.edit.autoindent"));
        topPanel.add((Node)this.autoIndentBox, 1, 0);
        this.closeCurlyBox = new CheckBox(Config.getString((String)"prefmgr.edit.closecurly"));
        topPanel.add((Node)this.closeCurlyBox, 1, 1);
        this.highlightingBox = new CheckBox(Config.getString((String)"prefmgr.edit.usesyntaxhilighting"));
        topPanel.add((Node)this.highlightingBox, 0, 1);
        this.lineNumbersBox = new CheckBox(Config.getString((String)"prefmgr.edit.displaylinenumbers"));
        topPanel.add((Node)this.lineNumbersBox, 0, 2);
        this.matchBracketsBox = new CheckBox(Config.getString((String)"prefmgr.edit.matchBrackets"));
        topPanel.add((Node)this.matchBracketsBox, 1, 2);
        this.checkFileChangedOnDiskBox = new CheckBox(Config.getString((String)"prefmgr.edit.checkfilechangeondisk"));
        topPanel.add((Node)this.checkFileChangedOnDiskBox, 1, 3);
        HBox bottomPanel = new HBox();
        JavaFXUtil.addStyleClass((Styleable)bottomPanel, (String[])new String[]{"prefmgr-java-scope-hbox"});
        bottomPanel.getChildren().add((Object)this.scopeHighlightingPrefDisplay.getHighlightStrengthSlider());
        bottomPanel.getChildren().add((Object)this.scopeHighlightingPrefDisplay.getColourPalette());
        javaEditorPanel.add(topPanel);
        javaEditorPanel.add(PrefMgrDialog.headedVBox((String)"prefmgr.edit.colortransparency", Arrays.asList(bottomPanel)));
        this.getChildren().add((Object)PrefMgrDialog.headedVBox((String)"prefmgr.edit.editor.title", javaEditorPanel));
        ArrayList<GridPane> textEditorPanel = new ArrayList<GridPane>();
        GridPane textTopPanel = new GridPane();
        JavaFXUtil.addStyleClass((Styleable)textTopPanel, (String[])new String[]{"prefmgr-text-editor-top"});
        this.textFileExtensionsField = new TextField();
        this.textFileExtensionsField.setPrefColumnCount(20);
        textTopPanel.add(PrefMgrDialog.labelledItem((String)"prefmgr.edit.textfileextensions", (Node)this.textFileExtensionsField), 0, 0);
        this.textFileExtensionsDefaultButton = new Button(Config.getString((String)"prefmgr.edit.texteditor.defaultFileExtensions"));
        this.textFileExtensionsDefaultButton.setOnAction(event -> this.textFileExtensionsField.setText(".txt, .md"));
        textTopPanel.add((Node)this.textFileExtensionsDefaultButton, 1, 0);
        Label t = new Label(Config.getString((String)"prefmgr.interface.text.restart"));
        textTopPanel.add((Node)t, 0, 1);
        textEditorPanel.add(textTopPanel);
        this.getChildren().add((Object)PrefMgrDialog.headedVBox((String)"prefmgr.edit.editor.texteditor.title", textEditorPanel));
    }

    public void beginEditing(Project project) {
        this.editorFontField.setText(String.valueOf(PrefMgr.getEditorFontSize().get()));
        this.highlightingBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.syntaxHilighting"));
        this.closeCurlyBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.autoAddClosingCurly"));
        this.autoIndentBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.autoIndent"));
        this.lineNumbersBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.displayLineNumbers"));
        this.matchBracketsBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.matchBrackets"));
        this.checkFileChangedOnDiskBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.checkDiskFileChanges"));
        this.textFileExtensionsField.setText(PrefMgr.getEditorTextFileExtensionsString());
    }

    public void revertEditing(Project project) {
    }

    public void commitEditing(Project project) {
        String fontText = this.editorFontField.getText();
        PrefMgr.setFlag((String)"bluej.editor.syntaxHilighting", (boolean)this.highlightingBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.autoIndent", (boolean)this.autoIndentBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.autoAddClosingCurly", (boolean)this.closeCurlyBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.displayLineNumbers", (boolean)this.lineNumbersBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.matchBrackets", (boolean)this.matchBracketsBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.checkDiskFileChanges", (boolean)this.checkFileChangedOnDiskBox.isSelected());
        int strength = this.scopeHighlightingPrefDisplay.getStrengthValue();
        try {
            PrefMgr.setEditorFontSize((int)Integer.parseInt(fontText));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        PrefMgr.setScopeHighlightStrength((int)strength);
        PrefMgr.setEditorTextFileExtensions((String)this.textFileExtensionsField.getText());
    }
}

