/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.fixes;

import bluej.Config;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.editor.fixes.SuggestionCell;
import bluej.parser.AssistContent;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.ParseUtils;
import bluej.parser.PrefixCompletionWrapper;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Package;
import bluej.utility.JavaReflective;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ScalableHeightLabel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.effect.BlendMode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class SuggestionList {
    private static final AtomicInteger nextSuggListId = new AtomicInteger(1);
    private final int suggestionListId;
    private final SuggestionListListener listener;
    private final SuggestionListView listBox;
    private final Stage window;
    private final List<SuggestionDetails> choices;
    private final List<SuggestionListItem> doubleSuggestions = new ArrayList<SuggestionListItem>();
    private final ObservableList<SuggestionListItem> showingItems = FXCollections.observableArrayList();
    private final HashMap<Integer, EligibleDetail> eligible = new HashMap();
    private int highlighted = -1;
    private final Consumer<Integer> highlightListener;
    private final ScalableHeightLabel similarLabel;
    private final ScalableHeightLabel noneLabel;
    private final DoubleProperty typeWidth;
    private final DoubleProperty typeWidthDerivedProperty;
    private String lastPrefix;
    private boolean lastAllowSimilar;
    private boolean expectingToLoseFocus = false;
    private ObjectProperty<SuggestionShown> shownState = new SimpleObjectProperty((Object)SuggestionShown.COMMON);
    private FXPlatformRunnable cancelShowDocsTask;
    private Pane docPane;
    private boolean hiding = false;
    private final BooleanProperty moreLabelAtBottom = new SimpleBooleanProperty(true);

    public SuggestionList(SuggestionListParent listParent, List<? extends SuggestionDetails> choices, String targetType, SuggestionShown startShown, Consumer<Integer> highlightListener, SuggestionListListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("SuggestionListListener cannot be null");
        }
        this.suggestionListId = nextSuggListId.getAndIncrement();
        this.choices = FXCollections.observableArrayList(choices);
        this.shownState.set((Object)startShown);
        this.listener = listener;
        this.highlightListener = highlightListener;
        this.similarLabel = new ScalableHeightLabel("Related:", false);
        this.similarLabel.setMaxWidth(9999.0);
        this.noneLabel = new ScalableHeightLabel("No completions", false);
        this.noneLabel.setMaxWidth(9999.0);
        JavaFXUtil.addStyleClass((Styleable)this.noneLabel, (String[])new String[]{"suggestion-none"});
        this.typeWidth = new SimpleDoubleProperty();
        this.window = new Stage(StageStyle.TRANSPARENT);
        this.listBox = new SuggestionListView((DoubleExpression)this.typeWidth, (FXPlatformConsumer<SuggestionListItem>)((FXPlatformConsumer)item -> {
            this.highlighted = this.doubleSuggestions.indexOf(item);
            int highlighted = this.getHighlighted();
            if (highlighted != -1) {
                listener.suggestionListChoiceClicked(this, highlighted);
                this.expectingToLoseFocus = true;
                this.hiding = true;
                this.window.hide();
                listener.hidden();
            }
        }));
        JavaFXUtil.addStyleClass((Styleable)this.listBox, (String[])new String[]{"suggestion-list"});
        this.typeWidthDerivedProperty = choices.stream().allMatch(s -> s.type == null) ? new ReadOnlyDoubleWrapper(0.0) : this.listBox.cssTypeWidthProperty();
        this.typeWidth.bind((ObservableValue)this.typeWidthDerivedProperty);
        this.listBox.setBackground(null);
        this.listBox.setItems(this.showingItems);
        this.listBox.setStyle((String)listParent.getFontCSS().get());
        this.docPane = new Pane();
        this.docPane.setMinWidth(400.0);
        this.docPane.setMaxHeight(300.0);
        this.docPane.setBackground(null);
        BorderPane listAndDocBorderPane = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)listAndDocBorderPane, (String[])new String[]{"suggestion-top-level"});
        AnchorPane listAndMoreAndTransPane = new AnchorPane();
        listAndMoreAndTransPane.setBackground(null);
        listAndMoreAndTransPane.setPickOnBounds(false);
        this.listBox.setMaxHeight(300.0);
        this.listBox.setPrefHeight(choices.isEmpty() ? 100.0 : 2.0 * listParent.getFontSize() * (double)choices.size());
        listAndDocBorderPane.setCenter((Node)listAndMoreAndTransPane);
        BorderPane.setMargin((Node)listAndMoreAndTransPane, (Insets)new Insets(0.0, 1.0, 0.0, 0.0));
        listAndDocBorderPane.setRight((Node)this.docPane);
        listAndDocBorderPane.setMaxHeight(300.0);
        Label moreLabel = new Label("Showing common options. Press Ctrl+Space again to see all options");
        JavaFXUtil.addStyleClass((Styleable)moreLabel, (String[])new String[]{"suggestion-more-label"});
        listAndDocBorderPane.setBackground(null);
        listAndDocBorderPane.setPickOnBounds(false);
        AnchorPane moreLabelPane = new AnchorPane(new Node[]{moreLabel});
        moreLabel.setMaxWidth(300.0);
        AnchorPane.setLeftAnchor((Node)moreLabel, (Double)0.0);
        AnchorPane.setTopAnchor((Node)moreLabel, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)moreLabel, (Double)0.0);
        JavaFXUtil.addStyleClass((Styleable)moreLabelPane, (String[])new String[]{"suggestion-more-label-pane"});
        this.window.setResizable(false);
        BorderPane listAndMorePane = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)listAndMorePane, (String[])new String[]{"suggestion-dialog-lhs"});
        listAndMorePane.setCenter((Node)this.listBox);
        if (this.shownState.get() == SuggestionShown.COMMON) {
            listAndMorePane.setBottom((Node)moreLabelPane);
        }
        listAndMoreAndTransPane.getChildren().add((Object)listAndMorePane);
        AnchorPane.setLeftAnchor((Node)listAndMorePane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)listAndMorePane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)listAndMorePane, (Double)0.0);
        JavaFXUtil.addChangeListener((ObservableValue)this.moreLabelAtBottom, atBottom -> {
            if (atBottom.booleanValue()) {
                listAndMorePane.setTop(null);
                listAndMorePane.setBottom((Node)(this.shownState.get() == SuggestionShown.COMMON ? moreLabelPane : null));
                AnchorPane.setTopAnchor((Node)listAndMorePane, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)listAndMorePane, null);
                BorderPane.setAlignment((Node)this.docPane, (Pos)Pos.TOP_LEFT);
            } else {
                listAndMorePane.setBottom(null);
                listAndMorePane.setTop((Node)(this.shownState.get() == SuggestionShown.COMMON ? moreLabelPane : null));
                AnchorPane.setTopAnchor((Node)listAndMorePane, null);
                AnchorPane.setBottomAnchor((Node)listAndMorePane, (Double)0.0);
                BorderPane.setAlignment((Node)this.docPane, (Pos)Pos.BOTTOM_LEFT);
            }
            JavaFXUtil.setPseudoclass((String)"bj-at-top", (atBottom == false ? 1 : 0) != 0, (Node[])new Node[]{moreLabelPane});
        });
        JavaFXUtil.addChangeListener(this.shownState, s -> {
            if (s == SuggestionShown.RARE) {
                listAndMorePane.setTop(null);
                listAndMorePane.setBottom(null);
            }
        });
        Scene scene = new Scene((Parent)listAndDocBorderPane);
        this.window.setHeight(350.0);
        scene.setFill(null);
        Config.addEditorStylesheets((Scene)scene);
        this.window.setScene(scene);
        listParent.setupSuggestionWindow(this.window);
        for (int j = 0; j <= 1; ++j) {
            for (int i = 0; i < choices.size(); ++i) {
                SuggestionDetails choice = choices.get(i);
                SuggestionListItem sugg = new SuggestionListItem(i, targetType != null && choice.type != null ? targetType.equals(choice.type) : false, j == 0);
                this.doubleSuggestions.add(sugg);
            }
        }
        this.listBox.setPlaceholder((Node)this.noneLabel);
        JavaFXUtil.addFocusListener((Stage)this.window, focused -> {
            if (!focused.booleanValue()) {
                this.hideDocDisplay();
                this.hiding = true;
                JavaFXUtil.runAfterCurrent(() -> {
                    this.window.hide();
                    if (!this.expectingToLoseFocus) {
                        listener.suggestionListFocusStolen(this.getHighlighted());
                    }
                    listener.hidden();
                });
            }
        });
        listAndDocBorderPane.addEventFilter(KeyEvent.KEY_TYPED, e -> {
            if (e.getCharacter().equals(" ") && e.isControlDown()) {
                if (this.shownState.get() == SuggestionShown.COMMON) {
                    this.shownState.set((Object)SuggestionShown.RARE);
                    this.calculateEligible(this.lastPrefix, this.lastAllowSimilar, false);
                    this.updateVisual(this.lastPrefix);
                }
            } else if (!e.getCharacter().contains("\u0000") && listener.suggestionListKeyTyped(this, (KeyEvent)e, this.getHighlighted()) == SuggestionListListener.Response.DISMISS) {
                this.expectingToLoseFocus = true;
                this.hiding = true;
                this.window.hide();
                listener.hidden();
            }
            e.consume();
        });
        listAndDocBorderPane.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            switch (e.getCode()) {
                case UP: {
                    this.up();
                    break;
                }
                case DOWN: {
                    this.down();
                    break;
                }
                case PAGE_UP: {
                    this.pageUp();
                    break;
                }
                case PAGE_DOWN: {
                    this.pageDown();
                    break;
                }
                case HOME: {
                    this.home();
                    break;
                }
                case END: {
                    this.end();
                    break;
                }
                case SPACE: {
                    if (e.isControlDown()) {
                        e.consume();
                        if (this.shownState.get() != SuggestionShown.COMMON) break;
                        this.shownState.set((Object)SuggestionShown.RARE);
                        this.calculateEligible(this.lastPrefix, this.lastAllowSimilar, false);
                        this.updateVisual(this.lastPrefix);
                        break;
                    }
                }
                default: {
                    int selected = this.getHighlighted();
                    if (selected == -1 && this.eligibleCount() == 1) {
                        selected = this.getFirstEligible() % choices.size();
                    }
                    if (listener.suggestionListKeyPressed(this, (KeyEvent)e, selected) != SuggestionListListener.Response.DISMISS) break;
                    this.expectingToLoseFocus = true;
                    this.hiding = true;
                    this.window.hide();
                    listener.hidden();
                }
            }
            e.consume();
        });
    }

    @OnThread(value=Tag.FXPlatform)
    public void show(Node reference, Bounds textBoundsWithinReference) {
        if (this.eligibleCount() == 1) {
            int choice;
            boolean singleOptionAvailable = true;
            if (this.shownState.get() == SuggestionShown.COMMON) {
                this.calculateEligible(this.lastPrefix, this.lastAllowSimilar, SuggestionShown.RARE, false);
                if (this.eligibleCount() != 1) {
                    this.calculateEligible(this.lastPrefix, this.lastAllowSimilar, SuggestionShown.COMMON, false);
                    singleOptionAvailable = false;
                }
            }
            if (singleOptionAvailable && (choice = this.getFirstEligible()) < this.choices.size()) {
                JavaFXUtil.runAfterCurrent(() -> {
                    this.listener.hidden();
                    this.listener.suggestionListChoiceClicked(this, choice);
                });
                return;
            }
        }
        this.window.getScene().getRoot().applyCss();
        double xPos = reference.localToScene(reference.getBoundsInLocal()).getMinX();
        Window refWindow = reference.getScene().getWindow();
        double screenMaxY = Screen.getScreensForRectangle((double)refWindow.getX(), (double)refWindow.getY(), (double)refWindow.getWidth(), (double)refWindow.getHeight()).stream().mapToDouble(s -> s.getVisualBounds().getMaxY()).min().orElse(999999.0);
        double windowX = refWindow.getX() + reference.getScene().getX() + xPos + textBoundsWithinReference.getMinX() - this.typeWidth.get() - 1.0;
        double windowY = refWindow.getY() + reference.getScene().getY() + reference.localToScene(reference.getLayoutBounds()).getMinY() + textBoundsWithinReference.getMinY();
        if (screenMaxY < this.window.getHeight() + windowY) {
            windowY -= 350.0;
            this.moreLabelAtBottom.set(false);
        } else {
            this.moreLabelAtBottom.set(true);
            windowY += textBoundsWithinReference.getHeight();
        }
        this.window.setX(windowX);
        this.window.setY(windowY);
        if (this.window.getOwner() == null) {
            this.window.initOwner(reference.getScene().getWindow());
        }
        this.window.show();
        this.listBox.requestFocus();
    }

    private void up() {
        for (int candidate = this.highlighted - 1; candidate >= -1; --candidate) {
            if (candidate != -1 && !this.eligible.containsKey(candidate)) continue;
            this.setHighlighted(candidate, true);
            break;
        }
    }

    private void down() {
        for (int candidate = this.highlighted + 1; candidate < this.doubleSuggestions.size(); ++candidate) {
            if (!this.eligible.containsKey(candidate)) continue;
            this.setHighlighted(candidate, true);
            break;
        }
    }

    private void home() {
        this.setHighlighted(this.getFirstEligible(), true);
    }

    private void end() {
        this.setHighlighted(this.getLastEligible(), true);
    }

    private void pageUp() {
        for (int i = 0; i < 10; ++i) {
            this.up();
        }
        if (this.highlighted == -1) {
            this.home();
        }
    }

    private void pageDown() {
        for (int i = 0; i < 10; ++i) {
            this.down();
        }
    }

    public void setHighlighted(int newHighlight, boolean scrollTo) {
        if (this.highlighted == newHighlight) {
            if (this.highlighted != -1 && scrollTo) {
                this.listBox.scrollTo(Math.max(0, this.showingItems.indexOf((Object)this.doubleSuggestions.get(newHighlight)) - 3));
            }
            return;
        }
        if (this.highlighted != -1) {
            this.doubleSuggestions.get((int)this.highlighted).highlighted.set(false);
        }
        this.highlighted = newHighlight;
        if (this.highlighted != -1) {
            this.doubleSuggestions.get((int)this.highlighted).highlighted.set(true);
            if (scrollTo) {
                this.listBox.scrollTo(Math.max(0, this.showingItems.indexOf((Object)this.doubleSuggestions.get(newHighlight)) - 3));
            }
        }
        if (this.highlightListener != null) {
            this.highlightListener.accept(this.getHighlighted());
        }
        JavaFXUtil.runNowOrLater(() -> this.showDocsFor(this.getHighlighted()));
    }

    public void calculateEligible(String prefix, boolean allowSimilar, boolean canChangeToRare) {
        this.calculateEligible(prefix, allowSimilar, (SuggestionShown)((Object)this.shownState.get()), canChangeToRare);
    }

    public void calculateEligible(String prefix, boolean allowSimilar, SuggestionShown shown, boolean canChangeToRare) {
        this.lastPrefix = prefix;
        this.lastAllowSimilar = allowSimilar;
        this.eligible.clear();
        for (int i = 0; i < this.choices.size(); ++i) {
            List<Integer> wordStarts;
            Optional<EligibleDetail> me;
            String sugg = this.choices.get((int)i).choice;
            if (this.choices.get((int)i).shown.compareTo(shown) > 0) continue;
            if (sugg.toLowerCase().startsWith(prefix.toLowerCase())) {
                this.eligible.put(i, new EligibleDetail(0, 0, prefix.length()));
                continue;
            }
            if (!allowSimilar || !(me = (wordStarts = SuggestionList.splitIdentLower(sugg)).stream().map(j -> new EligibleDetail((int)j, SuggestionList.distanceTo(prefix, sugg, j), prefix.length())).filter(EligibleDetail::close).sorted().findFirst()).isPresent()) continue;
            this.eligible.put(i + this.doubleSuggestions.size() / 2, me.get());
        }
        if (this.eligible.isEmpty() && shown == SuggestionShown.COMMON && canChangeToRare) {
            this.shownState.set((Object)SuggestionShown.RARE);
            this.calculateEligible(prefix, allowSimilar, SuggestionShown.RARE, false);
        }
    }

    private static int distanceTo(String prefix, String candidate, int offset) {
        prefix = prefix.toLowerCase();
        String partialLower = candidate.substring(offset, Math.min(candidate.length(), offset + prefix.length())).toLowerCase();
        String partialLowerShort = candidate.substring(offset, Math.min(candidate.length(), offset + Math.max(1, prefix.length() - 1))).toLowerCase();
        String partialLowerLong = candidate.substring(offset, Math.min(candidate.length(), offset + 1 + prefix.length())).toLowerCase();
        return Math.min(Utility.editDistance((String)partialLower, (String)prefix), Math.min(Utility.editDistance((String)partialLowerShort, (String)prefix), Utility.editDistance((String)partialLowerLong, (String)prefix)));
    }

    private static boolean hasCase(char c) {
        return Character.isUpperCase(c) != Character.isLowerCase(c);
    }

    private static List<Integer> splitIdentLower(String text) {
        int startCurWord = 0;
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (int i = 1; i < text.length(); ++i) {
            if (SuggestionList.hasCase(text.charAt(i)) && SuggestionList.hasCase(text.charAt(i - 1)) && (Character.isUpperCase(text.charAt(i)) == Character.isLowerCase(text.charAt(i - 1)) || Character.isLowerCase(text.charAt(i)) == Character.isUpperCase(text.charAt(i - 1))) && (startCurWord == 0 || i - startCurWord > 1)) {
                r.add(startCurWord);
                startCurWord = i;
                continue;
            }
            if (text.charAt(i) != '_' && text.charAt(i) != '.' || startCurWord >= i - 1) continue;
            r.add(startCurWord);
            startCurWord = i + 1;
        }
        r.add(startCurWord);
        return r;
    }

    public void updateVisual(String prefix) {
        boolean showingAnySimilar = false;
        for (int i = 0; i < this.doubleSuggestions.size(); ++i) {
            if (!this.eligible.containsKey(i) || i <= this.doubleSuggestions.size() / 2) continue;
            showingAnySimilar = true;
        }
        for (Map.Entry<Integer, EligibleDetail> e : this.eligible.entrySet()) {
            boolean canComplete = this.eligible.size() == 1 || this.highlighted == e.getKey() || this.doubleSuggestions.get((int)e.getKey().intValue()).getDetails().choice.equals(prefix);
            this.doubleSuggestions.get((int)e.getKey().intValue()).eligibleAt.set(e.getValue().suggestionOffset);
            this.doubleSuggestions.get((int)e.getKey().intValue()).eligibleLength.set(prefix.length());
            this.doubleSuggestions.get((int)e.getKey().intValue()).eligibleCanTab.set(canComplete);
        }
        ArrayList<SuggestionListItem> newShowingItems = new ArrayList<SuggestionListItem>();
        for (int i = 0; i < this.doubleSuggestions.size(); ++i) {
            if (this.eligible.containsKey(i)) {
                newShowingItems.add(this.doubleSuggestions.get(i));
            }
            if (i != this.choices.size() || !showingAnySimilar) continue;
            newShowingItems.add(new SuggestionListItem(-1, false, false));
        }
        this.showingItems.setAll(newShowingItems);
        if (this.highlighted != -1) {
            if (!this.eligible.containsKey(this.highlighted)) {
                this.setHighlighted(this.getFirstEligible(), true);
            } else {
                this.setHighlighted(this.highlighted, true);
            }
        }
    }

    public int eligibleCount() {
        return this.eligible.size();
    }

    public int getFirstEligible() {
        return this.eligible.keySet().stream().mapToInt(i -> i).min().orElse(-1);
    }

    public int getLastEligible() {
        return this.eligible.keySet().stream().mapToInt(i -> i).max().orElse(-1);
    }

    @OnThread(value=Tag.FXPlatform)
    public void highlightFirstEligible() {
        this.setHighlighted(this.getFirstEligible(), false);
    }

    private int getHighlighted() {
        return this.choices.size() == 0 ? -1 : this.highlighted % this.choices.size();
    }

    public Optional<String> getLongestCommonPrefix() {
        return SuggestionList.longestCommonPrefix(this.eligible.entrySet().stream().filter(e -> (Integer)e.getKey() < this.choices.size()).map(e -> this.choices.get((int)((Integer)e.getKey()).intValue()).choice).collect(Collectors.toList()));
    }

    private static Optional<String> longestCommonPrefix(List<String> srcs) {
        return srcs.stream().reduce((a, b) -> {
            int maxLen = Math.min(a.length(), b.length());
            if (maxLen == 0) {
                return "";
            }
            for (int i = 0; i < maxLen; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return a.substring(0, i);
            }
            return a.substring(0, maxLen);
        });
    }

    public DoubleExpression widthProperty() {
        return this.listBox.widthProperty();
    }

    public DoubleExpression typeWidthProperty() {
        return this.typeWidth;
    }

    public boolean isShowing() {
        return this.window.isShowing();
    }

    public boolean isInMiddleOfHiding() {
        return this.hiding;
    }

    @OnThread(value=Tag.FXPlatform)
    private void showDocsFor(int selected) {
        if (this.cancelShowDocsTask != null) {
            this.cancelShowDocsTask.run();
            this.cancelShowDocsTask = null;
        }
        this.hideDocDisplay();
        if (selected != -1 && this.choices.get(selected).hasDocs()) {
            this.cancelShowDocsTask = JavaFXUtil.runAfter((Duration)Duration.millis((double)500.0), () -> this.docPane.getChildren().setAll((Object[])new Node[]{this.choices.get(selected).makeDocPane()}));
        }
    }

    private void hideDocDisplay() {
        this.docPane.getChildren().clear();
    }

    public int getRecordingId() {
        return this.suggestionListId;
    }

    public static void getStaticClassesCompletion(List<AssistContent> completionCandidates, boolean isGreenfootImported, Package pkg, JavadocResolver javadocResolver) {
        if (Config.isGreenfoot() && isGreenfootImported) {
            JavaReflective greenfootClassRef = new JavaReflective(pkg.loadClass("greenfoot.Greenfoot"));
            ExpressionTypeInfo greenfootClass = new ExpressionTypeInfo((JavaType)new GenTypeClass((Reflective)greenfootClassRef), null, null, true, false);
            AssistContent[] greenfootStatic = ParseUtils.getPossibleCompletions((ExpressionTypeInfo)greenfootClass, (JavadocResolver)javadocResolver, null, null);
            Arrays.stream(greenfootStatic).filter(ac -> ac.getKind() == AssistContent.CompletionKind.METHOD).forEach(ac -> completionCandidates.add((AssistContent)new PrefixCompletionWrapper(ac, "Greenfoot.")));
        }
        JavaReflective systemClassRef = new JavaReflective(pkg.loadClass("java.lang.System"));
        ExpressionTypeInfo systemClass = new ExpressionTypeInfo((JavaType)new GenTypeClass((Reflective)systemClassRef), null, null, true, false);
        AssistContent[] systemStatic = ParseUtils.getPossibleCompletions((ExpressionTypeInfo)systemClass, (JavadocResolver)javadocResolver, null, null);
        Arrays.stream(systemStatic).filter(ac -> ac.getName().equals("out") || ac.getName().equals("err") || ac.getName().equals("in")).forEach(ac -> completionCandidates.add((AssistContent)new PrefixCompletionWrapper(ac, "System.")));
    }

    @OnThread(value=Tag.FXPlatform)
    public static interface SuggestionListParent {
        @OnThread(value=Tag.FX)
        public StringExpression getFontCSS();

        public double getFontSize();

        public void setupSuggestionWindow(Stage var1);
    }

    public static interface SuggestionListListener {
        @OnThread(value=Tag.FXPlatform)
        public void suggestionListChoiceClicked(SuggestionList var1, int var2);

        @OnThread(value=Tag.FXPlatform)
        public Response suggestionListKeyTyped(SuggestionList var1, KeyEvent var2, int var3);

        @OnThread(value=Tag.FXPlatform)
        public Response suggestionListKeyPressed(SuggestionList var1, KeyEvent var2, int var3);

        @OnThread(value=Tag.FXPlatform)
        default public void suggestionListFocusStolen(int highlighted) {
        }

        @OnThread(value=Tag.FXPlatform)
        default public void hidden() {
        }

        public static enum Response {
            DISMISS,
            CONTINUE;

        }
    }

    public static class SuggestionDetailsWithCustomDoc
    extends SuggestionDetails {
        private final FXSupplier<Pane> docMaker;

        public SuggestionDetailsWithCustomDoc(String choice, String suffix, String type, SuggestionShown shown, FXSupplier<Pane> docMaker) {
            super(choice, suffix, type, shown);
            this.docMaker = docMaker;
        }

        @Override
        public boolean hasDocs() {
            return true;
        }

        @Override
        public Pane makeDocPane() {
            return (Pane)this.docMaker.get();
        }
    }

    public static class SuggestionDetailsWithHTMLDoc
    extends SuggestionDetails {
        private final String docHTML;

        public SuggestionDetailsWithHTMLDoc(String choice, SuggestionShown shown, String docHTML) {
            super(choice, null, null, shown);
            this.docHTML = docHTML;
        }

        public SuggestionDetailsWithHTMLDoc(String choice, String suffix, String type, SuggestionShown shown, String docHTML) {
            super(choice, suffix, type, shown);
            this.docHTML = docHTML;
        }

        @Override
        public boolean hasDocs() {
            return true;
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public Pane makeDocPane() {
            WebView webView = new WebView();
            BorderPane docDisplay = new BorderPane((Node)webView);
            JavaFXUtil.addStyleClass((Styleable)docDisplay, (String[])new String[]{"suggestion-javadoc"});
            webView.getEngine().setJavaScriptEnabled(false);
            webView.getEngine().loadContent(this.docHTML);
            docDisplay.setMaxWidth(400.0);
            docDisplay.setMaxHeight(300.0);
            webView.setBlendMode(BlendMode.DARKEN);
            return docDisplay;
        }
    }

    public static class SuggestionDetails {
        public final String choice;
        public final String suffix;
        public final String type;
        public final SuggestionShown shown;

        public SuggestionDetails(String choice) {
            this(choice, null, null, SuggestionShown.COMMON);
        }

        public SuggestionDetails(String choice, String suffix, String type, SuggestionShown shown) {
            if (choice == null) {
                throw new IllegalArgumentException();
            }
            if (shown == null) {
                throw new IllegalArgumentException();
            }
            this.choice = choice;
            this.suffix = suffix;
            this.type = type;
            this.shown = shown;
        }

        public boolean hasDocs() {
            return false;
        }

        @OnThread(value=Tag.FXPlatform)
        public Pane makeDocPane() {
            return null;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    class SuggestionListItem {
        public final int index;
        public final boolean typeMatch;
        public final boolean direct;
        public final IntegerProperty eligibleAt = new SimpleIntegerProperty();
        public final IntegerProperty eligibleLength = new SimpleIntegerProperty();
        public final BooleanProperty eligibleCanTab = new SimpleBooleanProperty(false);
        public final BooleanProperty highlighted = new SimpleBooleanProperty(false);

        public SuggestionListItem(int index, boolean typeMatch, boolean direct) {
            this.index = index;
            this.typeMatch = typeMatch;
            this.direct = direct;
        }

        public SuggestionDetails getDetails() {
            return SuggestionList.this.choices.get(this.index);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SuggestionListItem that = (SuggestionListItem)o;
            if (this.index != that.index) {
                return false;
            }
            return this.direct == that.direct;
        }

        public int hashCode() {
            return 2 * this.index + (this.direct ? 1 : 0);
        }
    }

    public static enum SuggestionShown {
        COMMON,
        RARE;

    }

    private static class EligibleDetail
    implements Comparable<EligibleDetail> {
        public final int suggestionOffset;
        public final int distance;
        private final int length;

        public EligibleDetail(int suggestionOffset, int distance, int length) {
            this.suggestionOffset = suggestionOffset;
            this.distance = distance;
            this.length = length;
        }

        @Override
        @OnThread(value=Tag.FX, ignoreParent=true)
        public @OnThread(value=Tag.FX, ignoreParent=true) int compareTo(EligibleDetail e) {
            if (this.suggestionOffset == 0 == (e.suggestionOffset == 0)) {
                return Integer.compare(this.distance, e.distance);
            }
            if (this.suggestionOffset == 0) {
                return -1;
            }
            return 1;
        }

        public boolean close() {
            if (this.distance == 0 && this.suggestionOffset == 0) {
                return true;
            }
            if (this.distance == 0 && this.suggestionOffset != 0) {
                return this.length >= 2;
            }
            if (this.distance == 1) {
                return this.length >= 3;
            }
            if (this.distance == 2) {
                return this.length >= 10;
            }
            return false;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private static class SuggestionListView
    extends ListView<SuggestionListItem> {
        private final SimpleStyleableDoubleProperty cssTypeWidthProperty = new SimpleStyleableDoubleProperty(TYPE_WIDTH_META_DATA);
        private final SimpleStyleableDoubleProperty cssPrefWidthProperty = new SimpleStyleableDoubleProperty(PREF_WIDTH_META_DATA);
        private static final CssMetaData<SuggestionListView, Number> TYPE_WIDTH_META_DATA = JavaFXUtil.cssSize((String)"-bj-type-width", SuggestionListView::cssTypeWidthProperty);
        private static final CssMetaData<SuggestionListView, Number> PREF_WIDTH_META_DATA = JavaFXUtil.cssSize((String)"-bj-pref-width", SuggestionListView::cssPrefWidthProperty);
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList = JavaFXUtil.extendCss((List)ListView.getClassCssMetaData()).add(TYPE_WIDTH_META_DATA).add(PREF_WIDTH_META_DATA).build();

        public final SimpleStyleableDoubleProperty cssTypeWidthProperty() {
            return this.cssTypeWidthProperty;
        }

        public final SimpleStyleableDoubleProperty cssPrefWidthProperty() {
            return this.cssPrefWidthProperty;
        }

        @OnThread(value=Tag.Any)
        public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
            return cssMetaDataList;
        }

        @OnThread(value=Tag.Any)
        public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
            return SuggestionListView.getClassCssMetaData();
        }

        public SuggestionListView(DoubleExpression typeWidth, FXPlatformConsumer<SuggestionListItem> clickListener) {
            this.setEditable(false);
            this.setCellFactory(lv -> new SuggestionCell(typeWidth, clickListener));
            this.prefWidthProperty().bind((ObservableValue)this.cssPrefWidthProperty);
        }
    }
}

