/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.fixes;

import bluej.editor.EditorWatcher;
import bluej.editor.fixes.FixSuggestion;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public abstract class FixDisplayManager {
    protected int highlighted = -1;
    protected final List<FixDisplay> fixes = new ArrayList<FixDisplay>();
    private final int errorIdentifier;
    private final String message;

    public FixDisplayManager(int errorIdentifier, String message) {
        this.errorIdentifier = errorIdentifier;
        this.message = message;
    }

    protected void prepareFixDisplay(VBox vboxContainer, List<FixSuggestion> fixSuggestions, Supplier<EditorWatcher> editorWatcherSupplier) {
        if (fixSuggestions != null) {
            for (FixSuggestion fix : fixSuggestions) {
                FixDisplay l = new FixDisplay("  \u2022 Fix: " + fix.getDescription(), () -> fix.execute());
                l.onMouseClickedProperty().set(e -> {
                    this.recordExecute(editorWatcherSupplier, this.fixes.indexOf((Object)l));
                    fix.execute();
                    this.hide();
                    this.postFixError();
                    e.consume();
                });
                l.onMouseEnteredProperty().set(e -> this.setHighlighted(this.fixes.indexOf((Object)l)));
                vboxContainer.getChildren().add((Object)l);
                this.fixes.add(l);
            }
        }
        JavaFXUtil.addStyleClass((Styleable)vboxContainer, (String[])new String[]{"error-fix-display"});
        vboxContainer.setMinWidth(250.0);
    }

    @OnThread(value=Tag.FXPlatform)
    protected void executeAndRecordSelectedFix(Supplier<EditorWatcher> editorWatcherProvider) {
        if (this.highlighted != -1) {
            this.recordExecute(editorWatcherProvider, this.highlighted);
            this.fixes.get(this.highlighted).executeSuggestion();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void recordShow(Supplier<EditorWatcher> editorWatcherProvider) {
        EditorWatcher watcher = editorWatcherProvider.get();
        List fixDisplayText = Utility.mapList(this.fixes, FixDisplay::getDisplayText);
        watcher.recordShowErrorMessage(this.errorIdentifier, this.message, fixDisplayText);
    }

    @OnThread(value=Tag.FXPlatform)
    protected void recordExecute(Supplier<EditorWatcher> editorWatcherSupplier, int fixIndex) {
        EditorWatcher watcher = editorWatcherSupplier.get();
        watcher.recordFix(this.errorIdentifier, fixIndex);
    }

    protected abstract void hide();

    protected abstract void postFixError();

    protected void setHighlighted(int newHighlight) {
        if (this.highlighted != newHighlight) {
            if (this.highlighted != -1) {
                this.fixes.get(this.highlighted).setHighlight(false);
            }
            this.highlighted = newHighlight;
            if (this.highlighted != -1) {
                this.fixes.get(this.highlighted).setHighlight(true);
            }
        }
    }

    public boolean hasFixes() {
        return !this.fixes.isEmpty();
    }

    public void down() {
        this.setHighlighted(Math.min(this.fixes.size() - 1, this.highlighted + 1));
    }

    public void up() {
        this.setHighlighted(Math.max(0, this.highlighted - 1));
    }

    @OnThread(value=Tag.FX, ignoreParent=true)
    private static class FixDisplay
    extends HBox {
        private final Label enterHint = new Label("\u21b5");
        private final String displayText;
        private final FXPlatformRunnable executeFix;

        public FixDisplay(String display, FXPlatformRunnable executeFix) {
            this.displayText = display;
            this.executeFix = executeFix;
            this.enterHint.setVisible(false);
            Label l = new Label(display);
            this.getChildren().addAll((Object[])new Node[]{l, this.enterHint});
            HBox.setHgrow((Node)l, (Priority)Priority.ALWAYS);
            l.setMaxWidth(9999.0);
            this.setStyle((String)PrefMgr.getEditorFontCSS((boolean)false).get());
        }

        private void setHighlight(boolean highlight) {
            if (highlight) {
                JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"fix-highlight"});
            } else {
                JavaFXUtil.removeStyleClass((Styleable)this, (String[])new String[]{"fix-highlight"});
            }
            this.enterHint.setVisible(highlight);
        }

        @OnThread(value=Tag.Any)
        public String getDisplayText() {
            return this.displayText;
        }

        @OnThread(value=Tag.FXPlatform)
        protected void executeSuggestion() {
            this.executeFix.run();
        }
    }
}

