/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.base;

import bluej.editor.base.LineDisplay;
import bluej.editor.base.MarginAndTextLine;
import bluej.utility.javafx.JavaFXUtil;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public class LineContainer
extends Region {
    private final LineDisplay lineDisplay;
    private final boolean lineWrapping;

    public LineContainer(LineDisplay lineDisplay, boolean lineWrapping) {
        this.lineDisplay = lineDisplay;
        this.lineWrapping = lineWrapping;
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"line-container"});
    }

    protected void layoutChildren() {
        double y = this.snapPositionY(this.lineDisplay.getFirstVisibleLineOffset());
        if (!this.lineWrapping) {
            double height = this.snapSizeY(this.lineDisplay.calculateLineHeight());
            for (Node child : this.getChildren()) {
                if (!(child instanceof MarginAndTextLine)) continue;
                double nextY = this.snapPositionY(y + height);
                child.resizeRelocate(0.0, y, Math.max(this.getWidth(), child.prefWidth(-1.0)), nextY - y);
                y = nextY;
            }
        } else {
            for (Node child : this.getChildren()) {
                if (!(child instanceof MarginAndTextLine)) continue;
                double height = this.snapSizeY(child.prefHeight(this.getWidth()));
                double nextY = this.snapPositionY(y + height);
                child.resizeRelocate(0.0, y, this.getWidth(), nextY - y);
                y = nextY;
            }
        }
    }

    @OnThread(value=Tag.FX)
    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public double getTextDisplayWidth() {
        return this.getWidth() - this.lineDisplay.textLeftEdge();
    }
}

