/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions2;

import bluej.extensions2.ClassNotFoundException;
import bluej.extensions2.PackageNotFoundException;
import bluej.extensions2.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.views.View;
import java.awt.EventQueue;
import java.io.File;
import threadchecker.OnThread;
import threadchecker.Tag;

class Identifier {
    private File projectId;
    private String packageId;
    private String qualifiedClassName;

    @OnThread(value=Tag.Any)
    Identifier(Project bluejProject) {
        this(bluejProject, null, null);
    }

    @OnThread(value=Tag.Any)
    Identifier(Project bluejProject, Package bluejPackage) {
        this(bluejProject, bluejPackage, null);
    }

    @OnThread(value=Tag.Any)
    Identifier(Project bluejProject, Package bluejPackage, String aQualifiedClassName) {
        this.projectId = bluejProject.getProjectDir();
        if (bluejPackage != null) {
            this.packageId = bluejPackage.getQualifiedName();
        }
        this.qualifiedClassName = aQualifiedClassName;
    }

    Project getBluejProject() throws ProjectNotOpenException {
        Project aProject = Project.getProject((File)this.projectId);
        if (aProject == null) {
            throw new ProjectNotOpenException("Project " + this.projectId + " is closed");
        }
        return aProject;
    }

    Package getBluejPackage() throws ProjectNotOpenException, PackageNotFoundException {
        Project bluejProject = this.getBluejProject();
        Package bluejPkg = bluejProject.getCachedPackage(this.packageId);
        if (bluejPkg == null) {
            throw new PackageNotFoundException("Package '" + this.packageId + "' is deleted");
        }
        return bluejPkg;
    }

    String getClassName() {
        return this.qualifiedClassName;
    }

    PkgMgrFrame getPackageFrame() throws ProjectNotOpenException, PackageNotFoundException {
        Package thisPkg = this.getBluejPackage();
        final PkgMgrFrame pmf = PkgMgrFrame.createFrame((Package)thisPkg, null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                pmf.setVisible(true);
            }
        });
        return pmf;
    }

    Class<?> getJavaClass() throws ProjectNotOpenException, ClassNotFoundException {
        Project bluejPrj = this.getBluejProject();
        Class aClass = bluejPrj.loadClass(this.qualifiedClassName);
        if (aClass == null) {
            throw new ClassNotFoundException("Class " + this.qualifiedClassName + " Not Found");
        }
        return aClass;
    }

    ClassTarget getClassTarget() throws ProjectNotOpenException, PackageNotFoundException {
        Target aTarget;
        Package bluejPkg = this.getBluejPackage();
        String className = this.qualifiedClassName;
        int dotpos = this.qualifiedClassName.lastIndexOf(".");
        if (dotpos > 0) {
            className = this.qualifiedClassName.substring(dotpos + 1);
        }
        if ((aTarget = bluejPkg.getTarget(className)) == null) {
            return null;
        }
        if (!(aTarget instanceof ClassTarget)) {
            return null;
        }
        return (ClassTarget)aTarget;
    }

    View getBluejView() throws ProjectNotOpenException, ClassNotFoundException {
        Class<?> aClass = this.getJavaClass();
        return View.getView(aClass);
    }

    public int hashCode() {
        int total = 0;
        if (this.projectId != null) {
            total += this.projectId.hashCode();
        }
        if (this.packageId != null) {
            total += this.packageId.hashCode();
        }
        if (this.qualifiedClassName != null) {
            total += this.qualifiedClassName.hashCode();
        }
        return total;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Identifier)) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return this.qualifiedClassName == null ? other.qualifiedClassName == null : this.qualifiedClassName.equals(other.qualifiedClassName);
    }
}

