/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions2;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.extensions2.BPackage;
import bluej.extensions2.BProject;
import bluej.extensions2.ExtensionException;
import bluej.extensions2.ExtensionUnloadedException;
import bluej.extensions2.ExternalFileLauncher;
import bluej.extensions2.Identifier;
import bluej.extensions2.MenuGenerator;
import bluej.extensions2.PreferenceGenerator;
import bluej.extensions2.event.ApplicationEvent;
import bluej.extensions2.event.ApplicationListener;
import bluej.extensions2.event.ClassEvent;
import bluej.extensions2.event.ClassListener;
import bluej.extensions2.event.CompileEvent;
import bluej.extensions2.event.CompileListener;
import bluej.extensions2.event.ExtensionEvent;
import bluej.extensions2.event.ExtensionEventListener;
import bluej.extensions2.event.InvocationFinishedEvent;
import bluej.extensions2.event.InvocationFinishedListener;
import bluej.extensions2.event.PackageEvent;
import bluej.extensions2.event.PackageListener;
import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionPrefManager;
import bluej.extmgr.ExtensionWrapper;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javafx.scene.control.MenuItem;
import javafx.stage.Stage;

public final class BlueJ {
    private final ExtensionWrapper myWrapper;
    private final ExtensionPrefManager prefManager;
    private PreferenceGenerator currentPrefGen = null;
    private MenuGenerator currentMenuGen = null;
    private Properties localLabels;
    private static final List<String> blueJNativeFileExts = Collections.unmodifiableList(Arrays.asList(".java", ".class", ".css"));
    private final List<ExternalFileLauncher> externalFileLaunchers = new ArrayList<ExternalFileLauncher>();
    private ArrayList<ExtensionEventListener> eventListeners;
    private ArrayList<ApplicationListener> applicationListeners;
    private ArrayList<PackageListener> packageListeners;
    private ArrayList<CompileListener> compileListeners;
    private ArrayList<InvocationFinishedListener> invocationFinishedListeners;
    private ArrayList<ClassListener> classListeners;

    BlueJ(ExtensionWrapper aWrapper, ExtensionPrefManager aPrefManager) {
        this.myWrapper = aWrapper;
        this.prefManager = aPrefManager;
        this.eventListeners = new ArrayList();
        this.applicationListeners = new ArrayList();
        this.packageListeners = new ArrayList();
        this.compileListeners = new ArrayList();
        this.invocationFinishedListeners = new ArrayList();
        this.classListeners = new ArrayList();
        this.localLabels = this.myWrapper.getLabelProperties();
    }

    public final BProject openProject(File directory) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        if (directory == null) {
            return null;
        }
        Project openProj = Project.openProject((String)directory.getAbsolutePath());
        if (openProj == null) {
            return null;
        }
        Package pkg = openProj.getCachedPackage(openProj.getInitialPackageName());
        if (pkg == null) {
            return null;
        }
        Identifier aProject = new Identifier(openProj, pkg);
        try {
            aProject.getPackageFrame();
        }
        catch (ExtensionException extensionException) {
            // empty catch block
        }
        return openProj.getBProject();
    }

    public BProject newProject(File directory) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        Object pathString = directory.getAbsolutePath();
        if (!((String)pathString).endsWith(File.separator)) {
            pathString = (String)pathString + File.separator;
        }
        if (!Project.createNewProject((String)pathString)) {
            return null;
        }
        Project openProj = Project.openProject((String)directory.getAbsolutePath());
        if (openProj == null) {
            return null;
        }
        return openProj.getBProject();
    }

    public BProject[] getOpenProjects() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        Collection projects = Project.getProjects();
        BProject[] result = new BProject[projects.size()];
        Iterator iter = projects.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Project prj = (Project)iter.next();
            result[index] = prj.getBProject();
            ++index;
        }
        return result;
    }

    public BPackage getCurrentPackage() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        PkgMgrFrame pmf = PkgMgrFrame.getMostRecent();
        if (pmf == null) {
            return null;
        }
        Package pkg = pmf.getPackage();
        if (pkg == null) {
            return null;
        }
        return pkg.getBPackage();
    }

    public Stage getCurrentWindow() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return PkgMgrFrame.getMostRecent().getWindow();
    }

    public void setMenuGenerator(MenuGenerator menuGen) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        this.currentMenuGen = menuGen;
    }

    public MenuGenerator getMenuGenerator() {
        return this.currentMenuGen;
    }

    public void setPreferenceGenerator(PreferenceGenerator prefGen) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        this.currentPrefGen = prefGen;
        this.prefManager.panelRevalidate();
    }

    public PreferenceGenerator getPreferenceGenerator() {
        return this.currentPrefGen;
    }

    public final void addExternalFileLaunchers(List<ExternalFileLauncher> launchers) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        this.externalFileLaunchers.addAll(launchers);
    }

    final List<ExternalFileLauncher> getExternalFileLaunchers() {
        return Collections.unmodifiableList(this.externalFileLaunchers);
    }

    static final List<String> getBlueJNativeFileExtensions() {
        return blueJNativeFileExts;
    }

    public File getSystemLibDir() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return Config.getBlueJLibDir();
    }

    public File getUserConfigDir() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return Config.getUserConfigDir();
    }

    public String getDataCollectionUniqueID() {
        return DataCollector.getUserID();
    }

    public String getBlueJPropertyString(String property, String def) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return Config.getPropString((String)property, (String)def);
    }

    public String getExtensionPropertyString(String property, String def) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        String thisKey = this.myWrapper.getSettingsString(property);
        return Config.getPropString((String)thisKey, (String)def);
    }

    public void setExtensionPropertyString(String property, String value) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        String thisKey = this.myWrapper.getSettingsString(property);
        if (value != null) {
            Config.putPropString((String)thisKey, (String)value);
        } else {
            Config.removeProperty((String)thisKey);
        }
    }

    public String getLabel(String key) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        if (this.localLabels == null) {
            return Config.getString((String)key, (String)key);
        }
        String aLabel = this.localLabels.getProperty(key, null);
        if (aLabel != null) {
            return aLabel;
        }
        return Config.getString((String)key, (String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtensionEventListener(ExtensionEventListener listener) {
        if (listener != null) {
            ArrayList<ExtensionEventListener> arrayList = this.eventListeners;
            synchronized (arrayList) {
                this.eventListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtensionEventListener(ExtensionEventListener listener) {
        if (listener != null) {
            ArrayList<ExtensionEventListener> arrayList = this.eventListeners;
            synchronized (arrayList) {
                this.eventListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(ApplicationListener listener) {
        if (listener != null) {
            ArrayList<ApplicationListener> arrayList = this.applicationListeners;
            synchronized (arrayList) {
                this.applicationListeners.add(listener);
            }
            if (DataCollector.hasGivenUp()) {
                listener.dataSubmissionFailed(new ApplicationEvent(ApplicationEvent.EventType.DATA_SUBMISSION_FAILED_EVENT));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(ApplicationListener listener) {
        if (listener != null) {
            ArrayList<ApplicationListener> arrayList = this.applicationListeners;
            synchronized (arrayList) {
                this.applicationListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackageListener(PackageListener listener) {
        if (listener != null) {
            ArrayList<PackageListener> arrayList = this.packageListeners;
            synchronized (arrayList) {
                this.packageListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackageListener(PackageListener listener) {
        if (listener != null) {
            ArrayList<PackageListener> arrayList = this.packageListeners;
            synchronized (arrayList) {
                this.packageListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompileListener(CompileListener listener) {
        if (listener != null) {
            ArrayList<CompileListener> arrayList = this.compileListeners;
            synchronized (arrayList) {
                this.compileListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompileListener(CompileListener listener) {
        if (listener != null) {
            ArrayList<CompileListener> arrayList = this.compileListeners;
            synchronized (arrayList) {
                this.compileListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvocationFinishedListener(InvocationFinishedListener listener) {
        if (listener != null) {
            ArrayList<InvocationFinishedListener> arrayList = this.invocationFinishedListeners;
            synchronized (arrayList) {
                this.invocationFinishedListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvocationFinishedListener(InvocationFinishedListener listener) {
        if (listener != null) {
            ArrayList<InvocationFinishedListener> arrayList = this.invocationFinishedListeners;
            synchronized (arrayList) {
                this.invocationFinishedListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassListener(ClassListener listener) {
        if (listener != null) {
            ArrayList<ClassListener> arrayList = this.classListeners;
            synchronized (arrayList) {
                this.classListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassListener(ClassListener listener) {
        if (listener != null) {
            ArrayList<ClassListener> arrayList = this.classListeners;
            synchronized (arrayList) {
                this.classListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateExtensionEvent(ExtensionEvent event) {
        ExtensionEventListener[] listeners;
        ArrayList<ExtensionEventListener> arrayList = this.eventListeners;
        synchronized (arrayList) {
            listeners = this.eventListeners.toArray(new ExtensionEventListener[this.eventListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            ExtensionEventListener eventListener = listeners[i];
            eventListener.eventOccurred(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateApplicationEvent(ApplicationEvent event) {
        ApplicationListener[] listeners;
        ArrayList<ApplicationListener> arrayList = this.applicationListeners;
        synchronized (arrayList) {
            listeners = this.applicationListeners.toArray(new ApplicationListener[this.applicationListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            ApplicationListener eventListener = listeners[i];
            if (event.getEventType() == ApplicationEvent.EventType.APP_READY_EVENT) {
                eventListener.blueJReady(event);
                continue;
            }
            if (event.getEventType() != ApplicationEvent.EventType.DATA_SUBMISSION_FAILED_EVENT) continue;
            eventListener.dataSubmissionFailed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegatePackageEvent(PackageEvent event) {
        PackageListener[] listeners;
        ArrayList<PackageListener> arrayList = this.packageListeners;
        synchronized (arrayList) {
            listeners = this.packageListeners.toArray(new PackageListener[this.packageListeners.size()]);
        }
        PackageEvent.EventType thisEvent = event.getEventType();
        block7: for (int i = 0; i < listeners.length; ++i) {
            PackageListener eventListener = listeners[i];
            switch (thisEvent) {
                case PACKAGE_OPENED: {
                    eventListener.packageOpened(event);
                    continue block7;
                }
                case PACKAGE_CLOSING: {
                    eventListener.packageClosing(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateCompileEvent(CompileEvent event) {
        CompileListener[] listeners;
        ArrayList<CompileListener> arrayList = this.compileListeners;
        synchronized (arrayList) {
            listeners = this.compileListeners.toArray(new CompileListener[this.compileListeners.size()]);
        }
        CompileEvent.EventType thisEvent = event.getEventType();
        block10: for (int i = 0; i < listeners.length; ++i) {
            CompileListener eventListener = listeners[i];
            switch (thisEvent) {
                case COMPILE_START_EVENT: {
                    eventListener.compileStarted(event);
                    continue block10;
                }
                case COMPILE_ERROR_EVENT: {
                    eventListener.compileError(event);
                    continue block10;
                }
                case COMPILE_WARNING_EVENT: {
                    eventListener.compileWarning(event);
                    continue block10;
                }
                case COMPILE_FAILED_EVENT: {
                    eventListener.compileFailed(event);
                    continue block10;
                }
                case COMPILE_DONE_EVENT: {
                    eventListener.compileSucceeded(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateInvocationEvent(InvocationFinishedEvent event) {
        InvocationFinishedListener[] listeners;
        ArrayList<InvocationFinishedListener> arrayList = this.invocationFinishedListeners;
        synchronized (arrayList) {
            listeners = this.invocationFinishedListeners.toArray(new InvocationFinishedListener[this.invocationFinishedListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].invocationFinished(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateClassEvent(ClassEvent event) {
        ClassListener[] listeners;
        ArrayList<ClassListener> arrayList = this.classListeners;
        synchronized (arrayList) {
            listeners = this.classListeners.toArray(new ClassListener[this.classListeners.size()]);
        }
        block8: for (int i = 0; i < listeners.length; ++i) {
            switch (event.getEventType()) {
                case STATE_CHANGED: {
                    listeners[i].classStateChanged(event);
                    continue block8;
                }
                case CHANGED_NAME: {
                    listeners[i].classNameChanged(event);
                    continue block8;
                }
                case REMOVED: {
                    listeners[i].classRemoved(event);
                }
            }
        }
    }

    void delegateEvent(ExtensionEvent event) {
        this.delegateExtensionEvent(event);
        if (event instanceof ApplicationEvent) {
            this.delegateApplicationEvent((ApplicationEvent)event);
        } else if (event instanceof PackageEvent) {
            this.delegatePackageEvent((PackageEvent)event);
        } else if (event instanceof CompileEvent) {
            this.delegateCompileEvent((CompileEvent)event);
        } else if (event instanceof InvocationFinishedEvent) {
            this.delegateInvocationEvent((InvocationFinishedEvent)event);
        } else if (event instanceof ClassEvent) {
            this.delegateClassEvent((ClassEvent)event);
        }
    }

    MenuItem getMenuItem(ExtensionMenu attachedObject) {
        if (this.currentMenuGen == null || attachedObject == null) {
            return null;
        }
        return attachedObject.getMenuItem(this.currentMenuGen);
    }

    void postMenuItem(ExtensionMenu attachedObject, MenuItem onThisItem) {
        if (this.currentMenuGen != null && attachedObject != null) {
            attachedObject.postMenuItem(this.currentMenuGen, onThisItem);
        }
    }

    public void setScopeHighlightStrength(int strength) {
        PrefMgr.setScopeHighlightStrength((int)Math.min(Math.max(0, strength), 20));
    }
}

