/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Sequences {
    private Sequences() {
        throw new UnsupportedOperationException();
    }

    public static Iterable<BigInteger> halvingIntegral(BigInteger max, BigInteger start) {
        return () -> new BigIntegerHalvingIterator(start, max);
    }

    public static Iterable<BigDecimal> halvingDecimal(BigDecimal max, BigDecimal start) {
        return () -> new BigDecimalHalvingIterator(start, max);
    }

    public static Iterable<Integer> halving(int start) {
        return () -> new IntegerHalvingIterator(start);
    }

    private static final class IntegerHalvingIterator
    implements Iterator<Integer> {
        private boolean done;
        private int next;

        IntegerHalvingIterator(int start) {
            this.next = start;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int result = this.next;
            this.next = this.peek();
            this.done = this.next == 0;
            return result;
        }

        private int peek() {
            return this.next / 2;
        }
    }

    private static final class BigDecimalHalvingIterator
    implements Iterator<BigDecimal> {
        private final BigDecimal max;
        private boolean done;
        private BigDecimal next;

        BigDecimalHalvingIterator(BigDecimal start, BigDecimal max) {
            this.max = max;
            this.next = start;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public BigDecimal next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.next = this.peek();
            this.done = this.next.equals(this.peek());
            return this.next;
        }

        private BigDecimal peek() {
            return this.next.add(this.max.subtract(this.next).divide(BigDecimal.valueOf(2L), RoundingMode.HALF_UP));
        }
    }

    private static final class BigIntegerHalvingIterator
    implements Iterator<BigInteger> {
        private final BigInteger max;
        private boolean done;
        private BigInteger next;

        BigIntegerHalvingIterator(BigInteger start, BigInteger max) {
            this.max = max;
            this.next = start;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public BigInteger next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.next = this.peek();
            this.done = this.next.equals(this.peek());
            return this.next;
        }

        private BigInteger peek() {
            return this.next.add(this.max.subtract(this.next).divide(BigInteger.valueOf(2L)));
        }
    }
}

